/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.av;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import jogamp.opengl.util.av.NullGLMediaPlayer;

public class GLMediaPlayerFactory {
    private static final String AndroidGLMediaPlayerAPI14ClazzName = "jogamp.opengl.android.av.AndroidGLMediaPlayerAPI14";
    private static final String FFMPEGMediaPlayerClazzName = "jogamp.opengl.util.av.impl.FFMPEGMediaPlayer";
    private static final String OMXGLMediaPlayerClazzName = "jogamp.opengl.util.av.impl.OMXGLMediaPlayer";
    private static final String isAvailableMethodName = "isAvailable";

    public static GLMediaPlayer createDefault() {
        ClassLoader classLoader = GLMediaPlayerFactory.class.getClassLoader();
        GLMediaPlayer gLMediaPlayer = GLMediaPlayerFactory.create(classLoader, OMXGLMediaPlayerClazzName);
        if (null == gLMediaPlayer) {
            gLMediaPlayer = GLMediaPlayerFactory.create(classLoader, AndroidGLMediaPlayerAPI14ClazzName);
        }
        if (null == gLMediaPlayer) {
            gLMediaPlayer = GLMediaPlayerFactory.create(classLoader, FFMPEGMediaPlayerClazzName);
        }
        if (null == gLMediaPlayer) {
            gLMediaPlayer = GLMediaPlayerFactory.createNull();
        }
        return gLMediaPlayer;
    }

    public static GLMediaPlayer createNull() {
        if (GLMediaPlayer.DEBUG) {
            System.err.println("GLMediaPlayerFactory: Using NullGLMediaPlayer");
        }
        return new NullGLMediaPlayer();
    }

    public static GLMediaPlayer create(ClassLoader classLoader, String string) {
        block8: {
            try {
                if (GLMediaPlayer.DEBUG) {
                    System.err.println("GLMediaPlayerFactory: Trying: " + string);
                }
                if (((Boolean)ReflectionUtil.callStaticMethod(string, isAvailableMethodName, null, null, classLoader)).booleanValue()) {
                    GLMediaPlayer gLMediaPlayer = (GLMediaPlayer)ReflectionUtil.createInstance(string, classLoader);
                    if (GLMediaPlayer.DEBUG) {
                        System.err.println("GLMediaPlayerFactory: Using: " + string);
                    }
                    return gLMediaPlayer;
                }
                if (GLMediaPlayer.DEBUG) {
                    System.err.println("GLMediaPlayerFactory: Not available: " + string);
                }
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                if (GLMediaPlayer.DEBUG) {
                    Throwable throwable = jogampRuntimeException.getCause();
                    System.err.println("GLMediaPlayerFactory: Not available: " + string);
                    System.err.println("Caught cause " + throwable.getClass().getName() + ": " + throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (!GLMediaPlayer.DEBUG) break block8;
                System.err.println("GLMediaPlayerFactory: Not available: " + string);
                System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        return null;
    }
}

