/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.av.PTS;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.av.CodecID;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.opengl.util.av.GLMediaPlayerImpl;

public class NullGLMediaPlayer
extends GLMediaPlayerImpl {
    private TextureData texData = null;
    private final PTS video_pts = new PTS(() -> GLMediaPlayer.State.Playing == this.getState() ? this.getPlaySpeed() : 0.0f);

    @Override
    public final void printNativeInfo(PrintStream printStream) {
        printStream.println("NullGLMediaPlayer: available true");
    }

    @Override
    protected final boolean setPlaySpeedImpl(float f) {
        return false;
    }

    @Override
    protected final boolean resumeImpl() {
        this.video_pts.setSCR(Clock.currentMillis());
        return true;
    }

    @Override
    protected final boolean pauseImpl() {
        return true;
    }

    @Override
    protected final void stopImpl() {
    }

    @Override
    protected final int seekImpl(int n) {
        this.video_pts.setPTS(n);
        this.validatePos();
        return n;
    }

    @Override
    protected final int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame, Texture texture, boolean[] blArray) {
        int n = this.getLastBufferedAudioPTS();
        textureFrame.setPTS(n);
        return n;
    }

    @Override
    protected PTS getAudioPTSImpl() {
        return this.video_pts;
    }

    @Override
    protected final PTS getUpdatedAudioPTS() {
        this.validatePos();
        return this.video_pts;
    }

    @Override
    protected int getAudioQueuedDuration() {
        return 0;
    }

    @Override
    protected int getLastBufferedAudioPTS() {
        return this.video_pts.getLast();
    }

    @Override
    protected final void destroyImpl() {
        if (null != this.texData) {
            this.texData.destroy();
            this.texData = null;
        }
    }

    public static final TextureData createTestTextureData() {
        Object object;
        TextureData textureData = null;
        try {
            object = IOUtil.getResource("jogamp/opengl/assets/test-ntsc01-28x16.png", NullGLMediaPlayer.class.getClassLoader());
            if (null != object) {
                textureData = TextureIO.newTextureData(GLProfile.getGL2ES2(), ((URLConnection)object).getInputStream(), false, "png");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (null == textureData) {
            object = Buffers.newDirectByteBuffer(57600);
            while (((Buffer)object).hasRemaining()) {
                ((ByteBuffer)object).put((byte)-22);
                ((ByteBuffer)object).put((byte)-22);
                ((ByteBuffer)object).put((byte)-22);
                ((ByteBuffer)object).put((byte)-22);
            }
            ((ByteBuffer)object).rewind();
            textureData = new TextureData(GLProfile.getGL2ES2(), 6408, 160, 90, 0, 6408, 5121, false, false, false, (Buffer)object, null);
        }
        return textureData;
    }

    @Override
    protected final void initStreamImpl(int n, String string, int n2, String string2, int n3) throws IOException {
        this.texData = NullGLMediaPlayer.createTestTextureData();
        this.updateAttributes("null", new int[]{0}, new String[]{"und"}, 0, new int[0], new String[0], -2, new int[0], new String[0], -2, this.texData.getWidth(), this.texData.getHeight(), 0, 0, 0, 24.0f, 14400, 0, 600000, "png-static", null, null, CodecID.toFFmpeg(CodecID.PNG), -1, -1);
    }

    @Override
    protected final void initGLImpl(GL gL) throws IOException, GLException {
        this.setIsGLOriented(true);
    }

    @Override
    protected int validateTextureCount(int n) {
        return 1;
    }

    @Override
    protected final TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        Texture texture = super.createTexImageImpl(gL, n, this.getWidth(), this.getHeight());
        if (null != this.texData) {
            texture.updateImage(gL, this.texData);
        }
        return new TextureSequence.TextureFrame(texture);
    }

    @Override
    protected final void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        super.destroyTexFrame(gL, textureFrame);
    }

    private void validatePos() {
        boolean bl = false;
        if (0 > this.video_pts.getLast()) {
            this.video_pts.setPTS(0);
            bl = true;
        } else if (this.video_pts.getLast() > this.getDuration()) {
            this.video_pts.setPTS(this.getDuration());
            bl = true;
        }
        if (bl && GLMediaPlayer.State.Playing == this.getState()) {
            this.setState(GLMediaPlayer.State.Paused);
        }
    }
}

