/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.common.util.IOUtil;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.Tooltip;
import com.jogamp.graph.ui.TooltipShape;
import com.jogamp.graph.ui.TooltipText;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.BoxLayout;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.layout.Margin;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.GlyphShape;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.graph.ui.widgets.RangedGroup;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.graph.FontSetDemos;
import com.jogamp.opengl.demos.graph.MSAATool;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class FontView01
implements GLEventListener {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    private static final float GlyphGridWidth = 0.75f;
    private static final float GlyphGridBorderThickness = 0.02f;
    private static final Vec4f GlyphGridBorderColorComplex = new Vec4f(0.2f, 0.2f, 0.2f, 1.0f);
    private static final Vec4f GlyphGridBorderColorSimple = new Vec4f(0.2f, 0.2f, 0.7f, 1.0f);
    private static int max_glyph_count = 10000;
    private static boolean VERBOSE_GLYPHS = false;
    private static boolean VERBOSE_UI = false;
    private boolean showUnderline = false;
    private boolean showLabel = false;
    private boolean debug = false;
    private boolean trace = false;
    private final Font font;
    private final Font fontStatus;
    private final Font fontInfo;
    private float dpiY = 96.0f;
    private float pixPerMMY;
    private final Scene scene;
    private int maxGlyphCount = Integer.MAX_VALUE;
    private float mmPerCell = 8.0f;
    private int gridColumns = -1;
    private boolean firstReshape = true;
    Group mainView = null;
    Label infoLabel = null;
    int lastCodepoint = 0;

    public static void main(String[] stringArray) throws IOException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        float f = 8.0f;
        String string = null;
        int n = -1;
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = 0;
            while (object[0] < stringArray.length) {
                if (!options.parse(stringArray, (int[])object)) {
                    if (stringArray[object[0]].equals("-font")) {
                        object[0] = object[0] + 1;
                        string = stringArray[object[0]];
                    } else if (stringArray[object[0]].equals("-mmPerCell")) {
                        object[0] = object[0] + 1;
                        f = MiscUtils.atof(stringArray[object[0]], f);
                    } else if (stringArray[object[0]].equals("-gridCols")) {
                        object[0] = object[0] + 1;
                        n = MiscUtils.atoi(stringArray[object[0]], n);
                    } else if (stringArray[object[0]].equals("-showUnderline")) {
                        bl = true;
                    } else if (stringArray[object[0]].equals("-showLabel")) {
                        bl2 = true;
                    } else if (stringArray[object[0]].equals("-perf")) {
                        bl3 = true;
                    } else if (stringArray[object[0]].equals("-max")) {
                        object[0] = object[0] + 1;
                        max_glyph_count = MiscUtils.atoi(stringArray[object[0]], max_glyph_count);
                    }
                }
                object[0] = object[0] + 1;
            }
        }
        System.err.println(JoglVersion.getInstance().toString());
        System.err.println(options);
        object = new FontView01(string, FontView01.options.renderModes, false, false);
        object.showUnderline = bl;
        object.showLabel = bl2;
        object.mmPerCell = f;
        object.gridColumns = n;
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        if (0 == FontView01.options.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(FontView01.options.surface_width, FontView01.options.surface_height);
        gLWindow.setTitle(FontView01.class.getSimpleName() + ": " + object.font.getFullFamilyName() + ", " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.addGLEventListener((GLEventListener)object);
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.setExclusiveContext(FontView01.options.exclusiveContext);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(FontView01.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        if (FontView01.options.wait_to_start) {
            System.err.println("Press enter to continue");
            MiscUtils.waitForKey("Start");
        }
        gLWindow.setVisible(true);
        System.out.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        animator.start();
    }

    public FontView01(int n) {
        this(null, n, false, false);
    }

    private FontView01(String string, int n, boolean bl, boolean bl2) {
        this.debug = bl;
        this.trace = bl2;
        FontView01.options.renderModes = n;
        try {
            this.font = null == string ? FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeSerif.ttf", (ClassLoader)FontSetDemos.class.getClassLoader(), FontSetDemos.class).getInputStream(), (boolean)true) : FontFactory.get((File)new File(string));
            System.err.println("Font " + this.font.getFullFamilyName());
            this.fontStatus = FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeMono.ttf", (ClassLoader)FontSetDemos.class.getClassLoader(), FontSetDemos.class).getInputStream(), (boolean)true);
            this.fontInfo = FontFactory.get((int)0).getDefault();
            System.err.println("Status Font " + this.fontStatus.getFullFamilyName());
            System.err.println("Info Font " + this.fontInfo.getFullFamilyName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.scene = new Scene(FontView01.options.graphAASamples);
        this.scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        this.scene.setPMvCullingEnabled(true);
        this.scene.getRenderer().setHintBits(2);
    }

    public float getMMPerCell() {
        return this.mmPerCell;
    }

    public void setMMPerCell(float f) {
        this.mmPerCell = f;
    }

    public int getMaxGlyphCount() {
        return this.maxGlyphCount;
    }

    public void setMaxGlyphCount(int n) {
        this.maxGlyphCount = n;
    }

    public void init(final GLAutoDrawable gLAutoDrawable) {
        GlyphShape glyphShape;
        float[] fArray;
        float[] fArray2;
        Object object;
        Object object2 = gLAutoDrawable.getUpstreamWidget();
        if (object2 instanceof Window) {
            final Window window = (Window)object2;
            window.addMouseListener((MouseListener)new Shape.MouseGestureAdapter(){

                public void mouseWheelMoved(MouseEvent mouseEvent) {
                    if (null == FontView01.this.mainView || (float)mouseEvent.getX() >= (float)window.getSurfaceWidth() / 2.0f) {
                        return;
                    }
                    if (mouseEvent.isControlDown()) {
                        float[] fArray = mouseEvent.getRotation();
                        float f = mouseEvent.isShiftDown() ? fArray[0] : fArray[1];
                        float f2 = 1.0f + f / 200.0f;
                        AABBox aABBox = FontView01.this.mainView.getBounds();
                        AABBox aABBox2 = new AABBox(aABBox).scale(f2, f2, 1.0f);
                        float f3 = aABBox.getWidth() - aABBox2.getWidth();
                        float f4 = aABBox.getHeight() - aABBox2.getHeight();
                        FontView01.this.mainView.scale(f2, f2, 1.0f);
                        Vec3f vec3f = FontView01.this.mainView.getScale();
                        FontView01.this.mainView.move(vec3f.x() * f3 / 2.0f, vec3f.y() * f4 / 2.0f, 0.0f);
                        System.err.println("scale +" + f2 + " = " + vec3f);
                        mouseEvent.setConsumed(true);
                    } else {
                        Vec3f vec3f = new Vec3f(mouseEvent.getRotation()).scale((float)Math.PI / 180);
                        float f = vec3f.x();
                        vec3f.setX(vec3f.y());
                        vec3f.setY(f);
                        FontView01.this.mainView.setRotation(FontView01.this.mainView.getRotation().rotateByEuler(vec3f.scale(2.0f)));
                        mouseEvent.setConsumed(true);
                    }
                }
            });
            window.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    short s = keyEvent.getKeySymbol();
                    if (s == 100 || s == 27 || s == 81) {
                        MiscUtils.destroyWindow(gLAutoDrawable);
                    } else if (s == 83) {
                        FontView01.printScreenOnGLThread(FontView01.this.scene, gLAutoDrawable.getChosenGLCapabilities(), FontView01.this.font, FontView01.this.lastCodepoint);
                    }
                }
            });
            MonitorDevice monitorDevice = window.getMainMonitor();
            object = MonitorDevice.mmToInch((float[])monitorDevice.getPixelsPerMM(new float[2]));
            fArray2 = window.getPixelsPerMM(new float[2]);
            this.pixPerMMY = fArray2[1];
            fArray = MonitorDevice.mmToInch((float[])new float[2], (float[])fArray2);
            this.dpiY = fArray[1];
            float[] fArray3 = window.getCurrentSurfaceScale(new float[2]);
            System.err.println("HiDPI PixelScale: " + fArray3[0] + "x" + fArray3[1] + " (has)");
            System.err.println("Monitor detected: " + monitorDevice);
            System.err.println("Monitor dpi: " + object[0] + " x " + object[1]);
            System.err.println("Surface scale: native " + Arrays.toString(window.getMaximumSurfaceScale(new float[2])) + ", current " + Arrays.toString(window.getCurrentSurfaceScale(new float[2])));
            System.err.println("HiDPI PixelScale: " + fArray3[0] + "x" + fArray3[1] + " (has)");
        } else {
            this.dpiY = 96.0f;
            fArray = new float[]{this.dpiY, this.dpiY};
            this.pixPerMMY = MonitorDevice.inchToMM((float)this.dpiY);
            fArray2 = new float[]{this.pixPerMMY, this.pixPerMMY};
            System.err.println("Using default DPI of " + this.dpiY);
        }
        int n = (int)((float)gLAutoDrawable.getSurfaceHeight() / fArray2[1] / this.mmPerCell);
        if (0 >= this.gridColumns) {
            this.gridColumns = (int)((float)gLAutoDrawable.getSurfaceWidth() * 0.75f / fArray2[0] / this.mmPerCell);
        }
        System.err.println("Surface " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceHeight());
        System.err.println("Surface dpi " + fArray[0] + " x " + fArray[1]);
        System.err.println("Surface pixPerMM: " + fArray2[0] + " x " + fArray2[1]);
        System.err.println("mmPerCell " + this.mmPerCell + ", glyphGridRowsPerPage " + n + ", gridColumns " + this.gridColumns);
        int n2 = options.fixDefaultAARenderModeWithDPIThreshold(this.dpiY);
        System.err.println("AUTO RenderMode: dpi " + this.dpiY + ", threshold " + FontView01.options.noAADPIThreshold + ", mode " + Region.getRenderModeString((int)n2) + " -> " + Region.getRenderModeString((int)FontView01.options.renderModes));
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("FontView01: init (1.1)");
            GLWindow gLWindow = (GLWindow)gLAutoDrawable;
            this.scene.attachInputListenerTo(gLWindow);
        } else {
            System.err.println("FontView01: init (1.0)");
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null, (boolean)false).toString());
        System.err.println("VSync Swap Interval: " + gL2ES2.getSwapInterval());
        System.err.println("Chosen: " + gLAutoDrawable.getChosenGLCapabilities());
        MSAATool.dump(gLAutoDrawable);
        gL2ES2.setSwapInterval(1);
        gL2ES2.glEnable(2929);
        float f = 0.75f / (float)this.gridColumns;
        object = new Vec2f(0.75f, (float)n * f);
        long l = Clock.currentNanos();
        GridDim gridDim = new GridDim(this.font, this.gridColumns, n, 1, this.maxGlyphCount);
        Vec2f vec2f = new Vec2f(object.x(), (float)gridDim.rows * f);
        System.err.println(gridDim);
        System.err.println("GlyphGrid[pgsz " + object + ", totsz " + vec2f + ", cellSz " + f + "]");
        this.lastCodepoint = gridDim.contourChars.get(0).charValue();
        Group group = new Group((Group.Layout)new BoxLayout(1.0f, 1.0f, Alignment.FillCenter, new Margin(0.01f)));
        Group group2 = new Group();
        group2.setName("GlyphShapeHolderInfo");
        group.addShape((Shape)group2);
        Group group3 = new Group((Group.Layout)new BoxLayout(1.0f, 1.0f, Alignment.FillCenter, new Margin(0.025f, 0.025f, 0.025f, 0.025f)));
        Label label = new Label(FontView01.options.renderModes, this.fontStatus, (CharSequence)"Nothing there yet");
        FontView01.setGlyphInfo(this.fontStatus, label, this.font.getGlyph('A'));
        label.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        group3.addShape((Shape)label);
        group3.setRelayoutOnDirtyShapes(false);
        Shape.PointerListener pointerListener = (shape, vec3f, mouseEvent) -> {
            System.err.println("XXX: Hover: " + shape + ", event " + mouseEvent);
            GlyphShape glyphShape = FontView01.getGlyphShape(shape);
            mouseEvent.setConsumed(true);
            this.scene.invoke(false, gLAutoDrawable -> {
                GlyphShape glyphShape2;
                if (1 == group2.getShapeCount() && null != (glyphShape2 = (GlyphShape)group2.getShapeByIdx(0))) {
                    if (glyphShape2.getGlyph().getCodepoint() == glyphShape.getGlyph().getCodepoint()) {
                        return true;
                    }
                    group2.removeShape((Shape)glyphShape2);
                }
                group2.addShape((Shape)glyphShape);
                FontView01.setGlyphInfo(this.fontStatus, label, glyphShape.getGlyph());
                this.lastCodepoint = glyphShape.getGlyph().getCodepoint();
                return true;
            });
        };
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getRequestedGLCapabilities();
        Group group4 = new Group((Group.Layout)new GridLayout(2, 0.0f, 0.0f, Alignment.None));
        Group group5 = new Group((Group.Layout)new GridLayout(gridDim.columns, f * 0.9f, f * 0.9f, Alignment.FillCenter, new Gap(f * 0.1f)));
        group5.setInteractive(true).setDragAndResizable(false).setToggleable(false).setName("GlyphGrid");
        FontView01.addGlyphs(gLCapabilitiesImmutable.getGLProfile(), this.font, group5, gridDim, this.showUnderline, this.showLabel, this.fontStatus, this.fontInfo, pointerListener);
        group5.setRelayoutOnDirtyShapes(false);
        if (VERBOSE_UI) {
            group5.validate(gLCapabilitiesImmutable.getGLProfile());
            System.err.println("GlyphGrid " + group5);
            System.err.println("GlyphGrid " + group5.getLayout());
        }
        if (null != (glyphShape = FontView01.getGlyphShape((Shape)group5))) {
            group2.addShape((Shape)glyphShape);
        }
        glyphShape = new RangedGroup(FontView01.options.renderModes, group5, (Vec2f)object, null, new RangedGroup.SliderParam(new Vec2f(f / 4.0f, object.y()), f / 10.0f, true));
        glyphShape.getVertSlider().setColor(0.3f, 0.3f, 0.3f, 0.7f).setName("GlyphView");
        if (VERBOSE_UI) {
            glyphShape.getVertSlider().addChangeListener((rangeSlider, f2, f3, f4, f5, vec3f, mouseEvent) -> {
                Vec2f vec2f = rangeSlider.getMinMax();
                float f6 = f3 / f;
                System.err.println("VertSlider: row[" + f6 + ".." + (f6 + (float)gridDim.rowsPerPage - 1.0f) + "]/" + gridDim.rows + ", val[" + f2 + " -> " + f3 + "]/" + vec2f.y() + ", pct[" + 100.0f * f4 + "% -> " + 100.0f * f5 + "%], cellSz " + f);
                System.err.println("VertSlider: " + rangeSlider.getDescription());
            });
        }
        glyphShape.getVertSlider().receiveKeyEvents((Shape)group5);
        if (VERBOSE_UI) {
            glyphShape.validate(gLCapabilitiesImmutable.getGLProfile());
            System.err.println("GlyphView " + glyphShape);
        }
        group4.addShape((Shape)glyphShape);
        float f6 = (1.0f - object.x()) * 1.15f;
        float f7 = object.y() * 0.5f;
        Group group6 = new Group((Group.Layout)new GridLayout(1, f6, f7 * 1.0f, Alignment.FillCenter, new Gap(f7 * 0.001f, 0.0f)));
        group6.setPaddding(new Padding(0.0f, 0.0f, 0.0f, 0.01f));
        group6.addShape(group.setBorder(0.005f).setBorderColor(0.0f, 0.0f, 0.0f, 1.0f));
        group6.addShape(group3.setBorder(0.005f).setBorderColor(0.0f, 0.0f, 0.0f, 1.0f));
        if (VERBOSE_UI) {
            group6.validate(gLCapabilitiesImmutable.getGLProfile());
            System.err.println("InfoGrid " + group6);
            System.err.println("InfoGrid " + group6.getLayout());
            System.err.println("GlyphShapeBox " + group);
        }
        group4.addShape((Shape)group6);
        group4.setPaddding(new Padding(f / 6.0f, 0.0f, 0.0f));
        if (VERBOSE_UI) {
            group4.validate(gLCapabilitiesImmutable.getGLProfile());
            System.err.println("GlyphInfoGrid " + group4);
            System.err.println("GlyphInfoGrid " + group4.getLayout());
        }
        this.mainView = new Group((Group.Layout)new GridLayout(1, 0.0f, 0.0f, Alignment.None));
        this.mainView.addShape((Shape)group4);
        this.infoLabel = new Label(FontView01.options.renderModes, this.fontInfo, (CharSequence)"Not yet");
        this.infoLabel.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        this.infoLabel.setTooltip((Tooltip)new TooltipText((CharSequence)"Click on a Glyph for a big tooltip view.\nKey-Up/Down or Slider-Mouse-Scroll to move through glyphs.\nPage-Up/Down or Control + Slider-Mouse-Scroll to page faster.\nMouse-Scroll over left-half of Window rotates and holding control zooms.", this.fontInfo, 8.0f));
        f6 = f * 0.4f;
        Group group7 = new Group((Group.Layout)new BoxLayout(1.0f, f6, new Alignment(Alignment.Bit.Fill.value | Alignment.Bit.CenterVert.value), new Margin(0.0f, 0.005f)));
        group7.addShape((Shape)this.infoLabel);
        this.mainView.addShape((Shape)group7);
        if (VERBOSE_UI) {
            this.mainView.validate(gLCapabilitiesImmutable.getGLProfile());
            System.err.println("MainView " + this.mainView);
            System.err.println("MainView " + this.mainView.getLayout());
        }
        this.scene.addShape((Shape)this.mainView);
        this.scene.setAAQuality(FontView01.options.graphAAQuality);
        this.scene.init(gLAutoDrawable);
        this.firstReshape = true;
        long l2 = Clock.currentNanos();
        long l3 = l2 - l;
        float f8 = l3 / (long)gridDim.glyphCount;
        System.err.println("PERF: Total took " + (double)l3 / 1000000.0 + "ms, per-glyph " + (double)f8 / 1000000.0 + "ms, glyphs " + gridDim.glyphCount);
        OutlineShape.printPerf((PrintStream)System.err);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.mainView.destroy(gLAutoDrawable.getGL().getGL2ES2(), this.scene.getRenderer());
        this.mainView = null;
        this.infoLabel = null;
        this.scene.dispose(gLAutoDrawable);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.scene.reshape(gLAutoDrawable, n, n2, n3, n4);
        if (this.firstReshape) {
            this.firstReshape = false;
            AABBox aABBox = this.scene.getBounds();
            this.mainView.validate(gLAutoDrawable.getGL().getGL2ES2());
            AABBox aABBox2 = this.mainView.getBounds();
            float f = aABBox.getWidth() / aABBox2.getWidth();
            float f2 = aABBox.getHeight() / aABBox2.getHeight();
            float f3 = Math.min(f, f2);
            System.err.println("SceneBox " + aABBox);
            System.err.println("MainViewBox " + aABBox2);
            System.err.println("scale sx " + f + ", sy " + f2 + ", sxy " + f3);
            this.mainView.scale(f3, f3, 1.0f).moveTo(aABBox.getLow());
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.infoLabel.setText((CharSequence)(this.scene.getStatusText(gLAutoDrawable, FontView01.options.renderModes, this.dpiY) + " (Hover over 1s for help)"));
        this.scene.display(gLAutoDrawable);
    }

    static void printScreenOnGLThread(Scene scene, GLCapabilitiesImmutable gLCapabilitiesImmutable, Font font, int n) {
        String string = font.getFullFamilyName().replace(' ', '_').replace('-', '_');
        scene.screenshot(true, scene.nextScreenshotFile(null, FontView01.class.getSimpleName(), FontView01.options.renderModes, gLCapabilitiesImmutable, string + "_cp" + Integer.toHexString(n)));
    }

    static Group getGlyphShapeHolder(Shape shape) {
        if (!(shape instanceof Group)) {
            return null;
        }
        return (Group)((Group)shape).getShapeByName("GlyphHolder");
    }

    static GlyphShape getGlyphShape(Shape shape) {
        Group group = FontView01.getGlyphShapeHolder(shape);
        if (null != group && group.getShapeCount() > 0) {
            return (GlyphShape)group.getShapeByIdx(0);
        }
        return null;
    }

    static void addGlyphs(GLProfile gLProfile, Font font, Group group, GridDim gridDim, boolean bl, boolean bl2, Font font2, Font font3, Shape.PointerListener pointerListener) {
        AABBox aABBox = new AABBox();
        long l = Clock.currentNanos();
        for (int i = 0; i < gridDim.glyphCount; ++i) {
            Shape shape2;
            char c = gridDim.contourChars.get(i).charValue();
            Font.Glyph glyph = font.getGlyph(c);
            boolean bl3 = null != glyph.getShape() ? glyph.getShape().isComplex() : false;
            GlyphShape glyphShape = new GlyphShape(FontView01.options.renderModes, glyph, 0.0f, 0.0f);
            glyphShape.setColor(0.1f, 0.1f, 0.1f, 1.0f).setName("GlyphShape");
            glyphShape.setInteractive(false).setDragAndResizable(false);
            glyphShape.setName("cp_0x" + Integer.toHexString(glyph.getCodepoint()));
            Group group2 = new Group("GlyphHolder", null, null, (Shape)glyphShape);
            group2.setInteractive(false).setDragAndResizable(false);
            AABBox aABBox2 = glyph.getBounds(aABBox);
            boolean bl4 = bl && aABBox2.getMinY() < 0.0f;
            Group group3 = new Group((Group.Layout)new BoxLayout(1.0f, 1.0f, bl4 ? Alignment.None : Alignment.Center));
            group3.setBorder(0.02f).setBorderColor(bl3 ? GlyphGridBorderColorComplex : GlyphGridBorderColorSimple).setInteractive(true).setDragAndResizable(false).setName("GlyphHolder2");
            if (bl4) {
                shape2 = new Rectangle(FontView01.options.renderModes, 1.0f, aABBox2.getMinY(), 0.01f).setInteractive(false).setColor(0.0f, 0.0f, 1.0f, 0.25f);
                group3.addShape(shape2);
            }
            group3.addShape((Shape)group2);
            group3.onHover(pointerListener);
            group.receiveKeyEvents((Shape)group3);
            group3.setTooltip((Tooltip)new TooltipShape(new Vec4f(1.0f, 1.0f, 1.0f, 1.0f), new Vec4f(0.0f, 0.0f, 0.0f, 1.0f), 0.01f, new Padding(0.05f), new Vec2f(14.0f, 14.0f), 0L, FontView01.options.renderModes, (Shape)glyphShape, TooltipShape.NoOpDtor));
            group3.onClicked((shape, vec3f, mouseEvent) -> {
                System.err.println("XXX: Clicked: " + shape + ", event " + mouseEvent);
                if (mouseEvent.getPointerType(0).getPointerClass() == MouseEvent.PointerClass.Onscreen) {
                    pointerListener.run(shape, vec3f, mouseEvent);
                } else {
                    group3.getTooltip().now();
                }
            });
            if (0 < gridDim.reserverColumns() && 0 == i % gridDim.columnsNet) {
                FontView01.addLabel(group, font2, String.format("%04x", c));
            }
            if (bl2) {
                shape2 = new Group((Group.Layout)new GridLayout(1, 0.0f, 0.0f, Alignment.None));
                shape2.addShape(group3.setName("GlyphHolder3"));
                Label label = new Label(FontView01.options.renderModes, font3, (CharSequence)glyph.getName());
                shape2.addShape(label.scale(0.14285715f, 0.14285715f, 1.0f).setColor(0.0f, 0.0f, 0.0f, 1.0f).setInteractive(false).setDragAndResizable(false));
                group.addShape(shape2);
                continue;
            }
            group.addShape((Shape)group3);
        }
        long l2 = Clock.currentNanos();
        long l3 = l2 - l;
        float f = l3 / (long)gridDim.glyphCount;
        System.err.println("PERF: GlyphAdd took " + (double)l3 / 1000000.0 + "ms, per-glyph " + (double)f / 1000000.0 + "ms, glyphs " + gridDim.glyphCount);
    }

    static void addLabel(Group group, Font font, String string) {
        group.addShape(new Label(FontView01.options.renderModes, font, (CharSequence)string).setColor(0.0f, 0.0f, 0.0f, 1.0f).setInteractive(false).setDragAndResizable(false));
    }

    static void setGlyphInfo(Font font, Label label, Font.Glyph glyph) {
        label.setText((CharSequence)FontView01.getGlyphInfo(glyph));
        if (VERBOSE_GLYPHS) {
            System.err.println(label.getText());
        }
    }

    static String getGlyphInfo(Font.Glyph glyph) {
        OutlineShape outlineShape = glyph.getShape();
        boolean bl = null != outlineShape ? outlineShape.isComplex() : false;
        int n = null != outlineShape ? outlineShape.getVertexCount() : 0;
        String string = null != glyph.getName() ? glyph.getName() : "";
        AABBox aABBox = glyph.getBounds();
        String string2 = String.format("Box %+.3f/%+.3f%n    %+.3f/%+.3f", Float.valueOf(aABBox.getLow().x()), Float.valueOf(aABBox.getLow().y()), Float.valueOf(aABBox.getHigh().x()), Float.valueOf(aABBox.getHigh().y()));
        return String.format((Locale)null, "%s%nHeight: %1.3f%nLine Height: %1.3f%n%nSymbol: %04x, id %04x%nName: '%s'%nDim %1.3f x %1.3f%n%s%nAdvance %1.3f%nLS Bearings: %1.3f%nVertices: %03d%n%s", glyph.getFont().getFullFamilyName(), Float.valueOf(glyph.getFont().getMetrics().getAscent() - glyph.getFont().getMetrics().getDescent()), Float.valueOf(glyph.getFont().getLineHeight()), (int)glyph.getCodepoint(), glyph.getID(), string, Float.valueOf(aABBox.getWidth()), Float.valueOf(aABBox.getHeight()), string2, Float.valueOf(glyph.getAdvanceWidth()), Float.valueOf(glyph.getLeftSideBearings()), n, bl ? "Complex Shape" : "Simple Shape");
    }

    static class GridDim {
        final List<Character> contourChars = new ArrayList<Character>();
        final int glyphCount;
        final int columns;
        final int columnsNet;
        final int rows;
        final int rowsPerPage;
        final int elemCount;
        int complexGlyphCount;
        int maxNameLen;

        public GridDim(Font font, int n, int n2, int n3, int n4) {
            this.glyphCount = Math.min(n4, this.scanContourGlyphs(font));
            this.columns = n;
            this.columnsNet = n - n3;
            this.rows = (int)Math.ceil((double)this.glyphCount / (double)this.columnsNet);
            this.rowsPerPage = n2;
            this.elemCount = this.glyphCount + this.rows * n3;
            this.maxNameLen = 10;
        }

        public int reserverColumns() {
            return this.columns - this.columnsNet;
        }

        private int scanContourGlyphs(Font font) {
            long l = Clock.currentNanos();
            this.contourChars.clear();
            this.complexGlyphCount = 0;
            this.maxNameLen = 1;
            int[] nArray = new int[]{max_glyph_count};
            font.forAllGlyphs(glyph -> {
                if (!glyph.isNonContour()) {
                    int n = nArray[0];
                    nArray[0] = n - 1;
                    if (n > 0) {
                        this.contourChars.add(Character.valueOf(glyph.getCodepoint()));
                        if (null != glyph.getShape() && glyph.getShape().isComplex()) {
                            ++this.complexGlyphCount;
                        }
                        this.maxNameLen = Math.max(this.maxNameLen, glyph.getName().length());
                    }
                }
            });
            long l2 = Clock.currentNanos();
            long l3 = l2 - l;
            float f = l3 / (long)this.contourChars.size();
            System.err.println("PERF: GlyphScan took " + (double)l3 / 1000000.0 + "ms, per-glyph " + (double)f / 1000000.0 + "ms, glyphs " + this.contourChars.size());
            return this.contourChars.size();
        }

        public String toString() {
            return "GridDim[contours " + this.glyphCount + ", complex " + this.complexGlyphCount + " (" + (float)this.complexGlyphCount / (float)this.glyphCount * 100.0f + "%), " + this.columns + "x" + this.rows + "=" + this.columns * this.rows + ">=" + this.elemCount + ", rows/pg " + this.rowsPerPage + "]";
        }
    }
}

