/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.GLButton;
import com.jogamp.math.Recti;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.demos.es2.GearsES2;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;

public class UISceneDemo01 {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);

    public static void main(String[] stringArray) throws IOException {
        long l;
        options.parse(stringArray);
        System.err.println(options);
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        Font font = FontFactory.get((int)0).get(1, 2);
        System.err.println("Font: " + font.getFullFamilyName());
        Shape shape = UISceneDemo01.makeShape(font, UISceneDemo01.options.renderModes);
        System.err.println("Shape bounds " + shape.getBounds(gLCapabilities.getGLProfile()));
        System.err.println("Shape " + shape);
        Scene scene = new Scene(UISceneDemo01.options.graphAASamples);
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new MyPMVMatrixSetup());
        scene.addShape(shape);
        scene.setAAQuality(UISceneDemo01.options.graphAAQuality);
        final Animator animator = new Animator(0);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UISceneDemo01.options.surface_width, UISceneDemo01.options.surface_height);
        gLWindow.setTitle(UISceneDemo01.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)scene);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UISceneDemo01.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        scene.attachInputListenerTo(gLWindow);
        animator.setUpdateFPSFrames(60, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        scene.waitUntilDisplayed();
        AABBox aABBox = scene.getBounds();
        System.err.println("SceneBox " + aABBox);
        System.err.println("Shape " + shape);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        float f = aABBox.getMinX();
        float f2 = aABBox.getMaxX() - shape.getScaledWidth();
        int[] nArray = shape.getSurfaceSize(scene, new PMVMatrix4f(), new int[2]);
        float[] fArray = shape.getPixelPerShapeUnit(nArray, new float[2]);
        float f3 = gLWindow.getPixelsPerMM(new float[2])[0];
        float f4 = scene.getWidth() - nArray[0];
        float f5 = f4 / f3 / 1000.0f;
        float f6 = 50.0f * f3;
        float f7 = f6 / fArray[0];
        float f8 = f5 / 0.05f;
        System.err.println();
        System.err.printf("Shape: %d x %d [pixel], %.4f px/shape_unit%n", nArray[0], nArray[1], Float.valueOf(fArray[0]));
        System.err.printf("Shape: %s%n", shape);
        System.err.println();
        System.err.printf("Distance: %.0f pixel @ %.3f px/mm, %.3f mm%n", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf(f5 * 1000.0f));
        System.err.printf("Velocity: %.3f mm/s, %.3f px/s, %.6f obj/s, expected travel-duration %.3f s%n", Float.valueOf(50.0f), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8));
        long l2 = l = Clock.currentNanos() / 1000L;
        shape.moveTo(f, 0.0f, 0.0f);
        while (shape.getPosition().x() < f2 && gLWindow.isNativeValid()) {
            long l3 = Clock.currentNanos() / 1000L;
            float f9 = (float)(l3 - l2) / 1000000.0f;
            l2 = l3;
            float f10 = f7 * f9;
            gLWindow.invoke(true, gLAutoDrawable -> {
                shape.move(f10, 0.0f, 0.0f);
                return true;
            });
        }
        float f11 = (float)(Clock.currentNanos() / 1000L - l) / 1000000.0f;
        System.err.printf("Actual travel-duration %.3f s, delay %.3f s%n", Float.valueOf(f11), Float.valueOf(f11 - f8));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!UISceneDemo01.options.stayOpen) {
            gLWindow.destroy();
        }
    }

    static Shape makeShape(Font font, int n) {
        final GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setVerbose(false);
        gearsES2.setClearColor(new float[]{0.9f, 0.9f, 0.9f, 1.0f});
        final boolean[] blArray = new boolean[]{true};
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.err.println("Gears Anim: Waiting");
                try {
                    gearsES2.waitForInit(true);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("Gears Anim: Started");
                while (gearsES2.isInit()) {
                    if (blArray[0]) {
                        float f = (gearsES2.getRotY() + 1.0f) % 360.0f;
                        gearsES2.setRotY(f);
                    }
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.err.println("Gears Anim: End");
            }
        }).start();
        final GLButton gLButton = new GLButton(n, 25.0f, 10.0f, 1, (GLEventListener)gearsES2, false);
        gLButton.setToggleable(true);
        gLButton.setToggle(true);
        gLButton.setAnimate(true);
        gLButton.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                gLButton.setAnimate(gLButton.isToggleOn());
                blArray[0] = gLButton.getAnimate();
            }
        });
        return gLButton;
    }

    static class MyPMVMatrixSetup
    extends Scene.DefaultPMVMatrixSetup {
        MyPMVMatrixSetup() {
        }

        public void set(PMVMatrix4f pMVMatrix4f, Recti recti) {
            super.set(pMVMatrix4f, recti);
            AABBox aABBox = new AABBox();
            this.setPlaneBox(aABBox, pMVMatrix4f, recti);
            float f = aABBox.getWidth();
            float f2 = aABBox.getHeight();
            float f3 = f > f2 ? f : f2;
            pMVMatrix4f.scaleP(f3 / 100.0f, f3 / 100.0f, 1.0f);
        }
    }
}

