/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.math.Recti;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;

public class UIShapeDemo00 {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);

    public static void main(String[] stringArray) throws IOException {
        options.parse(stringArray);
        System.err.println(options);
        GLProfile gLProfile = GLProfile.get((String)UIShapeDemo00.options.glProfileName);
        System.err.println("GLProfile: " + gLProfile);
        Font font = FontFactory.get((int)0).get(1, 2);
        System.err.println("Font: " + font.getFullFamilyName());
        Button button = new Button(UIShapeDemo00.options.renderModes, font, (CharSequence)"Hello JogAmp", 0.3f, 0.120000005f);
        System.err.println("Shape bounds " + button.getBounds(gLProfile));
        final Scene scene = new Scene(UIShapeDemo00.options.graphAASamples);
        scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new MyPMVMatrixSetup());
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        scene.addShape((Shape)button);
        scene.setAAQuality(UIShapeDemo00.options.graphAAQuality);
        final Animator animator = new Animator(0);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.out.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UIShapeDemo00.options.surface_width, UIShapeDemo00.options.surface_height);
        gLWindow.setTitle(UIShapeDemo00.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)scene);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UIShapeDemo00.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        scene.attachInputListenerTo(gLWindow);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                if (s == 151) {
                    scene.setAAQuality(scene.getAAQuality() + 1);
                    System.err.println("AA Quality " + scene.getAAQuality());
                } else if (s == 149) {
                    scene.setAAQuality(scene.getAAQuality() - 1);
                    System.err.println("AA Quality " + scene.getAAQuality());
                } else if (s == 150) {
                    scene.setSampleCount(scene.getSampleCount() + 1);
                    System.err.println("AA Samples " + scene.getSampleCount());
                } else if (s == 152) {
                    scene.setSampleCount(scene.getSampleCount() - 1);
                    System.err.println("AA Samples " + scene.getSampleCount());
                } else if (s == 100 || s == 27 || s == 81) {
                    new InterruptSource.Thread(() -> gLWindow.destroy()).start();
                }
            }
        });
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
    }

    static class MyPMVMatrixSetup
    extends Scene.DefaultPMVMatrixSetup {
        MyPMVMatrixSetup() {
        }

        public void set(PMVMatrix4f pMVMatrix4f, Recti recti) {
            super.set(pMVMatrix4f, recti);
            AABBox aABBox = new AABBox();
            this.setPlaneBox(aABBox, pMVMatrix4f, recti);
            float f = aABBox.getWidth();
            float f2 = aABBox.getHeight();
            float f3 = f > f2 ? f : f2;
            pMVMatrix4f.scaleP(f3, f3, 1.0f);
        }
    }
}

