/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.util;

import com.jogamp.graph.curve.Region;
import com.jogamp.math.FloatUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.demos.util.MiscUtils;

public class CommandlineOptions {
    public static final float DefaultNoAADPIThreshold = 200.0f;
    public int surface_width;
    public int surface_height;
    public String glProfileName = "GL2ES2";
    public float noAADPIThreshold = 200.0f;
    public int renderModes = 0;
    public int sceneMSAASamples = 0;
    public int graphAASamples = 0;
    public int graphAAQuality = 1;
    public boolean exclusiveContext = false;
    public boolean wait_to_start = false;
    public boolean keepRunning = false;
    public boolean stayOpen = false;
    public int swapInterval = -1;
    public float total_duration = 0.0f;
    public boolean default_setting = true;
    public boolean default_aa_setting = true;

    public CommandlineOptions(int n, int n2, int n3) {
        this(n, n2, n3, 1, Region.isGraphAA((int)n3) ? 4 : 0, 0);
    }

    public CommandlineOptions(int n, int n2, int n3, int n4, int n5, int n6) {
        this.surface_width = n;
        this.surface_height = n2;
        this.renderModes = n3;
        this.graphAASamples = Region.clipAASampleCount((int)n5);
        this.graphAAQuality = Region.clipAAQuality((int)n4);
        this.sceneMSAASamples = !Region.isGraphAA((int)n3) ? n6 : 0;
    }

    public void parse(String[] stringArray) {
        int[] nArray = new int[]{0};
        nArray[0] = 0;
        while (nArray[0] < stringArray.length) {
            this.parse(stringArray, nArray);
            nArray[0] = nArray[0] + 1;
        }
    }

    public boolean parse(String[] stringArray, int[] nArray) {
        if (0 > nArray[0] || nArray[0] >= stringArray.length) {
            return false;
        }
        boolean bl = true;
        if (stringArray[nArray[0]].equals("-hhd")) {
            this.surface_width = 1280;
            this.surface_height = 720;
        } else if (stringArray[nArray[0]].equals("-fhd")) {
            this.surface_width = 1920;
            this.surface_height = 1080;
        } else if (stringArray[nArray[0]].equals("-w")) {
            nArray[0] = nArray[0] + 1;
            this.surface_width = MiscUtils.atoi(stringArray[nArray[0]], this.surface_width);
        } else if (stringArray[nArray[0]].equals("-h")) {
            nArray[0] = nArray[0] + 1;
            this.surface_height = MiscUtils.atoi(stringArray[nArray[0]], this.surface_height);
        } else if (stringArray[nArray[0]].equals("-es2")) {
            this.glProfileName = "GLES2";
        } else if (stringArray[nArray[0]].equals("-es3")) {
            this.glProfileName = "GLES3";
        } else if (stringArray[nArray[0]].equals("-gl2")) {
            this.glProfileName = "GL2";
        } else if (stringArray[nArray[0]].equals("-gl3bc")) {
            this.glProfileName = "GL3bc";
        } else if (stringArray[nArray[0]].equals("-gl3")) {
            this.glProfileName = "GL3";
        } else if (stringArray[nArray[0]].equals("-gl4")) {
            this.glProfileName = "GL4";
        } else if (stringArray[nArray[0]].equals("-gl4bc")) {
            this.glProfileName = "GL4bc";
        } else if (stringArray[nArray[0]].equals("-gldef")) {
            this.glProfileName = null;
        } else if (stringArray[nArray[0]].equals("-gnone")) {
            this.sceneMSAASamples = 0;
            this.graphAASamples = 0;
            this.renderModes = 0;
            this.default_aa_setting = false;
        } else if (stringArray[nArray[0]].equals("-smsaa")) {
            nArray[0] = nArray[0] + 1;
            this.graphAASamples = 0;
            this.sceneMSAASamples = MiscUtils.atoi(stringArray[nArray[0]], 4);
            this.renderModes &= 0xFFFFFFFC;
            this.default_aa_setting = false;
        } else if (stringArray[nArray[0]].equals("-gmsaa")) {
            nArray[0] = nArray[0] + 1;
            this.sceneMSAASamples = 0;
            this.graphAASamples = MiscUtils.atoi(stringArray[nArray[0]], 4);
            this.renderModes &= 0xFFFFFFFC;
            this.renderModes |= 1;
            this.default_aa_setting = false;
        } else if (stringArray[nArray[0]].equals("-gvbaa")) {
            nArray[0] = nArray[0] + 1;
            this.sceneMSAASamples = 0;
            this.graphAASamples = MiscUtils.atoi(stringArray[nArray[0]], 4);
            this.renderModes &= 0xFFFFFFFC;
            this.renderModes |= 2;
            this.default_aa_setting = false;
        } else if (stringArray[nArray[0]].equals("-color")) {
            this.renderModes |= 0x200;
        } else if (stringArray[nArray[0]].equals("-no-color")) {
            this.renderModes &= 0xFFFFFDFF;
        } else if (stringArray[nArray[0]].equals("-gaaq")) {
            nArray[0] = nArray[0] + 1;
            this.graphAAQuality = Region.clipAAQuality((int)MiscUtils.atoi(stringArray[nArray[0]], this.graphAAQuality));
        } else if (stringArray[nArray[0]].equals("-exclusiveContext")) {
            this.exclusiveContext = true;
        } else if (stringArray[nArray[0]].equals("-wait")) {
            this.wait_to_start = true;
        } else if (stringArray[nArray[0]].equals("-keep")) {
            this.keepRunning = true;
            this.stayOpen = true;
        } else if (stringArray[nArray[0]].equals("-stay")) {
            this.stayOpen = true;
        } else if (stringArray[nArray[0]].equals("-swapInterval")) {
            nArray[0] = nArray[0] + 1;
            this.swapInterval = MiscUtils.atoi(stringArray[nArray[0]], this.swapInterval);
        } else if (stringArray[nArray[0]].equals("-duration")) {
            nArray[0] = nArray[0] + 1;
            this.total_duration = MiscUtils.atof(stringArray[nArray[0]], this.total_duration);
        } else {
            bl = false;
        }
        this.default_setting = this.default_setting && !bl;
        return bl;
    }

    public GLProfile getGLProfile() {
        return GLProfile.get((String)this.glProfileName);
    }

    public void setGLProfile(String string) {
        this.glProfileName = string;
    }

    public GLCapabilities getGLCaps() {
        GLProfile gLProfile = this.getGLProfile();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        if (this.sceneMSAASamples > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(this.sceneMSAASamples);
        }
        return gLCapabilities;
    }

    public int fixDefaultAARenderModeWithDPIThreshold(float f) {
        boolean bl;
        int n = this.renderModes;
        boolean bl2 = bl = Region.isGraphAA((int)this.renderModes) || 0 < this.sceneMSAASamples;
        if (this.default_aa_setting && !FloatUtil.isZero((float)this.noAADPIThreshold)) {
            if (f >= this.noAADPIThreshold) {
                this.renderModes &= 0xFFFFFFFC;
            } else if (!bl) {
                this.renderModes = 2;
            }
        }
        return n;
    }

    public String toString() {
        return "Options{surface[width " + this.surface_width + " x " + this.surface_height + "], glp " + this.glProfileName + ", renderModes " + Region.getRenderModeString((int)this.renderModes) + ", aa-q " + this.graphAAQuality + ", gmsaa " + this.graphAASamples + ", smsaa " + this.sceneMSAASamples + ", exclusiveContext " + this.exclusiveContext + ", wait " + this.wait_to_start + ", keep " + this.keepRunning + ", stay " + this.stayOpen + ", swap-ival " + this.swapInterval + ", dur " + this.total_duration + "s}";
    }

    static {
        GLProfile.initSingleton();
    }
}

