/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.junit;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.UnsupportedAudioFileException;
import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.test.util.UITestCase;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ALExtLoopbackDeviceSOFTTest
extends UITestCase {
    static boolean dumpSamples = false;

    @Test
    public void test01Mono() throws UnsupportedAudioFileException, IOException {
        this.testAlCLoopbackDeviceSOFTImpl(0, 0.4f);
    }

    @Test
    public void test02Stereo() throws UnsupportedAudioFileException, IOException {
        this.testAlCLoopbackDeviceSOFTImpl(3, 0.8f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAlCLoopbackDeviceSOFTImpl(int n, float f) throws UnsupportedAudioFileException, IOException {
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        InputStream inputStream;
        ALC aLC = ALFactory.getALC();
        AL aL = ALFactory.getAL();
        ALExt aLExt = ALFactory.getALExt();
        System.out.println("Available null device OpenAL Extensions:" + aLC.alcGetString(null, 4102));
        if (!aLC.alcIsExtensionPresent(null, "ALC_SOFT_loopback")) {
            System.out.println("No extension ALC_SOFT_loopback present");
            return;
        }
        if (0 == n) {
            inputStream = ResourceLocation.getTestStream0();
            n5 = 5376;
            n4 = 5120;
            n3 = 8;
            n2 = 1;
            bl = false;
        } else if (3 == n) {
            inputStream = ResourceLocation.getTestStream3();
            n5 = 5377;
            n4 = 5122;
            n3 = 16;
            n2 = 2;
            bl = true;
        } else {
            return;
        }
        ALCdevice aLCdevice = null;
        Exception exception = null;
        try {
            Object object;
            int n6;
            System.out.println("begin testAlCLoopbackDeviceSOFT");
            aLCdevice = aLExt.alcLoopbackOpenDeviceSOFT(null);
            int n7 = aLC.alcGetError(aLCdevice);
            System.err.printf("CreatedSoftDevice: alcError 0x%X, dev %s%n", n7, aLCdevice);
            Assert.assertNotNull(aLCdevice);
            WAVData wAVData = null;
            ALCcontext aLCcontext = null;
            try {
                wAVData = WAVLoader.loadFromStream(inputStream);
                System.err.println("fmt " + wAVData.format);
                System.err.println("freq " + wAVData.freq);
                System.err.println("size " + wAVData.size);
                n6 = aLExt.alcIsRenderFormatSupportedSOFT(aLCdevice, wAVData.freq, n5, n4) ? 1 : 0;
                object = String.format("Supported channels 0x%X, data 0x%X: %b", n5, n4, n6 != 0);
                System.err.println((String)object);
                Assert.assertTrue("Not supported: " + (String)object, n6 != 0);
                aLCcontext = aLC.alcCreateContext(aLCdevice, new int[]{6544, n5, 6545, n4, 4103, wAVData.freq, 0}, 0);
                int n8 = aLC.alcGetError(aLCdevice);
                System.err.printf("CreatedSoftContext: alcError 0x%X, context %s%n", n8, aLCcontext);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            Assert.assertNull(exception);
            Assert.assertNotNull("ALC context null", aLCcontext);
            Assert.assertTrue("Could not make context current", aLC.alcMakeContextCurrent(aLCcontext));
            try {
                int n9;
                n6 = Math.min(4096, wAVData.size);
                object = new int[]{0};
                aL.alGenSources(1, (int[])object, 0);
                Assert.assertEquals("Could not gen source", 0L, aL.alGetError());
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                aL.alGenBuffers(1, nArray, 0);
                Assert.assertEquals("Could not generate AL buffer", 0L, aL.alGetError());
                aL.alBufferData(nArray[0], wAVData.format, wAVData.data, n6, wAVData.freq);
                Assert.assertEquals("Could not fill AL source buffer " + nArray[0] + ", sz " + n6 + ", " + wAVData.data, 0L, aL.alGetError());
                aL.alGetBufferi(nArray[0], 8196, nArray2, 0);
                Assert.assertEquals("Could not get buffer size " + nArray[0], 0L, aL.alGetError());
                System.err.println("Buffer size " + nArray2[0] + " of " + n6);
                aL.alSourcei(object[0], 4105, nArray[0]);
                Assert.assertEquals("Could source buffer " + nArray[0], 0L, aL.alGetError());
                aL.alSourcePlay(object[0]);
                Assert.assertEquals("Could not play source " + object[0], 0L, aL.alGetError());
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6).order(wAVData.data.order());
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                ShortBuffer shortBuffer2 = wAVData.data.asShortBuffer();
                try {
                    n9 = n6 / (n3 / 8 * n2);
                    aLExt.alcRenderSamplesSOFT(aLCdevice, byteBuffer, n9);
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
                Assert.assertNull(exception);
                n9 = aL.alGetError();
                int n10 = aLC.alcGetError(aLCdevice);
                System.err.printf("alcRendering: alError 0x%X, alcError 0x%X%n", n9, n10);
                int n11 = bl ? shortBuffer.limit() : byteBuffer.limit();
                float f2 = 0.0f;
                int n12 = 0;
                for (int i = 0; i < n11; ++i) {
                    float f3;
                    int n13;
                    int n14;
                    short s;
                    short s2;
                    if (dumpSamples && 0 == n12 % 3) {
                        System.err.printf("%n[%04d]: ", i);
                    }
                    if (bl) {
                        s2 = shortBuffer2.get(i);
                        s = shortBuffer.get(i);
                        n14 = 32768 + s2;
                        n13 = 32768 + s;
                        f3 = Math.abs((float)Math.abs(n14 - n13) / 65536.0f);
                        if (dumpSamples) {
                            System.err.printf("%6d %04X-> %6d %04X (%1.5f), ", s2, n14, (int)s, n13, Float.valueOf(f3));
                        }
                    } else {
                        s2 = wAVData.data.get(i);
                        s = byteBuffer.get(i);
                        n14 = 128 + s2;
                        n13 = 128 + s;
                        f3 = Math.abs((float)Math.abs(n14 - n13) / 256.0f);
                        if (dumpSamples) {
                            System.err.printf("%4d %02X-> %4d %02X (%1.5f), ", s2, n14, (int)s, n13, Float.valueOf(f3));
                        }
                    }
                    f2 += f3;
                    ++n12;
                }
                if (dumpSamples) {
                    System.err.println();
                }
                float f4 = f2 / (float)n12;
                float f5 = Math.abs(1.0f - f4);
                String string = String.format("Size[%04d s, %04d b, %04d b-t], Delta T %f, A %f, Accuracy %f / %f", n12, n6, wAVData.size, Float.valueOf(f2), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f));
                System.err.println(string);
                Assert.assertTrue("Too many rendering artifacts: " + string, f <= f5);
            }
            finally {
                aLC.alcMakeContextCurrent(null);
            }
        }
        finally {
            if (null != aLCdevice) {
                aLC.alcCloseDevice(aLCdevice);
            }
        }
        System.out.println("end testAlCLoopbackDeviceSOFT");
    }

    public static void main(String[] stringArray) throws IOException {
        dumpSamples = true;
        JUnitCore.main(ALExtLoopbackDeviceSOFTTest.class.getName());
    }
}

