/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLProgramBuilder;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLBuildConfiguration;
import com.jogamp.opencl.util.CLBuildListener;
import com.jogamp.opencl.util.CLProgramConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLProgramTest
extends UITestCase {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private static final String test20KernelSource = "__attribute__((reqd_work_group_size(1, 1, 1))) kernel void foo(float a, int b, short c) { }\n";

    @Test
    public void test01Enums() {
        for (CLProgram.Status status : CLProgram.Status.values()) {
            Assert.assertEquals((Object)status, (Object)CLProgram.Status.valueOf(status.STATUS));
        }
    }

    @Test
    public void test02RebuildProgram() throws IOException {
        CLContext cLContext = CLContext.create();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl"));
        if (!cLContext.getPlatform().isVendorAMD()) {
            try {
                cLProgram.createCLKernels();
                Assert.fail("expected exception but got none :(");
            }
            catch (CLException cLException) {
                System.out.println("got expected exception:  " + cLException.getCLErrorString());
                Assert.assertEquals(cLException.errorcode, -45L);
            }
        }
        System.out.println(cLProgram.getBuildStatus());
        cLProgram.build();
        System.out.println(cLProgram.getBuildStatus());
        Assert.assertTrue(cLProgram.isExecutable());
        CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM");
        Assert.assertNotNull(cLKernel);
        cLProgram.build();
        Assert.assertTrue(cLProgram.isExecutable());
        System.out.println(cLProgram.getBuildStatus());
        cLKernel = cLProgram.createCLKernel("VectorAddGM");
        Assert.assertNotNull(cLKernel);
        cLContext.release();
    }

    @Test
    public void test03ProgramBinaries() throws IOException {
        CLContext cLContext = CLContext.create();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build("-cl-mad-enable", "-Werror");
        Map<CLDevice, byte[]> map = cLProgram.getBinaries();
        Assert.assertFalse(map.isEmpty());
        CLDevice[] cLDeviceArray = cLProgram.getCLDevices();
        for (CLDevice cLDevice : cLDeviceArray) {
            Assert.assertTrue(map.containsKey(cLDevice));
        }
        cLProgram.release();
        Assert.assertFalse(cLProgram.isExecutable());
        Assert.assertNotNull(cLProgram.getBinaries());
        Assert.assertEquals(cLProgram.getBinaries().size(), 0L);
        Assert.assertNotNull(cLProgram.getBuildLog());
        Assert.assertEquals(cLProgram.getBuildLog().length(), 0L);
        Assert.assertNotNull(cLProgram.getSource());
        Assert.assertEquals(cLProgram.getSource().length(), 0L);
        Assert.assertNotNull(cLProgram.getCLDevices());
        Assert.assertEquals(cLProgram.getCLDevices().length, 0L);
        Object object = cLProgram.createCLKernels();
        Assert.assertNotNull(object);
        Assert.assertEquals(object.size(), 0L);
        Assert.assertNull(cLProgram.createCLKernel("foo"));
        cLProgram = cLContext.createProgram(map);
        if (!cLContext.getPlatform().isVendorIntel()) {
            Assert.assertFalse(cLProgram.isExecutable());
        } else {
            Assert.assertTrue(cLProgram.isExecutable());
        }
        Assert.assertNotNull(cLProgram.getCLDevices());
        Assert.assertTrue(cLProgram.getCLDevices().length != 0);
        Assert.assertNotNull(cLProgram.getBinaries());
        if (!cLContext.getPlatform().isVendorIntel()) {
            Assert.assertEquals(cLProgram.getBinaries().size(), 0L);
        } else {
            Assert.assertTrue(cLProgram.getBinaries().size() > 0);
        }
        Assert.assertNotNull(cLProgram.getBuildLog());
        Assert.assertTrue(cLProgram.getBuildLog().length() != 0);
        Assert.assertNotNull(cLProgram.getSource());
        Assert.assertEquals(cLProgram.getSource().length(), 0L);
        if (!cLContext.getPlatform().isVendorAMD() && !cLContext.getPlatform().isVendorIntel()) {
            try {
                object = cLProgram.createCLKernels();
                Assert.fail("expected an exception from createCLKernels but got: " + object);
            }
            catch (CLException cLException) {
                // empty catch block
            }
        }
        System.out.println(cLProgram.getBuildStatus());
        cLProgram.build();
        System.out.println(cLProgram.getBuildStatus());
        Assert.assertNotNull(cLProgram.createCLKernel("Test"));
        Assert.assertTrue(cLProgram.isExecutable());
        cLContext.release();
    }

    private void builderImpl(boolean bl) throws IOException, ClassNotFoundException, InterruptedException {
        Object object;
        Object object2;
        Object object3;
        CLContext cLContext = CLContext.create();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl"));
        cLProgram.prepare().build();
        Assert.assertTrue(cLProgram.isExecutable());
        cLProgram.prepare().withOption("-cl-mad-enable").forDevice(cLContext.getMaxFlopsDevice()).withDefine("RADIUS", 5).withDefine("ENABLE_FOOBAR").build();
        Assert.assertTrue(cLProgram.isExecutable());
        CLBuildConfiguration cLBuildConfiguration = CLProgramBuilder.createConfiguration().withOption("-cl-mad-enable").forDevices(cLContext.getDevices()).withDefine("RADIUS", 5).withDefine("ENABLE_FOOBAR");
        System.out.println(cLBuildConfiguration);
        if (bl) {
            object3 = cLProgram;
            cLBuildConfiguration.setProgram(cLProgram).build();
            Assert.assertEquals(object3, cLProgram);
        } else {
            object3 = new CountDownLatch(1);
            object2 = cLProgram;
            object = new CLBuildListener(){
                final /* synthetic */ CLProgram val$outerProgram;
                final /* synthetic */ CountDownLatch val$countdown;
                {
                    this.val$outerProgram = cLProgram;
                    this.val$countdown = countDownLatch;
                }

                @Override
                public void buildFinished(CLProgram cLProgram) {
                    Assert.assertEquals(this.val$outerProgram, cLProgram);
                    this.val$countdown.countDown();
                }
            };
            cLBuildConfiguration.setProgram(cLProgram).build((CLBuildListener)object);
            ((CountDownLatch)object3).await();
        }
        Assert.assertTrue(cLProgram.isExecutable());
        object3 = this.tmpFolder.newFile("foobar.builder");
        object2 = new ObjectOutputStream(new FileOutputStream((File)object3));
        cLBuildConfiguration.save((ObjectOutputStream)object2);
        ((ObjectOutputStream)object2).close();
        object = new ObjectInputStream(new FileInputStream((File)object3));
        CLBuildConfiguration cLBuildConfiguration2 = CLProgramBuilder.loadConfiguration((ObjectInputStream)object);
        ((ObjectInputStream)object).close();
        Assert.assertEquals(cLBuildConfiguration, cLBuildConfiguration2);
        cLBuildConfiguration2.build(cLProgram);
        Assert.assertTrue(cLProgram.isExecutable());
        object = new ObjectInputStream(new FileInputStream((File)object3));
        CLProgramConfiguration cLProgramConfiguration = CLProgramBuilder.loadConfiguration((ObjectInputStream)object, cLContext);
        Assert.assertNotNull(cLProgramConfiguration.getProgram());
        ((ObjectInputStream)object).close();
        cLProgram = cLProgramConfiguration.build();
        Assert.assertTrue(cLProgram.isExecutable());
        Assert.assertEquals(cLBuildConfiguration, cLBuildConfiguration.clone());
        cLContext.release();
    }

    @Test
    public void test10BuilderSync() throws IOException, ClassNotFoundException, InterruptedException {
        this.builderImpl(true);
    }

    @Test
    public void test11BuilderAsync() throws IOException, ClassNotFoundException, InterruptedException {
        this.builderImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test20Kernel() {
        CLContext cLContext = CLContext.create();
        try {
            CLProgram cLProgram = cLContext.createProgram(test20KernelSource).build();
            Assert.assertTrue(cLProgram.isExecutable());
            CLKernel cLKernel = cLProgram.createCLKernel("foo");
            Assert.assertNotNull(cLKernel);
            long[] lArray = cLKernel.getCompileWorkGroupSize(cLContext.getDevices()[0]);
            System.out.println("compile workgroup size: " + lArray[0] + " " + lArray[1] + " " + lArray[2]);
            Assert.assertEquals(1L, lArray[0]);
            Assert.assertEquals(1L, lArray[1]);
            Assert.assertEquals(1L, lArray[2]);
            Assert.assertEquals(0L, cLKernel.position());
            cLKernel.putArg(1.0f);
            Assert.assertEquals(1L, cLKernel.position());
            cLKernel.putArg(2);
            Assert.assertEquals(2L, cLKernel.position());
            cLKernel.putArg((short)3);
            Assert.assertEquals(3L, cLKernel.position());
            try {
                cLKernel.putArg(3);
                Assert.fail("exception not thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            Assert.assertEquals(3L, cLKernel.position());
            Assert.assertEquals(0L, cLKernel.rewind().position());
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test21AllKernels() {
        CLContext cLContext = CLContext.create();
        try {
            CLProgram cLProgram = cLContext.createProgram("kernel void foo(int a) { }\nkernel void bar(float b) { }\n").build();
            Assert.assertTrue(cLProgram.isExecutable());
            Map<String, CLKernel> map = cLProgram.createCLKernels();
            for (CLKernel cLKernel : map.values()) {
                System.out.println("kernel: " + cLKernel.toString());
            }
            Assert.assertNotNull(map.get("foo"));
            Assert.assertNotNull(map.get("bar"));
            map.get("foo").setArg(0, 42);
            map.get("bar").setArg(0, 3.14f);
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test22KerneWorkGrouplInfo() {
        CLContext cLContext = CLContext.create();
        try {
            CLProgram cLProgram = cLContext.createProgram(test20KernelSource).build();
            Assert.assertTrue(cLProgram.isExecutable());
            CLKernel cLKernel = cLProgram.createCLKernel("foo");
            Assert.assertNotNull(cLKernel);
            long l = cLKernel.getPreferredWorkGroupSizeMultiple(cLContext.getDevices()[0]);
            System.out.println("preferred workgroup size multiple: " + l);
            long l2 = cLKernel.getPrivateMemSize(cLContext.getDevices()[0]);
            System.out.println("private mem size: " + l2);
        }
        finally {
            cLContext.release();
        }
    }

    public void test60Load() throws IOException, ClassNotFoundException, InterruptedException {
        for (int i = 0; i < 100; ++i) {
            this.test02RebuildProgram();
            this.test11BuilderAsync();
            this.test03ProgramBinaries();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLProgramTest.class.getName();
        JUnitCore.main(string);
    }
}

