/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.BuildProgramCallback;
import com.jogamp.opencl.llb.impl.CLImpl12;
import com.jogamp.opencl.llb.impl.CLImpl20;
import com.jogamp.opencl.test.util.MiscUtils;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLUtil;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LowLevelBindingTest
extends UITestCase {
    private static final String programSource = " // OpenCL Kernel Function for element by element vector addition                                  \nkernel void VectorAdd(global const int* a, global const int* b, global int* c, int iNumElements) { \n    // get index in global data array                                                              \n    int iGID = get_global_id(0);                                                                   \n    // bound check (equivalent to the limit on a 'for' loop for standard/serial C code             \n    if (iGID >= iNumElements)  {                                                                   \n        return;                                                                                    \n    }                                                                                              \n    // add the vector elements                                                                     \n    c[iGID] = a[iGID] + b[iGID];                                                                   \n}                                                                                                  \nkernel void Test(global const int* a, global const int* b, global int* c, int iNumElements) {      \n    // get index in global data array                                                              \n    int iGID = get_global_id(0);                                                                   \n    // bound check (equivalent to the limit on a 'for' loop for standard/serial C code             \n    if (iGID >= iNumElements)  {                                                                   \n        return;                                                                                    \n    }                                                                                              \n    c[iGID] = iGID;                                                                                \n}                                                                                                  \n";
    private int ELEMENT_COUNT = 11444777;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("OS: " + System.getProperty("os.name"));
        System.out.println("VM: " + System.getProperty("java.vm.name"));
    }

    @Test
    public void contextlessTest() {
        System.out.println(" - - - lowLevelTest; contextless binding - - - ");
        CL cL = CLPlatform.getLowLevelCLInterface();
        int n = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        n = cL.clGetPlatformIDs(0, null, intBuffer);
        this.checkForError(n);
        System.out.println("#platforms: " + intBuffer.get(0));
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        n = cL.clGetPlatformIDs(pointerBuffer.capacity(), pointerBuffer, null);
        this.checkForError(n);
        PointerBuffer pointerBuffer2 = PointerBuffer.allocateDirect(1);
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(128);
        for (int i = 0; i < pointerBuffer.capacity(); ++i) {
            long l = pointerBuffer.get(i);
            System.out.println("platform id: " + l);
            n = cL.clGetPlatformInfo(l, 2304, byteBuffer.capacity(), byteBuffer, pointerBuffer2);
            this.checkForError(n);
            System.out.println("    profile: " + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer2.get(0)));
            n = cL.clGetPlatformInfo(l, 2305, byteBuffer.capacity(), byteBuffer, pointerBuffer2);
            this.checkForError(n);
            System.out.println("    version: " + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer2.get(0)));
            n = cL.clGetPlatformInfo(l, 2306, byteBuffer.capacity(), byteBuffer, pointerBuffer2);
            this.checkForError(n);
            System.out.println("    name: " + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer2.get(0)));
            n = cL.clGetPlatformInfo(l, 2307, byteBuffer.capacity(), byteBuffer, pointerBuffer2);
            this.checkForError(n);
            System.out.println("    vendor: " + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer2.get(0)));
            n = cL.clGetDeviceIDs(l, 0xFFFFFFFFL, 0, null, intBuffer);
            this.checkForError(n);
            System.out.println("#devices: " + intBuffer.get(0));
            PointerBuffer pointerBuffer3 = PointerBuffer.allocateDirect(intBuffer.get(0));
            n = cL.clGetDeviceIDs(l, 0xFFFFFFFFL, pointerBuffer3.capacity(), pointerBuffer3, null);
            for (int j = 0; j < pointerBuffer3.capacity(); ++j) {
                long l2 = pointerBuffer3.get(j);
                n = cL.clGetDeviceInfo(l2, 4139, byteBuffer.capacity(), byteBuffer, pointerBuffer2);
                this.checkForError(n);
                System.out.println("    device: " + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer2.get(0)));
                CL cL2 = CLPlatform.getLowLevelCLInterfaceForDevice(l2);
                if (cL2 instanceof CLImpl12) {
                    System.out.println("    CL impl: 1.2");
                } else if (cL2 instanceof CLImpl20) {
                    System.out.println("    CL impl: 2.0");
                } else {
                    System.out.println("    CL impl: 1.1");
                }
                n = cL2.clGetDeviceInfo(l2, 4096, byteBuffer.capacity(), byteBuffer, pointerBuffer2);
                this.checkForError(n);
                System.out.println("    type: " + (Object)((Object)CLDevice.Type.valueOf(byteBuffer.get())));
                byteBuffer.rewind();
            }
        }
    }

    @Test
    public void createContextTest() {
        System.out.println(" - - - createContextTest - - - ");
        CL cL = CLPlatform.getLowLevelCLInterface();
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        int n = cL.clGetPlatformIDs(0, null, intBuffer);
        this.checkForError(n);
        System.out.println("#platforms: " + intBuffer.get(0));
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        n = cL.clGetPlatformIDs(pointerBuffer.capacity(), pointerBuffer, null);
        this.checkForError(n);
        long l = pointerBuffer.get(0);
        n = cL.clGetDeviceIDs(l, 0xFFFFFFFFL, 0, null, intBuffer);
        this.checkForError(n);
        System.out.println("#devices: " + intBuffer.get(0));
        PointerBuffer pointerBuffer2 = PointerBuffer.allocateDirect(intBuffer.get(0));
        n = cL.clGetDeviceIDs(l, 0xFFFFFFFFL, pointerBuffer2.capacity(), pointerBuffer2, null);
        long l2 = cL.clCreateContext(null, pointerBuffer2, null, intBuffer);
        this.checkError("on clCreateContext", intBuffer.get());
        PointerBuffer pointerBuffer3 = PointerBuffer.allocateDirect(1);
        n = cL.clGetContextInfo(l2, 4225, 0L, null, pointerBuffer3);
        this.checkError("on clGetContextInfo", n);
        long l3 = pointerBuffer3.get(0) / (long)(Platform.is32Bit() ? 4 : 8);
        System.out.println("context created on " + l3 + " devices");
        Assert.assertEquals("context was not created on all devices specified", pointerBuffer2.capacity(), l3);
        n = cL.clReleaseContext(l2);
        this.checkError("on clReleaseContext", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lowLevelVectorAddTest() throws InterruptedException {
        int n;
        System.out.println(" - - - lowLevelTest2; VectorAdd kernel - - - ");
        CL cL = CLPlatform.getLowLevelCLInterface();
        int n2 = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        n2 = cL.clGetPlatformIDs(0, null, intBuffer);
        this.checkForError(n2);
        Assert.assertTrue(intBuffer.get(0) > 0);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        n2 = cL.clGetPlatformIDs(pointerBuffer.capacity(), pointerBuffer, null);
        this.checkForError(n2);
        long l = pointerBuffer.get(0);
        PointerBuffer pointerBuffer2 = (PointerBuffer)PointerBuffer.allocateDirect(3).put(4228L).put(l).put(0L).rewind();
        long l2 = cL.clCreateContextFromType(pointerBuffer2, 0xFFFFFFFFL, null, null);
        System.out.println("context handle: " + l2);
        this.checkError("on clCreateContextFromType", n2);
        PointerBuffer pointerBuffer3 = PointerBuffer.allocateDirect(1);
        n2 = cL.clGetContextInfo(l2, 4225, 0L, null, pointerBuffer3);
        this.checkError("on clGetContextInfo", n2);
        int n3 = (int)(pointerBuffer3.get(0) / (long)(Platform.is32Bit() ? 4 : 8));
        System.out.println("context created with " + n3 + " devices");
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(32768);
        n2 = cL.clGetContextInfo(l2, 4225, byteBuffer.capacity(), byteBuffer, null);
        this.checkError("on clGetContextInfo", n2);
        for (n = 0; n < n3; ++n) {
            System.out.println("device id: " + (Platform.is32Bit() ? (long)byteBuffer.getInt() : byteBuffer.getLong()));
        }
        n = new Random().nextInt(n3);
        System.out.println("using device# " + n);
        long l3 = Platform.is32Bit() ? (long)byteBuffer.getInt(n) : byteBuffer.getLong(n *= Platform.is32Bit() ? 4 : 8);
        byteBuffer.rewind();
        n2 = cL.clGetDeviceInfo(l3, 4100, byteBuffer.capacity(), byteBuffer, null);
        this.checkError("on clGetDeviceInfo", n2);
        int n4 = byteBuffer.getInt();
        System.out.println("max WGS: " + n4);
        long l4 = cL.clCreateCommandQueue(l2, l3, 0L, intBuffer);
        this.checkError("on clCreateCommandQueue", intBuffer.get(0));
        int n5 = Math.min(128, n4);
        int n6 = this.ELEMENT_COUNT;
        int n7 = 0;
        Buffer buffer = null;
        Buffer buffer2 = null;
        ByteBuffer byteBuffer2 = null;
        boolean bl = false;
        int n8 = 1;
        while (!bl) {
            try {
                n7 = MiscUtils.roundUp(n5, n6);
                System.out.println("allocating three buffers of size: " + n7);
                buffer = Buffers.newDirectByteBuffer(n7 * 4);
                buffer2 = Buffers.newDirectByteBuffer(n7 * 4);
                byteBuffer2 = Buffers.newDirectByteBuffer(n7 * 4);
                bl = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                n6 /= ++n8;
                System.out.println("not enough direct buffer memory; retrying with smaller buffers");
            }
        }
        long l5 = cL.clCreateBuffer(l2, 4L, buffer.capacity(), null, intBuffer);
        this.checkError("on clCreateBuffer", intBuffer.get(0));
        long l6 = cL.clCreateBuffer(l2, 4L, buffer2.capacity(), null, intBuffer);
        this.checkError("on clCreateBuffer", intBuffer.get(0));
        long l7 = cL.clCreateBuffer(l2, 2L, byteBuffer2.capacity(), null, intBuffer);
        this.checkError("on clCreateBuffer", intBuffer.get(0));
        PointerBuffer pointerBuffer4 = (PointerBuffer)PointerBuffer.allocateDirect(1).put(programSource.length()).rewind();
        final long l8 = cL.clCreateProgramWithSource(l2, 1, new String[]{programSource}, pointerBuffer4, intBuffer);
        System.out.println("program id: " + l8);
        this.checkError("on clCreateProgramWithSource", intBuffer.get(0));
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        BuildProgramCallback buildProgramCallback = new BuildProgramCallback(){

            @Override
            public void buildFinished(long l) {
                try {
                    Assert.assertEquals(l8, l);
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        };
        Class<CLProgram> clazz = CLProgram.class;
        synchronized (CLProgram.class) {
            n2 = cL.clBuildProgram(l8, 0, null, null, buildProgramCallback);
            this.checkError("on clBuildProgram", n2);
            System.out.println("waiting for program to build...");
            countDownLatch.await();
            // ** MonitorExit[var38_31] (shouldn't be in output)
            System.out.println("done");
            byteBuffer.rewind();
            n2 = cL.clGetProgramInfo(l8, 4450, byteBuffer.capacity(), byteBuffer, null);
            this.checkError("on clGetProgramInfo1", n2);
            System.out.println("program associated with " + byteBuffer.getInt(0) + " device(s)");
            n2 = cL.clGetProgramInfo(l8, 4452, 0L, null, pointerBuffer3);
            this.checkError("on clGetProgramInfo CL_PROGRAM_SOURCE", n2);
            System.out.println("program source length (cl): " + pointerBuffer3.get(0));
            System.out.println("program source length (java): " + programSource.length());
            byteBuffer.rewind();
            n2 = cL.clGetProgramInfo(l8, 4452, byteBuffer.capacity(), byteBuffer, null);
            this.checkError("on clGetProgramInfo CL_PROGRAM_SOURCE", n2);
            System.out.println("program source:\n" + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer3.get(0)));
            byteBuffer.rewind();
            n2 = cL.clGetProgramBuildInfo(l8, l3, 4481, byteBuffer.capacity(), byteBuffer, null);
            this.checkError("on clGetProgramBuildInfo1", n2);
            System.out.println("program build status: " + (Object)((Object)CLProgram.Status.valueOf(byteBuffer.getInt(0))));
            Assert.assertEquals("build status", 0L, byteBuffer.getInt(0));
            n2 = cL.clGetProgramBuildInfo(l8, l3, 4483, 0L, null, pointerBuffer3);
            this.checkError("on clGetProgramBuildInfo2", n2);
            System.out.println("program log length: " + pointerBuffer3.get(0));
            byteBuffer.rewind();
            n2 = cL.clGetProgramBuildInfo(l8, l3, 4483, byteBuffer.capacity(), byteBuffer, null);
            this.checkError("on clGetProgramBuildInfo3", n2);
            System.out.println("log:\n" + CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer3.get(0)));
            long l9 = cL.clCreateKernel(l8, "VectorAdd", intBuffer);
            System.out.println("kernel id: " + l9);
            this.checkError("on clCreateKernel", intBuffer.get(0));
            MiscUtils.fillBuffer((ByteBuffer)buffer, 23456);
            MiscUtils.fillBuffer((ByteBuffer)buffer2, 46987);
            n2 = cL.clSetKernelArg(l9, 0, Platform.is32Bit() ? 4L : 8L, this.wrap(l5));
            this.checkError("on clSetKernelArg0", n2);
            n2 = cL.clSetKernelArg(l9, 1, Platform.is32Bit() ? 4L : 8L, this.wrap(l6));
            this.checkError("on clSetKernelArg1", n2);
            n2 = cL.clSetKernelArg(l9, 2, Platform.is32Bit() ? 4L : 8L, this.wrap(l7));
            this.checkError("on clSetKernelArg2", n2);
            n2 = cL.clSetKernelArg(l9, 3, 4L, this.wrap(n6));
            this.checkError("on clSetKernelArg3", n2);
            System.out.println("used device memory: " + (buffer.capacity() + buffer2.capacity() + byteBuffer2.capacity()) / 1000000 + "MB");
            n2 = cL.clEnqueueWriteBuffer(l4, l5, 0, 0L, buffer.capacity(), buffer, 0, null, null);
            this.checkError("on clEnqueueWriteBuffer", n2);
            n2 = cL.clEnqueueWriteBuffer(l4, l6, 0, 0L, buffer2.capacity(), buffer2, 0, null, null);
            this.checkError("on clEnqueueWriteBuffer", n2);
            PointerBuffer pointerBuffer5 = (PointerBuffer)PointerBuffer.allocateDirect(1).put(n7).rewind();
            PointerBuffer pointerBuffer6 = (PointerBuffer)PointerBuffer.allocateDirect(1).put(n5).rewind();
            n2 = cL.clEnqueueNDRangeKernel(l4, l9, 1, null, pointerBuffer5, pointerBuffer6, 0, null, null);
            this.checkError("on clEnqueueNDRangeKernel", n2);
            n2 = cL.clEnqueueReadBuffer(l4, l7, 1, 0L, byteBuffer2.capacity(), byteBuffer2, 0, null, null);
            this.checkError("on clEnqueueReadBuffer", n2);
            System.out.println("a+b=c result snapshot: ");
            for (int i = 0; i < 10; ++i) {
                System.out.print(byteBuffer2.getInt() + ", ");
            }
            System.out.println("...; " + byteBuffer2.remaining() / 4 + " more");
            n2 = cL.clReleaseCommandQueue(l4);
            this.checkError("on clReleaseCommandQueue", n2);
            n2 = cL.clReleaseMemObject(l5);
            this.checkError("on clReleaseMemObject", n2);
            n2 = cL.clReleaseMemObject(l6);
            this.checkError("on clReleaseMemObject", n2);
            n2 = cL.clReleaseMemObject(l7);
            this.checkError("on clReleaseMemObject", n2);
            n2 = cL.clReleaseProgram(l8);
            this.checkError("on clReleaseProgram", n2);
            n2 = cL.clReleaseKernel(l9);
            this.checkError("on clReleaseKernel", n2);
            n2 = cL.clReleaseContext(l2);
            this.checkError("on clReleaseContext", n2);
            return;
        }
    }

    public void loadTest() throws InterruptedException {
        System.out.println(" - - - loadTest - - - ");
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        ArrayList<2> arrayList = new ArrayList<2>();
        int n = 0;
        while (n < 100) {
            final int n2 = n++;
            arrayList.add(new Callable<Object>(){

                @Override
                public Object call() {
                    try {
                        System.out.println("###start iteration " + n2);
                        LowLevelBindingTest lowLevelBindingTest = new LowLevelBindingTest();
                        lowLevelBindingTest.ELEMENT_COUNT = 123456;
                        lowLevelBindingTest.lowLevelVectorAddTest();
                        System.out.println("###end iteration " + n2);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                    return null;
                }
            });
        }
        for (Future future : executorService.invokeAll(arrayList)) {
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
                executorService.shutdown();
                Assert.fail();
            }
        }
        executorService.shutdown();
        executorService.awaitTermination(300L, TimeUnit.SECONDS);
    }

    private ByteBuffer wrap(long l) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(8).putLong(l).rewind();
    }

    private void checkForError(int n) {
        this.checkError("", n);
    }

    private void checkError(String string, int n) {
        if (n != 0) {
            throw CLException.newException(n, string);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = LowLevelBindingTest.class.getName();
        JUnitCore.main(string);
    }
}

