/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.graph.GPURegionGLListener01;
import com.jogamp.opengl.test.junit.graph.GPURegionGLListener10;
import com.jogamp.opengl.test.junit.graph.GPURendererListenerBase01;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.common.os.PlatformPropsImpl;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRegionRendererNEWT01
extends UITestCase {
    public static void main(String[] stringArray) throws IOException {
        String string = TestRegionRendererNEWT01.class.getName();
        JUnitCore.main(string);
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull(gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull(gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    public void test00RegionRendererNONE01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("t00-shape-vbaa0-msaa0", gLCapabilities, 800, 400);
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(0, 1, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener(gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion01");
        gLWindow.addGLEventListener(regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, -300, 0.0f, 2);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -150, 0.0f, 3);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -50, 0.0f, 4);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    public void test01RegionRendererNONE02() throws InterruptedException {
        if (Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("t01-shape-vbaa0-msaa0", gLCapabilities, 800, 400);
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(256, 1, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener(gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion02");
        gLWindow.addGLEventListener(regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, -300, 0.0f, 2);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -150, 0.0f, 3);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -50, 0.0f, 4);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    @Test
    public void test10RegionRendererMSAA01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("t10-shape-vbaa0-msaa1", gLCapabilities, 800, 400);
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(0, 1, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener(gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion01");
        gLWindow.addGLEventListener(regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, -300, 0.0f, 2);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -150, 0.0f, 3);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -50, 0.0f, 4);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    public void test11RegionRendererMSAA02() throws InterruptedException {
        if (Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("t11-shape-vbaa0-msaa1", gLCapabilities, 800, 400);
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(256, 1, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener(gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion02");
        gLWindow.addGLEventListener(regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, -300, 0.0f, 2);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -150, 0.0f, 3);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -50, 0.0f, 4);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    @Test
    public void test20RegionRendererR2T01() throws InterruptedException {
        if (Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("t20-shape-vbaa1-msaa0", gLCapabilities, 800, 400);
        GPURegionGLListener10 gPURegionGLListener10 = new GPURegionGLListener10(2, 1, 4, false, false);
        gPURegionGLListener10.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener(gPURegionGLListener10);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener10, gLWindow.getTitle(), "GPURegionNewtDemo02");
        gLWindow.addGLEventListener(regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, -300, 0.0f, 2);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -150, 0.0f, 3);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, -50, 0.0f, 4);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    private void test30RegionRendererShapesImpl(GLCapabilities gLCapabilities, int n) throws InterruptedException {
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("t30-shape0" + n + "-vbaa0-msaa1", gLCapabilities, 800, 400);
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(n, 0, 1, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener(gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion01");
        gLWindow.addGLEventListener(regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, -50, 0.0f, 4);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    @Test
    public void test30RegionRendererShapes() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.test30RegionRendererShapesImpl(gLCapabilities, 1);
        this.test30RegionRendererShapesImpl(gLCapabilities, 2);
        this.test30RegionRendererShapesImpl(gLCapabilities, 3);
        this.test30RegionRendererShapesImpl(gLCapabilities, 4);
    }

    private static class RegionGLListener
    implements GLEventListener {
        String winTitle;
        String name;
        GPURendererListenerBase01 impl;

        public RegionGLListener(GPURendererListenerBase01 gPURendererListenerBase01, String string, String string2) {
            this.impl = gPURendererListenerBase01;
            this.winTitle = string;
            this.name = string2;
        }

        public void setTech(float f, float f2, int n, float f3, int n2) {
            this.impl.setMatrix(f, f2, n, f3);
            this.impl.getRenderer().setSampleCount(n2);
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            this.impl.init(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            this.impl.display(gLAutoDrawable);
            try {
                this.impl.printScreen(gLAutoDrawable, "./", this.winTitle, this.name, false);
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            this.impl.dispose(gLAutoDrawable);
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            this.impl.reshape(gLAutoDrawable, n, n2, n3, n4);
        }
    }
}

