/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.graph.FontSet01;
import com.jogamp.opengl.test.junit.graph.FontViewListener01;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import java.io.File;
import java.io.IOException;
import jogamp.common.os.PlatformPropsImpl;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT21
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static int win_width = 1280;
    static int win_height = 720;
    static int[] aaQualitySet = new int[]{0, 1};
    static int[] sampleSet = new int[]{4};
    static Font[] fontSet = new Font[0];
    static boolean onlyOne = false;

    @BeforeClass
    public static void setup() {
        try {
            fontSet = FontSet01.getSet00();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestTextRendererNEWT21.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-one")) {
                onlyOne = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                win_width = TestTextRendererNEWT21.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                win_height = TestTextRendererNEWT21.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-font")) {
                fontSet = new Font[]{FontFactory.get(new File(stringArray[++i]))};
                continue;
            }
            if (stringArray[i].equals("-samples")) {
                sampleSet = new int[]{TestTextRendererNEWT21.atoi(stringArray[++i])};
                continue;
            }
            if (!stringArray[i].equals("-aaq")) continue;
            aaQualitySet = new int[]{TestTextRendererNEWT21.atoi(stringArray[++i])};
        }
        String string = TestTextRendererNEWT21.class.getName();
        JUnitCore.main(string);
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull(gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        if (!gLCapabilitiesImmutable.getSampleBuffers()) {
            gLWindow.setCapabilitiesChooser(new NonFSAAGLCapsChooser(true));
        }
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull(gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    @Test
    public void test00() throws InterruptedException, GLException, IOException {
        if (!onlyOne) {
            System.err.println("disabled !onlyOne");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT21.createWindow("TTRN21", gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        TestAction testAction = new TestAction(gLWindow, 2, aaQualitySet[0], sampleSet[0], fontSet[0]);
        testAction.setKeepAlive(true);
        testAction.run();
    }

    @Test
    public void test00TextRendererVBAA01() throws InterruptedException, GLException, IOException {
        if (onlyOne || Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT21.createWindow("TTRN21", gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        for (Font font : fontSet) {
            for (int n : aaQualitySet) {
                for (int n2 : sampleSet) {
                    new TestAction(gLWindow, 2, n, n2, font).run();
                }
            }
        }
        TestTextRendererNEWT21.destroyWindow(gLWindow);
    }

    @Test
    public void test10TextRendererMSAA01() throws InterruptedException, GLException, IOException {
        if (onlyOne || Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT21.createWindow("TTRN21", gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        for (Font font : fontSet) {
            for (int n : sampleSet) {
                new TestAction(gLWindow, 1, -1, n, font).run();
            }
        }
        TestTextRendererNEWT21.destroyWindow(gLWindow);
    }

    @Test
    public void test20TextRendererFSAA01() throws InterruptedException, GLException, IOException {
        if (onlyOne) {
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT21.createWindow("TTRN21", gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        for (Font font : fontSet) {
            new TestAction(gLWindow, 0, -1, 0, font).run();
        }
        TestTextRendererNEWT21.destroyWindow(gLWindow);
    }

    @Test
    public void test30TextRendererNoSampling() throws InterruptedException, GLException, IOException {
        if (onlyOne) {
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT21.createWindow("TTRN21", gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        for (Font font : fontSet) {
            new TestAction(gLWindow, 0, -1, 0, font).run();
        }
        TestTextRendererNEWT21.destroyWindow(gLWindow);
    }

    class TestAction
    implements Runnable {
        private final GLWindow window;
        private final int renderModes;
        private final int graphAAQuality;
        private final int graphSampleCount;
        private final Font font;
        private boolean keepAlive = false;

        public TestAction(GLWindow gLWindow, int n, int n2, int n3, Font font) {
            this.window = gLWindow;
            this.renderModes = n;
            this.graphAAQuality = n2;
            this.graphSampleCount = n3;
            this.font = font;
        }

        public void setKeepAlive(boolean bl) {
            this.keepAlive = bl;
        }

        @Override
        public void run() {
            int n = this.window.getChosenGLCapabilities().getNumSamples();
            if (null != this.font) {
                System.err.printf("Test Run: %s, %s%n", Region.getRenderModeString(this.renderModes, 0, this.graphSampleCount, n), this.font.getFullFamilyName());
                FontViewListener01 fontViewListener01 = new FontViewListener01(this.renderModes, this.graphAAQuality, this.graphSampleCount, this.font, '!');
                fontViewListener01.attachInputListenerTo(this.window);
                this.window.addGLEventListener(fontViewListener01);
                this.window.display();
                fontViewListener01.printScreenOnGLThread(this.window, "./", this.window.getTitle(), "", false);
                TestTextRendererNEWT21.sleep();
                if (!this.keepAlive) {
                    this.window.disposeGLEventListener(fontViewListener01, true);
                }
            } else {
                System.err.printf("Test Skipped: %s, font not available%n", Region.getRenderModeString(this.renderModes, 0, this.graphSampleCount, n));
            }
        }
    }
}

