/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.acore.GLProfile0XBase;
import java.io.IOException;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLProfile03NEWTOffscreen
extends GLProfile0XBase {
    @Test
    public void test01GLProfileDefaultFBO() throws InterruptedException {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
        System.out.println("GLProfile.getDefaultDevice(): " + GLProfile.getDefaultDevice());
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile.getDefault(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setFBO(true);
        this.validateOnlineOffscreen("default", gLCapabilities);
    }

    @Test
    public void test02GLProfileDefaultPBuffer() throws InterruptedException {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
        System.out.println("GLProfile.getDefaultDevice(): " + GLProfile.getDefaultDevice());
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile.getDefault(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setPBuffer(true);
        this.validateOnlineOffscreen("default", gLCapabilities);
    }

    @Test
    public void test03GLProfileDefaultBitmap() throws InterruptedException {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
        System.out.println("GLProfile.getDefaultDevice(): " + GLProfile.getDefaultDevice());
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile.getDefault(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBitmap(true);
        this.validateOnlineOffscreen("default", gLCapabilities);
    }

    @Test
    public void test11GLProfileMaxProgrammableFBO() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxProgrammable(true);
        System.out.println("GLProfile.getMaxProgrammable(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setFBO(true);
        this.validateOnlineOffscreen("maxProgrammable", gLCapabilities);
    }

    @Test
    public void test12GLProfileMaxProgrammablePBuffer() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxProgrammable(true);
        System.out.println("GLProfile.getMaxProgrammable(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setPBuffer(true);
        this.validateOnlineOffscreen("maxProgrammable", gLCapabilities);
    }

    public void test13GLProfileMaxProgrammableBitmap() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxProgrammable(true);
        System.out.println("GLProfile.getMaxProgrammable(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBitmap(true);
        this.validateOnlineOffscreen("maxProgrammable", gLCapabilities);
    }

    @Test
    public void test21GLProfileMaxFixedFuncFBO() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        System.out.println("GLProfile.getMaxFixedFunc(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setFBO(true);
        this.validateOnlineOffscreen("maxFixedFunc", gLCapabilities);
    }

    @Test
    public void test22GLProfileMaxFixedFuncPBuffer() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        System.out.println("GLProfile.getMaxFixedFunc(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setPBuffer(true);
        this.validateOnlineOffscreen("maxFixedFunc", gLCapabilities);
    }

    @Test
    public void test23GLProfileMaxFixedFuncBitmap() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        System.out.println("GLProfile.getMaxFixedFunc(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBitmap(true);
        this.validateOnlineOffscreen("maxFixedFunc", gLCapabilities);
    }

    @Test
    public void test31GLProfileGL2ES1() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2ES1")) {
            System.out.println("GLProfile GL2ES1 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES1();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.validateOnlineOffscreen("GL2ES1", gLCapabilities);
    }

    @Test
    public void test32GLProfileGL2ES2() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2ES2")) {
            System.out.println("GLProfile GL2ES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.validateOnlineOffscreen("GL2ES2", gLCapabilities);
    }

    @Test
    public void test33GLProfileGL4ES3() throws InterruptedException {
        if (!GLProfile.isAvailable("GL4ES3")) {
            System.out.println("GLProfile GL4ES3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL4ES3();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.validateOnlineOffscreen("GL4ES3", gLCapabilities);
    }

    @Test
    public void test34GLProfileGL2GL3() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2GL3")) {
            System.out.println("GLProfile GL2GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2GL3();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.validateOnlineOffscreen("GL2GL3", gLCapabilities);
    }

    void testSpecificProfile(String string) throws InterruptedException {
        if (GLProfile.isAvailable(string)) {
            GLProfile gLProfile = GLProfile.get(string);
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.validateOnlineOffscreen(string, gLCapabilities);
        } else {
            System.err.println("Profile " + string + " n/a");
        }
    }

    @Test
    public void test41_GL4bc() throws InterruptedException {
        this.testSpecificProfile("GL4bc");
    }

    @Test
    public void test42_GL3bc() throws InterruptedException {
        this.testSpecificProfile("GL3bc");
    }

    @Test
    public void test43_GL2() throws InterruptedException {
        this.testSpecificProfile("GL2");
    }

    @Test
    public void test44_GL4() throws InterruptedException {
        this.testSpecificProfile("GL4");
    }

    @Test
    public void test45_GL3() throws InterruptedException {
        this.testSpecificProfile("GL3");
    }

    @Test
    public void test46_GLES1() throws InterruptedException {
        this.testSpecificProfile("GLES1");
    }

    @Test
    public void test47_GLES2() throws InterruptedException {
        this.testSpecificProfile("GLES2");
    }

    @Test
    public void test48_GLES3() throws InterruptedException {
        this.testSpecificProfile("GLES3");
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLProfile03NEWTOffscreen.class.getName();
        JUnitCore.main(string);
    }
}

