/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMapBufferRead01NEWT
extends UITestCase {
    static final boolean DEBUG = false;
    static final float[] vertexData = new float[]{-0.3f, -0.2f, -0.1f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f};

    @Test
    public void testWriteRead01aMap() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2GL3")) {
            System.err.println("Test requires GL2/GL3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead01NEWT.createVerticesBB(false), false);
    }

    @Test
    public void testWriteRead01bMap() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2GL3")) {
            System.err.println("Test requires GL2/GL3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead01NEWT.createVerticesBB(true), false);
    }

    @Test
    public void testWriteRead02aMapRange() throws InterruptedException {
        if (!GLProfile.isAvailable("GL3") && GLProfile.isAvailable("GLES3")) {
            System.err.println("Test requires GL3 or GLES3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead01NEWT.createVerticesBB(false), true);
    }

    @Test
    public void testWriteRead02bMapRange() throws InterruptedException {
        if (!GLProfile.isAvailable("GL3") && GLProfile.isAvailable("GLES3")) {
            System.err.println("Test requires GL3 or GLES3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead01NEWT.createVerticesBB(true), true);
    }

    static ByteBuffer createVerticesBB(boolean bl) {
        ByteBuffer byteBuffer;
        if (bl) {
            byteBuffer = Buffers.newDirectByteBuffer(4 * vertexData.length);
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.put(vertexData, 0, vertexData.length).rewind();
        } else {
            byteBuffer = ByteBuffer.allocate(4 * vertexData.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            for (int i = 0; i < vertexData.length; ++i) {
                byteBuffer.putFloat(vertexData[i]);
            }
            byteBuffer.rewind();
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteRead01(ByteBuffer byteBuffer, boolean bl) throws InterruptedException {
        Assert.assertEquals(0L, byteBuffer.position());
        Assert.assertEquals(4 * vertexData.length, byteBuffer.limit());
        Assert.assertEquals(4 * vertexData.length, byteBuffer.capacity());
        Assert.assertEquals(4 * vertexData.length, byteBuffer.remaining());
        Assert.assertEquals(-0.3f, byteBuffer.getFloat(0), 0.05f);
        Assert.assertEquals(0.6f, byteBuffer.getFloat(32), 0.05f);
        GLProfile gLProfile = GLProfile.getMaxProgrammable(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, 800, 600, true);
        try {
            ByteBuffer byteBuffer2;
            int n;
            int n2;
            int n3;
            GL gL = windowContext.context.getGL();
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            gL.glBindBuffer(34962, nArray[0]);
            gL.glBufferData(34962, byteBuffer.capacity(), byteBuffer, 35045);
            int n4 = gL.getBoundBuffer(34962);
            GLBufferStorage gLBufferStorage = gL.getBufferStorage(n4);
            System.err.println("gpu-01 GL_ARRAY_BUFFER -> bufferName " + n4 + " -> " + gLBufferStorage);
            Assert.assertEquals("Buffer storage's bytes-buffer not null before map", null, gLBufferStorage.getMappedBuffer());
            if (bl) {
                n3 = 3;
                n2 = 4 * n3;
                n = byteBuffer.capacity() - n2;
                byteBuffer2 = gL.glMapBufferRange(34962, n2, n, 1);
            } else {
                n3 = 0;
                n2 = 0;
                n = byteBuffer.capacity();
                byteBuffer2 = gL.glMapBuffer(34962, 35000);
            }
            System.err.println("gpu-02 mapped GL_ARRAY_BUFFER, floatOffset " + n3 + ", byteOffset " + n2 + ", mapByteLength " + n + " -> " + byteBuffer2);
            System.err.println("gpu-03 GL_ARRAY_BUFFER -> bufferName " + n4 + " -> " + gLBufferStorage);
            Assert.assertNotNull(byteBuffer2);
            Assert.assertEquals("BufferStorage size less byteOffset not equals buffer storage size", gLBufferStorage.getSize() - (long)n2, byteBuffer2.capacity());
            Assert.assertEquals("BufferStorage's bytes-buffer not equal with mapped bytes-buffer", gLBufferStorage.getMappedBuffer(), byteBuffer2);
            Assert.assertEquals("Buffer storage size not equals mapByteLength", n, byteBuffer2.capacity());
            for (int i = 0; i < byteBuffer2.capacity(); i += 4) {
                Assert.assertEquals(byteBuffer.getFloat(n2 + i), byteBuffer2.getFloat(i), 1.0E-4f);
            }
            gL.glUnmapBuffer(34962);
            Assert.assertEquals("Buffer storage's bytes-buffer not null after unmap", null, gLBufferStorage.getMappedBuffer());
        }
        finally {
            NEWTGLContext.destroyWindow(windowContext);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestMapBufferRead01NEWT.class.getName();
        JUnitCore.main(string);
    }
}

