/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextListAWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLOffscreenAutoDrawable sharedDrawable;
    Gears sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2")) {
            glp = GLProfile.get("GL2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextListAWT.setTestSupported(false);
        }
    }

    private void initShared() {
        this.sharedDrawable = GLDrawableFactory.getFactory(glp).createOffscreenAutoDrawable(null, caps, null, width, height);
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedGears = new Gears();
        Assert.assertNotNull(this.sharedGears);
        this.sharedDrawable.addGLEventListener(this.sharedGears);
        this.sharedDrawable.display();
    }

    private void releaseShared() {
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedDrawable.destroy();
    }

    protected void setFrameTitle(final Frame frame, final boolean bl) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setTitle("Shared Gears AWT Test: " + frame.getX() + "/" + frame.getY() + " shared " + bl);
            }
        });
    }

    protected GLCanvas runTestGL(final Frame frame, Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException, InvocationTargetException {
        GLCanvas gLCanvas = new GLCanvas(caps);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.setSharedAutoDrawable(this.sharedDrawable);
        frame.add(gLCanvas);
        frame.setLocation(n, n2);
        frame.setSize(width, height);
        Gears gears = new Gears(bl2 ? 1 : 0);
        if (bl) {
            gears.setSharedGears(this.sharedGears);
        }
        gLCanvas.addGLEventListener(gears);
        animator.add(gLCanvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas, true, null));
        return gLCanvas;
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        this.initShared();
        final Frame frame = new Frame();
        final Frame frame2 = new Frame();
        final Frame frame3 = new Frame();
        Animator animator = new Animator();
        final GLCanvas gLCanvas = this.runTestGL(frame, animator, 0, 0, true, false);
        int n = frame.getX();
        int n2 = frame.getY();
        final GLCanvas gLCanvas2 = this.runTestGL(frame2, animator, n + width, n2 + 0, true, false);
        final GLCanvas gLCanvas3 = this.runTestGL(frame3, animator, n + 0, n2 + height, false, true);
        this.setFrameTitle(frame, true);
        this.setFrameTitle(frame2, true);
        this.setFrameTitle(frame3, false);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        frame.dispose();
                        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas, false, null));
                        frame2.dispose();
                        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas2, false, null));
                        frame3.dispose();
                        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas3, false, null));
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        this.releaseShared();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextListAWT.class.getName());
    }

    static {
        duration = 500L;
    }
}

