/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextListNEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLOffscreenAutoDrawable sharedDrawable;
    Gears sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2")) {
            glp = GLProfile.get("GL2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextListNEWT.setTestSupported(false);
        }
    }

    private void initShared() {
        this.sharedDrawable = GLDrawableFactory.getFactory(glp).createOffscreenAutoDrawable(null, caps, null, width, height);
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedGears = new Gears();
        Assert.assertNotNull(this.sharedGears);
        this.sharedDrawable.addGLEventListener(this.sharedGears);
        this.sharedDrawable.display();
    }

    private void releaseShared() {
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedDrawable.destroy();
        this.sharedDrawable = null;
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(this.sharedDrawable);
        }
        gLWindow.setSize(width, height);
        Gears gears = new Gears(bl2 ? 1 : 0);
        if (bl) {
            gears.setSharedGears(this.sharedGears);
        }
        gLWindow.addGLEventListener(gears);
        animator.add(gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        gLWindow.setPosition(n, n2);
        return gLWindow;
    }

    @Test
    public void test01() throws InterruptedException {
        this.initShared();
        Animator animator = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), false, true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        this.releaseShared();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextListNEWT.class.getName());
    }

    static {
        duration = 500L;
    }
}

