/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT4
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT4.setTestSupported(false);
        }
    }

    protected GLWindow createGLWindow(int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared true");
        gLWindow.setSize(width, height);
        gLWindow.addGLEventListener(gearsES2);
        return gLWindow;
    }

    @Test
    public void test01() throws InterruptedException {
        final Animator animator = new Animator(0);
        animator.start();
        GearsES2 gearsES2 = new GearsES2(0);
        GLWindow gLWindow = this.createGLWindow(0, 0, gearsES2);
        animator.add(gLWindow);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.createGLWindow(gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22);
        gLWindow2.setSharedAutoDrawable(gLWindow);
        animator.add(gLWindow2);
        gLWindow2.setVisible(true);
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        final GLWindow gLWindow3 = this.createGLWindow(gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), gearsES23);
        gLWindow3.setSharedAutoDrawable(gLWindow2);
        animator.add(gLWindow3);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        animator.setUncaughtExceptionHandler(new GLAnimatorControl.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(GLAnimatorControl gLAnimatorControl, GLAutoDrawable gLAutoDrawable, Throwable throwable) {
                if (gLAnimatorControl == animator && gLAutoDrawable == gLWindow3 && throwable instanceof RuntimeException) {
                    System.err.println("Caught expected exception: " + throwable.getMessage());
                    atomicBoolean.set(true);
                } else {
                    System.err.println("Caught unexpected exception: " + throwable.getMessage());
                    throwable.printStackTrace();
                    atomicBoolean2.set(true);
                }
            }
        });
        gLWindow3.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, false, null));
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        Assert.assertFalse("Unexpected exception (animator) caught", atomicBoolean.get());
        Assert.assertFalse("Unexpected exception (other) caught", atomicBoolean2.get());
        GLContext gLContext = gLWindow.getContext();
        GLContext gLContext2 = gLWindow2.getContext();
        GLContext gLContext3 = gLWindow3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 2L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 2L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        Assert.assertEquals("Ctx1 Master Context is different", gLContext, gLContext.getSharedMaster());
        Assert.assertEquals("Ctx2 Master Context is different", gLContext, gLContext2.getSharedMaster());
        Assert.assertEquals("Ctx3 Master Context is different", gLContext2, gLContext3.getSharedMaster());
        Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
        Assert.assertTrue("Gears2 is not shared", gearsES22.usesSharedGears());
        Assert.assertTrue("Gears3 is not shared", gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        System.err.println("XXX Destroy in clean order NOW");
        gLWindow3.destroy();
        gLWindow2.destroy();
        gLWindow.destroy();
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES2NEWT4.class.getName());
    }

    static {
        duration = 1000L;
    }
}

