/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.anim;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.lang.reflect.InvocationTargetException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAnimatorGLWindow01NEWT
extends UITestCase {
    static final int width = 400;
    static final int height = 400;
    static long duration = 1500L;

    protected GLWindow createGLWindow(GLCapabilities gLCapabilities, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.addGLEventListener(gearsES2);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(400, 400);
        gLWindow.setTitle("GLWindow: " + n + "/" + n2);
        return gLWindow;
    }

    static void pauseAnimator(Animator animator, boolean bl) {
        if (bl) {
            animator.pause();
            Assert.assertEquals(true, animator.isStarted());
            Assert.assertEquals(true, animator.isPaused());
            Assert.assertEquals(false, animator.isAnimating());
        } else {
            animator.resume();
            Assert.assertEquals(true, animator.isStarted());
            Assert.assertEquals(false, animator.isPaused());
            Assert.assertEquals(true, animator.isAnimating());
        }
    }

    static void stopAnimator(Animator animator) {
        animator.stop();
        Assert.assertEquals(false, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(false, animator.isAnimating());
    }

    @Test
    public void test01SyncedOneAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        Animator animator = new Animator(0);
        animator.start();
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertEquals(false, animator.isAnimating());
        GearsES2 gearsES2 = new GearsES2(0);
        GLWindow gLWindow = this.createGLWindow(gLCapabilities, 0, 0, gearsES2);
        animator.add(gLWindow);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(true, animator.isAnimating());
        GearsES2 gearsES22 = new GearsES2(0);
        GLWindow gLWindow2 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 400, gLWindow.getY() + 0, gearsES22);
        animator.add(gLWindow2);
        GearsES2 gearsES23 = new GearsES2(0);
        GLWindow gLWindow3 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 0, gLWindow.getY() + 400, gearsES23);
        animator.add(gLWindow3);
        gLWindow.setVisible(true);
        gLWindow2.setVisible(true);
        gLWindow3.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.stopAnimator(animator);
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
    }

    @Test
    public void test02AsyncEachAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        Animator animator = new Animator(0);
        GearsES2 gearsES2 = new GearsES2(0);
        GLWindow gLWindow = this.createGLWindow(gLCapabilities, 0, 0, gearsES2);
        animator.add(gLWindow);
        animator.start();
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(true, animator.isAnimating());
        gLWindow.setVisible(true);
        Animator animator2 = new Animator(0);
        GearsES2 gearsES22 = new GearsES2(0);
        GLWindow gLWindow2 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 400, gLWindow.getY() + 0, gearsES22);
        animator2.add(gLWindow2);
        animator2.start();
        Assert.assertEquals(true, animator2.isStarted());
        Assert.assertEquals(false, animator2.isPaused());
        Assert.assertEquals(true, animator2.isAnimating());
        gLWindow2.setVisible(true);
        Animator animator3 = new Animator(0);
        GearsES2 gearsES23 = new GearsES2(0);
        GLWindow gLWindow3 = this.createGLWindow(gLCapabilities, gLWindow.getX() + 0, gLWindow.getY() + 400, gearsES23);
        animator3.add(gLWindow3);
        animator3.start();
        Assert.assertEquals(true, animator3.isStarted());
        Assert.assertEquals(false, animator3.isPaused());
        Assert.assertEquals(true, animator3.isAnimating());
        gLWindow3.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow, true, null));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow2, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow2, true, null));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, true, null));
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow3, true, null));
        Assert.assertTrue(GLTestUtil.waitForContextCreated(gLWindow3, true, null));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, true);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator2, true);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator3, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator, false);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator2, false);
        TestAnimatorGLWindow01NEWT.pauseAnimator(animator3, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLWindow01NEWT.stopAnimator(animator);
        TestAnimatorGLWindow01NEWT.stopAnimator(animator2);
        TestAnimatorGLWindow01NEWT.stopAnimator(animator3);
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow2, false, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow3, false, null));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestAnimatorGLWindow01NEWT.class.getName());
    }
}

