/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLContextDrawableSwitch10NEWT
extends UITestCase {
    static long duration = 1000L;
    static int width;
    static int height;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    private GLAutoDrawable createGLAutoDrawableWithoutContext(GLCapabilities gLCapabilities, int n, int n2, int n3, int n4, WindowListener windowListener) throws InterruptedException {
        final Window window = NewtFactory.createWindow(gLCapabilities);
        Assert.assertNotNull(window);
        window.setPosition(n, n2);
        window.setSize(n3, n4);
        window.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForVisible(window, true, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(window, true, null));
        Assert.assertTrue(NewtTestUtil.waitForSize(window, n3, n4, null));
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable(window);
        Assert.assertNotNull(gLDrawable);
        gLDrawable.setRealized(true);
        Assert.assertTrue(gLDrawable.isRealized());
        Assert.assertEquals(gLDrawable.getSurfaceWidth(), window.getSurfaceWidth());
        Assert.assertEquals(gLDrawable.getSurfaceHeight(), window.getSurfaceHeight());
        final GLAutoDrawableDelegate gLAutoDrawableDelegate = new GLAutoDrawableDelegate(gLDrawable, null, window, false, null){

            @Override
            protected void destroyImplInLock() {
                super.destroyImplInLock();
                window.destroy();
            }
        };
        window.setWindowDestroyNotifyAction(new Runnable(){

            @Override
            public void run() {
                gLAutoDrawableDelegate.windowDestroyNotifyOp();
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                gLAutoDrawableDelegate.windowRepaintOp();
            }

            @Override
            public void windowResized(WindowEvent windowEvent) {
                gLAutoDrawableDelegate.windowResizedOp(window.getSurfaceWidth(), window.getSurfaceHeight());
            }
        });
        window.addWindowListener(windowListener);
        return gLAutoDrawableDelegate;
    }

    @Test(timeout=30000L)
    public void test01GLADDelegateGL2ES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch10NEWT.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testGLADDelegateImpl(gLCapabilities);
    }

    @Test(timeout=30000L)
    public void test02GLADDelegateGLES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch10NEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testGLADDelegateImpl(gLCapabilities);
    }

    private void testGLADDelegateImpl(GLCapabilities gLCapabilities) throws InterruptedException {
        long l;
        long l2;
        GLEventListenerCounter gLEventListenerCounter = new GLEventListenerCounter();
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        Animator animator = new Animator(0);
        animator.start();
        QuitAdapter quitAdapter = new QuitAdapter();
        GLAutoDrawable gLAutoDrawable = this.createGLAutoDrawableWithoutContext(gLCapabilities, 64, 64, width, height, quitAdapter);
        GLContext gLContext = gLAutoDrawable.createContext(null);
        gLAutoDrawable.setContext(gLContext, true);
        animator.add(gLAutoDrawable);
        gLAutoDrawable.addGLEventListener(gLEventListenerCounter);
        gLAutoDrawable.addGLEventListener(new GearsES2(1));
        gLAutoDrawable.addGLEventListener(snapshotGLEventListener);
        snapshotGLEventListener.setMakeSnapshot();
        long l3 = l2 = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l3 - l2 < duration) {
            Thread.sleep(100L);
            l3 = System.currentTimeMillis();
        }
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
        Assert.assertEquals(gLContext, gLAutoDrawable.getContext());
        Assert.assertEquals(3L, gLAutoDrawable.getGLEventListenerCount());
        Assert.assertEquals(gLContext.getGLReadDrawable(), gLAutoDrawable.getDelegatedDrawable());
        Assert.assertEquals(gLContext.getGLDrawable(), gLAutoDrawable.getDelegatedDrawable());
        GLEventListenerState gLEventListenerState = GLEventListenerState.moveFrom(gLAutoDrawable);
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
        Assert.assertEquals(gLContext, gLEventListenerState.context);
        Assert.assertNull(gLContext.getGLReadDrawable());
        Assert.assertNull(gLContext.getGLDrawable());
        Assert.assertEquals(3L, gLEventListenerState.listenerCount());
        Assert.assertEquals(true, gLEventListenerState.isOwner());
        Assert.assertEquals(null, gLAutoDrawable.getContext());
        Assert.assertEquals(0L, gLAutoDrawable.getGLEventListenerCount());
        gLAutoDrawable.destroy();
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
        quitAdapter = new QuitAdapter();
        gLAutoDrawable = this.createGLAutoDrawableWithoutContext(gLCapabilities, 128 + width, 64, width + 100, height + 100, quitAdapter);
        snapshotGLEventListener.setMakeSnapshot();
        Assert.assertEquals(null, gLAutoDrawable.getContext());
        Assert.assertEquals(0L, gLAutoDrawable.getGLEventListenerCount());
        gLEventListenerState.moveTo(gLAutoDrawable);
        Assert.assertTrue(gLAutoDrawable.isRealized());
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
        Assert.assertEquals(gLEventListenerState.context, gLAutoDrawable.getContext());
        Assert.assertEquals(3L, gLAutoDrawable.getGLEventListenerCount());
        Assert.assertEquals(gLEventListenerState.context.getGLReadDrawable(), gLAutoDrawable.getDelegatedDrawable());
        Assert.assertEquals(gLEventListenerState.context.getGLDrawable(), gLAutoDrawable.getDelegatedDrawable());
        Assert.assertEquals(false, gLEventListenerState.isOwner());
        long l4 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l4 - l < duration) {
            Thread.sleep(100L);
            l4 = System.currentTimeMillis();
        }
        gLAutoDrawable.destroy();
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        Assert.assertEquals(1L, gLEventListenerCounter.disposeCount);
        animator.stop();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestGLContextDrawableSwitch10NEWT.class.getName());
    }
}

