/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug816OSXCALayerPos04aAWT
extends UITestCase {
    static long duration = 1600L;
    static int width = 640;
    static int height = 480;

    @Test
    public void test() throws InterruptedException, InvocationTargetException {
        long l;
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos04aAWT.getGLP());
        final Frame frame = new Frame("TestBug816OSXCALayerPos04aAWT");
        Assert.assertNotNull(frame);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2(1));
        Animator animator = new Animator();
        animator.add(gLCanvas);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(frame);
        frame.setSize(400, 400);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setLocation(100, 100);
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(frame, true, null));
        final Dialog dialog = new Dialog(frame, "Bug 816 AWT Top-Level Dialog");
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)gLCanvas, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                dialog.setLocation(200, 200);
                dialog.setSize(width / 2, height / 2);
                dialog.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(dialog, true, null));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas, true, null));
        animator.start();
        Assert.assertTrue(animator.isStarted());
        Assert.assertTrue(animator.isAnimating());
        animator.setUpdateFPSFrames(60, System.err);
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull(frame);
        Assert.assertNotNull(gLCanvas);
        Assert.assertNotNull(animator);
        animator.stop();
        Assert.assertFalse(animator.isAnimating());
        Assert.assertFalse(animator.isStarted());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(false, frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(gLCanvas);
                frame.dispose();
            }
        });
    }

    static GLProfile getGLP() {
        return GLProfile.getMaxProgrammableCore(true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestBug816OSXCALayerPos04aAWT.class.getName());
    }
}

