/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.common.os.Clock;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.AnimatorBase;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLCanvasAWTActionDeadlock02AWT
extends UITestCase {
    static int framesPerTest = 240;

    @Test
    public void test00() {
        MiniPApplet miniPApplet;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(MiniPApplet.class.getName());
            miniPApplet = (MiniPApplet)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (miniPApplet != null) {
            try {
                miniPApplet.run();
            }
            catch (Exception exception) {
                Assume.assumeNoException(exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-frames")) continue;
            framesPerTest = MiscUtils.atoi(stringArray[++i], framesPerTest);
        }
        JUnitCore.main(TestGLCanvasAWTActionDeadlock02AWT.class.getName());
    }

    static class MiniPApplet
    extends Applet
    implements MouseMotionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        public int frameRate = 120;
        public int numSamples = 4;
        public boolean fullScreen = false;
        public boolean useAnimator = true;
        public boolean resizeableFrame = true;
        public boolean restartCanvas = true;
        public int restartTimeout = 100;
        public boolean printThreadInfo = false;
        public boolean printEventInfo = false;
        int width;
        int height;
        String OPENGL_VENDOR;
        String OPENGL_RENDERER;
        String OPENGL_VERSION;
        String OPENGL_EXTENSIONS;
        int currentSamples = -1;
        private Frame frame;
        private GLProfile profile;
        private GLCapabilities capabilities;
        private GLCanvas canvas;
        private SimpleListener listener;
        private CustomAnimator animator;
        private long beforeTime;
        private long overSleepTime;
        private final long frameRatePeriod = 1000000000L / (long)this.frameRate;
        private boolean initialized = false;
        private boolean osxCALayerAWTModBug = false;
        boolean justInitialized = true;
        private double theta = 0.0;
        private double s = 0.0;
        private double c = 0.0;
        private long millisOffset;
        private int fcount;
        private int lastm;
        private float frate;
        private final int fint = 3;
        private boolean setFramerate = false;
        private boolean restarted = false;
        private int frameCount = 0;

        MiniPApplet() {
        }

        void run() throws InterruptedException, InvocationTargetException {
            this.frameCount = 0;
            while (this.frameCount < framesPerTest) {
                if (!this.initialized) {
                    this.setup();
                }
                if (this.restartCanvas && this.restartTimeout == this.frameCount) {
                    this.restart();
                }
                if (this.useAnimator) {
                    this.animator.requestRender();
                } else {
                    this.canvas.display();
                }
                this.clock();
                ++this.frameCount;
                if (null != this.frame) continue;
            }
            this.dispose();
        }

        void setup() throws InterruptedException, InvocationTargetException {
            Rectangle rectangle;
            if (this.printThreadInfo) {
                System.out.println("Current thread at setup(): " + Thread.currentThread());
            }
            this.millisOffset = System.currentTimeMillis();
            VersionNumber versionNumber = new VersionNumber(1, 7, 0);
            this.osxCALayerAWTModBug = Platform.OSType.MACOS == Platform.getOSType() && 0 > Platform.getJavaVersionNumber().compareTo(versionNumber);
            System.err.println("OSX CALayer AWT-Mod Bug " + this.osxCALayerAWTModBug);
            System.err.println("OSType " + (Object)((Object)Platform.getOSType()));
            System.err.println("Java Version " + Platform.getJavaVersionNumber());
            this.width = 300;
            this.height = 300;
            final MiniPApplet miniPApplet = this;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            this.frame = new Frame(graphicsDevice.getDefaultConfiguration());
            if (this.fullScreen) {
                DisplayMode displayMode = graphicsDevice.getDisplayMode();
                rectangle = new Rectangle(0, 0, displayMode.getWidth(), displayMode.getHeight());
            } else {
                rectangle = null;
            }
            AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                @Override
                public void run() {
                    frame.setTitle("MiniPApplet");
                }
            });
            if (this.fullScreen) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            frame.setUndecorated(true);
                            frame.setBackground(Color.GRAY);
                            frame.setBounds(rectangle);
                            frame.setVisible(true);
                        }
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Assume.assumeNoException(throwable);
                }
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frame.setLayout(null);
                        frame.add(miniPApplet);
                        if (fullScreen) {
                            frame.invalidate();
                        } else {
                            frame.pack();
                        }
                        frame.setResizable(resizeableFrame);
                        if (fullScreen) {
                            frame.setBounds(rectangle);
                            miniPApplet.setBounds((rectangle.width - miniPApplet.width) / 2, (rectangle.height - miniPApplet.height) / 2, miniPApplet.width, miniPApplet.height);
                        } else {
                            Insets insets = frame.getInsets();
                            int n = miniPApplet.width + insets.left + insets.right;
                            int n2 = miniPApplet.height + insets.top + insets.bottom;
                            frame.setSize(n, n2);
                            frame.setLocation(100, 100);
                            int n3 = n2 - insets.top - insets.bottom;
                            miniPApplet.setBounds((n - width) / 2, insets.top + (n3 - height) / 2, width, height);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Assume.assumeNoException(throwable);
            }
            this.frame.add(this);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    try {
                        this.dispose();
                    }
                    catch (Exception exception) {
                        Assume.assumeNoException(exception);
                    }
                }
            });
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
            this.profile = GLProfile.getDefault();
            this.capabilities = new GLCapabilities(this.profile);
            this.capabilities.setSampleBuffers(true);
            this.capabilities.setNumSamples(this.numSamples);
            this.capabilities.setDepthBits(24);
            this.capabilities.setAlphaBits(8);
            this.canvas = new GLCanvas(this.capabilities);
            this.canvas.setBounds(0, 0, this.width, this.height);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    this.setLayout(new BorderLayout());
                    this.add((Component)canvas, "Center");
                    this.validate();
                }
            });
            this.canvas.addMouseMotionListener(this);
            this.canvas.addKeyListener(this);
            this.listener = new SimpleListener();
            this.canvas.addGLEventListener(this.listener);
            if (this.useAnimator) {
                this.animator = new CustomAnimator(this.canvas);
                this.animator.start();
            }
            this.initialized = true;
        }

        void restart() throws InterruptedException, InvocationTargetException {
            System.out.println("Restarting surface...");
            if (this.useAnimator) {
                this.animator.stop();
                this.animator.remove(this.canvas);
            }
            this.canvas.disposeGLEventListener(this.listener, true);
            this.remove(this.canvas);
            this.capabilities = new GLCapabilities(this.profile);
            this.capabilities.setSampleBuffers(true);
            this.capabilities.setNumSamples(this.numSamples);
            this.canvas = new GLCanvas(this.capabilities);
            this.canvas.setBounds(0, 0, this.width, this.height);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    this.setLayout(new BorderLayout());
                    this.add((Component)canvas, "Center");
                    this.validate();
                }
            });
            this.canvas.addMouseMotionListener(this);
            this.canvas.addKeyListener(this);
            this.canvas.addGLEventListener(this.listener);
            if (this.useAnimator) {
                this.animator.add(this.canvas);
                this.animator.start();
            }
            this.setFramerate = false;
            this.restarted = true;
            System.out.println("Done");
        }

        void dispose() throws InterruptedException, InvocationTargetException {
            if (null == this.frame) {
                return;
            }
            if (this.useAnimator) {
                this.animator.stop();
                this.animator.remove(this.canvas);
            }
            this.canvas.removeGLEventListener(this.listener);
            if (EventQueue.isDispatchThread()) {
                this.remove(this.canvas);
                this.frame.remove(this);
                this.frame.validate();
                this.frame.dispose();
                this.frame = null;
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.remove(canvas);
                        frame.remove(this);
                        frame.validate();
                        frame.dispose();
                        frame = null;
                    }
                });
            }
        }

        void draw(GL2 gL2) {
            int[] nArray;
            if (!this.osxCALayerAWTModBug || !this.justInitialized) {
                AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                    @Override
                    public void run() {
                        frame.setTitle("frame " + frameCount);
                    }
                });
            }
            if (this.printThreadInfo) {
                System.out.println("Current thread at draw(): " + Thread.currentThread());
            }
            if (this.OPENGL_VENDOR == null) {
                this.OPENGL_VENDOR = gL2.glGetString(7936);
                this.OPENGL_RENDERER = gL2.glGetString(7937);
                this.OPENGL_VERSION = gL2.glGetString(7938);
                this.OPENGL_EXTENSIONS = gL2.glGetString(7939);
                System.out.println(this.OPENGL_VENDOR);
                System.out.println(this.OPENGL_RENDERER);
                System.out.println(this.OPENGL_VERSION);
                System.out.println(this.OPENGL_EXTENSIONS);
                nArray = new int[]{0};
                gL2.glGetIntegerv(36183, nArray, 0);
                System.out.println("Maximum number of samples supported by the hardware: " + nArray[0]);
                System.out.println("Frame: " + this.frame);
                System.out.println("Applet: " + this);
                System.out.println("GLCanvas: " + this.canvas);
                System.out.println("GLDrawable: " + this.canvas.getDelegatedDrawable());
            }
            if (this.currentSamples == -1) {
                nArray = new int[]{0};
                gL2.glGetIntegerv(32937, nArray, 0);
                this.currentSamples = nArray[0];
                if (this.numSamples != this.currentSamples) {
                    System.err.println("Requested sampling level " + this.numSamples + " not supported. Using " + this.currentSamples + " samples instead.");
                }
            }
            if (!this.setFramerate) {
                if (60 < this.frameRate) {
                    gL2.setSwapInterval(0);
                } else if (30 < this.frameRate) {
                    gL2.setSwapInterval(1);
                } else {
                    gL2.setSwapInterval(2);
                }
                this.setFramerate = true;
            }
            if (this.restarted) {
                nArray = new int[]{0};
                gL2.glGetIntegerv(32937, nArray, 0);
                if (this.numSamples != nArray[0]) {
                    System.err.println("Multisampling level requested " + this.numSamples + " not supported. Using " + nArray[0] + "samples instead.");
                }
            }
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gL2.glClear(16384);
            this.theta += 0.01;
            this.s = Math.sin(this.theta);
            this.c = Math.cos(this.theta);
            gL2.glBegin(4);
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glVertex2d(-this.c, -this.c);
            gL2.glColor3f(0.0f, 1.0f, 0.0f);
            gL2.glVertex2d(0.0, this.c);
            gL2.glColor3f(0.0f, 0.0f, 1.0f);
            gL2.glVertex2d(this.s, -this.s);
            gL2.glEnd();
            gL2.glFlush();
            ++this.fcount;
            int n = (int)(System.currentTimeMillis() - this.millisOffset);
            if (n - this.lastm > 3000) {
                this.frate = (float)this.fcount / 3.0f;
                this.fcount = 0;
                this.lastm = n;
                System.err.println("fps: " + this.frate);
            }
        }

        void clock() {
            long l = Clock.currentNanos();
            long l2 = l - this.beforeTime;
            long l3 = this.frameRatePeriod - l2 - this.overSleepTime;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3 / 1000000L, (int)(l3 % 1000000L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.overSleepTime = Clock.currentNanos() - l - l3;
            } else {
                this.overSleepTime = 0L;
            }
            this.beforeTime = Clock.currentNanos();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.printEventInfo) {
                System.err.println("Mouse dragged event: " + mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.printEventInfo) {
                System.err.println("Mouse moved event: " + mouseEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.printEventInfo) {
                System.err.println("Key pressed event: " + keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.printEventInfo) {
                System.err.println("Key released event: " + keyEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.printEventInfo) {
                System.err.println("Key typed event: " + keyEvent);
            }
        }

        public static class CustomAnimator
        extends AnimatorBase {
            private Timer timer = null;
            private TimerTask task = null;
            private volatile boolean shouldRun;

            @Override
            protected String getBaseName(String string) {
                return "Custom" + string + "Animator";
            }

            public CustomAnimator(GLAutoDrawable gLAutoDrawable) {
                if (gLAutoDrawable != null) {
                    this.add(gLAutoDrawable);
                }
            }

            public synchronized void requestRender() {
                this.shouldRun = true;
            }

            @Override
            public final synchronized boolean isStarted() {
                return this.timer != null;
            }

            @Override
            public final synchronized boolean isAnimating() {
                return this.timer != null && this.task != null;
            }

            private void startTask() {
                if (null != this.task) {
                    return;
                }
                this.task = new TimerTask(){
                    private boolean firstRun = true;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (this.firstRun) {
                            Thread.currentThread().setName("OPENGL");
                            this.firstRun = false;
                        }
                        if (shouldRun) {
                            animThread = Thread.currentThread();
                            this.display();
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                shouldRun = false;
                            }
                        }
                    }
                };
                this.fpsCounter.resetFPSCounter();
                this.shouldRun = false;
                this.timer.schedule(this.task, 0L, 1L);
            }

            @Override
            public synchronized boolean start() {
                if (this.timer != null) {
                    return false;
                }
                this.timer = new Timer();
                this.startTask();
                return true;
            }

            @Override
            public synchronized boolean stop() {
                if (this.timer == null) {
                    return false;
                }
                this.shouldRun = false;
                if (null != this.task) {
                    this.task.cancel();
                    this.task = null;
                }
                if (null != this.timer) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.animThread = null;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }

            @Override
            public final synchronized boolean isPaused() {
                return false;
            }

            @Override
            public synchronized boolean resume() {
                return false;
            }

            @Override
            public synchronized boolean pause() {
                return false;
            }
        }

        class SimpleListener
        implements GLEventListener {
            SimpleListener() {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                MiniPApplet.this.draw(gLAutoDrawable.getGL().getGL2());
                MiniPApplet.this.justInitialized = false;
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                MiniPApplet.this.justInitialized = true;
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        }
    }
}

