/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec3f;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.GearsObject;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsObjectES2;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.TileRendererBase;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoGLEventListener;
import com.jogamp.opengl.util.stereo.ViewerPose;
import java.awt.Component;
import java.nio.FloatBuffer;

public class GearsES2
implements StereoGLEventListener,
TileRendererBase.TileRendererListener {
    private final FloatBuffer lightPos = Buffers.newDirectFloatBuffer(new float[]{5.0f, 5.0f, 10.0f});
    private ShaderState st = null;
    private PMVMatrix pmvMatrix = null;
    private GLUniformData pmvMatrixUniform = null;
    private GLUniformData colorU = null;
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private boolean flipVerticalInGLOrientation = false;
    private final boolean customRendering = false;
    private final float view_rotz = 0.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private float panZ = 0.0f;
    private volatile GearsObjectES2 gear1 = null;
    private volatile GearsObjectES2 gear2 = null;
    private volatile GearsObjectES2 gear3 = null;
    private GearsES2 sharedGears = null;
    private Object syncObjects = null;
    private boolean useMappedBuffers = false;
    private boolean validateBuffers = false;
    private volatile boolean usesSharedGears = false;
    private FloatBuffer gear1Color = GearsObject.red;
    private FloatBuffer gear2Color = GearsObject.green;
    private FloatBuffer gear3Color = GearsObject.blue;
    private float angle = 0.0f;
    private int swapInterval = 0;
    public MouseListener gearsMouse = new GearsMouseAdapter();
    public KeyListener gearsKeys = new GearsKeyAdapter();
    private TileRendererBase tileRendererInUse = null;
    private boolean doRotateBeforePrinting;
    private boolean doRotate = true;
    private boolean ignoreFocus = false;
    private float[] clearColor = null;
    private boolean clearBuffers = true;
    private boolean verbose = true;
    private volatile boolean isInit = false;
    private PinchToZoomGesture pinchToZoomGesture = null;
    private static final int TIME_OUT = 2000;
    private static final int POLL_DIVIDER = 20;
    private static final int TIME_SLICE = 100;
    private final GestureHandler.GestureListener pinchToZoomListener = new GestureHandler.GestureListener(){

        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
            PinchToZoomGesture.ZoomEvent zoomEvent = (PinchToZoomGesture.ZoomEvent)gestureEvent;
            float f = zoomEvent.getZoom();
            GearsES2.this.panZ = f * 30.0f - 30.0f;
        }
    };
    private float zNear = 5.0f;
    private float zFar = 10000.0f;
    private float zViewDist = 40.0f;
    private final Matrix4f mat4Tmp1 = new Matrix4f();
    private final Matrix4f mat4Tmp2 = new Matrix4f();
    private final Vec3f vec3Tmp1 = new Vec3f();
    private final Vec3f vec3Tmp2 = new Vec3f();
    private final Vec3f vec3Tmp3 = new Vec3f();
    private static final float scalePos = 20.0f;

    public GearsES2(int n) {
        this.swapInterval = n;
    }

    public GearsES2() {
        this.swapInterval = 1;
    }

    @Override
    public void addTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = tileRendererBase;
        this.doRotateBeforePrinting = this.doRotate;
        this.setDoRotation(false);
    }

    @Override
    public void removeTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = null;
        this.setDoRotation(this.doRotateBeforePrinting);
    }

    @Override
    public void startTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("GearsES2.startTileRendering: " + this.sid() + "" + tileRendererBase);
    }

    @Override
    public void endTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("GearsES2.endTileRendering: " + this.sid() + "" + tileRendererBase);
    }

    public void setIgnoreFocus(boolean bl) {
        this.ignoreFocus = bl;
    }

    public void setDoRotation(boolean bl) {
        this.doRotate = bl;
    }

    public void setClearBuffers(boolean bl) {
        this.clearBuffers = bl;
    }

    public GearsES2 setVerbose(boolean bl) {
        this.verbose = bl;
        return this;
    }

    public void setFlipVerticalInGLOrientation(boolean bl) {
        this.flipVerticalInGLOrientation = bl;
    }

    public void setClearColor(float[] fArray) {
        this.clearColor = fArray;
    }

    public void setGearsColors(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.gear1Color = floatBuffer;
        this.gear2Color = floatBuffer2;
        this.gear3Color = floatBuffer3;
    }

    public void setSharedGears(GearsES2 gearsES2) {
        this.sharedGears = gearsES2;
    }

    public void setSyncObjects(Object object) {
        this.syncObjects = object;
    }

    public GearsObjectES2 getGear1() {
        return this.gear1;
    }

    public GearsObjectES2 getGear2() {
        return this.gear2;
    }

    public GearsObjectES2 getGear3() {
        return this.gear3;
    }

    public boolean usesSharedGears() {
        return this.usesSharedGears;
    }

    public void setUseMappedBuffers(boolean bl) {
        this.useMappedBuffers = bl;
    }

    public void setValidateBuffers(boolean bl) {
        this.validateBuffers = bl;
    }

    public PMVMatrix4f getPMVMatrix() {
        return this.pmvMatrix;
    }

    public boolean waitForInit(boolean bl) throws InterruptedException {
        int n;
        for (n = 0; n < 20 && bl != this.isInit; ++n) {
            Thread.sleep(100L);
        }
        return n < 20;
    }

    private final String sid() {
        return "0x" + Integer.toHexString(this.hashCode());
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        Object object;
        if (null != this.sharedGears && !this.sharedGears.isInit()) {
            if (this.verbose) {
                System.err.println(Thread.currentThread() + " GearsES2.init.0 " + this.sid() + ": pending shared Gears .. re-init later XXXXX");
            }
            gLAutoDrawable.setGLEventListenerInitState(this, false);
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.init.0 " + this.sid() + ": tileRendererInUse " + this.tileRendererInUse + ", " + this);
            System.err.println("GearsES2 init " + this.sid() + " on " + Thread.currentThread());
            System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
            System.err.println("INIT GL IS: " + gL2ES2.getClass().getName());
            System.err.println(JoglVersion.getGLStrings(gL2ES2, null, false).toString());
        }
        if (!gL2ES2.hasGLSL()) {
            System.err.println("No GLSL available, no rendering.");
            return;
        }
        this.st = new ShaderState();
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.getClass(), "shader", "shader/bin", "gears", true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, this.getClass(), "shader", "shader/bin", "gears", true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(gL2ES2, shaderCode, System.err);
        shaderProgram.add(gL2ES2, shaderCode2, System.err);
        this.st.attachShaderProgram(gL2ES2, shaderProgram, true);
        this.pmvMatrix = new PMVMatrix(6);
        this.st.attachObject("pmvMatrix", this.pmvMatrix);
        this.pmvMatrixUniform = new GLUniformData("pmvMatrix", 4, 4, this.pmvMatrix.getSyncPMvMviMvit());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        GLUniformData gLUniformData = new GLUniformData("lightPos", 3, this.lightPos);
        this.st.ownUniform(gLUniformData);
        this.st.uniform(gL2ES2, gLUniformData);
        this.colorU = new GLUniformData("color", 4, GearsObject.red);
        this.st.ownUniform(this.colorU);
        this.st.uniform(gL2ES2, this.colorU);
        if (null != this.sharedGears) {
            this.gear1 = new GearsObjectES2(this.sharedGears.getGear1(), this.st, this.pmvMatrix, this.pmvMatrixUniform, this.colorU);
            this.gear2 = new GearsObjectES2(this.sharedGears.getGear2(), this.st, this.pmvMatrix, this.pmvMatrixUniform, this.colorU);
            this.gear3 = new GearsObjectES2(this.sharedGears.getGear3(), this.st, this.pmvMatrix, this.pmvMatrixUniform, this.colorU);
            this.usesSharedGears = true;
            if (this.verbose) {
                System.err.println("gear1 " + this.sid() + " created w/ share: " + this.sharedGears.getGear1() + " -> " + this.gear1);
                System.err.println("gear2 " + this.sid() + " created w/ share: " + this.sharedGears.getGear2() + " -> " + this.gear2);
                System.err.println("gear3 " + this.sid() + " created w/ share: " + this.sharedGears.getGear3() + " -> " + this.gear3);
            }
            if (gL2ES2.getContext().hasRendererQuirk(20)) {
                this.syncObjects = this.sharedGears;
                if (this.verbose) {
                    System.err.println("Shared GearsES2: Synchronized Objects due to quirk " + GLRendererQuirks.toString(20));
                }
            } else if (null == this.syncObjects) {
                this.syncObjects = new Object();
                if (this.verbose) {
                    System.err.println("Shared GearsES2: Unsynchronized Objects");
                }
            }
        } else {
            this.gear1 = new GearsObjectES2(gL2ES2, this.useMappedBuffers, this.st, this.gear1Color, 1.0f, 4.0f, 1.0f, 20, 0.7f, this.pmvMatrix, this.pmvMatrixUniform, this.colorU, this.validateBuffers);
            if (this.verbose) {
                System.err.println("gear1 " + this.sid() + " created: " + this.gear1);
            }
            this.gear2 = new GearsObjectES2(gL2ES2, this.useMappedBuffers, this.st, this.gear2Color, 0.5f, 2.0f, 2.0f, 10, 0.7f, this.pmvMatrix, this.pmvMatrixUniform, this.colorU, this.validateBuffers);
            if (this.verbose) {
                System.err.println("gear2 " + this.sid() + " created: " + this.gear2);
            }
            this.gear3 = new GearsObjectES2(gL2ES2, this.useMappedBuffers, this.st, this.gear3Color, 1.3f, 2.0f, 0.5f, 10, 0.7f, this.pmvMatrix, this.pmvMatrixUniform, this.colorU, this.validateBuffers);
            if (this.verbose) {
                System.err.println("gear3 " + this.sid() + " created: " + this.gear2);
            }
            if (null == this.syncObjects) {
                this.syncObjects = new Object();
            }
        }
        if ((object = gLAutoDrawable.getUpstreamWidget()) instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.gearsMouse);
            window.addKeyListener(this.gearsKeys);
            window.addGestureListener(this.pinchToZoomListener);
            this.pinchToZoomGesture = new PinchToZoomGesture(gLAutoDrawable.getNativeSurface(), false);
            window.addGestureHandler(this.pinchToZoomGesture);
        } else if (GLProfile.isAWTAvailable() && object instanceof Component) {
            Component component = (Component)object;
            new AWTMouseAdapter(this.gearsMouse, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
            new AWTKeyAdapter(this.gearsKeys, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
        }
        this.st.useProgram(gL2ES2, false);
        gL2ES2.glFinish();
        this.isInit = true;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.init.X " + this.sid() + " FIN " + this);
        }
    }

    public final boolean isInit() {
        return this.isInit;
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (!this.isInit) {
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.setSwapInterval(this.swapInterval);
        this.reshapeImpl(gL2ES2, n, n2, n3, n4, n3, n4);
    }

    @Override
    public void reshapeTile(TileRendererBase tileRendererBase, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isInit) {
            return;
        }
        GL2ES2 gL2ES2 = tileRendererBase.getAttachedDrawable().getGL().getGL2ES2();
        gL2ES2.setSwapInterval(0);
        this.reshapeImpl(gL2ES2, n, n2, n3, n4, n5, n6);
    }

    public void setZ(float f, float f2, float f3) {
        this.zNear = f;
        this.zFar = f2;
        this.zViewDist = f3;
    }

    void reshapeImpl(GL2ES2 gL2ES2, int n, int n2, int n3, int n4, int n5, int n6) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl = gL2ES2.getContext().getGLDrawable().getChosenGLCapabilities().getSampleBuffers();
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.reshape " + this.sid() + " " + n + "/" + n2 + " " + n3 + "x" + n4 + " of " + n5 + "x" + n6 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gL2ES2.getContext().getGLDrawable().getHandle()) + ", msaa " + bl + ", tileRendererInUse " + this.tileRendererInUse);
        }
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        if (n6 > n5) {
            f5 = (float)n6 / (float)n5;
            f4 = -1.0f;
            f3 = 1.0f;
            f2 = -f5;
            f = f5;
        } else {
            f5 = (float)n5 / (float)n6;
            f4 = -f5;
            f3 = f5;
            f2 = -1.0f;
            f = 1.0f;
        }
        f5 = f3 - f4;
        float f6 = f - f2;
        float f7 = f4 + (float)n * f5 / (float)n5;
        float f8 = f7 + (float)n3 * f5 / (float)n5;
        float f9 = f2 + (float)n2 * f6 / (float)n6;
        float f10 = f9 + (float)n4 * f6 / (float)n6;
        float f11 = f8 - f7;
        float f12 = f10 - f9;
        if (this.verbose) {
            System.err.println(">> GearsES2 " + this.sid() + ", angle " + this.angle + ", [l " + f4 + ", r " + f3 + ", b " + f2 + ", t " + f + "] " + f5 + "x" + f6 + " -> [l " + f7 + ", r " + f8 + ", b " + f9 + ", t " + f10 + "] " + f11 + "x" + f12 + ", v-flip " + this.flipVerticalInGLOrientation);
        }
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        if (this.flipVerticalInGLOrientation && gL2ES2.getContext().getGLDrawable().isGLOriented()) {
            this.pmvMatrix.glScalef(1.0f, -1.0f, 1.0f);
        }
        this.pmvMatrix.glFrustumf(f7, f8, f9, f10, this.zNear, this.zFar);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -this.zViewDist);
        this.st.useProgram(gL2ES2, true);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
    }

    @Override
    public void reshapeForEye(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, EyeParameter eyeParameter, ViewerPose viewerPose) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        Matrix4f matrix4f = new Matrix4f();
        this.pmvMatrix.glMatrixMode(5889);
        if (this.flipVerticalInGLOrientation && gL2ES2.getContext().getGLDrawable().isGLOriented()) {
            this.mat4Tmp1.setToScale(1.0f, -1.0f, 1.0f);
            this.mat4Tmp2.setToPerspective(eyeParameter.fovhv, this.zNear, this.zFar);
            matrix4f.mul(this.mat4Tmp1, this.mat4Tmp2);
        } else {
            matrix4f.setToPerspective(eyeParameter.fovhv, this.zNear, this.zFar);
        }
        this.pmvMatrix.glLoadMatrixf(matrix4f);
        this.pmvMatrix.glMatrixMode(5888);
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f = this.vec3Tmp1.set(viewerPose.position);
        vec3f.scale(20.0f);
        vec3f.add(eyeParameter.positionOffset);
        quaternion.mult(viewerPose.orientation);
        Vec3f vec3f2 = quaternion.rotateVector(Vec3f.UNIT_Y, this.vec3Tmp2);
        Vec3f vec3f3 = quaternion.rotateVector(Vec3f.UNIT_Z_NEG, this.vec3Tmp3);
        Vec3f vec3f4 = vec3f3.add(vec3f);
        Matrix4f matrix4f2 = this.mat4Tmp2.setToLookAt(vec3f, vec3f4, vec3f2, this.mat4Tmp1);
        matrix4f.mul(this.mat4Tmp1.setToTranslation(eyeParameter.distNoseToPupilX, eyeParameter.distMiddleToPupilY, eyeParameter.eyeReliefZ), matrix4f2);
        matrix4f.translate(0.0f, 0.0f, -this.zViewDist, this.mat4Tmp1);
        this.pmvMatrix.glLoadMatrixf(matrix4f);
        this.st.useProgram(gL2ES2, true);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object;
        Object object2;
        if (!this.isInit) {
            return;
        }
        this.isInit = false;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.dispose " + this.sid() + ": tileRendererInUse " + this.tileRendererInUse);
        }
        if ((object2 = gLAutoDrawable.getUpstreamWidget()) instanceof Window) {
            object = (Window)object2;
            object.removeMouseListener(this.gearsMouse);
            object.removeKeyListener(this.gearsKeys);
            object.removeGestureHandler(this.pinchToZoomGesture);
            this.pinchToZoomGesture = null;
            object.removeGestureListener(this.pinchToZoomListener);
        }
        if (!(object = gLAutoDrawable.getGL().getGL2ES2()).hasGLSL()) {
            return;
        }
        this.st.useProgram((GL2ES2)object, false);
        this.gear1.destroy((GL)object);
        this.gear1 = null;
        this.gear2.destroy((GL)object);
        this.gear2 = null;
        this.gear3.destroy((GL)object);
        this.gear3 = null;
        this.pmvMatrix = null;
        this.colorU = null;
        this.st.destroy((GL2ES2)object);
        this.st = null;
        this.sharedGears = null;
        this.syncObjects = null;
        if (this.verbose) {
            System.err.println(Thread.currentThread() + " GearsES2.dispose " + this.sid() + " FIN");
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        this.display(gLAutoDrawable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLAutoDrawable gLAutoDrawable, int n) {
        boolean bl;
        if (!this.isInit) {
            return;
        }
        if (null != this.sharedGears && !this.sharedGears.isInit()) {
            return;
        }
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (this.verbose && (null == gLAnimatorControl || !gLAnimatorControl.isAnimating())) {
            System.err.println(Thread.currentThread() + " GearsES2.display " + this.sid() + " " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceHeight() + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gLAutoDrawable.getHandle()));
        }
        boolean bl2 = 0 != (1 & n);
        boolean bl3 = bl = 0 != (2 & n);
        if (this.doRotate && !bl2) {
            this.angle += 0.5f;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        Object object = gLAutoDrawable.getUpstreamWidget();
        boolean bl4 = object instanceof NativeWindow ? ((NativeWindow)object).hasFocus() : true;
        if (this.clearBuffers && !bl) {
            if (null != this.clearColor) {
                gL2ES2.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            } else if (null != this.tileRendererInUse) {
                gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
            } else if (this.ignoreFocus || bl4) {
                gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                gL2ES2.glClearColor(0.2f, 0.2f, 0.2f, 0.0f);
            }
            if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof GLJPanel && !((GLJPanel)gLAutoDrawable).isOpaque() && ((GLJPanel)gLAutoDrawable).shouldPreserveColorBufferIfTranslucent()) {
                gL2ES2.glClear(256);
            } else {
                gL2ES2.glClear(16640);
            }
        }
        if (!gL2ES2.hasGLSL()) {
            return;
        }
        this.setGLStates(gL2ES2, true);
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glPushMatrix();
        this.pmvMatrix.glTranslatef(this.panX, this.panY, this.panZ);
        this.pmvMatrix.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        this.pmvMatrix.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        this.pmvMatrix.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        Object object2 = this.syncObjects;
        synchronized (object2) {
            this.gear1.draw((GL)gL2ES2, -3.0f, -2.0f, 1.0f * this.angle - 0.0f);
            this.gear2.draw((GL)gL2ES2, 3.1f, -2.0f, -2.0f * this.angle - 9.0f);
            this.gear3.draw((GL)gL2ES2, -3.1f, 4.2f, -2.0f * this.angle - 25.0f);
        }
        this.pmvMatrix.glPopMatrix();
        this.st.useProgram(gL2ES2, false);
        this.setGLStates(gL2ES2, false);
    }

    public void setGLStates(GL2ES2 gL2ES2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.flipVerticalInGLOrientation || !gL2ES2.getContext().getGLDrawable().isGLOriented();
        if (bl) {
            gL2ES2.glEnable(2929);
            if (bl2) {
                gL2ES2.glEnable(2884);
            }
        } else {
            gL2ES2.glDisable(2929);
            if (bl2) {
                gL2ES2.glDisable(2884);
            }
        }
    }

    public String toString() {
        return "GearsES2[obj " + this.sid() + " isInit " + this.isInit + ", usesShared " + this.usesSharedGears + ", 1 " + this.gear1 + ", 2 " + this.gear2 + ", 3 " + this.gear3 + ", sharedGears " + this.sharedGears + "]";
    }

    class GearsMouseAdapter
    implements MouseListener {
        private int prevMouseX;
        private int prevMouseY;

        GearsMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            float[] fArray = mouseEvent.getRotation();
            if (mouseEvent.isControlDown()) {
                float f = mouseEvent.isShiftDown() ? fArray[0] : fArray[1] * 0.5f;
                GearsES2.this.panZ += f;
                System.err.println("panZ.2: incr " + f + ", dblZoom " + mouseEvent.isShiftDown() + " -> " + GearsES2.this.panZ);
            } else {
                GearsES2.this.panX -= fArray[0];
                GearsES2.this.panY += fArray[1];
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getPointerCount() == 1) {
                this.prevMouseX = mouseEvent.getX();
                this.prevMouseY = mouseEvent.getY();
            } else if (mouseEvent.getPointerCount() == 4) {
                Object object = mouseEvent.getSource();
                if (mouseEvent.getPressure(0, true) > 0.7f && object instanceof Window) {
                    ((Window)object).setKeyboardVisible(true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.isConfined()) {
                this.navigate(mouseEvent);
            } else {
                this.prevMouseX = mouseEvent.getX();
                this.prevMouseY = mouseEvent.getY();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.navigate(mouseEvent);
        }

        private void navigate(MouseEvent mouseEvent) {
            Object object;
            int n;
            int n2;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            Object object2 = mouseEvent.getSource();
            Window window = null;
            if (object2 instanceof Window) {
                window = (Window)object2;
                n2 = window.getSurfaceWidth();
                n = window.getSurfaceHeight();
            } else if (object2 instanceof GLAutoDrawable) {
                object = (GLAutoDrawable)object2;
                n2 = object.getSurfaceWidth();
                n = object.getSurfaceHeight();
            } else if (GLProfile.isAWTAvailable() && object2 instanceof Component) {
                object = (Component)object2;
                n2 = ((Component)object).getWidth();
                n = ((Component)object).getHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object2);
            }
            float f = 360.0f * ((float)(n3 - this.prevMouseX) / (float)n2);
            float f2 = 360.0f * ((float)(this.prevMouseY - n4) / (float)n);
            GearsES2.this.view_rotx += f2;
            GearsES2.this.view_roty += f;
            this.prevMouseX = n3;
            this.prevMouseY = n4;
        }
    }

    class GearsKeyAdapter
    extends KeyAdapter {
        GearsKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (149 == s) {
                GearsES2.this.view_roty -= 1.0f;
            } else if (151 == s) {
                GearsES2.this.view_roty += 1.0f;
            } else if (150 == s) {
                GearsES2.this.view_rotx -= 1.0f;
            } else if (152 == s) {
                GearsES2.this.view_rotx += 1.0f;
            }
        }
    }
}

