/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.nio.FloatBuffer;

public class TextureDraw01ES2Listener
implements GLEventListener,
TextureDraw01Accessor {
    TextureData textureData;
    Texture texture;
    int textureUnit;
    boolean keepTextureBound;
    ShaderState st;
    PMVMatrix pmvMatrix;
    GLUniformData pmvMatrixUniform;
    GLArrayDataServer interleavedVBO;
    float[] clearColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    static final String shaderBasename = "texture01_xxx";
    private static final float[] s_quadVertices = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] s_quadColors = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] s_quadTexCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    public TextureDraw01ES2Listener(TextureData textureData, int n) {
        this.textureData = textureData;
        this.textureUnit = n;
        this.keepTextureBound = false;
    }

    public void setClearColor(float[] fArray) {
        this.clearColor = fArray;
    }

    @Override
    public void setKeepTextureBound(boolean bl) {
        this.keepTextureBound = bl;
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    private void initShader(GL2ES2 gL2ES2, boolean bl) {
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.getClass(), "shader", "shader/bin", shaderBasename, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, this.getClass(), "shader", "shader/bin", shaderBasename, true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, bl);
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        if (null != this.textureData) {
            this.texture = TextureIO.newTexture(gLAutoDrawable.getGL(), this.textureData);
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.initShader(gL2ES2, true);
        this.pmvMatrix = new PMVMatrix();
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, this.pmvMatrix.getSyncPMv());
        this.st.ownUniform(this.pmvMatrixUniform);
        if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_ActiveTexture", this.textureUnit))) {
            throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
        }
        if (null != this.texture) {
            this.texture.getImageTexCoords().getST_LB_RB_LT_RT(s_quadTexCoords, 0, 1.0f, 1.0f);
        }
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved(9, 5126, false, 12, 35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 4; ++i) {
            floatBuffer.put(s_quadVertices, i * 3, 3);
            floatBuffer.put(s_quadColors, i * 4, 4);
            floatBuffer.put(s_quadTexCoords, i * 2, 2);
        }
        this.interleavedVBO.seal(gL2ES2, true);
        this.interleavedVBO.enableBuffer(gL2ES2, false);
        this.st.ownAttribute(this.interleavedVBO, true);
        gL2ES2.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
        gL2ES2.glEnable(2929);
        if (this.keepTextureBound && null != this.texture) {
            gL2ES2.glActiveTexture(33984 + this.textureUnit);
            this.texture.enable(gL2ES2);
            this.texture.bind(gL2ES2);
        }
        this.st.useProgram(gL2ES2, false);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
        if (null != this.st) {
            this.pmvMatrix.glMatrixMode(5889);
            this.pmvMatrix.glLoadIdentity();
            this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 10.0f);
            this.pmvMatrix.glMatrixMode(5888);
            this.pmvMatrix.glLoadIdentity();
            this.st.useProgram(gL2ES2, true);
            this.st.uniform(gL2ES2, this.pmvMatrixUniform);
            this.st.useProgram(gL2ES2, false);
        }
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.texture) {
            this.texture.disable(gL2ES2);
            this.texture.destroy(gL2ES2);
        }
        if (null != this.textureData) {
            this.textureData.destroy();
        }
        this.pmvMatrixUniform = null;
        this.pmvMatrix = null;
        this.st.destroy(gL2ES2);
        this.st = null;
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClear(16640);
        this.st.useProgram(gL2ES2, true);
        this.interleavedVBO.enableBuffer(gL2ES2, true);
        if (!this.keepTextureBound && null != this.texture) {
            gL2ES2.glActiveTexture(33984 + this.textureUnit);
            this.texture.enable(gL2ES2);
            this.texture.bind(gL2ES2);
        }
        gL2ES2.glDrawArrays(5, 0, 4);
        if (!this.keepTextureBound && null != this.texture) {
            this.texture.disable(gL2ES2);
        }
        this.interleavedVBO.enableBuffer(gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }
}

