/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug1431NewtCanvasAWT
extends UITestCase {
    static long duration = 500L;

    static void setFrameSize(final Frame frame, final boolean bl, final int n, final int n2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = new Dimension(n, n2);
                    frame.setSize(dimension);
                    if (bl) {
                        frame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        long l;
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLWindow gLWindow = GLWindow.create(gLCapabilities);
        JOGLQuadNewt jOGLQuadNewt = new JOGLQuadNewt();
        gLWindow.addGLEventListener(jOGLQuadNewt);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        snapshotGLEventListener.setPostSNDetail(this.getClass().getSimpleName());
        gLWindow.addGLEventListener(snapshotGLEventListener);
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowResized(com.jogamp.newt.event.WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }

            @Override
            public void windowMoved(com.jogamp.newt.event.WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }
        });
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame(this.getClass().getSimpleName());
        final Animator animator = new Animator(gLWindow);
        final boolean[] blArray = new boolean[]{false};
        frame.add(newtCanvasAWT);
        frame.setSize(640, 480);
        frame.addWindowListener(new java.awt.event.WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                blArray[0] = true;
                animator.stop();
                frame.dispose();
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.validate();
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(frame, true, null));
        Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, true, null));
        animator.start();
        Assert.assertTrue(animator.isAnimating());
        Assert.assertTrue(animator.isStarted());
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        System.err.println("XXXX");
        newtCanvasAWT.requestFocus();
        snapshotGLEventListener.setMakeSnapshot();
        Thread.sleep(100L);
        TestBug1431NewtCanvasAWT.setFrameSize(frame, false, 800, 600);
        snapshotGLEventListener.setMakeSnapshot();
        Thread.sleep(10L);
        snapshotGLEventListener.setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!blArray[0] && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        if (!blArray[0]) {
            animator.stop();
            Assert.assertFalse(animator.isAnimating());
            Assert.assertFalse(animator.isStarted());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
            gLWindow.destroy();
            Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, false, null));
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        System.err.println("duration " + duration);
        JUnitCore.main(TestBug1431NewtCanvasAWT.class.getName());
    }

    public static class JOGLQuadNewt
    implements GLEventListener {
        final int[] exp_gl_viewport = new int[]{-1, -1, -1, -1};
        final int[] has_gl_viewport = new int[]{-1, -1, -1, -1};
        private float rotateT = 0.0f;

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClear(16384);
            gL2.glClear(256);
            gL2.glLoadIdentity();
            gL2.glTranslatef(0.0f, 0.0f, -5.0f);
            gL2.glRotatef(this.rotateT, 1.0f, 0.0f, 0.0f);
            gL2.glRotatef(this.rotateT, 0.0f, 1.0f, 0.0f);
            gL2.glRotatef(this.rotateT, 0.0f, 0.0f, 1.0f);
            gL2.glBegin(7);
            gL2.glColor3f(0.0f, 1.0f, 1.0f);
            gL2.glVertex3f(-1.0f, 1.0f, 0.0f);
            gL2.glVertex3f(1.0f, 1.0f, 0.0f);
            gL2.glVertex3f(1.0f, -1.0f, 0.0f);
            gL2.glVertex3f(-1.0f, -1.0f, 0.0f);
            gL2.glEnd();
            this.rotateT += 0.2f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glShadeModel(7425);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glClearDepth(1.0);
            gL2.glEnable(2929);
            gL2.glDepthFunc(515);
            gL2.glHint(3152, 4354);
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            this.exp_gl_viewport[0] = n;
            this.exp_gl_viewport[1] = n2;
            this.exp_gl_viewport[2] = n3;
            this.exp_gl_viewport[3] = n4;
            gL2.glGetIntegerv(2978, this.has_gl_viewport, 0);
            System.err.println("GLEL reshape: Surface " + gLAutoDrawable.getSurfaceWidth() + "x" + gLAutoDrawable.getSurfaceWidth() + ", reshape " + n + "/" + n2 + " " + n3 + "x" + n4);
            System.err.println("GLEL reshape: Viewport " + this.has_gl_viewport[0] + "/" + this.has_gl_viewport[1] + ", " + this.has_gl_viewport[2] + "x" + this.has_gl_viewport[3]);
            float f = (float)n3 / (float)n4;
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            float f2 = 0.5f * f;
            gL2.glFrustumf(-f2, f2, -0.5f, 0.5f, 1.0f, 1000.0f);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }
}

