/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.LandscapeES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestLandscapeES2NEWT
extends UITestCase {
    static int width = 500;
    static int height = 290;
    static int swapInterval = 1;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean mainRun = false;
    static boolean exclusiveContext = false;
    static boolean useAnimator = true;
    static long duration = 1000L;

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException {
        Animator animator;
        System.err.println("requested: swapInterval " + swapInterval + ", " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.setSize(width, height);
        LandscapeES2 landscapeES2 = new LandscapeES2(swapInterval);
        gLWindow.addGLEventListener(landscapeES2);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        snapshotGLEventListener.setPostSNDetail(landscapeES2.getClass().getSimpleName());
        gLWindow.addGLEventListener(snapshotGLEventListener);
        Animator animator2 = animator = useAnimator ? new Animator(0) : null;
        if (useAnimator) {
            animator.setExclusiveContext(exclusiveContext);
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    gLWindow.invokeOnNewThread(null, false, new Runnable(){

                        @Override
                        public void run() {
                            gLWindow.setFullscreen(!gLWindow.isFullscreen());
                        }
                    });
                } else if (keyEvent.getKeyChar() == 'd') {
                    gLWindow.invokeOnNewThread(null, false, new Runnable(){

                        @Override
                        public void run() {
                            gLWindow.setUndecorated(!gLWindow.isUndecorated());
                        }
                    });
                }
            }
        });
        if (useAnimator) {
            animator.add(gLWindow);
            animator.start();
        }
        gLWindow.setVisible(true);
        if (useAnimator) {
            animator.setUpdateFPSFrames(60, System.err);
        }
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        if (useAnimator) {
            animator.stop();
        }
        gLWindow.destroy();
    }

    @Test
    public void test01GL2ES2() throws InterruptedException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test02GL3() throws InterruptedException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (!stringArray[i].equals("-gl3")) continue;
            forceGL3 = true;
        }
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        JUnitCore.main(TestLandscapeES2NEWT.class.getName());
    }
}

