/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glu;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelStorageModes;
import java.awt.Frame;
import java.nio.ByteBuffer;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug694ScaleImageUnpackBufferSizeAWT
extends UITestCase
implements GLEventListener {
    boolean testDone = false;

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.testDone) {
            this.testDone = true;
            GL gL = gLAutoDrawable.getGL();
            GLU gLU = GLU.createGLU(gL);
            System.err.println("Using GLU " + gLU.getClass().getName());
            this.testGLUScaleImage(gL, gLU, 0);
            this.testGLUScaleImage(gL, gLU, 1);
            this.testGLUScaleImage(gL, gLU, 4);
            this.testGLUScaleImage(gL, gLU, 8);
        }
    }

    private void testGLUScaleImage(GL gL, GLU gLU, int n) {
        GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
        if (0 < n) {
            gLPixelStorageModes.setUnpackAlignment(gL, n);
        }
        int[] nArray = new int[1];
        int n2 = GLBuffers.sizeof(gL, nArray, 6409, 5121, 213, 213, 1, false);
        int n3 = GLBuffers.sizeof(gL, nArray, 6409, 5121, 256, 256, 1, false);
        System.err.println("Unpack-Alignment " + n + ":  in-size " + n2);
        System.err.println("Unpack-Alignment " + n + ": out-size " + n3);
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n2);
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(n3);
        gLU.gluScaleImage(6409, 213, 213, 5121, byteBuffer, 256, 256, 5121, byteBuffer2);
        if (0 < n) {
            gLPixelStorageModes.restore(gL);
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    @Test
    public void test01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        gLCanvas.addGLEventListener(this);
        final Frame frame = new Frame("Test");
        frame.add(gLCanvas);
        frame.setSize(256, 256);
        frame.validate();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        gLCanvas.display();
        Thread.sleep(200L);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove(gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestBug694ScaleImageUnpackBufferSizeAWT.class.getName());
    }
}

