/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.perf;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPerf001GLJPanelInit01AWT
extends UITestCase {
    final long INIT_TIMEOUT = 10000L;
    static long duration = 0L;
    static boolean wait = false;
    static int width = 800;
    static int height = 600;
    static int rows = 5;
    static int cols = 5;
    AtomicInteger initCount = new AtomicInteger(0);

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final boolean bl, int n, int n2, int n3, int n4, final CanvasType canvasType, boolean bl2) {
        long l;
        final Animator animator = bl2 ? new Animator() : null;
        final ArrayList arrayList = new ArrayList();
        final JPanel jPanel = new JPanel();
        final JFrame jFrame = new JFrame(this.getSimpleTestName("."));
        jPanel.setLayout(new GridLayout(n3, n4));
        final int n5 = n3 * n4;
        final Dimension dimension = new Dimension(n / n4, n2 / n3);
        final long[] lArray = new long[10];
        if (wait) {
            UITestCase.waitForKey("Pre-Init");
        }
        System.err.println("INIT START");
        this.initCount.set(0);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    lArray[0] = Platform.currentTimeMillis();
                    for (int i = 0; i < n5; ++i) {
                        GLADComp gLADComp;
                        switch (canvasType.ordinal()) {
                            case 0: {
                                gLADComp = TestPerf001GLJPanelInit01AWT.this.createGLCanvas(gLCapabilitiesImmutable, bl, animator, dimension);
                                break;
                            }
                            case 1: {
                                gLADComp = TestPerf001GLJPanelInit01AWT.this.createGLJPanel(gLCapabilitiesImmutable, bl, animator, dimension);
                                break;
                            }
                            case 2: {
                                gLADComp = TestPerf001GLJPanelInit01AWT.this.createNewtCanvasAWT(gLCapabilitiesImmutable, bl, animator, dimension);
                                arrayList.add((NewtCanvasAWT)gLADComp.comp);
                                break;
                            }
                            default: {
                                throw new InternalError("XXX");
                            }
                        }
                        gLADComp.glad.addGLEventListener(new GLEventListener(){

                            @Override
                            public void init(GLAutoDrawable gLAutoDrawable) {
                                TestPerf001GLJPanelInit01AWT.this.initCount.getAndIncrement();
                            }

                            @Override
                            public void dispose(GLAutoDrawable gLAutoDrawable) {
                            }

                            @Override
                            public void display(GLAutoDrawable gLAutoDrawable) {
                            }

                            @Override
                            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                            }
                        });
                        jPanel.add(gLADComp.comp);
                    }
                    lArray[1] = Platform.currentTimeMillis();
                    jFrame.getContentPane().add(jPanel);
                    jFrame.pack();
                    jFrame.setVisible(true);
                    lArray[2] = Platform.currentTimeMillis();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        long l2 = l = System.currentTimeMillis();
        while (n5 > this.initCount.get() && 10000L > l2 - l) {
            try {
                Thread.sleep(100L);
                System.err.println("Sleep initialized: " + this.initCount.get() + "/" + n5);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
        }
        lArray[3] = Platform.currentTimeMillis();
        double d = this.initCount.get();
        System.err.printf("P: %d %s:%n\tctor\t%6d/t %6.2f/1%n\tvisible\t%6d/t %6.2f/1%n\tsum-i\t%6d/t %6.2f/1%n", new Object[]{this.initCount.get(), canvasType, lArray[1] - lArray[0], (double)(lArray[1] - lArray[0]) / d, lArray[3] - lArray[1], (double)(lArray[3] - lArray[1]) / d, lArray[3] - lArray[0], (double)(lArray[3] - lArray[0]) / d});
        System.err.println("INIT END: " + this.initCount.get() + "/" + n5);
        if (wait) {
            UITestCase.waitForKey("Post-Init");
        }
        if (null != animator) {
            animator.start();
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (null != animator) {
            animator.stop();
        }
        lArray[4] = Platform.currentTimeMillis();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    while (!arrayList.isEmpty()) {
                        ((NewtCanvasAWT)arrayList.remove(0)).destroy();
                    }
                    jFrame.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l3 = lArray[4] - lArray[0] - duration;
        System.err.printf("T: duration %d %d%n\ttotal-d\t%6d/t %6.2f/1%n\ttotal-i\t%6d/t %6.2f/1%n", duration, lArray[4] - lArray[3], lArray[4] - lArray[0], (double)(lArray[4] - lArray[0]) / d, l3, (double)l3 / d);
        System.err.println("Total: " + (lArray[4] - lArray[0]));
    }

    private GLADComp createNewtCanvasAWT(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        newtCanvasAWT.setSize(dimension);
        newtCanvasAWT.setPreferredSize(dimension);
        if (bl) {
            GearsES2 gearsES2 = new GearsES2(0);
            gearsES2.setVerbose(false);
            gLWindow.addGLEventListener(gearsES2);
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLWindow);
        }
        return new GLADComp(gLWindow, newtCanvasAWT);
    }

    private GLADComp createGLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas.setSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        if (bl) {
            gLCanvas.addGLEventListener(new GearsES2(0));
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLCanvas);
        }
        return new GLADComp(gLCanvas, gLCanvas);
    }

    private GLADComp createGLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, GLAnimatorControl gLAnimatorControl, Dimension dimension) {
        GLJPanel gLJPanel = new GLJPanel(gLCapabilitiesImmutable);
        gLJPanel.setSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        if (bl) {
            gLJPanel.addGLEventListener(new GearsES2(0));
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLJPanel);
        }
        return new GLADComp(gLJPanel, gLJPanel);
    }

    public void test01NopGLJPanel() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, width, height, rows, cols, CanvasType.GLJPanel_T, false);
    }

    public void test02NopGLJPanelBMP() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setBitmap(true);
        this.test(gLCapabilities, false, width, height, rows, cols, CanvasType.GLJPanel_T, false);
    }

    public void test03NopGLCanvas() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), false, width, height, rows, cols, CanvasType.GLCanvas_T, false);
    }

    public void test11GearsGLJPanel() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, width, height, rows, cols, CanvasType.GLJPanel_T, true);
    }

    public void test13GearsGLCanvas() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, width, height, rows, cols, CanvasType.GLCanvas_T, true);
    }

    @Test
    public void test14GearsNewtCanvasAWT() throws InterruptedException, InvocationTargetException {
        this.test(new GLCapabilities(null), true, width, height, rows, cols, CanvasType.NewtCanvasAWT_T, true);
    }

    public static void main(String[] stringArray) {
        CanvasType canvasType = CanvasType.GLJPanel_T;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-rows")) {
                rows = MiscUtils.atoi(stringArray[++i], rows);
                continue;
            }
            if (stringArray[i].equals("-cols")) {
                cols = MiscUtils.atoi(stringArray[++i], cols);
                continue;
            }
            if (stringArray[i].equals("-type")) {
                canvasType = CanvasType.valueOf(stringArray[++i]);
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-gears")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                wait = true;
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-waitMain")) {
                bl3 = true;
                bl2 = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            bl2 = true;
        }
        if (bl3) {
            UITestCase.waitForKey("Main-Start");
        }
        if (bl2) {
            GLProfile.initSingleton();
            TestPerf001GLJPanelInit01AWT testPerf001GLJPanelInit01AWT = new TestPerf001GLJPanelInit01AWT();
            testPerf001GLJPanelInit01AWT.test(null, bl, width, height, rows, cols, canvasType, bl);
        } else {
            JUnitCore.main(TestPerf001GLJPanelInit01AWT.class.getName());
        }
    }

    static class GLADComp {
        final GLAutoDrawable glad;
        final Component comp;

        GLADComp(GLAutoDrawable gLAutoDrawable, Component component) {
            this.glad = gLAutoDrawable;
            this.comp = component;
        }
    }

    static enum CanvasType {
        GLCanvas_T,
        GLJPanel_T,
        NewtCanvasAWT_T;

    }
}

