/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.swt;

import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.swt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.SWTTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSWTJOGLGLCanvas01GLn
extends UITestCase {
    static int duration = 250;
    static boolean doAnimation = true;
    static final int iwidth = 640;
    static final int iheight = 480;
    Display display = null;
    Shell shell = null;
    Composite composite = null;

    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    @Before
    public void init() {
        SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

            @Override
            public void run() {
                TestSWTJOGLGLCanvas01GLn.this.display = new Display();
                Assert.assertNotNull(TestSWTJOGLGLCanvas01GLn.this.display);
                SWTAccessor.printInfo(System.err, TestSWTJOGLGLCanvas01GLn.this.display);
            }
        });
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSWTJOGLGLCanvas01GLn.this.shell = new Shell(TestSWTJOGLGLCanvas01GLn.this.display);
                Assert.assertNotNull(TestSWTJOGLGLCanvas01GLn.this.shell);
                TestSWTJOGLGLCanvas01GLn.this.shell.setLayout((Layout)new FillLayout());
                TestSWTJOGLGLCanvas01GLn.this.composite = new Composite((Composite)TestSWTJOGLGLCanvas01GLn.this.shell, 262144);
                TestSWTJOGLGLCanvas01GLn.this.composite.setLayout((Layout)new FillLayout());
                Assert.assertNotNull(TestSWTJOGLGLCanvas01GLn.this.composite);
            }
        });
    }

    @After
    public void release() {
        Assert.assertNotNull(this.display);
        Assert.assertNotNull(this.shell);
        Assert.assertNotNull(this.composite);
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestSWTJOGLGLCanvas01GLn.this.composite.dispose();
                    TestSWTJOGLGLCanvas01GLn.this.shell.dispose();
                }
            });
            SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

                @Override
                public void run() {
                    TestSWTJOGLGLCanvas01GLn.this.display.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        this.display = null;
        this.shell = null;
        this.composite = null;
    }

    protected void runTestAGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(false, false);
        final GLCanvas gLCanvas = GLCanvas.create(this.composite, 0, gLCapabilitiesImmutable, null);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.addGLEventListener(gLEventListener);
        gLCanvas.addGLEventListener(new GLEventListener(){
            int displayCount = 0;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (this.displayCount < 3) {
                    TestSWTJOGLGLCanvas01GLn.this.snapshot(this.displayCount++, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestSWTJOGLGLCanvas01GLn.this.shell.setText(TestSWTJOGLGLCanvas01GLn.this.getSimpleTestName("."));
                TestSWTJOGLGLCanvas01GLn.this.shell.setSize(640, 480);
                TestSWTJOGLGLCanvas01GLn.this.shell.open();
            }
        });
        Animator animator = new Animator();
        if (doAnimation) {
            animator.add(gLCanvas);
            animator.start();
        }
        SWTTestUtil.WaitAction waitAction = new SWTTestUtil.WaitAction(this.display, true, 16L);
        long l = System.currentTimeMillis();
        long l2 = l + (long)duration;
        try {
            while (System.currentTimeMillis() < l2 && !gLCanvas.isDisposed()) {
                waitAction.run();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        animator.stop();
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                gLCanvas.dispose();
            }
        });
    }

    @Test
    public void test() throws InterruptedException {
        this.runTestAGL(new GLCapabilities(GLProfile.getGL2ES2()), new GearsES2());
    }

    @Test
    public void test_MultisampleAndAlpha() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(2);
        this.runTestAGL(gLCapabilities, new MultisampleDemoES2(true));
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestSWTJOGLGLCanvas01GLn.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-still")) continue;
            doAnimation = false;
        }
        System.out.println("durationPerTest: " + duration);
        JUnitCore.main(TestSWTJOGLGLCanvas01GLn.class.getName());
    }
}

