/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.gl2es1.GLUgl2es1;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

class DemoGL2ES1Plain
implements GLEventListener {
    final boolean useArrayData;
    final boolean useVBO;
    final GLU glu;
    final float[] vertices = new float[]{0.0f, 0.0f, 0.0f, 400.0f, 0.0f, 0.0f, 200.0f, 400.0f, 0.0f};
    final float[] colors = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    final ByteBuffer bufferAll;
    final int bufferVOffset;
    final int bufferCOffset;
    final int bufferVSize;
    final int bufferCSize;
    final FloatBuffer bufferC;
    final FloatBuffer bufferV;
    final int[] vboName = new int[]{0};
    final GLArrayDataWrapper arrayC;
    final GLArrayDataWrapper arrayV;

    DemoGL2ES1Plain(boolean bl, boolean bl2) {
        this.useArrayData = bl;
        this.useVBO = bl2;
        this.glu = new GLUgl2es1();
        this.bufferAll = Buffers.newDirectByteBuffer((this.colors.length + this.vertices.length) * 4);
        this.bufferVOffset = 0;
        this.bufferCOffset = this.bufferVSize = 9 * GLBuffers.sizeOfGLType(5126);
        this.bufferCSize = 9 * GLBuffers.sizeOfGLType(5126);
        this.bufferV = (FloatBuffer)GLBuffers.sliceGLBuffer(this.bufferAll, this.bufferVOffset, this.bufferVSize, 5126);
        this.bufferV.put(this.vertices, 0, this.vertices.length).rewind();
        this.bufferC = (FloatBuffer)GLBuffers.sliceGLBuffer(this.bufferAll, this.bufferCOffset, this.bufferCSize, 5126);
        this.bufferC.put(this.colors, 0, this.colors.length).rewind();
        System.err.println("bufferAll: " + this.bufferAll + ", byteOffset " + Buffers.getDirectBufferByteOffset(this.bufferAll));
        System.err.println("bufferV: off " + this.bufferVOffset + ", size " + this.bufferVSize + ": " + this.bufferV + ", byteOffset " + Buffers.getDirectBufferByteOffset(this.bufferV));
        System.err.println("bufferC: off " + this.bufferCOffset + ", size " + this.bufferCSize + ": " + this.bufferC + ", byteOffset " + Buffers.getDirectBufferByteOffset(this.bufferC));
        if (bl) {
            this.arrayV = GLArrayDataWrapper.createFixed(32884, 3, 5126, false, 0, this.bufferV, 0, (long)this.bufferVOffset, 35044, 34962);
            this.arrayC = GLArrayDataWrapper.createFixed(32886, 3, 5126, false, 0, this.bufferC, 0, (long)this.bufferCOffset, 35044, 34962);
        } else {
            this.arrayV = null;
            this.arrayC = null;
        }
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        System.err.println("GL_VENDOR   " + gL.glGetString(7936));
        System.err.println("GL_RENDERER " + gL.glGetString(7937));
        System.err.println("GL_VERSION  " + gL.glGetString(7938));
        if (this.useVBO) {
            gL.glGenBuffers(1, this.vboName, 0);
            if (0 == this.vboName[0]) {
                throw new GLException("glGenBuffers didn't return valid VBO name");
            }
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, n3, 0.0f, n4);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glViewport(0, 0, n3, n4);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glClear(16384);
        gL2ES1.glLoadIdentity();
        if (this.useVBO) {
            gL2ES1.glBindBuffer(34962, this.vboName[0]);
            gL2ES1.glBufferData(34962, this.bufferAll.limit(), this.bufferAll, 35044);
            if (this.useArrayData) {
                this.arrayV.setVBOName(this.vboName[0]);
                this.arrayC.setVBOName(this.vboName[0]);
            }
        }
        gL2ES1.glEnableClientState(32884);
        if (this.useArrayData) {
            gL2ES1.glVertexPointer(this.arrayV);
        } else if (this.useVBO) {
            gL2ES1.glVertexPointer(3, 5126, 0, this.bufferVOffset);
        } else {
            gL2ES1.glVertexPointer(3, 5126, 0, this.bufferV);
        }
        gL2ES1.glEnableClientState(32886);
        if (this.useArrayData) {
            gL2ES1.glColorPointer(this.arrayC);
        } else if (this.useVBO) {
            gL2ES1.glColorPointer(3, 5126, 0, this.bufferCOffset);
        } else {
            gL2ES1.glColorPointer(3, 5126, 0, this.bufferC);
        }
        if (this.useVBO) {
            gL2ES1.glBindBuffer(34962, 0);
        }
        gL2ES1.glDrawArrays(4, 0, 3);
        gL2ES1.glFlush();
        gL2ES1.glDisableClientState(32886);
        gL2ES1.glDisableClientState(32884);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        if (0 != this.vboName[0]) {
            gL.glDeleteBuffers(1, this.vboName, 0);
            this.vboName[0] = 0;
        }
    }
}

