/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;

public class ImageTstFiles {
    public static final String[] pngFileNames = new String[]{"bug724-transparent-grey_gimpexp.png", "bug724-transparent-grey_orig.png", "cross-grey-alpha-16x16.png", "grayscale_texture.png", "pointer-grey-alpha-16x24.png", "test-ntscI_3-01-160x90.png", "test-ntscI_4-01-160x90.png", "test-ntscIG3-01-160x90.png", "test-ntscIG4-01-160x90.png", "test-ntscN_3-01-160x90.png", "test-ntscN_4-01-160x90.png", "test-ntscNG4-01-160x90.png", "test-ntscP_3-01-160x90.png", "test-ntscP_4-01-160x90.png"};
    public static final String[] jpgFileNames = new String[]{"bug745_qttdef_post_frame.jpg", "darwin_03_N_4-YCCK-640x452.jpg", "darwin_03_N_4-YCCK.jpg", "j1-baseline.jpg", "j2-progressive.jpg", "j3-baseline_gray.jpg", "test-cmyk-01.jpg", "test-ntscN_3-01-160x90-60pct-yuv422h-base.jpg", "test-ntscN_3-01-160x90-60pct-yuv422h-prog.jpg", "test-ntscN_3-01-160x90-90pct-yuv444-base.jpg", "test-ntscN_3-01-160x90-90pct-yuv444-prog.jpg", "test-ycck-01.jpg"};
    public static final String[] tgaFileNames = new String[]{"bug744-rle32.tga", "bug982.rle32.256x256.tga", "test-u32.tga"};
    public static final String[] ddsFileNames = new String[]{"test-64x32_DXT1.dds", "test-64x32_DXT5.dds", "test-64x32_uncompressed.dds"};
    public ArrayList<NamedInputStream> pngStreams;
    public ArrayList<NamedInputStream> jpgStreams;
    public ArrayList<NamedInputStream> tgaStreams;
    public ArrayList<NamedInputStream> ddsStreams;
    public ArrayList<NamedInputStream> allStreams;

    private final ArrayList<NamedInputStream> init(String[] stringArray) throws IOException {
        ArrayList<NamedInputStream> arrayList = new ArrayList<NamedInputStream>();
        for (int i = 0; i < stringArray.length; ++i) {
            InputStream inputStream;
            URLConnection uRLConnection = IOUtil.getResource(stringArray[i], this.getClass().getClassLoader(), this.getClass());
            if (null == uRLConnection || null == (inputStream = uRLConnection.getInputStream())) continue;
            arrayList.add(new NamedInputStream(uRLConnection.getURL().toString(), stringArray[i], inputStream));
        }
        return arrayList;
    }

    public void init() throws IOException {
        this.pngStreams = this.init(pngFileNames);
        this.jpgStreams = this.init(jpgFileNames);
        this.tgaStreams = this.init(tgaFileNames);
        this.ddsStreams = this.init(ddsFileNames);
        this.allStreams = new ArrayList();
        this.allStreams.addAll(this.pngStreams);
        this.allStreams.addAll(this.jpgStreams);
        this.allStreams.addAll(this.tgaStreams);
        this.allStreams.addAll(this.ddsStreams);
    }

    public void clear() {
        this.pngStreams.clear();
        this.jpgStreams.clear();
        this.tgaStreams.clear();
        this.ddsStreams.clear();
        this.allStreams.clear();
    }

    public static class NamedInputStream {
        final String fullPath;
        final String basePath;
        final InputStream stream;

        public NamedInputStream(String string, String string2, InputStream inputStream) {
            this.fullPath = string;
            this.basePath = string2;
            this.stream = inputStream;
        }
    }
}

