/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PMVMatrix;
import java.nio.FloatBuffer;
import jogamp.common.os.PlatformPropsImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPMVMatrix01NEWT
extends UITestCase {
    static final float epsilon = 1.0E-5f;
    static FloatBuffer matrix2x3R = FloatBuffer.wrap(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f});
    static FloatBuffer matrix2x3C = FloatBuffer.wrap(new float[]{1.0f, 4.0f, 2.0f, 5.0f, 3.0f, 6.0f});
    static FloatBuffer matrix3x2R = FloatBuffer.wrap(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f});
    static FloatBuffer matrix3x2C = FloatBuffer.wrap(new float[]{1.0f, 3.0f, 5.0f, 2.0f, 4.0f, 6.0f});
    static Matrix4f translated123R = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    static Matrix4f translated123C = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 2.0f, 3.0f, 1.0f});
    static Matrix4f translated123I = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, -2.0f, -3.0f, 1.0f});
    static Matrix4f translated123IT = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, -2.0f, 0.0f, 0.0f, 1.0f, -3.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    static DrawableContext dc;

    @Test
    public void test00MatrixToString() {
        String string = translated123C.toString(null, null, "%10.5f").toString();
        String string2 = translated123R.toString(null, null, "%10.5f").toString();
        System.err.println("FLU-C-O 4x4: ");
        System.err.println(string);
        System.err.println();
        System.err.println("FLU-R-O 4x4: ");
        System.err.println(string2);
        System.err.println();
        String string3 = FloatUtil.matrixToString(null, null, "%10.5f", matrix2x3R, 0, 2, 3, true).toString();
        String string4 = FloatUtil.matrixToString(null, null, "%10.5f", matrix2x3C, 0, 2, 3, false).toString();
        System.err.println("FLU-R-O 2x3: ");
        System.err.println(string3);
        System.err.println();
        System.err.println("FLU-C-O 2x3: ");
        System.err.println(string4);
        System.err.println();
        Assert.assertEquals(string4, string3);
        String string5 = FloatUtil.matrixToString(null, null, "%10.5f", matrix3x2R, 0, 3, 2, true).toString();
        String string6 = FloatUtil.matrixToString(null, null, "%10.5f", matrix3x2C, 0, 3, 2, false).toString();
        System.err.println("FLU-R-O 3x2: ");
        System.err.println(string5);
        System.err.println();
        System.err.println("FLU-C-O 3x2: ");
        System.err.println(string6);
        System.err.println();
        Assert.assertEquals(string6, string5);
    }

    @Test
    public void test01aTraditionalAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix();
        System.err.println("test01a.P0: " + pMVMatrix.toString());
        Assert.assertEquals(0L, pMVMatrix.getReqBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        Matrix4f matrix4f = pMVMatrix.getP();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue(0 != pMVMatrix.getModifiedBits(true));
        Assert.assertTrue(0 == pMVMatrix.getModifiedBits(false));
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue("Modified bits zero", 0 != pMVMatrix.getModifiedBits(true));
        Assert.assertTrue("Dirty bits clean, " + pMVMatrix.toString(), 0 != pMVMatrix.getDirtyBits());
        System.err.println("test01a.P1: " + pMVMatrix.toString());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        Assert.assertEquals("Update has been perfomed, but non requested", false, pMVMatrix.update());
        Matrix4f matrix4f2 = pMVMatrix.getP();
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        Matrix4f matrix4f3 = pMVMatrix.getMv();
        MiscUtils.assertMatrix4fEquals("Mv not translated123, " + pMVMatrix.toString(), translated123C, matrix4f3, 1.0E-5f);
        IllegalArgumentException illegalArgumentException = null;
        try {
            pMVMatrix.getMvi();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        Assert.assertNotNull(illegalArgumentException);
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        Assert.assertNotNull(pMVMatrix.getFrustum());
        Assert.assertNotNull(pMVMatrix.getPMv());
        Assert.assertNotNull(pMVMatrix.getPMvi());
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue(0 != pMVMatrix.getModifiedBits(true));
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        System.err.println("test01a.PX: " + pMVMatrix.toString());
    }

    @Test
    public void test01bTraditionalAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix(6);
        System.err.println("test01b.P0: " + pMVMatrix.toString());
        Assert.assertEquals(6L, pMVMatrix.getReqBits());
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(true, pMVMatrix.isReqDirty());
        Assert.assertEquals(62L, pMVMatrix.getDirtyBits());
        Assert.assertTrue("Dirty bits clean, " + pMVMatrix.toString(), 0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString(), 62L, pMVMatrix.getDirtyBits());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        Matrix4f matrix4f = pMVMatrix.getP();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue("Modified bits zero", 0 != pMVMatrix.getModifiedBits(true));
        Assert.assertTrue("Dirty bits clean, " + pMVMatrix.toString(), 0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString(), 62L, pMVMatrix.getDirtyBits());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue("Modified bits zero", 0 != pMVMatrix.getModifiedBits(true));
        Assert.assertTrue("Dirty bits clean, " + pMVMatrix.toString(), 0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString(), 62L, pMVMatrix.getDirtyBits());
        System.err.println("test01b.P1: " + pMVMatrix.toString());
        Assert.assertEquals(62L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(true, pMVMatrix.isReqDirty());
        Assert.assertEquals(true, pMVMatrix.update());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertNotNull(pMVMatrix.getFrustum());
        Assert.assertNotNull(pMVMatrix.getPMv());
        Assert.assertNotNull(pMVMatrix.getPMvi());
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Matrix4f matrix4f2 = pMVMatrix.getP();
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        Matrix4f matrix4f3 = pMVMatrix.getMv();
        MiscUtils.assertMatrix4fEquals("Mv not translated123, " + pMVMatrix.toString(), translated123C, matrix4f3, 1.0E-5f);
        Matrix4f matrix4f4 = pMVMatrix.getMvi();
        MiscUtils.assertMatrix4fEquals("Mvi not translated123, " + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertNotNull(pMVMatrix.getFrustum());
        Assert.assertNotNull(pMVMatrix.getPMv());
        Assert.assertNotNull(pMVMatrix.getPMvi());
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Matrix4f matrix4f5 = pMVMatrix.getMvit();
        MiscUtils.assertMatrix4fEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue("Modified bits zero", 0 != pMVMatrix.getModifiedBits(true));
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(true, pMVMatrix.isReqDirty());
        Assert.assertEquals(62L, pMVMatrix.getDirtyBits());
        System.err.println("test01b.P2: " + pMVMatrix.toString());
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mv not identity, " + pMVMatrix.toString(), matrix4f, matrix4f3, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvi already identity w/o update, " + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvit already identity w/o update, " + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvi not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
        Assert.assertEquals(true, pMVMatrix.update());
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        MiscUtils.assertMatrix4fEquals("Mvi not identity after update, " + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not identity after update, " + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        Assert.assertNotNull(pMVMatrix.getFrustum());
        Assert.assertNotNull(pMVMatrix.getPMv());
        Assert.assertNotNull(pMVMatrix.getPMvi());
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        System.err.println("test01b.PX: " + pMVMatrix.toString());
    }

    @Test
    public void test02MviUpdateShaderAccess() {
        PMVMatrix pMVMatrix = new PMVMatrix(6);
        Assert.assertEquals(6L, pMVMatrix.getReqBits());
        Assert.assertTrue(0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals(true, pMVMatrix.isReqDirty());
        Assert.assertEquals(62L, pMVMatrix.getDirtyBits());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        Matrix4f matrix4f = pMVMatrix.getP();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        Assert.assertTrue("Modified bits zero", 0 != pMVMatrix.getModifiedBits(true));
        Assert.assertEquals(62L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(true, pMVMatrix.isReqDirty());
        Assert.assertEquals(true, pMVMatrix.update());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertNotNull(pMVMatrix.getFrustum());
        Assert.assertNotNull(pMVMatrix.getPMv());
        Assert.assertNotNull(pMVMatrix.getPMvi());
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Matrix4f matrix4f2 = pMVMatrix.getP();
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        Matrix4f matrix4f3 = pMVMatrix.getMv();
        MiscUtils.assertMatrix4fEquals("Mv not identity, " + pMVMatrix.toString(), matrix4f, matrix4f3, 1.0E-5f);
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Matrix4f matrix4f4 = pMVMatrix.getMvi();
        MiscUtils.assertMatrix4fEquals("Mvi not identity, " + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Matrix4f matrix4f5 = pMVMatrix.getMvit();
        MiscUtils.assertMatrix4fEquals("Mvi not identity, " + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        pMVMatrix.glTranslatef(1.0f, 2.0f, 3.0f);
        Assert.assertTrue("Modified bits zero", 0 != pMVMatrix.getModifiedBits(true));
        Assert.assertTrue("Dirty bits clean, " + pMVMatrix.toString(), 0 != pMVMatrix.getDirtyBits());
        Assert.assertEquals("Remaining dirty bits not Mvi|Mvit|Frustum, " + pMVMatrix.toString(), 62L, pMVMatrix.getDirtyBits());
        MiscUtils.assertMatrix4fEquals("P not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), matrix4f, matrix4f2, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mv not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123C, matrix4f3, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvi already translated123 w/o update, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fNotEqual("Mvit already translated123 w/o update, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvi not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), matrix4f, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not identity, " + pMVMatrix.toString() + pMVMatrix.toString(), matrix4f, matrix4f5, 1.0E-5f);
        Assert.assertEquals(62L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(true, pMVMatrix.isReqDirty());
        Assert.assertEquals(true, pMVMatrix.update());
        Assert.assertEquals(56L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        Assert.assertNotNull(pMVMatrix.getFrustum());
        Assert.assertNotNull(pMVMatrix.getPMv());
        Assert.assertNotNull(pMVMatrix.getPMvi());
        Assert.assertEquals(0L, pMVMatrix.getDirtyBits());
        Assert.assertEquals(false, pMVMatrix.isReqDirty());
        MiscUtils.assertMatrix4fEquals("Mvi not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123I, matrix4f4, 1.0E-5f);
        MiscUtils.assertMatrix4fEquals("Mvit not translated123, " + pMVMatrix.toString() + pMVMatrix.toString(), translated123IT, matrix4f5, 1.0E-5f);
    }

    @Test
    public void test10MvTranslate() {
        Matrix4f matrix4f = new Matrix4f();
        Object object = new PMVMatrix();
        ((PMVMatrix)object).glMatrixMode(5889);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glMatrixMode(5888);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glTranslatef(5.0f, 6.0f, 7.0f);
        matrix4f.load(((PMVMatrix4f)object).getMv());
        object = FloatBuffer.allocate(16);
        Object object2 = TestPMVMatrix01NEWT.dc.glc.getGL().getGL2ES1();
        object2.glMatrixMode(5889);
        object2.glLoadIdentity();
        object2.glMatrixMode(5888);
        object2.glLoadIdentity();
        object2.glTranslatef(5.0f, 6.0f, 7.0f);
        object2.glGetFloatv(2982, (FloatBuffer)object);
        object2 = new Matrix4f((FloatBuffer)object);
        MiscUtils.assertMatrix4fEquals("Arrays not equal, expected" + PlatformPropsImpl.NEWLINE + object2 + ", actual" + PlatformPropsImpl.NEWLINE + matrix4f, (Matrix4f)object2, matrix4f, 1.0E-5f);
    }

    @Test
    public void test11MvTranslateRotate() {
        Matrix4f matrix4f = new Matrix4f();
        Object object = new PMVMatrix();
        ((PMVMatrix)object).glMatrixMode(5889);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glMatrixMode(5888);
        ((PMVMatrix)object).glLoadIdentity();
        ((PMVMatrix)object).glTranslatef(5.0f, 6.0f, 7.0f);
        ((PMVMatrix)object).glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        matrix4f.load(((PMVMatrix4f)object).getMv());
        object = FloatBuffer.allocate(16);
        Object object2 = TestPMVMatrix01NEWT.dc.glc.getGL().getGL2ES1();
        object2.glMatrixMode(5889);
        object2.glLoadIdentity();
        object2.glMatrixMode(5888);
        object2.glLoadIdentity();
        object2.glTranslatef(5.0f, 6.0f, 7.0f);
        object2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        object2.glGetFloatv(2982, (FloatBuffer)object);
        object2 = new Matrix4f((FloatBuffer)object);
        MiscUtils.assertMatrix4fEquals("Arrays not equal, expected" + PlatformPropsImpl.NEWLINE + object2 + ", actual" + PlatformPropsImpl.NEWLINE + matrix4f, (Matrix4f)object2, matrix4f, 1.0E-5f);
    }

    @BeforeClass
    public static void setup() throws Throwable {
        try {
            dc = TestPMVMatrix01NEWT.createOffscreenDrawableAndCurrentFFPContext();
        }
        catch (Throwable throwable) {
            TestPMVMatrix01NEWT.setTestSupported(false);
            throw throwable;
        }
    }

    @AfterClass
    public static void cleanup() {
        TestPMVMatrix01NEWT.destroyDrawableContext(dc);
    }

    private static DrawableContext createOffscreenDrawableAndCurrentFFPContext() throws Throwable {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
        GLDrawable gLDrawable = gLDrawableFactory.createOffscreenDrawable(null, gLCapabilities, null, 64, 64);
        gLDrawable.setRealized(true);
        GLContext gLContext = null;
        try {
            gLContext = gLDrawable.createContext(null);
            Assert.assertTrue("Context could not be made current", 0 < gLContext.makeCurrent());
            return new DrawableContext(gLDrawable, gLContext);
        }
        catch (Throwable throwable) {
            if (null != gLContext) {
                gLContext.destroy();
            }
            gLDrawable.setRealized(false);
            throw throwable;
        }
    }

    private static void destroyDrawableContext(DrawableContext drawableContext) {
        if (null != drawableContext.glc) {
            drawableContext.glc.destroy();
            drawableContext.glc = null;
        }
        if (null != drawableContext.d) {
            drawableContext.d.setRealized(false);
            drawableContext.d = null;
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestPMVMatrix01NEWT.class.getName());
    }

    static class DrawableContext {
        GLDrawable d;
        GLContext glc;

        DrawableContext(GLDrawable gLDrawable, GLContext gLContext) {
            this.d = gLDrawable;
            this.glc = gLContext;
        }
    }
}

