/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.math;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.VectorUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestQuaternion01NOUI
extends JunitTracer {
    static final boolean DEBUG = false;
    static final Quaternion QUAT_IDENT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    static final Vec3f ZERO = new Vec3f(0.0f, 0.0f, 0.0f);
    static final Vec3f ONE = new Vec3f(1.0f, 1.0f, 1.0f);
    static final Vec3f NEG_ONE = new Vec3f(-1.0f, -1.0f, -1.0f);
    static final Vec3f UNIT_X = new Vec3f(1.0f, 0.0f, 0.0f);
    static final Vec3f UNIT_Y = new Vec3f(0.0f, 1.0f, 0.0f);
    static final Vec3f UNIT_Z = new Vec3f(0.0f, 0.0f, 1.0f);
    static final Vec3f NEG_UNIT_X = new Vec3f(-1.0f, 0.0f, 0.0f);
    static final Vec3f NEG_UNIT_Y = new Vec3f(0.0f, -1.0f, 0.0f);
    static final Vec3f NEG_UNIT_Z = new Vec3f(0.0f, 0.0f, -1.0f);
    static final Vec4f NEG_ONE_v4 = new Vec4f(-1.0f, -1.0f, -1.0f, 0.0f);
    static final Vec4f ONE_v4 = new Vec4f(1.0f, 1.0f, 1.0f, 0.0f);
    static final float MACH_EPSILON = 1.1920929E-7f;

    @Test
    public void test01Normalize() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion).normalize();
        Assert.assertEquals(0.0f, Math.abs(1.0f - quaternion2.magnitude()), 1.1920929E-7f);
    }

    @Test
    public void test02RotateZeroVector() {
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f = new Vec3f(0.0f, 0.0f, 0.0f);
        Vec3f vec3f2 = quaternion.rotateVector(vec3f, new Vec3f());
        Assert.assertEquals(vec3f, vec3f2);
    }

    @Test
    public void test03InvertAndConj() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion).invert();
        Assert.assertEquals(quaternion, quaternion2.invert());
        quaternion = new Quaternion(-1.0f, -2.0f, -3.0f, 4.0f);
        quaternion2 = new Quaternion(1.0f, 2.0f, 3.0f, 4.0f).conjugate();
        Assert.assertEquals(quaternion, quaternion2);
    }

    @Test
    public void test04Dot() {
        Quaternion quaternion = new Quaternion(7.0f, 2.0f, 5.0f, -1.0f);
        Assert.assertTrue(35.0f == quaternion.dot(3.0f, 1.0f, 2.0f, -2.0f));
        Assert.assertTrue(-11.0f == quaternion.dot(new Quaternion(-1.0f, 1.0f, -1.0f, 1.0f)));
    }

    @Test
    public void test10AngleAxis() {
        Vec3f vec3f = new Vec3f();
        Quaternion quaternion = new Quaternion().setFromAngleAxis(1.5707964f, new Vec3f(2.0f, 0.0f, 0.0f), vec3f);
        Quaternion quaternion2 = new Quaternion().setFromAngleNormalAxis(1.5707964f, new Vec3f(1.0f, 0.0f, 0.0f));
        Assert.assertEquals(quaternion2, quaternion);
        Assert.assertEquals(0.0f, 1.0f - quaternion2.magnitude(), 1.1920929E-7f);
        Assert.assertTrue(1.0f - quaternion.magnitude() <= 1.1920929E-7f);
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        quaternion.rotateVector(Vec3f.ONE, vec3f2);
        quaternion2.rotateVector(Vec3f.ONE, vec3f3);
        Assert.assertEquals(vec3f2, vec3f3);
        Assert.assertEquals(0.0f, Math.abs(vec3f2.dist(vec3f3)), 1.1920929E-7f);
        quaternion.rotateVector(Vec3f.UNIT_Z, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(Vec3f.UNIT_Y_NEG.dist(vec3f2)), 1.1920929E-7f);
        quaternion2.setFromAngleAxis(1.5707964f, ZERO, vec3f);
        Assert.assertEquals(QUAT_IDENT, quaternion2);
        float f = quaternion.toAngleAxis(vec3f2);
        quaternion2.setFromAngleAxis(f, vec3f2, vec3f);
        Assert.assertEquals(quaternion, quaternion2);
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        f = quaternion.toAngleAxis(vec3f2);
        Assert.assertTrue(0.0f == f);
        Assert.assertEquals(UNIT_X, vec3f2);
    }

    @Test
    public void test11FromVectorToVector() {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromVectors(UNIT_Z, UNIT_X, vec3f, vec3f2);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromNormalVectors(UNIT_Z, UNIT_X, vec3f);
        Assert.assertEquals(quaternion, quaternion2);
        quaternion2.setFromAngleAxis(1.5707964f, UNIT_Y, vec3f);
        Assert.assertEquals(quaternion2, quaternion);
        quaternion.setFromVectors(UNIT_Z, NEG_UNIT_Z, vec3f, vec3f2);
        quaternion.rotateVector(UNIT_Z, vec3f3);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_Z.dist(vec3f3)), 1.0E-6f);
        quaternion.setFromVectors(UNIT_X, NEG_UNIT_X, vec3f, vec3f2);
        quaternion.rotateVector(UNIT_X, vec3f3);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_X.dist(vec3f3)), 1.0E-6f);
        quaternion.setFromVectors(UNIT_Y, NEG_UNIT_Y, vec3f, vec3f2);
        quaternion.rotateVector(UNIT_Y, vec3f3);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_Y.dist(vec3f3)), 1.0E-6f);
        quaternion.setFromVectors(ONE, NEG_ONE, vec3f, vec3f2);
        quaternion.rotateVector(ONE, vec3f3);
        Assert.assertEquals(0.0f, Math.abs(NEG_ONE.dist(vec3f3)), 1.0E-6f);
        quaternion.setFromVectors(ZERO, ZERO, vec3f, vec3f2);
        Assert.assertEquals(QUAT_IDENT, quaternion);
    }

    @Test
    public void test12FromAndToEulerAngles() {
        Quaternion quaternion = new Quaternion();
        Vec3f vec3f = new Vec3f(0.0f, 1.5707964f, 0.0f);
        quaternion.setFromEuler(vec3f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        Vec3f vec3f2 = quaternion.toEuler(new Vec3f());
        Assert.assertEquals(vec3f, vec3f2);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromEuler(vec3f2);
        Assert.assertEquals(quaternion, quaternion2);
        Vec3f vec3f3 = new Vec3f(0.0f, 0.0f, -1.5707964f);
        quaternion.setFromEuler(vec3f3);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        Vec3f vec3f4 = quaternion.toEuler(new Vec3f());
        Assert.assertEquals(vec3f3, vec3f4);
        quaternion2.setFromEuler(vec3f4);
        Assert.assertEquals(quaternion, quaternion2);
        Vec3f vec3f5 = new Vec3f(1.5707964f, 0.0f, 0.0f);
        quaternion.setFromEuler(vec3f5);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        Vec3f vec3f6 = quaternion.toEuler(new Vec3f());
        Assert.assertEquals(vec3f5, vec3f6);
        quaternion2.setFromEuler(vec3f6);
        Assert.assertEquals(quaternion, quaternion2);
    }

    @Test
    public void test13FromEulerAnglesAndRotateVector() {
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(0.0f, 1.5707964f, 0.0f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        Vec3f vec3f = quaternion.rotateVector(UNIT_X, new Vec3f());
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_Z.dist(vec3f)), 1.1920929E-7f);
        quaternion.setFromEuler(0.0f, 0.0f, -1.5707964f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_Y.dist(vec3f)), 1.1920929E-7f);
        quaternion.setFromEuler(1.5707964f, 0.0f, 0.0f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals(0.0f, Math.abs(UNIT_Z.dist(vec3f)), 1.1920929E-7f);
    }

    @Test
    public void test14Matrix() {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec4f vec4f = new Vec4f();
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        matrix4f.loadIdentity();
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        float f = 1.5707964f;
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        matrix4f.load(fArray);
        Object object = new float[16];
        matrix4f.get((float[])object);
        Assert.assertArrayEquals(fArray, (float[])object, 1.1920929E-7f);
        quaternion.setFromEuler(f, 0.0f, 0.0f);
        object = new float[16];
        quaternion.toMatrix((float[])object);
        Assert.assertArrayEquals(fArray, (float[])object, 1.1920929E-7f);
        object = new float[16];
        quaternion.toMatrix((float[])object);
        Assert.assertArrayEquals(fArray, (float[])object, 1.1920929E-7f);
        matrix4f2.load((float[])object);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals(0.0f, Math.abs(UNIT_Z.dist(vec3f)), 1.0E-6f);
        matrix4f.getRotation(quaternion);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals(0.0f, Math.abs(UNIT_Z.dist(vec3f)), 1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(NEG_ONE, vec3f);
        object = new float[3];
        vec3f.get((float[])object);
        Object object2 = new float[16];
        quaternion.toMatrix((float[])object2);
        Object object3 = new float[3];
        NEG_ONE.get((float[])object3);
        Object object4 = new float[3];
        FloatUtil.multMatrixVec3((float[])object2, (float[])object3, object4);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3((float[])object, object4)), 1.0E-6f);
        Assert.assertArrayEquals((float[])object, object4, 1.1920929E-7f);
        matrix4f2.mulVec3f(NEG_ONE, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        Assert.assertEquals(vec3f, vec3f2);
        float[] fArray2 = new float[3];
        vec3f2.get(fArray2);
        Assert.assertArrayEquals(object4, fArray2, 1.1920929E-7f);
        object = new float[4];
        vec3f.get((float[])object);
        object2 = new float[16];
        quaternion.toMatrix((float[])object2);
        object3 = new float[4];
        NEG_ONE_v4.get((float[])object3);
        object4 = new float[4];
        FloatUtil.multMatrixVec((float[])object2, (float[])object3, object4);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3((float[])object, object4)), 1.0E-6f);
        Assert.assertArrayEquals((float[])object, object4, 1.1920929E-7f);
        matrix4f2.mulVec4f(NEG_ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        Assert.assertEquals(vec3f, vec3f2);
        fArray2 = new float[4];
        vec4f.get(fArray2);
        Assert.assertArrayEquals(object4, fArray2, 1.1920929E-7f);
        f = (float)Math.PI;
        matrix4f.load(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        quaternion.setFromEuler(f, 0.0f, 0.0f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_Y.dist(vec3f)), 1.0E-6f);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_Y, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_Y.dist(vec3f)), 1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(ONE, vec3f);
        matrix4f2.mulVec4f(ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        f = (float)Math.PI;
        matrix4f.load(new float[]{FloatUtil.cos(f), 0.0f, -FloatUtil.sin(f), 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, FloatUtil.sin(f), 0.0f, FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        quaternion.setFromEuler(0.0f, f, 0.0f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_X.dist(vec3f)), 1.0E-6f);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_X.dist(vec3f)), 1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(NEG_ONE, vec3f);
        matrix4f2.mulVec4f(NEG_ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        f = (float)Math.PI;
        matrix4f.load(new float[]{FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        quaternion.setFromEuler(0.0f, 0.0f, f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_X.dist(vec3f)), 1.0E-6f);
        quaternion.setFromMat(matrix4f);
        quaternion.rotateVector(UNIT_X, vec3f);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_X.dist(vec3f)), 1.0E-6f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        quaternion.rotateVector(ONE, vec3f);
        matrix4f2.mulVec4f(ONE_v4, vec4f);
        vec3f2.set(vec4f);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        f = 0.7853982f;
        object = new Vec3f(FloatUtil.cos(f), FloatUtil.sin(f), 0.0f);
        object2 = new Vec3f(-FloatUtil.sin(f), FloatUtil.cos(f), 0.0f);
        object3 = new Vec3f(0.0f, 0.0f, 1.0f);
        object4 = new Vec3f();
        matrix4f.load(new float[]{FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        matrix4f.getColumn(0, (Vec3f)object4);
        Assert.assertEquals(object, object4);
        Assert.assertEquals(0.0f, Math.abs(((Vec3f)object).dist((Vec3f)object4)), 1.1920929E-7f);
        matrix4f.getColumn(1, (Vec3f)object4);
        Assert.assertEquals(object2, object4);
        Assert.assertEquals(0.0f, Math.abs(((Vec3f)object2).dist((Vec3f)object4)), 1.1920929E-7f);
        matrix4f.getColumn(2, (Vec3f)object4);
        Assert.assertEquals(object3, object4);
        Assert.assertEquals(0.0f, Math.abs(((Vec3f)object3).dist((Vec3f)object4)), 1.1920929E-7f);
    }

    @Test
    public void test15aAxesAndMatrix() {
        Vec3f vec3f = new Vec3f(0.0f, 1.5707964f, 0.0f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(vec3f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMat(matrix4f);
        quaternion2.toEuler(vec3f2);
        Assert.assertEquals(vec3f, vec3f2);
        Assert.assertEquals(quaternion2, quaternion);
        Vec3f vec3f3 = new Vec3f();
        quaternion2.toEuler(vec3f3);
        quaternion.setFromEuler(vec3f3);
        Assert.assertEquals(quaternion2, quaternion);
    }

    @Test
    public void test15bAxesAndMatrix() {
        Vec3f vec3f = new Vec3f(1.5707964f, 0.0f, 0.0f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(vec3f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMat(matrix4f);
        quaternion2.toEuler(vec3f2);
        Assert.assertEquals(vec3f, vec3f2);
        Assert.assertEquals(quaternion2, quaternion);
        Vec3f vec3f3 = new Vec3f();
        quaternion2.toEuler(vec3f3);
        quaternion.setFromEuler(vec3f3);
        Assert.assertEquals(quaternion2, quaternion);
    }

    @Test
    public void test15cAxesAndMatrix() {
        Vec3f vec3f = new Vec3f(0.7853982f, 1.5707964f, 0.0f);
        float[] fArray = new float[3];
        vec3f.get(fArray);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
        Matrix4f matrix4f2 = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(vec3f);
        quaternion.toMatrix(matrix4f2);
        Assert.assertEquals(matrix4f, matrix4f2);
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMat(matrix4f);
        quaternion2.toEuler(vec3f2);
        Object object = new float[3];
        vec3f2.get((float[])object);
        Assert.assertArrayEquals(fArray, object, 1.1920929E-7f);
        Assert.assertTrue(vec3f + " != " + vec3f2, vec3f.isEqual(vec3f2, 1.0E-6f));
        Assert.assertEquals(quaternion2, quaternion);
        object = new Vec3f();
        quaternion2.toEuler((Vec3f)object);
        quaternion.setFromEuler((Vec3f)object);
        Assert.assertEquals(quaternion2, quaternion);
    }

    @Test
    public void test20AddSubtract() {
        Quaternion quaternion = new Quaternion(1.0f, 2.0f, 3.0f, 4.0f);
        Quaternion quaternion2 = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion3 = new Quaternion(1.0f, 1.0f, 1.0f, 1.0f);
        Quaternion quaternion4 = new Quaternion();
        quaternion4.set(quaternion2);
        quaternion4.add(quaternion3);
        Assert.assertEquals(quaternion, quaternion4);
        quaternion2.set(0.0f, 1.0f, 2.0f, 3.0f);
        quaternion3.set(1.0f, 1.0f, 1.0f, 1.0f);
        quaternion4.set(quaternion2);
        quaternion4.subtract(quaternion3);
        Assert.assertEquals(new Quaternion(-1.0f, 0.0f, 1.0f, 2.0f), quaternion4);
    }

    @Test
    public void test21Multiply() {
        Quaternion quaternion = new Quaternion(0.5f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.set(quaternion);
        quaternion2.scale(2.0f);
        Assert.assertEquals(new Quaternion(1.0f, 2.0f, 4.0f, 6.0f), quaternion2);
        quaternion2.set(quaternion);
        quaternion2.scale(4.0f);
        Assert.assertEquals(new Quaternion(2.0f, 4.0f, 8.0f, 12.0f), quaternion2);
        quaternion.setFromAngleNormalAxis(0.7853982f, UNIT_Y);
        quaternion2.set(quaternion);
        quaternion2.mult(quaternion);
        Vec3f vec3f = new Vec3f();
        quaternion2.rotateVector(UNIT_Z, vec3f);
        Assert.assertTrue(Math.abs(UNIT_X.dist(vec3f)) <= 1.0E-6f);
        quaternion2.setFromAngleNormalAxis(1.5707964f, UNIT_Y);
        quaternion.mult(quaternion);
        quaternion.mult(quaternion2);
        quaternion.rotateVector(UNIT_Z, vec3f);
        Assert.assertTrue(Math.abs(NEG_UNIT_Z.dist(vec3f)) <= 1.0E-6f);
        quaternion2.setFromEuler(0.0f, 1.5707964f, 0.0f);
        quaternion.mult(quaternion2);
        quaternion.rotateVector(UNIT_Z, vec3f);
        Assert.assertTrue(Math.abs(NEG_UNIT_X.dist(vec3f)) <= 1.0E-6f);
    }

    @Test
    public void test22InvertMultNormalAndConj() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion);
        Quaternion quaternion3 = new Quaternion(quaternion);
        quaternion2.invert();
        quaternion3.mult(quaternion2);
        Assert.assertEquals(QUAT_IDENT, quaternion3);
        quaternion2.invert();
        Assert.assertEquals(quaternion, quaternion2);
        quaternion.setFromAngleNormalAxis(0.7853982f, UNIT_Y);
        quaternion2.set(quaternion);
        quaternion2.invert();
        quaternion3.set(quaternion);
        quaternion3.mult(quaternion2);
        Assert.assertEquals(QUAT_IDENT, quaternion3);
        quaternion2.invert();
        Assert.assertEquals(quaternion, quaternion2);
        quaternion.set(-1.0f, -2.0f, -3.0f, 4.0f);
        quaternion2.set(1.0f, 2.0f, 3.0f, 4.0f);
        quaternion3.set(quaternion2);
        quaternion3.conjugate();
        Assert.assertEquals(quaternion, quaternion3);
    }

    @Test
    public void test23RotationOrder() {
        Object object = new Quaternion().setFromEuler((float)(-Math.PI), 0.0f, 0.0f);
        Object object2 = new Quaternion().rotateByAngleX((float)(-Math.PI));
        Assert.assertEquals(object, object2);
        object = new Quaternion().setFromEuler(1.5707964f, 0.0f, 0.0f);
        object2 = new Quaternion().rotateByAngleX(1.5707964f);
        Assert.assertEquals(object, object2);
        object = new Quaternion().setFromEuler(1.5707964f, 0.7853982f, 0.0f);
        object2 = new Quaternion().rotateByAngleY(0.7853982f).rotateByAngleX(1.5707964f);
        Assert.assertEquals(object, object2);
        object = new Quaternion().setFromEuler((float)Math.PI, 0.7853982f, 1.5707964f);
        object2 = new Quaternion().rotateByAngleY(0.7853982f).rotateByAngleZ(1.5707964f).rotateByAngleX((float)Math.PI);
        Assert.assertEquals(object, object2);
        object = new Vec3f();
        object2 = new Vec3f();
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(1.5707964f, 0.7853982f, (float)Math.PI);
        ((Vec3f)object2).set(1.0f, 1.0f, 1.0f);
        quaternion.rotateVector((Vec3f)object2, (Vec3f)object2);
        ((Vec3f)object).set(1.0f, 1.0f, 1.0f);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.rotateByAngleY(0.7853982f).rotateByAngleZ((float)Math.PI).rotateByAngleX(1.5707964f);
        quaternion.rotateVector((Vec3f)object, (Vec3f)object);
        Assert.assertEquals(0.0f, ((Vec3f)object).dist((Vec3f)object2), 1.1920929E-7f);
        Assert.assertEquals(object, object2);
        ((Vec3f)object).set(1.0f, 1.0f, 1.0f);
        ((Vec3f)object2).set(1.0f, 1.0f, 1.0f);
        quaternion2.setIdentity().rotateByAngleX(0.7853982f).rotateVector((Vec3f)object, (Vec3f)object);
        quaternion2.setIdentity().rotateByAngleNormalAxis(0.7853982f, 1.0f, 0.0f, 0.0f).rotateVector((Vec3f)object2, (Vec3f)object2);
        Assert.assertEquals(0.0f, ((Vec3f)object).dist((Vec3f)object2), 1.1920929E-7f);
        Assert.assertEquals(object, object2);
        ((Vec3f)object).set(1.0f, 1.0f, 1.0f);
        ((Vec3f)object2).set(1.0f, 1.0f, 1.0f);
        quaternion2.setIdentity().rotateByAngleY(0.7853982f).rotateVector((Vec3f)object, (Vec3f)object);
        quaternion2.setIdentity().rotateByAngleNormalAxis(0.7853982f, 0.0f, 1.0f, 0.0f).rotateVector((Vec3f)object2, (Vec3f)object2);
        Assert.assertEquals(0.0f, ((Vec3f)object).dist((Vec3f)object2), 1.1920929E-7f);
        Assert.assertEquals(object, object2);
        ((Vec3f)object).set(1.0f, 1.0f, 1.0f);
        ((Vec3f)object2).set(1.0f, 1.0f, 1.0f);
        quaternion2.setIdentity().rotateByAngleZ(0.7853982f).rotateVector((Vec3f)object, (Vec3f)object);
        quaternion2.setIdentity().rotateByAngleNormalAxis(0.7853982f, 0.0f, 0.0f, 1.0f).rotateVector((Vec3f)object2, (Vec3f)object2);
        Assert.assertEquals(0.0f, ((Vec3f)object).dist((Vec3f)object2), 1.1920929E-7f);
        Assert.assertEquals(object, object2);
        quaternion.set(quaternion2);
        quaternion2.rotateByAngleNormalAxis(0.0f, 0.0f, 0.0f, 0.0f);
        Assert.assertEquals(quaternion, quaternion2);
    }

    @Test
    public void test24Axes() {
        Quaternion quaternion = new Quaternion().rotateByAngleX(0.7853982f).rotateByAngleY(1.5707964f);
        Matrix4f matrix4f = new Matrix4f();
        quaternion.toMatrix(matrix4f);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        matrix4f.getColumn(0, vec3f);
        matrix4f.getColumn(1, vec3f2);
        matrix4f.getColumn(2, vec3f3);
        Quaternion quaternion2 = new Quaternion().setFromAxes(vec3f, vec3f2, vec3f3);
        Assert.assertEquals(quaternion, quaternion2);
        Quaternion quaternion3 = new Quaternion().setFromMat(matrix4f);
        Assert.assertEquals(quaternion3, quaternion2);
        quaternion2.toAxes(vec3f, vec3f2, vec3f3, matrix4f);
        quaternion3.setFromAxes(vec3f, vec3f2, vec3f3);
        Assert.assertEquals(quaternion, quaternion3);
        Assert.assertEquals(quaternion2, quaternion3);
    }

    @Test
    public void test25Slerp() {
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion().rotateByAngleY(1.5707964f);
        Vec3f vec3f = new Vec3f(FloatUtil.sin(0.7853982f), 0.0f, FloatUtil.sin(0.7853982f));
        Vec3f vec3f2 = new Vec3f();
        Quaternion quaternion3 = new Quaternion();
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(UNIT_Z, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        if (!vec3f.equals(vec3f2)) {
            System.err.println("Deviance: " + vec3f + ", " + vec3f2 + ": " + vec3f.minus(vec3f2) + ", dist " + vec3f.dist(vec3f2));
        }
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 1.0f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(NEG_UNIT_X.dist(vec3f2)), 1.0E-6f);
        Assert.assertEquals(NEG_UNIT_X, vec3f2);
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(UNIT_Y.dist(vec3f2)), 1.0E-6f);
        if (!UNIT_Y.equals(vec3f2)) {
            System.err.println("Deviance: " + UNIT_Y + ", " + vec3f2 + ": " + UNIT_Y.minus(vec3f2) + ", dist " + UNIT_Y.dist(vec3f2));
        }
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 0.0f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(UNIT_X.dist(vec3f2)), 1.0E-6f);
        Assert.assertEquals(UNIT_X, vec3f2);
        quaternion2.setIdentity();
        quaternion3.setSlerp(quaternion, quaternion2, 0.25f);
        quaternion3.rotateVector(UNIT_X, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(UNIT_X.dist(vec3f2)), 1.0E-6f);
        Assert.assertEquals(UNIT_X, vec3f2);
        vec3f.set(0.0f, -FloatUtil.sin(0.7853982f), FloatUtil.sin(0.7853982f));
        quaternion.setIdentity().rotateByAngleX((float)(-Math.PI));
        quaternion2.setIdentity().rotateByAngleX(1.5707964f);
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(UNIT_Y, vec3f2);
        Assert.assertEquals(0.0f, Math.abs(vec3f.dist(vec3f2)), 1.0E-6f);
        if (!vec3f.equals(vec3f2)) {
            System.err.println("Deviance: " + vec3f + ", " + vec3f2 + ": " + vec3f.minus(vec3f2) + ", dist " + vec3f.dist(vec3f2));
        }
    }

    @Test
    public void test26LookAt() {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = new Vec3f();
        Vec3f vec3f4 = new Vec3f();
        Vec3f vec3f5 = new Vec3f();
        vec3f.set(NEG_UNIT_X);
        Quaternion quaternion = new Quaternion().setLookAt(vec3f, UNIT_Y, vec3f2, vec3f3, vec3f4);
        Assert.assertEquals(0.0f, vec3f.dist(quaternion.rotateVector(UNIT_Z, vec3f5)), 1.0E-6f);
        Assert.assertEquals(vec3f, vec3f5);
        vec3f.set(ONE).normalize();
        quaternion.setLookAt(vec3f, UNIT_Y, vec3f2, vec3f3, vec3f4);
        quaternion.rotateVector(UNIT_Z, vec3f5);
        Assert.assertEquals(0.0f, vec3f.dist(vec3f5), 1.0E-6f);
        Assert.assertEquals(vec3f, vec3f5);
        vec3f.set(-1.0f, 2.0f, -1.0f).normalize();
        quaternion.setLookAt(vec3f, UNIT_Y, vec3f2, vec3f3, vec3f4);
        quaternion.rotateVector(UNIT_Z, vec3f5);
        Assert.assertEquals(0.0f, vec3f.dist(vec3f5), 1.0E-6f);
        if (!vec3f.equals(vec3f5)) {
            System.err.println("Deviance: " + vec3f + ", " + vec3f5 + ": " + vec3f.minus(vec3f5) + ", dist " + vec3f.dist(vec3f5));
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestQuaternion01NOUI.class.getName());
    }
}

