/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestDisplayLifecycle01NEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static final int width = 500;
    static final int height = 500;
    static final int xy_pos = 100;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getDefault();
        caps = new GLCapabilities(glp);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2) throws InterruptedException {
        GLWindow gLWindow;
        Object object;
        Assert.assertNotNull(gLCapabilities);
        if (null != screen) {
            object = NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull(object);
            gLWindow = GLWindow.create((Window)object);
        } else {
            gLWindow = GLWindow.create(gLCapabilities);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        object = new GearsES2();
        TestDisplayLifecycle01NEWT.setDemoFields((GLEventListener)object, gLWindow);
        gLWindow.addGLEventListener((GLEventListener)object);
        gLWindow.addWindowListener(new TraceWindowAdapter());
        gLWindow.setSize(n, n2);
        return gLWindow;
    }

    private void testDisplayCreate01(Display display, Screen screen) throws InterruptedException {
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        GLWindow gLWindow = TestDisplayLifecycle01NEWT.createWindow(screen, caps, 500, 500);
        gLWindow.setPosition(100, 100);
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertNotNull(gLWindow.getScreen());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertTrue(NewtTestUtil.hasPositionMax2xInsetsOr64Pix(gLWindow, 100, 100));
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        Assert.assertTrue(NewtTestUtil.hasPositionMax2xInsetsOr64Pix(gLWindow, 100, 100));
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.setVisible(false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        NewtTestUtil.hasPositionMax2xInsetsOr64Pix(gLWindow, 100, 100);
        gLWindow.resetFPSCounter();
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        Assert.assertTrue(NewtTestUtil.hasPositionMax2xInsetsOr64Pix(gLWindow, 100, 100));
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 2L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.destroy();
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.resetFPSCounter();
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.display();
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 2: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.destroy();
        Display.dumpDisplayList("Post destroy(true)");
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        EDTUtil eDTUtil = display.getEDTUtil();
        Assert.assertNotNull(eDTUtil);
        Assert.assertEquals(false, eDTUtil.isRunning());
        eDTUtil.start();
        Assert.assertEquals(true, eDTUtil.isRunning());
        eDTUtil.invoke(true, null);
        Assert.assertEquals(true, eDTUtil.isRunning());
        eDTUtil.invokeStop(true, null);
        eDTUtil.waitUntilStopped();
        Assert.assertEquals(false, eDTUtil.isRunning());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertNotNull(gLWindow.getScreen());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
    }

    @Test
    public void testDisplayCreate01_AutoDestroyLifecycle() throws InterruptedException {
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, 0);
        System.err.println("Pass - 1");
        this.testDisplayCreate01(display, screen);
        System.err.println("Pass - 2");
        this.testDisplayCreate01(display, screen);
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestDisplayLifecycle01NEWT.atoi(stringArray[++i]);
        }
        System.err.println("durationPerTest: " + durationPerTest);
        String string = TestDisplayLifecycle01NEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 100L;
    }
}

