/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.newt.WindowEventCom1;
import com.jogamp.opengl.test.junit.newt.WindowEventCom2;
import com.jogamp.opengl.test.junit.newt.WindowEventCom3;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestListenerCom01AWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static boolean verbose;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
    }

    @Test
    public void testListenerStringPassingAndOrder() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(new GLCapabilities(null));
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("NEWT - CHILD");
        System.out.println("durationPerTest " + durationPerTest);
        GearsES2 gearsES2 = new GearsES2();
        TestListenerCom01AWT.setDemoFields(gearsES2, gLWindow, false);
        gLWindow.addGLEventListener(gearsES2);
        WindowEventCom1 windowEventCom1 = new WindowEventCom1();
        WindowEventCom2 windowEventCom2 = new WindowEventCom2();
        WindowEventCom3 windowEventCom3 = new WindowEventCom3();
        gLWindow.addWindowListener(0, windowEventCom3);
        gLWindow.addWindowListener(0, windowEventCom2);
        gLWindow.addWindowListener(0, windowEventCom1);
        Assert.assertEquals(windowEventCom1, gLWindow.getWindowListener(0));
        Assert.assertEquals(windowEventCom2, gLWindow.getWindowListener(1));
        Assert.assertEquals(windowEventCom3, gLWindow.getWindowListener(2));
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame("AWT Parent Frame");
        frame.add(newtCanvasAWT);
        frame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
            frame.setSize(width += 10, height += 10);
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        verbose = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestListenerCom01AWT.atoi(stringArray[++i]);
        }
        String string = TestListenerCom01AWT.class.getName();
        JUnitTestRunner.main((String[])new String[]{string, "filtertrace=true", "haltOnError=false", "haltOnFailure=false", "showoutput=true", "outputtoformatters=true", "logfailedtests=true", "logtestlistenerevents=true", "formatter=org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter", "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter,TEST-" + string + ".xml"});
    }

    static {
        durationPerTest = 500L;
        verbose = false;
    }
}

