/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.graph.font.FontScale;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowHolder;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.opengl.util.NEWTDemoListener;

public class NewtReparentingKeyAdapter
extends NEWTDemoListener {
    final NativeWindowHolder winHolder;

    public NewtReparentingKeyAdapter(NativeWindowHolder nativeWindowHolder, GLWindow gLWindow) {
        super(gLWindow);
        this.winHolder = nativeWindowHolder;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isAutoRepeat() || keyEvent.isConsumed()) {
            return;
        }
        if (0 == keyEvent.getModifiers()) {
            short s = keyEvent.getKeySymbol();
            switch (s) {
                case 76: {
                    keyEvent.setConsumed(true);
                    Point point = this.winHolder.getNativeWindow().getLocationOnScreen(null);
                    Point point2 = this.glWindow.getLocationOnScreen(null);
                    this.printlnState("[location]", "Parent " + point + ", NEWT " + point2);
                    break;
                }
                case 82: {
                    keyEvent.setConsumed(true);
                    this.quitAdapterOff();
                    this.glWindow.invokeOnNewThread(null, false, new Runnable(){

                        @Override
                        public void run() {
                            Thread thread = NewtReparentingKeyAdapter.this.glWindow.setExclusiveContextThread(null);
                            if (NewtReparentingKeyAdapter.this.glWindow.getParent() == null) {
                                NewtReparentingKeyAdapter.this.printlnState("[reparent pre - glWin to HOME: child pos " + NewtReparentingKeyAdapter.this.winHolder.getNativeWindow().getX() + "/" + NewtReparentingKeyAdapter.this.winHolder.getNativeWindow().getY() + "]");
                                NewtReparentingKeyAdapter.this.glWindow.reparentWindow(NewtReparentingKeyAdapter.this.winHolder.getNativeWindow(), -1, -1, 0);
                            } else {
                                Point point = NewtReparentingKeyAdapter.this.winHolder.getNativeWindow().getLocationOnScreen(null);
                                Point point2 = NewtReparentingKeyAdapter.this.glWindow.getLocationOnScreen(null);
                                NewtReparentingKeyAdapter.this.printlnState("[reparent pre - glWin to TOP.1] frame ", point + ", glWindow " + point2);
                                NewtReparentingKeyAdapter.this.glWindow.reparentWindow(null, point2.getX(), point2.getY(), 0);
                            }
                            NewtReparentingKeyAdapter.this.printlnState("[reparent post]");
                            NewtReparentingKeyAdapter.this.glWindow.requestFocus();
                            NewtReparentingKeyAdapter.this.glWindow.setExclusiveContextThread(thread);
                            NewtReparentingKeyAdapter.this.quitAdapterOn();
                        }
                    });
                }
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    public void setTitle() {
        this.setTitle(this.winHolder.getNativeWindow(), this.glWindow);
    }

    String getNativeWinTitle(NativeWindow nativeWindow) {
        return "[" + nativeWindow.getX() + "/" + nativeWindow.getY() + " " + nativeWindow.getWidth() + "x" + nativeWindow.getHeight() + "], pix: " + nativeWindow.getSurfaceWidth() + "x" + nativeWindow.getSurfaceHeight();
    }

    public void setTitle(NativeWindow nativeWindow, Window window) {
        CapabilitiesImmutable capabilitiesImmutable = window.getChosenCapabilities();
        CapabilitiesImmutable capabilitiesImmutable2 = window.getRequestedCapabilities();
        CapabilitiesImmutable capabilitiesImmutable3 = null != capabilitiesImmutable ? capabilitiesImmutable : capabilitiesImmutable2;
        String string = capabilitiesImmutable3.isBackgroundOpaque() ? "opaque" : "transl";
        float[] fArray = FontScale.ppmmToPPI(window.getPixelsPerMM(new float[2]));
        window.setTitle("GLWindow[" + string + "], win: " + window.getBounds() + ", pix: " + window.getSurfaceWidth() + "x" + window.getSurfaceHeight() + ", sDPI " + fArray[0] + " x " + fArray[1]);
    }
}

