/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.common.os.Platform;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParenting01dAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static GLCapabilities glCaps;
    static boolean manual_test;

    @BeforeClass
    public static void initClass() throws InterruptedException {
        if (!manual_test && Platform.OSType.LINUX == Platform.getOSType()) {
            JunitTracer.setTestSupported(false);
        }
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @Test
    public void test01GLWindowReparentRecreateNoPreserve() throws InterruptedException, InvocationTargetException {
        this.testGLWindowInvisibleReparentRecreateImpl(false);
    }

    @Test
    public void test02GLWindowReparentRecreateGLPreserve() throws InterruptedException, InvocationTargetException {
        this.testGLWindowInvisibleReparentRecreateImpl(true);
    }

    private void testGLWindowInvisibleReparentRecreateImpl(boolean bl) throws InterruptedException, InvocationTargetException {
        long l;
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        MyGLEventListenerCounter myGLEventListenerCounter = new MyGLEventListenerCounter();
        gLWindow.addGLEventListener(myGLEventListenerCounter);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener(redSquareES2);
        Assert.assertEquals("Init Counter Invalid " + myGLEventListenerCounter, 0L, myGLEventListenerCounter.initCount);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull(newtCanvasAWT);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        Assert.assertEquals("Init Counter Invalid " + myGLEventListenerCounter, 0L, myGLEventListenerCounter.initCount);
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        frame.add((Component)container, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        gLWindow.display();
        Assert.assertEquals("Init Counter Invalid " + myGLEventListenerCounter, 1L, myGLEventListenerCounter.initCount);
        Assert.assertEquals("Dispose Counter Invalid " + myGLEventListenerCounter, 0L, myGLEventListenerCounter.disposeCount);
        int n = 1 | (bl ? 2 : 0);
        System.err.println(this.getSimpleTestName(".") + ": Start Reparent #1");
        Window.ReparentOperation reparentOperation = gLWindow.reparentWindow(null, -1, -1, n);
        System.err.println(this.getSimpleTestName(".") + ": Result Reparent #1: " + (Object)((Object)reparentOperation));
        Assert.assertEquals((Object)Window.ReparentOperation.ACTION_NATIVE_CREATION, (Object)reparentOperation);
        gLWindow.display();
        Assert.assertEquals("Init Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter, 1L, myGLEventListenerCounter.initCount);
        Assert.assertEquals("Dispose Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter, 0L, myGLEventListenerCounter.disposeCount);
        gLWindow.setVisible(false);
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, false, null));
        System.err.println(this.getSimpleTestName(".") + ": Start Reparent #2");
        Window.ReparentOperation reparentOperation2 = gLWindow.reparentWindow(newtCanvasAWT.getNativeWindow(), -1, -1, n);
        System.err.println(this.getSimpleTestName(".") + ": Result Reparent #2: " + (Object)((Object)reparentOperation2));
        Assert.assertEquals((Object)Window.ReparentOperation.ACTION_NATIVE_CREATION, (Object)reparentOperation2);
        gLWindow.setVisible(true);
        Assert.assertTrue(NewtTestUtil.waitForVisible(gLWindow, true, null));
        Assert.assertTrue(NewtTestUtil.waitForRealized(gLWindow, true, null));
        gLWindow.display();
        if (bl) {
            Assert.assertEquals("Init Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter, 1L, myGLEventListenerCounter.initCount);
            Assert.assertEquals("Dispose Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter, 0L, myGLEventListenerCounter.disposeCount);
        } else {
            Assert.assertEquals("Init Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter, 2L, myGLEventListenerCounter.initCount);
            Assert.assertEquals("Dispose Counter Invalid (Preserve Failed 2) " + myGLEventListenerCounter, 1L, myGLEventListenerCounter.disposeCount);
        }
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < durationPerTest) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(true, gLWindow.isNativeValid());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, gLWindow.isNativeValid());
        boolean bl2 = gLWindow.getChosenCapabilities().isOnscreen();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(newtCanvasAWT);
            }
        });
        if (bl2) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        if (bl2) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        if (bl) {
            Assert.assertEquals("Init Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter, 1L, myGLEventListenerCounter.initCount);
            Assert.assertEquals("Dispose Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter, 1L, myGLEventListenerCounter.disposeCount);
        } else {
            Assert.assertEquals("Init Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter, 2L, myGLEventListenerCounter.initCount);
            Assert.assertEquals("Dispose Counter Invalid (Preserve Failed 1) " + myGLEventListenerCounter, 2L, myGLEventListenerCounter.disposeCount);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        manual_test = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        String string = TestParenting01dAWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 800L;
        manual_test = false;
    }

    static class MyGLEventListenerCounter
    extends GLEventListenerCounter {
        MyGLEventListenerCounter() {
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
            System.err.println("MyGLEventListenerCounter.init: " + this);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            super.dispose(gLAutoDrawable);
            System.err.println("MyGLEventListenerCounter.dispose: " + this);
        }
    }
}

