/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.junit.Assert;

public class NEWTKeyUtil {
    public static final int TIME_OUT = 2000;
    public static final int POLL_DIVIDER = 20;
    public static final int TIME_SLICE = 100;

    public static void dumpKeyEvents(List<EventObject> list) {
        for (int i = 0; i < list.size(); ++i) {
            System.err.println(i + ": " + list.get(i));
        }
    }

    public static boolean validateKeyCodes(CodeSeg[] codeSegArray, List<List<EventObject>> list, boolean bl) {
        int n;
        ArrayList<CodeEvent> arrayList = new ArrayList<CodeEvent>();
        int n2 = 0;
        boolean bl2 = true;
        for (n = 0; n < codeSegArray.length; ++n) {
            CodeSeg codeSeg = codeSegArray[n];
            n2 += codeSeg.max - codeSeg.min + 1;
            List<EventObject> list2 = list.get(n);
            bl2 &= NEWTKeyUtil.validateKeyCodes(arrayList, codeSeg, list2, bl);
        }
        if (bl) {
            System.err.println("*** Total KeyCode Misses " + arrayList.size() + " / " + n2 + ", valid " + bl2);
            for (n = 0; n < arrayList.size(); ++n) {
                System.err.println("Miss[" + n + "]: " + arrayList.get(n));
            }
        }
        return bl2;
    }

    public static boolean validateKeyCodes(List<CodeEvent> list, CodeSeg codeSeg, List<EventObject> list2, boolean bl) {
        int n;
        int n2 = codeSeg.max - codeSeg.min + 1;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            short s = (short)(codeSeg.min + n);
            KeyEvent keyEvent = (KeyEvent)(n4 < list2.size() ? list2.get(n4) : null);
            if (null == keyEvent) {
                list.add(new CodeEvent(s, codeSeg.description, keyEvent));
                ++n3;
                ++n4;
                continue;
            }
            if (s != keyEvent.getKeyCode()) {
                list.add(new CodeEvent(s, codeSeg.description, keyEvent));
                ++n3;
            }
            n4 += 2;
        }
        int n5 = n = n4 == list2.size() && 0 == list.size() ? 1 : 0;
        if (bl) {
            System.err.println("+++ Code Segment " + codeSeg.description + ", Misses: " + n3 + " / " + n2 + ", events " + list2.size() + ", valid " + (n != 0));
        }
        return n != 0;
    }

    public static void validateKeyEvent(KeyEvent keyEvent, short s, int n, short s2, char c) {
        if (0 <= s) {
            Assert.assertTrue("KeyEvent type mismatch, expected 0x" + Integer.toHexString(s) + ", has " + keyEvent, s == keyEvent.getEventType());
        }
        if (0 <= n) {
            Assert.assertTrue("KeyEvent modifier mismatch, expected 0x" + Integer.toHexString(n) + ", has " + keyEvent, n == keyEvent.getModifiers());
        }
        if (0 != s2) {
            Assert.assertTrue("KeyEvent code mismatch, expected 0x" + Integer.toHexString(s2) + ", has " + keyEvent, s2 == keyEvent.getKeyCode());
        }
        if ('\u0000' != c) {
            Assert.assertTrue("KeyEvent char mismatch, expected 0x" + Integer.toHexString(c) + ", has " + keyEvent, c == keyEvent.getKeyChar());
        }
    }

    public static short getNextKeyEventType(KeyEvent keyEvent) {
        short s = keyEvent.getEventType();
        switch (s) {
            case 300: {
                return 301;
            }
            case 301: {
                return 300;
            }
        }
        Assert.assertTrue("Invalid event " + keyEvent, false);
        return 0;
    }

    public static void validateKeyEventOrder(List<EventObject> list) {
        IntIntHashMap intIntHashMap = new IntIntHashMap();
        for (int i = 0; i < list.size(); ++i) {
            KeyEvent keyEvent = (KeyEvent)list.get(i);
            int n = intIntHashMap.get(keyEvent.getKeyCode());
            if (0 >= n) {
                n = 300;
            }
            short s = keyEvent.getEventType();
            Assert.assertEquals("Key event not in proper order " + i + "/" + list.size() + " - event " + keyEvent, n, s);
            n = NEWTKeyUtil.getNextKeyEventType(keyEvent);
            intIntHashMap.put(keyEvent.getKeyCode(), n);
        }
    }

    public static void validateKeyAdapterStats(NEWTKeyAdapter nEWTKeyAdapter, int n, int n2, int n3, int n4) {
        int n5 = n + n2;
        int n6 = n3 + n4;
        int n7 = n5 + n6;
        int n8 = nEWTKeyAdapter.getKeyPressedCount(false);
        int n9 = nEWTKeyAdapter.getKeyPressedCount(true);
        int n10 = nEWTKeyAdapter.getKeyReleasedCount(false);
        int n11 = nEWTKeyAdapter.getKeyReleasedCount(true);
        int n12 = n8 - n9;
        int n13 = n10 - n11;
        int n14 = n8 + n10;
        int n15 = n12 + n13;
        int n16 = n9 + n11;
        System.err.println("Expec Single Press " + n + ", Release " + n2);
        System.err.println("Expec AutoRp Press " + n3 + ", Release " + n4);
        System.err.println("Total Single Press " + n12 + ", Release " + n13 + ", Events " + n15);
        System.err.println("Total AutoRp Press " + n9 + ", Release " + n11 + ", Events " + n16);
        System.err.println("Total ALL    Press " + n8 + ", Release " + n10 + ", Events " + n14);
        Assert.assertEquals("Internal Error: pressReleaseSI != pressReleaseALL - pressReleaseAR", n15, n14 - n16);
        Assert.assertEquals("Key press count failure (SI)", n, n12);
        Assert.assertEquals("Key released count failure (SI)", n2, n13);
        Assert.assertEquals("Key press count failure (AR)", n3, n9);
        Assert.assertEquals("Key released count failure (AR)", n4, n11);
        Assert.assertEquals("Key pressRelease count failure (SI)", n5, n15);
        Assert.assertEquals("Key pressRelease count failure (AR)", n6, n16);
        List<EventObject> list = nEWTKeyAdapter.copyQueue();
        Assert.assertEquals("Key pressRelease count failure (ALL) w/ list sum  ", n7, n14);
        Assert.assertEquals("Key total count failure (ALL) w/ list size ", n14, list.size());
    }

    public static class CodeSeg {
        public final short min;
        public final short max;
        public final String description;

        public CodeSeg(int n, int n2, String string) {
            this.min = (short)n;
            this.max = (short)n2;
            this.description = string;
        }
    }

    public static class CodeEvent {
        public final short code;
        public final String description;
        public final KeyEvent event;

        public CodeEvent(short s, String string, KeyEvent keyEvent) {
            this.code = s;
            this.description = string;
            this.event = keyEvent;
        }

        public String toString() {
            return "Code 0x" + Integer.toHexString(this.code & 0xFFFF) + " != " + this.event + " // " + this.description;
        }
    }
}

