/*
 * Decompiled with CFR 0.152.
 */
package demos.tennis;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public class Tennis
implements GLEventListener {
    private float view_rotx = 0.0f;
    private float view_roty = 0.0f;
    private final float view_rotz = 0.0f;
    private float sx = 0.0f;
    private float sy = 0.0f;
    private float spx;
    private float spy;
    private float spz;
    private float BallCx = 0.0f;
    private float BallCy = 0.0f;
    private float BallCz = 0.0f;
    private float EnDeskCx = 0.0f;
    private float EnDeskCy = 0.0f;
    private int cube = 0;
    private int mydesk = 0;
    private int endesk = 0;
    private int ball = 0;
    private int box = 0;
    private final int swapInterval;
    private static Texture[] texture;
    private float Bax = 0.0f;
    private float Bay = 0.0f;
    private float Vec = 3.0f;
    private boolean CanF = false;
    private int WindowW = 0;
    private int WindowH = 0;
    private float LPositionDX = 0.0f;
    private float NPositionDX = 0.0f;
    private float LPositionDY = 0.0f;
    private float NPositionDY = 0.0f;
    private float DspeedX = 0.0f;
    private float DspeedY = 0.0f;
    private boolean mouseButtonDown = false;
    private boolean control = true;
    private int prevMouseX;
    private int prevMouseY;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Tennis Demo");
        frame.setSize(640, 480);
        frame.setLayout(new BorderLayout());
        final Animator animator = new Animator();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        GLCanvas gLCanvas = new GLCanvas();
        animator.add((GLAutoDrawable)gLCanvas);
        Tennis tennis = new Tennis();
        gLCanvas.addGLEventListener((GLEventListener)tennis);
        frame.add((Component)gLCanvas, "Center");
        frame.validate();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Cursor cursor = toolkit.createCustomCursor(bufferedImage, new Point(0, 0), "none");
        frame.setCursor(cursor);
        frame.setVisible(true);
        animator.start();
    }

    public Tennis(int n) {
        this.swapInterval = n;
    }

    public Tennis() {
        this.swapInterval = 1;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("Tennis: Init: " + gLAutoDrawable);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL2.getClass().getName());
        System.err.println("GL_VENDOR: " + gL2.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL2.glGetString(7937));
        System.err.println("GL_VERSION: " + gL2.glGetString(7938));
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] fArray2 = new float[]{25.0f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        float[] fArray4 = new float[]{0.8f, 0.1f, 0.0f, 0.7f};
        float[] fArray5 = new float[]{0.8f, 0.75f, 0.0f, 0.7f};
        float[] fArray6 = new float[]{0.2f, 0.2f, 1.0f, 0.7f};
        float[] fArray7 = new float[]{0.8f, 0.4f, 0.1f, 0.7f};
        texture = new Texture[5];
        try {
            System.err.println("Loading texture...");
            Tennis.texture[0] = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/tennis/TennisTop.png"), (boolean)false, (String)"png");
            Tennis.texture[1] = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/tennis/TennisBottom.png"), (boolean)false, (String)"png");
            Tennis.texture[2] = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/tennis/TennisMyDesk.png"), (boolean)false, (String)"png");
            Tennis.texture[3] = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/tennis/TennisEnDesk.png"), (boolean)false, (String)"png");
            Tennis.texture[4] = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/tennis/Stars.png"), (boolean)false, (String)"png");
            System.err.println("Texture0 estimated memory size = " + texture[0].getEstimatedMemorySize());
            System.err.println("Texture1 estimated memory size = " + texture[1].getEstimatedMemorySize());
            System.err.println("Texture2 estimated memory size = " + texture[2].getEstimatedMemorySize());
            System.err.println("Texture3 estimated memory size = " + texture[3].getEstimatedMemorySize());
            System.err.println("Stars estimated memory size = " + texture[4].getEstimatedMemorySize());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            iOException.printStackTrace(new PrintStream(byteArrayOutputStream));
            JOptionPane.showMessageDialog(null, byteArrayOutputStream.toString(), "Error loading texture", 0);
            throw new GLException((Throwable)iOException);
        }
        gL2.glShadeModel(7425);
        gL2.glClearDepth(1.0);
        gL2.glEnable(2929);
        gL2.glDepthFunc(515);
        gL2.glHint(3152, 4354);
        gL2.glEnable(3553);
        gL2.glTexParameteri(3553, 10240, 0);
        gL2.glTexParameteri(3553, 10241, 0);
        gL2.glMaterialfv(1028, 4610, fArray, 0);
        gL2.glMaterialfv(1028, 5633, fArray2, 0);
        gL2.glLightfv(16384, 4611, fArray3, 0);
        gL2.glEnable(2896);
        gL2.glEnable(16384);
        if (0 >= this.cube) {
            this.cube = gL2.glGenLists(1);
            gL2.glNewList(this.cube, 4864);
            gL2.glMaterialfv(1028, 5634, fArray7, 0);
            Tennis.cube(gL2);
            gL2.glEndList();
            System.err.println("cube list created: " + this.cube);
        } else {
            System.err.println("cube list reused: " + this.cube);
        }
        if (0 >= this.box) {
            this.box = gL2.glGenLists(1);
            gL2.glNewList(this.box, 4864);
            gL2.glMaterialfv(1028, 5634, fArray7, 0);
            Tennis.box(gL2);
            gL2.glEndList();
            System.err.println("box list created: " + this.box);
        } else {
            System.err.println("box list reused: " + this.box);
        }
        if (0 >= this.mydesk) {
            this.mydesk = gL2.glGenLists(1);
            gL2.glNewList(this.mydesk, 4864);
            gL2.glMaterialfv(1028, 5634, fArray4, 0);
            Tennis.desk(gL2, 2);
            gL2.glEndList();
            System.err.println("mydesk list created: " + this.mydesk);
        } else {
            System.err.println("mydesk list reused: " + this.mydesk);
        }
        if (0 >= this.endesk) {
            this.endesk = gL2.glGenLists(1);
            gL2.glNewList(this.endesk, 4864);
            gL2.glMaterialfv(1028, 5634, fArray6, 0);
            Tennis.desk(gL2, 3);
            gL2.glEndList();
            System.err.println("endesk list created: " + this.endesk);
        } else {
            System.err.println("endesk list reused: " + this.endesk);
        }
        if (0 >= this.ball) {
            this.ball = gL2.glGenLists(1);
            gL2.glNewList(this.ball, 4864);
            gL2.glMaterialfv(1028, 5634, fArray5, 0);
            Tennis.ball(gL2);
            gL2.glEndList();
            System.err.println("ball list created: " + this.ball);
        } else {
            System.err.println("ball list reused: " + this.ball);
        }
        gL2.glEnable(2977);
        TennisMouseAdapter tennisMouseAdapter = new TennisMouseAdapter();
        TennisKeyAdapter tennisKeyAdapter = new TennisKeyAdapter();
        if (gLAutoDrawable instanceof Window) {
            Window window = (Window)gLAutoDrawable;
            window.addMouseListener((MouseListener)tennisMouseAdapter);
            window.addKeyListener((KeyListener)tennisKeyAdapter);
        } else if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof Component) {
            Component component = (Component)gLAutoDrawable;
            new AWTMouseAdapter((MouseListener)tennisMouseAdapter, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
            new AWTKeyAdapter((KeyListener)tennisKeyAdapter, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println("Tennis: Dispose");
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (!this.mouseButtonDown && this.control) {
            this.MovMydesk();
        }
        this.MoveSphere();
        this.MoveEnDesk();
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof GLJPanel && !((GLJPanel)gLAutoDrawable).isOpaque() && ((GLJPanel)gLAutoDrawable).shouldPreserveColorBufferIfTranslucent()) {
            gL2.glClear(256);
        } else {
            gL2.glClear(16640);
        }
        gL2.glDisable(2929);
        gL2.glCallList(this.box);
        gL2.glEnable(2929);
        gL2.glPushMatrix();
        gL2.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glPushMatrix();
        gL2.glTranslatef(0.0f, 0.0f, 0.0f);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.cube);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(this.sx, this.sy, 3.0f);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.mydesk);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(this.EnDeskCx, this.EnDeskCy, -3.0f);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.endesk);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(this.BallCx, this.BallCy, this.BallCz);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.ball);
        gL2.glPopMatrix();
        gL2.glPopMatrix();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.err.println("Gears: Reshape " + n + "/" + n2 + " " + n3 + "x" + n4);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.setSwapInterval(this.swapInterval);
        float f = (float)n4 / (float)n3;
        this.WindowW = n3;
        this.WindowH = n4;
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        if (f < 1.0f) {
            gL2.glFrustum(-1.0, 1.0, (double)(-f), (double)f, 1.0, 60.0);
        } else {
            f = 1.0f / f;
            gL2.glFrustum((double)(-f), (double)f, -1.0, 1.0, 1.0, 60.0);
        }
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(0.0f, 0.0f, -6.0f);
    }

    public static void cube(GL2 gL2) {
        TextureCoords textureCoords;
        gL2.glShadeModel(7424);
        gL2.glBegin(7);
        gL2.glNormal3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(-2.0f, -1.5f, -3.0f);
        gL2.glVertex3f(-2.0f, 1.5f, -3.0f);
        gL2.glVertex3f(-2.0f, 1.5f, 3.0f);
        gL2.glVertex3f(-2.0f, -1.5f, 3.0f);
        gL2.glNormal3f(-1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(-2.05f, -1.55f, -3.0f);
        gL2.glVertex3f(-2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(-2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(-2.05f, -1.55f, 3.0f);
        gL2.glEnd();
        if (texture[0] != null) {
            texture[0].enable((GL)gL2);
            texture[0].bind((GL)gL2);
            gL2.glTexEnvi(8960, 8704, 7681);
            textureCoords = texture[0].getImageTexCoords();
            gL2.glBegin(7);
            gL2.glNormal3f(0.0f, -1.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
            gL2.glVertex3f(-2.0f, 1.5f, -3.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
            gL2.glVertex3f(-2.0f, 1.5f, 3.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
            gL2.glVertex3f(2.0f, 1.5f, 3.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
            gL2.glVertex3f(2.0f, 1.5f, -3.0f);
            gL2.glEnd();
            texture[0].disable((GL)gL2);
        }
        gL2.glBegin(7);
        gL2.glNormal3f(0.0f, 1.0f, 0.0f);
        gL2.glVertex3f(-2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(-2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(2.05f, 1.55f, -3.0f);
        gL2.glEnd();
        gL2.glBegin(7);
        gL2.glNormal3f(-1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(2.0f, -1.5f, -3.0f);
        gL2.glVertex3f(2.0f, 1.5f, -3.0f);
        gL2.glVertex3f(2.0f, 1.5f, 3.0f);
        gL2.glVertex3f(2.0f, -1.5f, 3.0f);
        gL2.glNormal3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(2.05f, -1.55f, -3.0f);
        gL2.glVertex3f(2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(2.05f, -1.55f, 3.0f);
        gL2.glEnd();
        if (texture[1] != null) {
            texture[1].enable((GL)gL2);
            texture[1].bind((GL)gL2);
            gL2.glTexEnvi(8960, 8704, 7681);
            textureCoords = texture[1].getImageTexCoords();
            gL2.glBegin(7);
            gL2.glNormal3f(0.0f, 1.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
            gL2.glVertex3f(-2.0f, -1.5f, -3.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
            gL2.glVertex3f(-2.0f, -1.5f, 3.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
            gL2.glVertex3f(2.0f, -1.5f, 3.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
            gL2.glVertex3f(2.0f, -1.5f, -3.0f);
            gL2.glNormal3f(0.0f, -1.0f, 0.0f);
            gL2.glVertex3f(-2.05f, -1.55f, -3.0f);
            gL2.glVertex3f(-2.05f, -1.55f, 3.0f);
            gL2.glVertex3f(2.05f, -1.55f, 3.0f);
            gL2.glVertex3f(2.05f, -1.55f, -3.0f);
            gL2.glEnd();
            texture[1].disable((GL)gL2);
        }
        gL2.glBegin(7);
        gL2.glNormal3f(0.0f, 0.0f, -1.0f);
        gL2.glVertex3f(-2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(2.0f, 1.5f, -3.0f);
        gL2.glVertex3f(-2.0f, 1.5f, -3.0f);
        gL2.glVertex3f(-2.05f, -1.55f, -3.0f);
        gL2.glVertex3f(2.05f, -1.55f, -3.0f);
        gL2.glVertex3f(2.0f, -1.5f, -3.0f);
        gL2.glVertex3f(-2.0f, -1.5f, -3.0f);
        gL2.glVertex3f(-2.05f, -1.55f, -3.0f);
        gL2.glVertex3f(-2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(-2.0f, 1.5f, -3.0f);
        gL2.glVertex3f(-2.0f, -1.5f, -3.0f);
        gL2.glVertex3f(2.05f, -1.55f, -3.0f);
        gL2.glVertex3f(2.05f, 1.55f, -3.0f);
        gL2.glVertex3f(2.0f, 1.5f, -3.0f);
        gL2.glVertex3f(2.0f, -1.5f, -3.0f);
        gL2.glEnd();
        gL2.glBegin(7);
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        gL2.glVertex3f(-2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(2.0f, 1.5f, 3.0f);
        gL2.glVertex3f(-2.0f, 1.5f, 3.0f);
        gL2.glVertex3f(-2.05f, -1.55f, 3.0f);
        gL2.glVertex3f(2.05f, -1.55f, 3.0f);
        gL2.glVertex3f(2.0f, -1.5f, 3.0f);
        gL2.glVertex3f(-2.0f, -1.5f, 3.0f);
        gL2.glVertex3f(-2.05f, -1.55f, 3.0f);
        gL2.glVertex3f(-2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(-2.0f, 1.5f, 3.0f);
        gL2.glVertex3f(-2.0f, -1.5f, 3.0f);
        gL2.glVertex3f(2.05f, -1.55f, 3.0f);
        gL2.glVertex3f(2.05f, 1.55f, 3.0f);
        gL2.glVertex3f(2.0f, 1.5f, 3.0f);
        gL2.glVertex3f(2.0f, -1.5f, 3.0f);
        gL2.glEnd();
    }

    public static void box(GL2 gL2) {
        gL2.glShadeModel(7424);
        if (texture[4] != null) {
            texture[4].enable((GL)gL2);
            texture[4].bind((GL)gL2);
            gL2.glTexParameteri(3553, 10242, 10497);
            gL2.glTexParameteri(3553, 10243, 10497);
            gL2.glTexEnvi(8960, 8704, 7681);
            gL2.glBegin(7);
            gL2.glNormal3f(0.0f, 0.0f, 1.0f);
            gL2.glTexCoord2f(0.0f, 0.0f);
            gL2.glVertex3f(-8.0f, -8.0f, 0.0f);
            gL2.glTexCoord2f(0.0f, 8.0f);
            gL2.glVertex3f(-8.0f, 8.0f, 0.0f);
            gL2.glTexCoord2f(8.0f, 8.0f);
            gL2.glVertex3f(8.0f, 8.0f, 0.0f);
            gL2.glTexCoord2f(8.0f, 0.0f);
            gL2.glVertex3f(8.0f, -8.0f, 0.0f);
            gL2.glEnd();
            texture[4].disable((GL)gL2);
        }
    }

    public static void desk(GL2 gL2, int n) {
        float f;
        int n2;
        gL2.glShadeModel(7424);
        if (texture[n] != null) {
            texture[n].enable((GL)gL2);
            texture[n].bind((GL)gL2);
            gL2.glTexParameteri(3553, 10242, 10497);
            gL2.glTexParameteri(3553, 10243, 10497);
            gL2.glTexEnvi(8960, 8704, 7681);
            gL2.glBegin(8);
            gL2.glNormal3f(0.0f, 0.0f, 1.0f);
            for (n2 = 0; n2 < 25; ++n2) {
                f = (float)Math.pow(Math.sin((double)((float)n2 / 24.0f) * Math.PI), 0.4);
                gL2.glTexCoord2f((float)(n2 - 12) / 40.0f, f / 4.0f + 0.75f);
                gL2.glVertex3f((float)(n2 - 12) / 40.0f, f / 10.0f + 0.1f, 0.01f + f / 25.0f);
                gL2.glTexCoord2f((float)(n2 - 12) / 40.0f, -f / 4.0f + 0.25f);
                gL2.glVertex3f((float)(n2 - 12) / 40.0f, -f / 10.0f - 0.1f, 0.01f + f / 25.0f);
            }
            gL2.glEnd();
            gL2.glBegin(8);
            gL2.glNormal3f(0.0f, 0.0f, -1.0f);
            for (n2 = 0; n2 < 25; ++n2) {
                f = (float)Math.pow(Math.sin((double)((float)n2 / 24.0f) * Math.PI), 0.4);
                gL2.glTexCoord2f((float)(n2 - 12) / 40.0f, f / 4.0f + 0.75f);
                gL2.glVertex3f((float)(n2 - 12) / 40.0f, f / 10.0f + 0.1f, -0.01f - f / 25.0f);
                gL2.glTexCoord2f((float)(n2 - 12) / 40.0f, -f / 4.0f + 0.25f);
                gL2.glVertex3f((float)(n2 - 12) / 40.0f, -f / 10.0f - 0.1f, -0.01f - f / 25.0f);
            }
            gL2.glEnd();
            texture[2].disable((GL)gL2);
        }
        gL2.glBegin(8);
        gL2.glNormal3f(0.0f, 1.0f, 0.0f);
        for (n2 = 0; n2 < 25; ++n2) {
            f = (float)Math.pow(Math.sin((double)((float)n2 / 24.0f) * Math.PI), 0.4);
            gL2.glVertex3f((float)(n2 - 12) / 40.0f, f / 10.0f + 0.1f, -0.01f - f / 25.0f);
            gL2.glVertex3f((float)(n2 - 12) / 40.0f, f / 10.0f + 0.1f, 0.01f + f / 25.0f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        gL2.glNormal3f(0.0f, -1.0f, 0.0f);
        for (n2 = 0; n2 < 25; ++n2) {
            f = (float)Math.pow(Math.sin((double)((float)n2 / 24.0f) * Math.PI), 0.4);
            gL2.glVertex3f((float)(n2 - 12) / 40.0f, -f / 10.0f - 0.1f, 0.01f + f / 25.0f);
            gL2.glVertex3f((float)(n2 - 12) / 40.0f, -f / 10.0f - 0.1f, -0.01f - f / 25.0f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        gL2.glNormal3f(-1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(-0.3f, -0.1f, 0.01f);
        gL2.glVertex3f(-0.3f, 0.1f, 0.01f);
        gL2.glVertex3f(-0.3f, 0.1f, -0.01f);
        gL2.glVertex3f(-0.3f, -0.1f, -0.01f);
        gL2.glNormal3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(0.3f, -0.1f, 0.01f);
        gL2.glVertex3f(0.3f, 0.1f, 0.01f);
        gL2.glVertex3f(0.3f, 0.1f, -0.01f);
        gL2.glVertex3f(0.3f, -0.1f, -0.01f);
        gL2.glEnd();
    }

    public static void ball(GL2 gL2) {
        gL2.glShadeModel(7424);
        gL2.glBegin(8);
        for (int i = 0; i < 20; ++i) {
            float f = (float)Math.cos((double)((float)i / 20.0f) * Math.PI) / 10.0f;
            float f2 = (float)Math.cos((double)((float)(i + 1) / 20.0f) * Math.PI) / 10.0f;
            float f3 = (float)Math.sqrt(Math.abs(0.01f - f * f));
            float f4 = (float)Math.sqrt(Math.abs(0.01f - f2 * f2));
            for (int j = 0; j < 21; ++j) {
                float f5 = (float)((double)f3 * Math.cos((double)((float)j / 21.0f * 2.0f) * Math.PI));
                float f6 = (float)((double)f3 * Math.sin((double)((float)j / 21.0f * 2.0f) * Math.PI));
                gL2.glNormal3f(10.0f * f5, 10.0f * f, 10.0f * f6);
                gL2.glVertex3f(f5, f, f6);
                f5 = (float)((double)f4 * Math.cos((double)((float)j / 21.0f * 2.0f) * Math.PI));
                f6 = (float)((double)f4 * Math.sin((double)((float)j / 21.0f * 2.0f) * Math.PI));
                gL2.glNormal3f(10.0f * f5, 10.0f * f2, 10.0f * f6);
                gL2.glVertex3f(f5, f2, f6);
            }
        }
        gL2.glEnd();
    }

    public void MoveSphere() {
        if (this.BallCz > 3.0f || this.BallCz < -3.0f) {
            this.Vec = this.BallCz;
            this.BallCx = 0.0f;
            this.BallCy = 0.0f;
            this.BallCz = 0.0f;
            this.spz = 0.0f;
            this.spx = 0.0f;
            this.spy = 0.0f;
            this.CanF = false;
            this.Bax = 0.0f;
            this.Bay = 0.0f;
        }
        if (this.spz < 0.0f && (double)(this.BallCz + this.spz) < -2.8 && (double)(this.BallCx + this.spx) < (double)this.EnDeskCx + 0.3 && (double)(this.BallCx + this.spx) > (double)this.EnDeskCx - 0.3 && (double)(this.BallCy + this.spy) < (double)this.EnDeskCy + 0.2 && (double)(this.BallCy + this.spy) > (double)this.EnDeskCy - 0.2) {
            this.spz = -this.spz + 0.002f;
            this.spx += (this.BallCx - this.EnDeskCx) / 10.0f;
            this.spy += (this.BallCy - this.EnDeskCy) / 10.0f;
        }
        if (this.spz > 0.0f && (double)(this.BallCz + this.spz) > 2.8 && (double)(this.BallCx + this.spx) < (double)this.sx + 0.3 && (double)(this.BallCx + this.spx) > (double)this.sx - 0.3 && (double)(this.BallCy + this.spy) < (double)this.sy + 0.2 && (double)(this.BallCy + this.spy) > (double)this.sy - 0.2) {
            this.spz = -this.spz - 0.002f;
            this.spx += (this.BallCx - this.sx) / 10.0f;
            this.spy += (this.BallCy - this.sy) / 10.0f;
            this.Bax = this.DspeedX / 100.0f;
            this.Bay = this.DspeedY / 100.0f;
        }
        if ((double)(this.BallCx + this.spx) < -1.9 || (double)(this.BallCx + this.spx) > 1.9) {
            this.spx = -this.spx;
        }
        if ((double)(this.BallCy + this.spy) < -1.4 || (double)(this.BallCy + this.spy) > 1.4) {
            this.spy = -this.spy;
        }
        this.spx += this.Bax;
        this.spy += this.Bay;
        if (this.CanF) {
            this.BallCx += this.spx;
        }
        this.BallCy += this.spy;
        this.BallCz += this.spz;
        this.Bax -= this.Bax / 100.0f;
        this.Bay -= this.Bay / 100.0f;
    }

    public void MoveEnDesk() {
        float f;
        float f2;
        double d = Math.sqrt((this.BallCx - this.EnDeskCx) * (this.BallCx - this.EnDeskCx) + (this.BallCy - this.EnDeskCy) * (this.BallCy - this.EnDeskCy));
        if (d < 0.07) {
            f2 = Math.abs(this.BallCx - this.EnDeskCx);
            f = Math.abs(this.BallCy - this.EnDeskCy);
        } else {
            f2 = Math.abs(this.BallCx - this.EnDeskCx) / (float)d * 0.07f;
            f = Math.abs(this.BallCy - this.EnDeskCy) / (float)d * 0.07f;
        }
        if (this.BallCx - this.EnDeskCx > 0.0f && (double)(this.EnDeskCx + f2) <= 1.7) {
            this.EnDeskCx += f2;
        }
        if (this.BallCx - this.EnDeskCx < 0.0f && (double)(this.EnDeskCx - f2) >= -1.7) {
            this.EnDeskCx -= f2;
        }
        if (this.BallCy - this.EnDeskCy > 0.0f && (double)(this.EnDeskCy + f) <= 1.3) {
            this.EnDeskCy += f;
        }
        if (this.BallCy - this.EnDeskCy < 0.0f && (double)(this.EnDeskCy - f) >= -1.3) {
            this.EnDeskCy -= f;
        }
    }

    public void MovMydesk() {
        this.LPositionDX = this.sx;
        this.LPositionDY = this.sy;
        int n = MouseInfo.getPointerInfo().getLocation().x;
        int n2 = MouseInfo.getPointerInfo().getLocation().y;
        this.sx += ((float)n - 500.0f) / 300.0f;
        this.sy += (400.0f - (float)n2) / 300.0f;
        if (this.sx < -1.7f || this.sx > 1.7f) {
            this.sx = this.sx > 0.0f ? 1.7f : -1.7f;
        }
        if ((double)this.sy < -1.3 || (double)this.sy > 1.3) {
            this.sy = this.sy > 0.0f ? 1.3f : -1.3f;
        }
        try {
            Robot robot = new Robot();
            robot.mouseMove(500, 400);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.NPositionDX = this.sx;
        this.NPositionDY = this.sy;
        this.DspeedX = this.NPositionDX - this.LPositionDX;
        this.DspeedY = this.NPositionDY - this.LPositionDY;
    }

    static {
        GLProfile.initSingleton();
    }

    class TennisMouseAdapter
    extends MouseAdapter {
        TennisMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Tennis.this.prevMouseX = mouseEvent.getX();
            Tennis.this.prevMouseY = mouseEvent.getY();
            Tennis.this.mouseButtonDown = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Tennis.this.mouseButtonDown = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            float f = 360.0f * ((float)(n - Tennis.this.prevMouseX) / (float)Tennis.this.WindowW);
            float f2 = 360.0f * ((float)(Tennis.this.prevMouseY - n2) / (float)Tennis.this.WindowH);
            Tennis.this.prevMouseX = n;
            Tennis.this.prevMouseY = n2;
            Tennis.this.view_rotx += f2;
            Tennis.this.view_roty += f;
        }
    }

    class TennisKeyAdapter
    extends KeyAdapter {
        TennisKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (27 == s) {
                System.exit(0);
            }
            if (17 == s) {
                Tennis.this.control = false;
            }
            if (32 == s) {
                if (!Tennis.this.CanF) {
                    if (Tennis.this.Vec < 0.0f) {
                        Tennis.this.spz = -0.07f;
                    } else {
                        Tennis.this.spz = 0.07f;
                    }
                }
                Tennis.this.CanF = true;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (17 == s) {
                Tennis.this.control = true;
            }
        }
    }
}

