/*
 * Decompiled with CFR 0.152.
 */
package demos.dualDepthPeeling;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import demos.data.DemosDataAnchor;
import demos.dualDepthPeeling.GLHelper;
import demos.dualDepthPeeling.Model;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class DualDepthPeeling
implements GLEventListener,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final int DUAL_PEELING_MODE = 0;
    public static final int F2B_PEELING_MODE = 1;
    public static final int WEIGHTED_AVERAGE_MODE = 2;
    public static final int WEIGHTED_SUM_MODE = 3;
    public static final float FOVY = 30.0f;
    public static final float ZNEAR = 1.0E-4f;
    public static final float ZFAR = 10.0f;
    public static final float FPS_TIME_WINDOW = 1.0f;
    public static final float MAX_DEPTH = 1.0f;
    public int g_numPasses = 4;
    public int g_imageWidth = 1024;
    public int g_imageHeight = 768;
    public Model g_model;
    public int g_quadDisplayList;
    public int[] g_vboId = new int[1];
    public int[] g_eboId = new int[1];
    public boolean g_useOQ = true;
    public int[] g_queryId = new int[1];
    public String MODEL_FILENAME = "models/dragon.obj";
    public static final String s_FrontBlenderTex = "FrontBlenderTex";
    public static final String s_BackBlenderTex = "BackBlenderTex";
    public static final String s_DepthBlenderTex = "DepthBlenderTex";
    public static final String s_ColorTex = "ColorTex";
    public static final String s_ColorTex0 = "ColorTex0";
    public static final String s_ColorTex1 = "ColorTex1";
    public static final String s_TempTex = "TempTex";
    public static final String s_BackgroundColor = "BackgroundColor";
    public GLUniformData g_FrontBlenderTexUnit;
    public GLUniformData g_BackBlenderTexUnit;
    public GLUniformData g_DepthBlenderTexUnit;
    public GLUniformData g_ColorTexUnit;
    public GLUniformData g_ColorTex0Unit;
    public GLUniformData g_ColorTex1Unit;
    public GLUniformData g_TempTexUnit;
    public GLUniformData g_AlphaUni;
    public GLUniformData g_backgroundColorUni;
    public ShaderState g_shaderState;
    public ShaderProgram g_shaderDualInit;
    public ShaderProgram g_shaderDualPeel;
    public ShaderProgram g_shaderDualBlend;
    public ShaderProgram g_shaderDualFinal;
    public ShaderProgram g_shaderFrontInit;
    public ShaderProgram g_shaderFrontPeel;
    public ShaderProgram g_shaderFrontBlend;
    public ShaderProgram g_shaderFrontFinal;
    public ShaderProgram g_shaderAverageInit;
    public ShaderProgram g_shaderAverageFinal;
    public ShaderProgram g_shaderWeightedSumInit;
    public ShaderProgram g_shaderWeightedSumFinal;
    public float g_opacity = 0.6f;
    public char g_mode = '\u0000';
    public boolean g_showOsd = true;
    public boolean g_bShowUI = true;
    public int g_numGeoPasses = 0;
    public boolean g_rotating = false;
    public boolean g_panning = false;
    public boolean g_scaling = false;
    public int g_oldX;
    public int g_oldY;
    public int g_newX;
    public int g_newY;
    public float g_bbScale = 1.0f;
    public float[] g_bbTrans = new float[]{0.0f, 0.0f, 0.0f};
    public float[] g_rot = new float[]{0.0f, 45.0f};
    public float[] g_pos = new float[]{0.0f, 0.0f, 2.0f};
    static final FloatBuffer g_white = Buffers.newDirectFloatBuffer((float[])new float[]{1.0f, 1.0f, 1.0f});
    static final FloatBuffer g_black = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 0.0f});
    FloatBuffer g_backgroundColor = g_white;
    public int[] g_dualBackBlenderFboId = new int[1];
    public int[] g_dualPeelingSingleFboId = new int[1];
    public int[] g_dualDepthTexId = new int[2];
    public int[] g_dualFrontBlenderTexId = new int[2];
    public int[] g_dualBackTempTexId = new int[2];
    public int[] g_dualBackBlenderTexId = new int[1];
    public int[] g_frontFboId = new int[2];
    public int[] g_frontDepthTexId = new int[2];
    public int[] g_frontColorTexId = new int[2];
    public int[] g_frontColorBlenderTexId = new int[1];
    public int[] g_frontColorBlenderFboId = new int[1];
    public int[] g_accumulationTexId = new int[2];
    public int[] g_accumulationFboId = new int[1];
    int[] g_drawBuffers = new int[]{36064, 36065, 36066, 36067, 36068, 36069, 36070};
    boolean reloadShaders = false;
    private GLCanvas m_kCanvas;

    public DualDepthPeeling() {
        this.InitGL();
    }

    public void InitDualPeelingRenderTargets(GL2 gL2) {
        int n;
        gL2.glGenTextures(2, this.g_dualDepthTexId, 0);
        gL2.glGenTextures(2, this.g_dualFrontBlenderTexId, 0);
        gL2.glGenTextures(2, this.g_dualBackTempTexId, 0);
        gL2.glGenFramebuffers(1, this.g_dualPeelingSingleFboId, 0);
        for (n = 0; n < 2; ++n) {
            gL2.glBindTexture(34037, this.g_dualDepthTexId[n]);
            gL2.glTexParameteri(34037, 10242, 10496);
            gL2.glTexParameteri(34037, 10243, 10496);
            gL2.glTexParameteri(34037, 10241, 9728);
            gL2.glTexParameteri(34037, 10240, 9728);
            gL2.glTexImage2D(34037, 0, 34951, this.g_imageWidth, this.g_imageHeight, 0, 6407, 5126, null);
            gL2.glBindTexture(34037, this.g_dualFrontBlenderTexId[n]);
            gL2.glTexParameteri(34037, 10242, 10496);
            gL2.glTexParameteri(34037, 10243, 10496);
            gL2.glTexParameteri(34037, 10241, 9728);
            gL2.glTexParameteri(34037, 10240, 9728);
            gL2.glTexImage2D(34037, 0, 6408, this.g_imageWidth, this.g_imageHeight, 0, 6408, 5126, null);
            gL2.glBindTexture(34037, this.g_dualBackTempTexId[n]);
            gL2.glTexParameteri(34037, 10242, 10496);
            gL2.glTexParameteri(34037, 10243, 10496);
            gL2.glTexParameteri(34037, 10241, 9728);
            gL2.glTexParameteri(34037, 10240, 9728);
            gL2.glTexImage2D(34037, 0, 6408, this.g_imageWidth, this.g_imageHeight, 0, 6408, 5126, null);
        }
        gL2.glGenTextures(1, this.g_dualBackBlenderTexId, 0);
        gL2.glBindTexture(34037, this.g_dualBackBlenderTexId[0]);
        gL2.glTexParameteri(34037, 10242, 10496);
        gL2.glTexParameteri(34037, 10243, 10496);
        gL2.glTexParameteri(34037, 10241, 9728);
        gL2.glTexParameteri(34037, 10240, 9728);
        gL2.glTexImage2D(34037, 0, 6407, this.g_imageWidth, this.g_imageHeight, 0, 6407, 5126, null);
        gL2.glGenFramebuffers(1, this.g_dualBackBlenderFboId, 0);
        gL2.glBindFramebuffer(36160, this.g_dualBackBlenderFboId[0]);
        gL2.glFramebufferTexture2D(36160, 36064, 34037, this.g_dualBackBlenderTexId[0], 0);
        gL2.glBindFramebuffer(36160, this.g_dualPeelingSingleFboId[0]);
        n = 0;
        gL2.glFramebufferTexture2D(36160, 36064, 34037, this.g_dualDepthTexId[n], 0);
        gL2.glFramebufferTexture2D(36160, 36065, 34037, this.g_dualFrontBlenderTexId[n], 0);
        gL2.glFramebufferTexture2D(36160, 36066, 34037, this.g_dualBackTempTexId[n], 0);
        n = 1;
        gL2.glFramebufferTexture2D(36160, 36067, 34037, this.g_dualDepthTexId[n], 0);
        gL2.glFramebufferTexture2D(36160, 36068, 34037, this.g_dualFrontBlenderTexId[n], 0);
        gL2.glFramebufferTexture2D(36160, 36069, 34037, this.g_dualBackTempTexId[n], 0);
        gL2.glFramebufferTexture2D(36160, 36070, 34037, this.g_dualBackBlenderTexId[0], 0);
    }

    void DeleteDualPeelingRenderTargets(GL2 gL2) {
        gL2.glDeleteFramebuffers(1, this.g_dualBackBlenderFboId, 0);
        gL2.glDeleteFramebuffers(1, this.g_dualPeelingSingleFboId, 0);
        gL2.glDeleteTextures(2, this.g_dualDepthTexId, 0);
        gL2.glDeleteTextures(2, this.g_dualFrontBlenderTexId, 0);
        gL2.glDeleteTextures(2, this.g_dualBackTempTexId, 0);
        gL2.glDeleteTextures(1, this.g_dualBackBlenderTexId, 0);
    }

    void InitFrontPeelingRenderTargets(GL2 gL2) {
        gL2.glGenTextures(2, this.g_frontDepthTexId, 0);
        gL2.glGenTextures(2, this.g_frontColorTexId, 0);
        gL2.glGenFramebuffers(2, this.g_frontFboId, 0);
        for (int i = 0; i < 2; ++i) {
            gL2.glBindTexture(34037, this.g_frontDepthTexId[i]);
            gL2.glTexParameteri(34037, 10242, 10496);
            gL2.glTexParameteri(34037, 10243, 10496);
            gL2.glTexParameteri(34037, 10241, 9728);
            gL2.glTexParameteri(34037, 10240, 9728);
            gL2.glTexImage2D(34037, 0, 36012, this.g_imageWidth, this.g_imageHeight, 0, 6402, 5126, null);
            gL2.glBindTexture(34037, this.g_frontColorTexId[i]);
            gL2.glTexParameteri(34037, 10242, 10496);
            gL2.glTexParameteri(34037, 10243, 10496);
            gL2.glTexParameteri(34037, 10241, 9728);
            gL2.glTexParameteri(34037, 10240, 9728);
            gL2.glTexImage2D(34037, 0, 6408, this.g_imageWidth, this.g_imageHeight, 0, 6408, 5126, null);
            gL2.glBindFramebuffer(36160, this.g_frontFboId[i]);
            gL2.glFramebufferTexture2D(36160, 36096, 34037, this.g_frontDepthTexId[i], 0);
            gL2.glFramebufferTexture2D(36160, 36064, 34037, this.g_frontColorTexId[i], 0);
        }
        gL2.glGenTextures(1, this.g_frontColorBlenderTexId, 0);
        gL2.glBindTexture(34037, this.g_frontColorBlenderTexId[0]);
        gL2.glTexParameteri(34037, 10242, 10496);
        gL2.glTexParameteri(34037, 10243, 10496);
        gL2.glTexParameteri(34037, 10241, 9728);
        gL2.glTexParameteri(34037, 10240, 9728);
        gL2.glTexImage2D(34037, 0, 6408, this.g_imageWidth, this.g_imageHeight, 0, 6408, 5126, null);
        gL2.glGenFramebuffers(1, this.g_frontColorBlenderFboId, 0);
        gL2.glBindFramebuffer(36160, this.g_frontColorBlenderFboId[0]);
        gL2.glFramebufferTexture2D(36160, 36096, 34037, this.g_frontDepthTexId[0], 0);
        gL2.glFramebufferTexture2D(36160, 36064, 34037, this.g_frontColorBlenderTexId[0], 0);
    }

    void DeleteFrontPeelingRenderTargets(GL2 gL2) {
        gL2.glDeleteFramebuffers(2, this.g_frontFboId, 0);
        gL2.glDeleteFramebuffers(1, this.g_frontColorBlenderFboId, 0);
        gL2.glDeleteTextures(2, this.g_frontDepthTexId, 0);
        gL2.glDeleteTextures(2, this.g_frontColorTexId, 0);
        gL2.glDeleteTextures(1, this.g_frontColorBlenderTexId, 0);
    }

    void InitAccumulationRenderTargets(GL2 gL2) {
        gL2.glGenTextures(2, this.g_accumulationTexId, 0);
        gL2.glBindTexture(34037, this.g_accumulationTexId[0]);
        gL2.glTexParameteri(34037, 10242, 10496);
        gL2.glTexParameteri(34037, 10243, 10496);
        gL2.glTexParameteri(34037, 10241, 9728);
        gL2.glTexParameteri(34037, 10240, 9728);
        gL2.glTexImage2D(34037, 0, 34842, this.g_imageWidth, this.g_imageHeight, 0, 6408, 5126, null);
        gL2.glBindTexture(34037, this.g_accumulationTexId[1]);
        gL2.glTexParameteri(34037, 10242, 10496);
        gL2.glTexParameteri(34037, 10243, 10496);
        gL2.glTexParameteri(34037, 10241, 9728);
        gL2.glTexParameteri(34037, 10240, 9728);
        gL2.glTexImage2D(34037, 0, 34949, this.g_imageWidth, this.g_imageHeight, 0, 6408, 5126, null);
        gL2.glGenFramebuffers(1, this.g_accumulationFboId, 0);
        gL2.glBindFramebuffer(36160, this.g_accumulationFboId[0]);
        gL2.glFramebufferTexture2D(36160, 36064, 34037, this.g_accumulationTexId[0], 0);
        gL2.glFramebufferTexture2D(36160, 36065, 34037, this.g_accumulationTexId[1], 0);
    }

    void DeleteAccumulationRenderTargets(GL2 gL2) {
        gL2.glDeleteFramebuffers(1, this.g_accumulationFboId, 0);
        gL2.glDeleteTextures(2, this.g_accumulationTexId, 0);
    }

    void MakeFullScreenQuad(GL2 gL2) {
        GLU gLU = GLU.createGLU((GL)gL2);
        this.g_quadDisplayList = gL2.glGenLists(1);
        gL2.glNewList(this.g_quadDisplayList, 4864);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gLU.gluOrtho2D(0.0f, 1.0f, 0.0f, 1.0f);
        gL2.glBegin(7);
        gL2.glVertex2f(0.0f, 0.0f);
        gL2.glVertex2f(1.0f, 0.0f);
        gL2.glVertex2f(1.0f, 1.0f);
        gL2.glVertex2f(0.0f, 1.0f);
        gL2.glEnd();
        gL2.glPopMatrix();
        gL2.glEndList();
    }

    void LoadModel(GL2 gL2, String string) {
        this.g_model = new Model();
        System.err.println("loading OBJ...\n");
        this.g_model.loadModelFromFile(DemosDataAnchor.class, string);
        System.err.println("compiling mesh...\n");
        this.g_model.compileModel();
        System.err.println(this.g_model.getPositionCount() + " vertices");
        System.err.println(this.g_model.getIndexCount() / 3 + " triangles");
        int n = this.g_model.getCompiledVertexCount() * 4;
        int n2 = this.g_model.getCompiledIndexCount() * 4;
        gL2.glGenBuffers(1, this.g_vboId, 0);
        gL2.glBindBuffer(34962, this.g_vboId[0]);
        gL2.glBufferData(34962, (long)n, (Buffer)this.g_model.getCompiledVertices(), 35044);
        gL2.glBindBuffer(34962, 0);
        gL2.glGenBuffers(1, this.g_eboId, 0);
        gL2.glBindBuffer(34963, this.g_eboId[0]);
        gL2.glBufferData(34963, (long)n2, (Buffer)this.g_model.getCompiledIndices(), 35044);
        gL2.glBindBuffer(34963, 0);
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        this.g_model.computeBoundingBox(fArray, fArray2);
        float[] fArray3 = new float[]{fArray2[0] - fArray[0], fArray2[1] - fArray[1], fArray2[2] - fArray[2]};
        this.g_bbScale = (float)(1.0 / Math.sqrt(fArray3[0] * fArray3[0] + fArray3[1] * fArray3[1] + fArray3[2] * fArray3[2]) * 1.5);
        this.g_bbTrans = new float[]{(float)((double)(-this.g_bbScale) * ((double)fArray[0] + 0.5 * (double)fArray3[0])), (float)((double)(-this.g_bbScale) * ((double)fArray[1] + 0.5 * (double)fArray3[1])), (float)((double)(-this.g_bbScale) * ((double)fArray[2] + 0.5 * (double)fArray3[2]))};
    }

    void DrawModel(GL2 gL2) {
        gL2.glBindBuffer(34962, this.g_vboId[0]);
        gL2.glBindBuffer(34963, this.g_eboId[0]);
        int n = this.g_model.getCompiledVertexSize() * 4;
        int n2 = this.g_model.getCompiledNormalOffset() * 4;
        gL2.glVertexPointer(this.g_model.getPositionSize(), 5126, n, 0L);
        gL2.glNormalPointer(5126, n, (long)n2);
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32885);
        gL2.glDrawElements(4, this.g_model.getCompiledIndexCount(), 5125, 0L);
        gL2.glBindBuffer(34963, 0);
        gL2.glBindBuffer(34962, 0);
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32885);
        ++this.g_numGeoPasses;
    }

    public GLCanvas GetCanvas() {
        return this.m_kCanvas;
    }

    ShaderProgram build(GL2ES2 gL2ES2, String string, boolean bl) {
        ShaderProgram shaderProgram = new ShaderProgram();
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, DualDepthPeeling.class, (String)"shader", null, (String)string, (boolean)false);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, DualDepthPeeling.class, (String)"shader", null, (String)string, (boolean)false);
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (bl && !shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        return shaderProgram;
    }

    ShaderProgram build(GL2ES2 gL2ES2, String[] stringArray, boolean bl) {
        ShaderProgram shaderProgram = new ShaderProgram();
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, (int)stringArray.length, DualDepthPeeling.class, (String)"shader", (String[])stringArray, null, null, (boolean)false);
        shaderProgram.add(shaderCode);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, (int)stringArray.length, DualDepthPeeling.class, (String)"shader", (String[])stringArray, null, null, (boolean)false);
        shaderProgram.add(shaderCode2);
        if (bl && !shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        return shaderProgram;
    }

    void BuildShaders(GL2 gL2) {
        System.err.println("\nloading shaders...\n");
        this.g_shaderState = new ShaderState();
        this.g_shaderDualInit = this.build((GL2ES2)gL2, "dual_peeling_init", true);
        this.g_shaderDualPeel = this.build((GL2ES2)gL2, new String[]{"shade", "dual_peeling_peel"}, true);
        this.g_shaderDualBlend = this.build((GL2ES2)gL2, "dual_peeling_blend", true);
        this.g_shaderDualFinal = this.build((GL2ES2)gL2, "dual_peeling_final", true);
        this.g_shaderFrontInit = this.build((GL2ES2)gL2, new String[]{"shade", "front_peeling_init"}, true);
        this.g_shaderFrontPeel = this.build((GL2ES2)gL2, new String[]{"shade", "front_peeling_peel"}, true);
        this.g_shaderFrontBlend = this.build((GL2ES2)gL2, "front_peeling_blend", true);
        this.g_shaderFrontFinal = this.build((GL2ES2)gL2, "front_peeling_final", true);
        this.g_shaderAverageInit = this.build((GL2ES2)gL2, new String[]{"shade", "wavg_init"}, true);
        this.g_shaderAverageFinal = this.build((GL2ES2)gL2, "wavg_final", true);
        this.g_shaderWeightedSumInit = this.build((GL2ES2)gL2, new String[]{"shade", "wsum_init"}, true);
        this.g_shaderWeightedSumFinal = this.build((GL2ES2)gL2, "wsum_final", true);
        this.g_DepthBlenderTexUnit = new GLUniformData(s_DepthBlenderTex, 0);
        this.g_shaderState.ownUniform(this.g_DepthBlenderTexUnit);
        this.g_FrontBlenderTexUnit = new GLUniformData(s_FrontBlenderTex, 1);
        this.g_shaderState.ownUniform(this.g_FrontBlenderTexUnit);
        this.g_BackBlenderTexUnit = new GLUniformData(s_BackBlenderTex, 2);
        this.g_shaderState.ownUniform(this.g_BackBlenderTexUnit);
        this.g_TempTexUnit = new GLUniformData(s_TempTex, 0);
        this.g_shaderState.ownUniform(this.g_TempTexUnit);
        this.g_AlphaUni = new GLUniformData("Alpha", this.g_opacity);
        this.g_shaderState.ownUniform(this.g_AlphaUni);
        this.g_backgroundColorUni = new GLUniformData(s_BackgroundColor, 3, this.g_backgroundColor);
        this.g_shaderState.ownUniform(this.g_backgroundColorUni);
        this.g_ColorTexUnit = new GLUniformData(s_ColorTex, 0);
        this.g_shaderState.ownUniform(this.g_ColorTexUnit);
        this.g_ColorTex0Unit = new GLUniformData(s_ColorTex0, 0);
        this.g_shaderState.ownUniform(this.g_ColorTex0Unit);
        this.g_ColorTex1Unit = new GLUniformData(s_ColorTex1, 1);
        this.g_shaderState.ownUniform(this.g_ColorTex1Unit);
    }

    void DestroyShaders(GL2 gL2) {
        this.g_shaderState.release((GL2ES2)gL2, false, false, false);
        this.g_shaderDualInit.destroy((GL2ES2)gL2);
        this.g_shaderDualPeel.destroy((GL2ES2)gL2);
        this.g_shaderDualBlend.destroy((GL2ES2)gL2);
        this.g_shaderDualFinal.destroy((GL2ES2)gL2);
        this.g_shaderFrontInit.destroy((GL2ES2)gL2);
        this.g_shaderFrontPeel.destroy((GL2ES2)gL2);
        this.g_shaderFrontBlend.destroy((GL2ES2)gL2);
        this.g_shaderFrontFinal.destroy((GL2ES2)gL2);
        this.g_shaderAverageInit.destroy((GL2ES2)gL2);
        this.g_shaderAverageFinal.destroy((GL2ES2)gL2);
        this.g_shaderWeightedSumInit.destroy((GL2ES2)gL2);
        this.g_shaderWeightedSumFinal.destroy((GL2ES2)gL2);
    }

    void ReloadShaders(GL2 gL2) {
        this.DestroyShaders(gL2);
        this.BuildShaders(gL2);
    }

    void InitGL() {
        GLProfile gLProfile = GLProfile.getMaxProgrammable((boolean)true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setHardwareAccelerated(true);
        this.m_kCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        this.m_kCanvas.setSize(this.g_imageWidth, this.g_imageHeight);
        this.m_kCanvas.addGLEventListener((GLEventListener)this);
        this.m_kCanvas.addKeyListener((KeyListener)this);
        this.m_kCanvas.addMouseListener((MouseListener)this);
        this.m_kCanvas.addMouseMotionListener((MouseMotionListener)this);
    }

    void RenderDualPeeling(GL2 gL2) {
        gL2.glDisable(2929);
        gL2.glEnable(3042);
        gL2.glBindFramebuffer(36160, this.g_dualPeelingSingleFboId[0]);
        gL2.glDrawBuffers(2, this.g_drawBuffers, 1);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glClear(16384);
        gL2.glDrawBuffer(this.g_drawBuffers[0]);
        gL2.glClearColor(-1.0f, -1.0f, 0.0f, 0.0f);
        gL2.glClear(16384);
        gL2.glBlendEquation(32776);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderDualInit, true);
        this.DrawModel(gL2);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
        gL2.glDrawBuffer(this.g_drawBuffers[6]);
        gL2.glClearColor(this.g_backgroundColor.get(0), this.g_backgroundColor.get(1), this.g_backgroundColor.get(2), 0.0f);
        gL2.glClear(16384);
        int n = 0;
        for (int i = 1; this.g_useOQ || i < this.g_numPasses; ++i) {
            n = i % 2;
            int n2 = 1 - n;
            int n3 = n * 3;
            gL2.glDrawBuffers(2, this.g_drawBuffers, n3 + 1);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glClear(16384);
            gL2.glDrawBuffer(this.g_drawBuffers[n3 + 0]);
            gL2.glClearColor(-1.0f, -1.0f, 0.0f, 0.0f);
            gL2.glClear(16384);
            gL2.glDrawBuffers(3, this.g_drawBuffers, n3 + 0);
            gL2.glBlendEquation(32776);
            this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderDualPeel, true);
            GLHelper.bindTextureRECT(gL2, this.g_dualDepthTexId[n2], this.g_DepthBlenderTexUnit.intValue());
            GLHelper.bindTextureRECT(gL2, this.g_dualFrontBlenderTexId[n2], this.g_FrontBlenderTexUnit.intValue());
            this.DrawModel(gL2);
            this.g_shaderState.useProgram((GL2ES2)gL2, false);
            gL2.glDrawBuffer(this.g_drawBuffers[6]);
            gL2.glBlendEquation(32774);
            gL2.glBlendFunc(770, 771);
            if (this.g_useOQ) {
                gL2.glBeginQuery(35092, this.g_queryId[0]);
            }
            this.g_TempTexUnit.setData(0);
            this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderDualBlend, true);
            GLHelper.bindTextureRECT(gL2, this.g_dualBackTempTexId[n], this.g_TempTexUnit.intValue());
            gL2.glCallList(this.g_quadDisplayList);
            this.g_shaderState.useProgram((GL2ES2)gL2, false);
            if (!this.g_useOQ) continue;
            gL2.glEndQuery(35092);
            int[] nArray = new int[]{0};
            gL2.glGetQueryObjectuiv(this.g_queryId[0], 34918, nArray, 0);
            if (nArray[0] == 0) break;
        }
        gL2.glDisable(3042);
        gL2.glBindFramebuffer(36160, 0);
        gL2.glDrawBuffer(1029);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderDualFinal, true);
        GLHelper.bindTextureRECT(gL2, this.g_dualFrontBlenderTexId[n], this.g_FrontBlenderTexUnit.intValue());
        GLHelper.bindTextureRECT(gL2, this.g_dualBackBlenderTexId[0], this.g_BackBlenderTexUnit.intValue());
        gL2.glCallList(this.g_quadDisplayList);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
    }

    void RenderFrontToBackPeeling(GL2 gL2) {
        gL2.glBindFramebuffer(36160, this.g_frontColorBlenderFboId[0]);
        gL2.glDrawBuffer(this.g_drawBuffers[0]);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glClear(16640);
        gL2.glEnable(2929);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderFrontInit, true);
        this.DrawModel(gL2);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
        int n = (this.g_numPasses - 1) * 2;
        for (int i = 1; this.g_useOQ || i < n; ++i) {
            int n2 = i % 2;
            int n3 = 1 - n2;
            gL2.glBindFramebuffer(36160, this.g_frontFboId[n2]);
            gL2.glDrawBuffer(this.g_drawBuffers[0]);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glClear(16640);
            gL2.glDisable(3042);
            gL2.glEnable(2929);
            if (this.g_useOQ) {
                gL2.glBeginQuery(35092, this.g_queryId[0]);
            }
            this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderDualPeel, true);
            GLHelper.bindTextureRECT(gL2, this.g_frontDepthTexId[n3], this.g_DepthBlenderTexUnit.intValue());
            this.DrawModel(gL2);
            this.g_shaderState.useProgram((GL2ES2)gL2, false);
            if (this.g_useOQ) {
                gL2.glEndQuery(35092);
            }
            gL2.glBindFramebuffer(36160, this.g_frontColorBlenderFboId[0]);
            gL2.glDrawBuffer(this.g_drawBuffers[0]);
            gL2.glDisable(2929);
            gL2.glEnable(3042);
            gL2.glBlendEquation(32774);
            gL2.glBlendFuncSeparate(772, 1, 0, 771);
            this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderDualBlend, true);
            GLHelper.bindTextureRECT(gL2, this.g_frontColorTexId[n2], this.g_TempTexUnit.intValue());
            gL2.glCallList(this.g_quadDisplayList);
            this.g_shaderState.useProgram((GL2ES2)gL2, false);
            gL2.glDisable(3042);
            if (!this.g_useOQ) continue;
            int[] nArray = new int[]{0};
            gL2.glGetQueryObjectuiv(this.g_queryId[0], 34918, nArray, 0);
            if (nArray[0] == 0) break;
        }
        gL2.glBindFramebuffer(36160, 0);
        gL2.glDrawBuffer(1029);
        gL2.glDisable(2929);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderFrontFinal, true);
        GLHelper.bindTextureRECT(gL2, this.g_frontColorBlenderTexId[0], this.g_ColorTexUnit.intValue());
        gL2.glCallList(this.g_quadDisplayList);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
    }

    void RenderAverageColors(GL2 gL2) {
        gL2.glDisable(2929);
        gL2.glBindFramebuffer(36160, this.g_accumulationFboId[0]);
        gL2.glDrawBuffers(2, this.g_drawBuffers, 0);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glClear(16384);
        gL2.glBlendEquation(32774);
        gL2.glBlendFunc(1, 1);
        gL2.glEnable(3042);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderAverageInit, true);
        this.DrawModel(gL2);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
        gL2.glDisable(3042);
        gL2.glBindFramebuffer(36160, 0);
        gL2.glDrawBuffer(1029);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderAverageFinal, true);
        GLHelper.bindTextureRECT(gL2, this.g_accumulationTexId[0], this.g_ColorTex0Unit.intValue());
        GLHelper.bindTextureRECT(gL2, this.g_accumulationTexId[1], this.g_ColorTex1Unit.intValue());
        gL2.glCallList(this.g_quadDisplayList);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
    }

    void RenderWeightedSum(GL2 gL2) {
        gL2.glDisable(2929);
        gL2.glBindFramebuffer(36160, this.g_accumulationFboId[0]);
        gL2.glDrawBuffer(this.g_drawBuffers[0]);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glClear(16384);
        gL2.glBlendEquation(32774);
        gL2.glBlendFunc(1, 1);
        gL2.glEnable(3042);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderWeightedSumInit, true);
        this.DrawModel(gL2);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
        gL2.glDisable(3042);
        gL2.glBindFramebuffer(36160, 0);
        gL2.glDrawBuffer(1029);
        this.g_shaderState.attachShaderProgram((GL2ES2)gL2, this.g_shaderWeightedSumFinal, true);
        GLHelper.bindTextureRECT(gL2, this.g_accumulationTexId[0], this.g_ColorTexUnit.intValue());
        gL2.glCallList(this.g_quadDisplayList);
        this.g_shaderState.useProgram((GL2ES2)gL2, false);
    }

    public static void main(String[] stringArray) {
        System.out.println("dual_depth_peeling - sample comparing multiple order independent transparency techniques\n");
        System.out.println("  Commands:\n");
        System.out.println("     A/D       - Change uniform opacity\n");
        System.out.println("     1         - Dual peeling mode\n");
        System.out.println("     2         - Front to back peeling mode\n");
        System.out.println("     3         - Weighted average mode\n");
        System.out.println("     4         - Weighted sum mode\n");
        System.out.println("     R         - Reload all shaders\n");
        System.out.println("     B         - Change background color\n");
        System.out.println("     Q         - Toggle occlusion queries\n");
        System.out.println("     +/-       - Change number of geometry passes\n\n");
        DualDepthPeeling dualDepthPeeling = new DualDepthPeeling();
        Frame frame = new Frame("Dual Depth Peeling");
        frame.add((Component)dualDepthPeeling.GetCanvas());
        frame.setSize(dualDepthPeeling.GetCanvas().getWidth(), dualDepthPeeling.GetCanvas().getHeight());
        final Animator animator = new Animator((GLAutoDrawable)dualDepthPeeling.GetCanvas());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        frame.setVisible(true);
        animator.start();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyChar()) {
            case '\b': {
                this.g_bShowUI = !this.g_bShowUI;
                break;
            }
            case 'q': {
                this.g_useOQ = !this.g_useOQ;
                break;
            }
            case '+': {
                ++this.g_numPasses;
                break;
            }
            case '-': {
                --this.g_numPasses;
                break;
            }
            case 'b': {
                this.g_backgroundColor = this.g_backgroundColor == g_white ? g_black : g_white;
                this.g_backgroundColorUni.setData(this.g_backgroundColor);
                break;
            }
            case 'o': {
                this.g_showOsd = !this.g_showOsd;
                break;
            }
            case 'r': {
                this.reloadShaders = true;
                break;
            }
            case '1': {
                this.g_mode = '\u0000';
                break;
            }
            case '2': {
                this.g_mode = '\u0001';
                break;
            }
            case '3': {
                this.g_mode = (char)2;
                break;
            }
            case '4': {
                this.g_mode = (char)3;
                break;
            }
            case 'a': {
                this.g_opacity = (float)((double)this.g_opacity - 0.05);
                this.g_opacity = (float)Math.max((double)this.g_opacity, 0.0);
                this.g_AlphaUni.setData(this.g_opacity);
                break;
            }
            case 'd': {
                this.g_opacity = (float)((double)this.g_opacity + 0.05);
                this.g_opacity = (float)Math.min((double)this.g_opacity, 1.0);
                this.g_AlphaUni.setData(this.g_opacity);
            }
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.reloadShaders) {
            this.reloadShaders = false;
            this.ReloadShaders(gL2);
        }
        GLU gLU = GLU.createGLU((GL)gL2);
        this.g_numGeoPasses = 0;
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gLU.gluLookAt(this.g_pos[0], this.g_pos[1], this.g_pos[2], this.g_pos[0], this.g_pos[1], 0.0f, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(this.g_rot[0], 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.g_rot[1], 0.0f, 1.0f, 0.0f);
        gL2.glTranslatef(this.g_bbTrans[0], this.g_bbTrans[1], this.g_bbTrans[2]);
        gL2.glScalef(this.g_bbScale, this.g_bbScale, this.g_bbScale);
        switch (this.g_mode) {
            case '\u0000': {
                this.RenderDualPeeling(gL2);
                break;
            }
            case '\u0001': {
                this.RenderFrontToBackPeeling(gL2);
                break;
            }
            case '\u0002': {
                this.RenderAverageColors(gL2);
                break;
            }
            case '\u0003': {
                this.RenderWeightedSum(gL2);
            }
        }
        gLAutoDrawable.swapBuffers();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("init");
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.m_kCanvas.setAutoSwapBufferMode(false);
        try {
            this.InitDualPeelingRenderTargets(gL2);
        }
        catch (GLException gLException) {
            try {
                this.InitDualPeelingRenderTargets(gL2);
            }
            catch (GLException gLException2) {
                System.err.println(gLException2.getStackTrace());
            }
        }
        this.InitFrontPeelingRenderTargets(gL2);
        this.InitAccumulationRenderTargets(gL2);
        gL2.glBindFramebuffer(36160, 0);
        this.BuildShaders(gL2);
        this.LoadModel(gL2, this.MODEL_FILENAME);
        this.MakeFullScreenQuad(gL2);
        gL2.glDisable(2884);
        gL2.glDisable(2896);
        gL2.glDisable(2977);
        gL2.glGenQueries(1, this.g_queryId, 0);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.g_imageWidth != n3 || this.g_imageHeight != n4) {
            this.g_imageWidth = n3;
            this.g_imageHeight = n4;
            this.DeleteDualPeelingRenderTargets(gL2);
            this.InitDualPeelingRenderTargets(gL2);
            this.DeleteFrontPeelingRenderTargets(gL2);
            this.InitFrontPeelingRenderTargets(gL2);
            this.DeleteAccumulationRenderTargets(gL2);
            this.InitAccumulationRenderTargets(gL2);
        }
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        GLU gLU = GLU.createGLU((GL)gL2);
        gLU.gluPerspective(30.0f, (float)this.g_imageWidth / (float)this.g_imageHeight, 1.0E-4f, 10.0f);
        gL2.glMatrixMode(5888);
        gL2.glViewport(0, 0, this.g_imageWidth, this.g_imageHeight);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.g_oldX = this.g_newX;
        this.g_oldY = this.g_newY;
        this.g_newX = mouseEvent.getX();
        this.g_newY = mouseEvent.getY();
        float f = (float)(this.g_newX - this.g_oldX) / (float)this.g_imageWidth;
        float f2 = (float)(this.g_newY - this.g_oldY) / (float)this.g_imageHeight;
        if (this.g_rotating) {
            this.g_rot[1] = this.g_rot[1] + f * 180.0f;
            this.g_rot[0] = this.g_rot[0] + f2 * 180.0f;
        } else if (this.g_panning) {
            this.g_pos[0] = this.g_pos[0] - f;
            this.g_pos[1] = this.g_pos[1] + f2;
        } else if (this.g_scaling) {
            this.g_pos[2] = this.g_pos[2] - f2 * this.g_pos[2];
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.g_newX = mouseEvent.getX();
        this.g_newY = mouseEvent.getY();
        this.g_scaling = false;
        this.g_panning = false;
        this.g_rotating = false;
        if (mouseEvent.getButton() == 1) {
            if (mouseEvent.isShiftDown()) {
                this.g_scaling = true;
            } else if (mouseEvent.isControlDown()) {
                this.g_panning = true;
            } else {
                this.g_rotating = true;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

