/*
 * Decompiled with CFR 0.152.
 */
package demos.context;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DualContext
extends Canvas {
    private GLDrawable drawable;
    private GLContext context1;
    private GLContext context2;
    private GLU glu;
    private GLUT glut;
    private int repaintNum;

    public DualContext(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        super(DualContext.unwrap(aWTGraphicsConfiguration));
        NativeWindowFactory.getFactory(this.getClass());
        NativeWindow nativeWindow = NativeWindowFactory.getNativeWindow((Object)this, (AbstractGraphicsConfiguration)aWTGraphicsConfiguration);
        GLCapabilities gLCapabilities = (GLCapabilities)nativeWindow.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
        this.drawable = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile()).createGLDrawable((NativeSurface)nativeWindow);
        this.context1 = this.drawable.createContext(null);
        this.context2 = this.drawable.createContext(null);
        this.glu = new GLU();
        this.glut = new GLUT();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.drawable.setRealized(true);
    }

    @Override
    public void removeNotify() {
        this.context1.destroy();
        this.context2.destroy();
        this.drawable.setRealized(false);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        String string = "" + ++this.repaintNum;
        int n4 = this.context1.makeCurrent();
        if (n4 != 0) {
            this.clearAndDraw(this.context1.getGL().getGL2(), 1.0f, 0.0f, 0.0f, 0, 0, n3, n2, string);
            this.context1.release();
        }
        if ((n4 = this.context2.makeCurrent()) != 0) {
            this.clearAndDraw(this.context2.getGL().getGL2(), 0.0f, 0.0f, 1.0f, n3, 0, n - n3, n2, string);
            this.context2.release();
        }
        this.drawable.swapBuffers();
    }

    private void clearAndDraw(GL2 gL2, float f, float f2, float f3, int n, int n2, int n3, int n4, String string) {
        gL2.glViewport(n, n2, n3, n4);
        gL2.glScissor(n, n2, n3, n4);
        gL2.glEnable(3089);
        gL2.glClearColor(f, f2, f3, 1.0f);
        gL2.glClear(16640);
        float f4 = this.glut.glutStrokeLengthf(0, string);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluOrtho2D((float)n, (float)(n + n3), (float)n2, (float)(n2 + n4));
        gL2.glTranslatef((float)n + ((float)n3 - f4) / 2.0f, (float)(n2 + n4 / 2), 0.0f);
        this.glut.glutStrokeString(0, string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Dual OpenGL Context Test");
        GLProfile gLProfile = GLProfile.getDefault();
        AWTGraphicsScreen aWTGraphicsScreen = (AWTGraphicsScreen)AWTGraphicsScreen.createDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, gLCapabilities.getClass()).chooseGraphicsConfiguration((CapabilitiesImmutable)gLCapabilities, (CapabilitiesImmutable)gLCapabilities, null, (AbstractGraphicsScreen)aWTGraphicsScreen, 0);
        final DualContext dualContext = new DualContext(aWTGraphicsConfiguration);
        jFrame.getContentPane().add((Component)dualContext, "Center");
        JButton jButton = new JButton("Repaint");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dualContext.repaint();
            }
        });
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)jButton, "South");
        jFrame.setSize(800, 400);
        jFrame.setVisible(true);
    }

    private static GraphicsConfiguration unwrap(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        if (aWTGraphicsConfiguration == null) {
            return null;
        }
        return aWTGraphicsConfiguration.getAWTGraphicsConfiguration();
    }
}

