/*
 * Decompiled with CFR 0.152.
 */
package demos.cubefbo;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

class CubeObject {
    static final float[] light_position = new float[]{-50.0f, 50.0f, 50.0f, 0.0f};
    static final float[] light_ambient = new float[]{0.125f, 0.125f, 0.125f, 1.0f};
    static final float[] light_diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] material_spec = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    static final float[] zero_vec4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    boolean initialized = false;
    ShortBuffer cubeVertices = Buffers.newDirectShortBuffer((int)s_cubeVertices.length);
    ShortBuffer cubeTexCoords;
    ByteBuffer cubeColors;
    ByteBuffer cubeNormals;
    ByteBuffer cubeIndices;
    private static final short[] s_cubeVertices = new short[]{-10, 10, 10, 10, -10, 10, 10, 10, 10, -10, -10, 10, -10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10, -10, -10, -10, 10, 10, -10, -10, 10, -10, 10, -10, -10, -10, -10, 10, 10, 10, 10, -10, 10, 10, 10, -10, 10, -10, 10, -10, 10, 10, 10, -10, 10, 10, 10, 10, -10, -10, -10, -10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10};
    private static final short[] s_cubeTexCoords = new short[]{0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0};
    private static final byte[] s_cubeColors = new byte[]{0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1, 0, -128, 0, -1};
    private static final byte[] s_cubeIndices = new byte[]{0, 3, 1, 2, 0, 1, 6, 5, 4, 5, 7, 4, 8, 11, 9, 10, 8, 9, 15, 12, 13, 12, 14, 13, 16, 19, 17, 18, 16, 17, 23, 20, 21, 20, 22, 21};
    private static final byte[] s_cubeNormals = new byte[]{0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0};

    CubeObject(boolean bl) {
        this.cubeVertices.put(s_cubeVertices);
        this.cubeVertices.rewind();
        this.cubeColors = Buffers.newDirectByteBuffer((int)s_cubeColors.length);
        this.cubeColors.put(s_cubeColors);
        this.cubeColors.rewind();
        this.cubeNormals = Buffers.newDirectByteBuffer((int)s_cubeNormals.length);
        this.cubeNormals.put(s_cubeNormals);
        this.cubeNormals.rewind();
        this.cubeIndices = Buffers.newDirectByteBuffer((int)s_cubeIndices.length);
        this.cubeIndices.put(s_cubeIndices);
        this.cubeIndices.rewind();
        if (bl) {
            this.cubeTexCoords = Buffers.newDirectShortBuffer((int)s_cubeTexCoords.length);
            this.cubeTexCoords.put(s_cubeTexCoords);
            this.cubeTexCoords.rewind();
        }
    }

    private void perspective(GL2 gL2, float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan((double)f * Math.PI / 360.0);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        gL2.glFrustum((double)f7, (double)f8, (double)f6, (double)f5, (double)f3, (double)f4);
    }

    public void dispose(GL2 gL2) {
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32885);
        gL2.glDisableClientState(32886);
        gL2.glDisableClientState(32888);
        this.cubeVertices.clear();
        this.cubeVertices = null;
        this.cubeColors.clear();
        this.cubeColors = null;
        this.cubeNormals.clear();
        this.cubeNormals = null;
        this.cubeIndices.clear();
        this.cubeIndices = null;
        if (null != this.cubeTexCoords) {
            this.cubeTexCoords.clear();
            this.cubeTexCoords = null;
        }
    }

    public void reshape(GL2 gL2, int n, int n2, int n3, int n4) {
        float f = n4 != 0 ? (float)n3 / (float)n4 : 1.0f;
        gL2.glViewport(0, 0, n3, n4);
        gL2.glScissor(0, 0, n3, n4);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glLightfv(16384, 4611, light_position, 0);
        gL2.glLightfv(16384, 4608, light_ambient, 0);
        gL2.glLightfv(16384, 4609, light_diffuse, 0);
        gL2.glLightfv(16384, 4610, zero_vec4, 0);
        gL2.glMaterialfv(1032, 4610, material_spec, 0);
        gL2.glEnable(2977);
        gL2.glEnable(2896);
        gL2.glEnable(16384);
        gL2.glEnable(2903);
        gL2.glEnable(2884);
        gL2.glHint(3152, 4353);
        gL2.glShadeModel(7425);
        gL2.glDisable(3024);
        gL2.glClearColor(0.0f, 0.1f, 0.0f, 1.0f);
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32885);
        gL2.glEnableClientState(32886);
        if (this.cubeTexCoords != null) {
            gL2.glEnableClientState(32888);
        } else {
            gL2.glDisableClientState(32888);
        }
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.perspective(gL2, 55.0f, f, 0.1f, 100.0f);
        gL2.glCullFace(1029);
    }

    public void display(GL2 gL2, float f, float f2) {
        gL2.glClear(16640);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(0.0f, 0.0f, -30.0f);
        gL2.glRotatef(f2, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(f, 1.0f, 0.0f, 0.0f);
        gL2.glVertexPointer(3, 5122, 0, (Buffer)this.cubeVertices);
        gL2.glColorPointer(4, 5121, 0, (Buffer)this.cubeColors);
        gL2.glNormalPointer(5120, 0, (Buffer)this.cubeNormals);
        if (this.cubeTexCoords != null) {
            gL2.glTexCoordPointer(2, 5122, 0, (Buffer)this.cubeTexCoords);
            gL2.glTexEnvi(8960, 8704, 7681);
        }
        gL2.glDrawElements(4, 36, 5121, (Buffer)this.cubeIndices);
    }
}

