/*
 * Decompiled with CFR 0.152.
 */
package demos.cubefbo;

import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import demos.cubefbo.CubeObject;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class FBCubes
implements GLEventListener,
MouseListener,
MouseMotionListener {
    private static final int FBO_SIZE = 128;
    int x;
    int y;
    int width;
    int height;
    float motionIncr;
    float xRot;
    float yRot;
    private boolean dragging;
    private int lastDragX;
    private int lastDragY;
    CubeObject cubeInner = new CubeObject(false);
    CubeObject cubeMiddle = new CubeObject(true);
    CubeObject cubeOuter = new CubeObject(true);
    FBObject fbo1 = new FBObject();
    FBObject fbo2 = new FBObject();

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.fbo1.init((GL)gL2, 128, 128, 0);
        this.fbo1.attachTexture2D((GL)gL2, 0, true);
        this.fbo1.attachRenderbuffer((GL)gL2, FBObject.Attachment.Type.DEPTH, 32);
        this.fbo1.unbind((GL)gL2);
        this.fbo2.init((GL)gL2, 128, 128, 0);
        this.fbo2.attachTexture2D((GL)gL2, 0, true);
        this.fbo2.attachRenderbuffer((GL)gL2, FBObject.Attachment.Type.DEPTH, 32);
        this.fbo2.unbind((GL)gL2);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.cubeOuter.reshape(gLAutoDrawable.getGL().getGL2(), n, n2, n3, n4);
        this.motionIncr = 180.0f / (float)Math.max(n3, n4);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.out.println("FBCubes.dispose: " + gLAutoDrawable);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.fbo1.destroy((GL)gL2);
        this.fbo2.destroy((GL)gL2);
        this.fbo1 = null;
        this.fbo2 = null;
        this.cubeInner.dispose(gL2);
        this.cubeInner = null;
        this.cubeMiddle.dispose(gL2);
        this.cubeMiddle = null;
        this.cubeOuter.dispose(gL2);
        this.cubeOuter = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.fbo1.bind((GL)gL2);
        this.cubeInner.reshape(gL2, 0, 0, 128, 128);
        this.cubeInner.display(gL2, this.xRot, this.yRot);
        this.fbo1.unbind((GL)gL2);
        FBObject fBObject = this.fbo1;
        FBObject fBObject2 = this.fbo2;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            fBObject2.bind((GL)gL2);
            gL2.glEnable(3553);
            fBObject.use((GL)gL2, (FBObject.TextureAttachment)fBObject.getColorbuffer(0));
            this.cubeMiddle.reshape(gL2, 0, 0, 128, 128);
            this.cubeMiddle.display(gL2, this.xRot, this.yRot);
            fBObject.unuse((GL)gL2);
            gL2.glDisable(3553);
            fBObject2.unbind((GL)gL2);
            FBObject fBObject3 = fBObject;
            fBObject = fBObject2;
            fBObject2 = fBObject3;
        }
        this.cubeOuter.reshape(gL2, this.x, this.y, this.width, this.height);
        gL2.glClear(16640);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glEnable(3553);
        fBObject.use((GL)gL2, (FBObject.TextureAttachment)fBObject.getColorbuffer(0));
        this.cubeOuter.display(gL2, this.xRot, this.yRot);
        fBObject.unuse((GL)gL2);
        gL2.glDisable(3553);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragging) {
            this.dragging = true;
            this.lastDragX = mouseEvent.getX();
            this.lastDragY = mouseEvent.getY();
        } else {
            this.yRot += (float)(mouseEvent.getX() - this.lastDragX) * this.motionIncr;
            this.xRot += (float)(mouseEvent.getY() - this.lastDragY) * this.motionIncr;
            this.lastDragX = mouseEvent.getX();
            this.lastDragY = mouseEvent.getY();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

