/*
 * Decompiled with CFR 0.152.
 */
package demos.es1;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class RedSquare
extends Thread
implements WindowListener,
KeyListener,
MouseListener,
GLEventListener {
    public static boolean glDebugEmu = false;
    public static boolean glDebug = false;
    public static boolean glTrace = false;
    public Window nWindow = null;
    public GLWindow window;
    private GLProfile glp;
    private GLU glu;
    private boolean quit = false;
    private final String glprofile;
    private final int type;
    Animator glAnimator = null;
    private FloatBuffer colors;
    private FloatBuffer vertices;
    public static int USE_NEWT = 0;
    public static int USE_AWT = 1;
    public static boolean oneThread = false;
    public static boolean useAnimator = false;
    public static int swapInterval = -1;

    public RedSquare() {
        this(null, USE_NEWT);
    }

    public RedSquare(String string, int n) {
        this.glprofile = string;
        this.type = n;
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    public void windowResized(WindowEvent windowEvent) {
    }

    public void windowMoved(WindowEvent windowEvent) {
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
        System.out.println("WINDOW-DESTROY NOTIFY " + Thread.currentThread() + " QUIT " + windowEvent);
        this.quit = true;
        if (null != this.glAnimator) {
            this.glAnimator.stop();
        }
    }

    public void windowDestroyed(WindowEvent windowEvent) {
        System.out.println("WINDOW-DESTROYED " + Thread.currentThread());
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.out.println("KEY-PRESSED " + Thread.currentThread() + " UNHANDLED " + keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.out.println("KEY-RELEASED " + Thread.currentThread() + " UNHANDLED " + keyEvent);
        if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
            return;
        }
        if (keyEvent.getKeyChar() == 'f') {
            System.out.println("KEY-TYPED " + Thread.currentThread() + " FULLSCREEN " + keyEvent);
            this.window.setFullscreen(!this.window.isFullscreen());
        } else if (keyEvent.getKeyChar() == 'q') {
            System.out.println("KEY-TYPED " + Thread.currentThread() + " QUIT " + keyEvent);
            this.quit = true;
            if (null != this.glAnimator) {
                this.glAnimator.stop();
            }
        } else {
            System.out.println("KEY-TYPED " + Thread.currentThread() + " UNHANDLED " + keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("MOUSE-CLICKED " + Thread.currentThread() + " UNHANDLED " + mouseEvent);
        switch (mouseEvent.getClickCount()) {
            case 1: {
                if (mouseEvent.getButton() <= 1) break;
                this.window.setFullscreen(!this.window.isFullscreen());
                break;
            }
            default: {
                this.quit = true;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
    }

    public boolean shouldQuit() {
        return this.quit;
    }

    @Override
    public void run() {
        int n = 800;
        int n2 = 480;
        this.glp = GLProfile.get((String)this.glprofile);
        System.out.println("RUN " + Thread.currentThread() + " " + this.glp);
        try {
            GLCapabilities gLCapabilities = new GLCapabilities(this.glp);
            if (0 != (this.type & USE_AWT)) {
                Display display = NewtFactory.createDisplay((String)".awt", null);
                Screen screen = NewtFactory.createScreen((Display)display, (int)0);
                this.nWindow = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
                this.nWindow.setUndecorated(false);
                this.window = GLWindow.create((Window)this.nWindow);
            } else {
                this.window = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            }
            this.window.addWindowListener((WindowListener)this);
            this.window.addMouseListener((MouseListener)this);
            this.window.addKeyListener((KeyListener)this);
            this.window.addGLEventListener((GLEventListener)this);
            this.window.setUpdateFPSFrames(300, System.err);
            this.window.setSize(n, n2);
            this.window.setVisible(true);
            this.window.setUpdateFPSFrames(300, System.err);
            if (!oneThread) {
                if (useAnimator) {
                    System.out.println("Using Animator .. " + Thread.currentThread());
                    this.glAnimator = new Animator(Thread.currentThread().getThreadGroup(), (GLAutoDrawable)this.window);
                    this.glAnimator.start();
                    while (this.glAnimator.isAnimating()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                    this.shutdown();
                } else {
                    do {
                        this.display();
                    } while (!this.quit && this.window.getTotalFPSDuration() < 11000L);
                    this.shutdown();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void display() {
        try {
            this.window.display();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            System.out.println("SHUTDOWN " + Thread.currentThread() + " START");
            this.window.destroy();
            this.window = null;
            if (null != this.nWindow) {
                this.nWindow.destroy();
                this.nWindow = null;
            }
            System.out.println("SHUTDOWN " + Thread.currentThread() + " FIN");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        if (glDebugEmu) {
            try {
                gL = gL.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", GL2ES2.class, (GL)gL, null));
                if (glTrace) {
                    gL = gL.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", GL2ES2.class, (GL)gL, (Object[])new Object[]{System.err}));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            glDebug = false;
            glTrace = false;
        }
        GL2ES1 gL2ES1 = FixedFuncUtil.wrapFixedFuncEmul((GL)gL, (ShaderSelectionMode)ShaderSelectionMode.AUTO, null);
        if (swapInterval >= 0) {
            gL2ES1.setSwapInterval(swapInterval);
        }
        if (glDebug) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", GL2ES1.class, (GL)gL2ES1, null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (glTrace) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", GL2ES1.class, (GL)gL2ES1, (Object[])new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.glu = GLU.createGLU((GL)gL2ES1);
        System.err.println(Thread.currentThread() + " Entering initialization");
        System.err.println(Thread.currentThread() + " GL Profile: " + gL2ES1.getGLProfile());
        System.err.println(Thread.currentThread() + " GL:" + gL2ES1);
        System.err.println(Thread.currentThread() + " GL_VERSION=" + gL2ES1.glGetString(7938));
        System.err.println(Thread.currentThread() + " GL_EXTENSIONS:");
        System.err.println(Thread.currentThread() + "   " + gL2ES1.glGetString(7939));
        System.err.println(Thread.currentThread() + " swapInterval: " + swapInterval + " (GL: " + gL2ES1.getSwapInterval() + ")");
        System.err.println(Thread.currentThread() + " GLU: " + this.glu);
        this.colors = Buffers.newDirectFloatBuffer((int)16);
        this.vertices = Buffers.newDirectFloatBuffer((int)12);
        this.colors.put(0, 1.0f);
        this.colors.put(1, 0.0f);
        this.colors.put(2, 0.0f);
        this.colors.put(3, 1.0f);
        this.colors.put(4, 0.0f);
        this.colors.put(5, 0.0f);
        this.colors.put(6, 1.0f);
        this.colors.put(7, 1.0f);
        this.colors.put(8, 1.0f);
        this.colors.put(9, 0.0f);
        this.colors.put(10, 0.0f);
        this.colors.put(11, 1.0f);
        this.colors.put(12, 1.0f);
        this.colors.put(13, 0.0f);
        this.colors.put(14, 0.0f);
        this.colors.put(15, 1.0f);
        this.vertices.put(0, -2.0f);
        this.vertices.put(1, 2.0f);
        this.vertices.put(2, 0.0f);
        this.vertices.put(3, 2.0f);
        this.vertices.put(4, 2.0f);
        this.vertices.put(5, 0.0f);
        this.vertices.put(6, -2.0f);
        this.vertices.put(7, -2.0f);
        this.vertices.put(8, 0.0f);
        this.vertices.put(9, 2.0f);
        this.vertices.put(10, -2.0f);
        this.vertices.put(11, 0.0f);
        gL2ES1.glEnableClientState(32884);
        gL2ES1.glEnableClientState(32886);
        gL2ES1.glVertexPointer(3, 5126, 0, (Buffer)this.vertices);
        gL2ES1.glColorPointer(4, 5126, 0, (Buffer)this.colors);
        gL2ES1.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES1.glEnable(2929);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        this.glu.gluPerspective(45.0f, (float)n3 / (float)n4, 1.0f, 100.0f);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glClear(16640);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(0.0f, 0.0f, -10.0f);
        float f = (float)this.window.getTotalFPSDuration() * 360.0f / 4000.0f;
        gL2ES1.glRotatef(f, 0.0f, 0.0f, 1.0f);
        gL2ES1.glRotatef(f, 0.0f, 1.0f, 0.0f);
        gL2ES1.glDrawArrays(5, 0, 4);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        System.out.println(Thread.currentThread() + " RedSquare.dispose: " + gL2ES1.getContext());
        gL2ES1.glDisableClientState(32884);
        gL2ES1.glDisableClientState(32886);
        this.glu = null;
        this.colors.clear();
        this.colors = null;
        this.vertices.clear();
        this.vertices = null;
        System.out.println(Thread.currentThread() + " RedSquare.dispose: FIN");
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public static void main(String[] stringArray) {
        int n = USE_NEWT;
        boolean bl = true;
        ArrayList<RedSquare> arrayList = new ArrayList<RedSquare>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-swapi")) {
                ++i;
                try {
                    swapInterval = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-trace")) {
                glTrace = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                glDebug = true;
                continue;
            }
            if (stringArray[i].equals("-debugff")) {
                glDebugEmu = true;
                continue;
            }
            if (stringArray[i].equals("-1thread")) {
                oneThread = true;
                continue;
            }
            if (stringArray[i].equals("-awt")) {
                n |= USE_AWT;
                continue;
            }
            if (stringArray[i].equals("-noedt")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-animator")) {
                useAnimator = true;
                continue;
            }
            if (!stringArray[i].startsWith("-GL")) continue;
            arrayList.add(new RedSquare(stringArray[i].substring(1), n));
        }
        if (arrayList.size() == 0) {
            arrayList.add(new RedSquare("GL2ES1", n));
        }
        NewtFactory.setUseEDT((boolean)bl);
        System.out.println(Thread.currentThread() + " RedSquare.main: Start - oneThread: " + oneThread);
        if (!oneThread) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).start();
            }
            boolean bl2 = false;
            int n2 = 0;
            while (!bl2) {
                int n3 = 0;
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    if (!((Thread)iterator2.next()).isAlive()) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n3;
                }
                if (n2 != n3) {
                    System.out.println(Thread.currentThread() + " RedSquare.main: alive changed: " + n2 + " -> " + n3);
                }
                n2 = n3;
                bl2 = 0 == n3;
            }
        } else {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).run();
            }
            while (arrayList.size() > 0) {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    RedSquare redSquare = (RedSquare)iterator.next();
                    if (redSquare.shouldQuit()) {
                        redSquare.shutdown();
                        iterator.remove();
                        continue;
                    }
                    redSquare.display();
                }
            }
        }
        System.out.println(Thread.currentThread() + " RedSquare.main: FIN");
    }
}

