/*
 * Decompiled with CFR 0.152.
 */
package demos.es1.angeles;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.FixedPoint;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLES1;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import demos.es1.angeles.CamTrack;
import demos.es1.angeles.SuperShape;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class AngelesES1
implements GLEventListener {
    private boolean blendingEnabled = true;
    private GLES1 gl;
    private GLU glu;
    private final int RUN_LENGTH = 108840;
    private final int RANDOM_UINT_MAX = 65535;
    private long sRandomSeed = 0L;
    long sStartTick = 0L;
    long sTick = 0L;
    int sCurrentCamTrack = 0;
    long sCurrentCamTrackStartTick = 0L;
    long sNextCamTrackStartTick = Integer.MAX_VALUE;
    GLObject[] sSuperShapeObjects = new GLObject[21];
    GLObject sGroundPlane;
    IntBuffer quadVertices;
    IntBuffer light0Position;
    IntBuffer light0Diffuse;
    IntBuffer light1Position;
    IntBuffer light1Diffuse;
    IntBuffer light2Position;
    IntBuffer light2Diffuse;
    IntBuffer materialSpecular;
    private int gAppAlive = 0;
    private int width;
    private int height;
    private int x;
    private int y;
    private int frames;

    public AngelesES1() {
        this(true);
    }

    public AngelesES1(boolean bl) {
        this.blendingEnabled = bl;
        this.quadVertices = Buffers.newDirectIntBuffer((int)12);
        this.quadVertices.put(new int[]{-65536, -65536, 65536, -65536, -65536, 65536, 65536, -65536, 65536, 65536, -65536, 65536});
        this.quadVertices.flip();
        this.light0Position = Buffers.newDirectIntBuffer((int)4);
        this.light0Diffuse = Buffers.newDirectIntBuffer((int)4);
        this.light1Position = Buffers.newDirectIntBuffer((int)4);
        this.light1Diffuse = Buffers.newDirectIntBuffer((int)4);
        this.light2Position = Buffers.newDirectIntBuffer((int)4);
        this.light2Diffuse = Buffers.newDirectIntBuffer((int)4);
        this.materialSpecular = Buffers.newDirectIntBuffer((int)4);
        this.light0Position.put(new int[]{-262144, 65536, 65536, 0});
        this.light0Diffuse.put(new int[]{65536, 26214, 0, 65536});
        this.light1Position.put(new int[]{65536, -131072, -65536, 0});
        this.light1Diffuse.put(new int[]{4587, 9175, 22937, 65536});
        this.light2Position.put(new int[]{-65536, 0, -262144, 0});
        this.light2Diffuse.put(new int[]{4587, 11141, 9175, 65536});
        this.materialSpecular.put(new int[]{65536, 65536, 65536, 65536});
        this.light0Position.flip();
        this.light0Diffuse.flip();
        this.light1Position.flip();
        this.light1Diffuse.flip();
        this.light2Position.flip();
        this.light2Diffuse.flip();
        this.materialSpecular.flip();
        this.seedRandom(15L);
        this.width = 0;
        this.height = 0;
        this.x = 0;
        this.y = 0;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.gl = gLAutoDrawable.getGL().getGLES1();
        this.glu = GLU.createGLU();
        this.gl.glEnable(2977);
        this.gl.glEnable(2929);
        this.gl.glDisable(2884);
        this.gl.glShadeModel(7424);
        this.gl.glEnable(2896);
        this.gl.glEnable(16384);
        this.gl.glEnable(16385);
        this.gl.glEnable(16386);
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32886);
        for (int i = 0; i < 21; ++i) {
            this.sSuperShapeObjects[i] = this.createSuperShape(SuperShape.sParams[i]);
        }
        this.sGroundPlane = this.createGroundPlane();
        this.gAppAlive = 1;
        this.sStartTick = System.currentTimeMillis();
        this.frames = 0;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        this.gl = gLAutoDrawable.getGL().getGLES1();
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glClearColorx(6553, 13107, 19660, 65536);
        this.gl.glCullFace(1028);
        this.gl.glHint(3152, 4353);
        this.gl.glShadeModel(7424);
        this.gl.glDisable(3024);
        System.out.println("reshape ..");
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        long l = System.currentTimeMillis();
        if (this.gAppAlive == 0) {
            return;
        }
        this.gl = gLAutoDrawable.getGL().getGLES1();
        this.sTick = this.sTick + l - this.sStartTick >> 1;
        if (this.sTick >= 108840L) {
            this.gAppAlive = 0;
            return;
        }
        this.gl.glClear(16640);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(45.0f, (float)this.width / (float)this.height, 0.5f, 150.0f);
        this.camTrack();
        this.configureLightAndMaterial();
        if (this.blendingEnabled) {
            this.gl.glPushMatrix();
            this.drawModels(-1.0f);
            this.gl.glPopMatrix();
        }
        this.drawGroundPlane();
        this.drawModels(1.0f);
        if (this.blendingEnabled) {
            this.drawFadeQuad();
        }
        ++this.frames;
        l = System.currentTimeMillis();
        long l2 = l - this.sStartTick;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    void seedRandom(long l) {
        this.sRandomSeed = l;
    }

    int randomUInt() {
        this.sRandomSeed = this.sRandomSeed * 214013L + 2531011L;
        return Math.abs((int)(this.sRandomSeed >> 16));
    }

    static void vector3Sub(VECTOR3 vECTOR3, VECTOR3 vECTOR32, VECTOR3 vECTOR33) {
        vECTOR3.x = vECTOR32.x - vECTOR33.x;
        vECTOR3.y = vECTOR32.y - vECTOR33.y;
        vECTOR3.z = vECTOR32.z - vECTOR33.z;
    }

    static void superShapeMap(VECTOR3 vECTOR3, float f, float f2, float f3, float f4) {
        vECTOR3.x = (float)(Math.cos(f3) * Math.cos(f4) / (double)f / (double)f2);
        vECTOR3.y = (float)(Math.sin(f3) * Math.cos(f4) / (double)f / (double)f2);
        vECTOR3.z = (float)(Math.sin(f4) / (double)f2);
    }

    float ssFunc(float f, float[] fArray) {
        return this.ssFunc(f, fArray, 0);
    }

    float ssFunc(float f, float[] fArray, int n) {
        return (float)Math.pow(Math.pow(Math.abs(Math.cos(fArray[0 + n] * f / 4.0f)) / (double)fArray[1 + n], fArray[4 + n]) + Math.pow(Math.abs(Math.sin(fArray[0 + n] * f / 4.0f)) / (double)fArray[2 + n], fArray[5 + n]), 1.0f / fArray[3 + n]);
    }

    GLObject createSuperShape(float[] fArray) {
        int n = (int)fArray[12];
        int n2 = (int)fArray[13];
        int n3 = n2 / 4;
        int n4 = n2 / 2;
        int n5 = n;
        int n6 = n4 - n3;
        int n7 = n5 * n6 * 2;
        int n8 = n7 * 3;
        float[] fArray2 = new float[3];
        GLObject gLObject = new GLObject(n8, 3, true);
        if (gLObject == null) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = (float)(this.randomUInt() % 155 + 100) / 255.0f;
        }
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = n3; j < n4; ++j) {
                float f = (float)(-Math.PI + (double)(i * 2) * Math.PI / (double)n);
                float f2 = (float)(-Math.PI + (double)((i + 1) * 2) * Math.PI / (double)n);
                float f3 = (float)(-1.5707963267948966 + (double)(j * 2) * Math.PI / (double)n2);
                float f4 = (float)(-1.5707963267948966 + (double)((j + 1) * 2) * Math.PI / (double)n2);
                float f5 = this.ssFunc(f, fArray);
                float f6 = this.ssFunc(f3, fArray, 6);
                float f7 = this.ssFunc(f2, fArray);
                float f8 = this.ssFunc(f4, fArray, 6);
                if (f5 != 0.0f && f6 != 0.0f && f7 != 0.0f && f8 != 0.0f) {
                    int n11;
                    VECTOR3 vECTOR3 = new VECTOR3();
                    VECTOR3 vECTOR32 = new VECTOR3();
                    VECTOR3 vECTOR33 = new VECTOR3();
                    VECTOR3 vECTOR34 = new VECTOR3();
                    VECTOR3 vECTOR35 = new VECTOR3();
                    VECTOR3 vECTOR36 = new VECTOR3();
                    VECTOR3 vECTOR37 = new VECTOR3();
                    AngelesES1.superShapeMap(vECTOR3, f5, f6, f, f3);
                    AngelesES1.superShapeMap(vECTOR32, f7, f6, f2, f3);
                    AngelesES1.superShapeMap(vECTOR33, f7, f8, f2, f4);
                    AngelesES1.superShapeMap(vECTOR34, f5, f8, f, f4);
                    if (j == n3 + 1) {
                        vECTOR32.z = 0.0f;
                        vECTOR3.z = 0.0f;
                    }
                    AngelesES1.vector3Sub(vECTOR35, vECTOR32, vECTOR3);
                    AngelesES1.vector3Sub(vECTOR36, vECTOR34, vECTOR3);
                    vECTOR37.x = vECTOR35.y * vECTOR36.z - vECTOR35.z * vECTOR36.y;
                    vECTOR37.y = vECTOR35.z * vECTOR36.x - vECTOR35.x * vECTOR36.z;
                    vECTOR37.z = vECTOR35.x * vECTOR36.y - vECTOR35.y * vECTOR36.x;
                    float f9 = vECTOR3.z + 0.5f;
                    for (n11 = n10 * 3; n11 < (n10 + 6) * 3; n11 += 3) {
                        gLObject.normalArray.put(n11, FixedPoint.toFixed((float)vECTOR37.x));
                        gLObject.normalArray.put(n11 + 1, FixedPoint.toFixed((float)vECTOR37.y));
                        gLObject.normalArray.put(n11 + 2, FixedPoint.toFixed((float)vECTOR37.z));
                    }
                    for (n11 = n10 * 4; n11 < (n10 + 6) * 4; n11 += 4) {
                        int[] nArray = new int[3];
                        for (int k = 0; k < 3; ++k) {
                            nArray[k] = (int)(f9 * fArray2[k] * 255.0f);
                            if (nArray[k] <= 255) continue;
                            nArray[k] = 255;
                        }
                        gLObject.colorArray.put(n11, (byte)nArray[0]);
                        gLObject.colorArray.put(n11 + 1, (byte)nArray[1]);
                        gLObject.colorArray.put(n11 + 2, (byte)nArray[2]);
                        gLObject.colorArray.put(n11 + 3, (byte)0);
                    }
                    gLObject.vertexArray.put(n10 * 3, FixedPoint.toFixed((float)vECTOR3.x));
                    gLObject.vertexArray.put(n10 * 3 + 1, FixedPoint.toFixed((float)vECTOR3.y));
                    gLObject.vertexArray.put(n10 * 3 + 2, FixedPoint.toFixed((float)vECTOR3.z));
                    gLObject.vertexArray.put(++n10 * 3, FixedPoint.toFixed((float)vECTOR32.x));
                    gLObject.vertexArray.put(n10 * 3 + 1, FixedPoint.toFixed((float)vECTOR32.y));
                    gLObject.vertexArray.put(n10 * 3 + 2, FixedPoint.toFixed((float)vECTOR32.z));
                    gLObject.vertexArray.put(++n10 * 3, FixedPoint.toFixed((float)vECTOR34.x));
                    gLObject.vertexArray.put(n10 * 3 + 1, FixedPoint.toFixed((float)vECTOR34.y));
                    gLObject.vertexArray.put(n10 * 3 + 2, FixedPoint.toFixed((float)vECTOR34.z));
                    gLObject.vertexArray.put(++n10 * 3, FixedPoint.toFixed((float)vECTOR32.x));
                    gLObject.vertexArray.put(n10 * 3 + 1, FixedPoint.toFixed((float)vECTOR32.y));
                    gLObject.vertexArray.put(n10 * 3 + 2, FixedPoint.toFixed((float)vECTOR32.z));
                    gLObject.vertexArray.put(++n10 * 3, FixedPoint.toFixed((float)vECTOR33.x));
                    gLObject.vertexArray.put(n10 * 3 + 1, FixedPoint.toFixed((float)vECTOR33.y));
                    gLObject.vertexArray.put(n10 * 3 + 2, FixedPoint.toFixed((float)vECTOR33.z));
                    gLObject.vertexArray.put(++n10 * 3, FixedPoint.toFixed((float)vECTOR34.x));
                    gLObject.vertexArray.put(n10 * 3 + 1, FixedPoint.toFixed((float)vECTOR34.y));
                    gLObject.vertexArray.put(n10 * 3 + 2, FixedPoint.toFixed((float)vECTOR34.z));
                    ++n10;
                }
                ++n9;
            }
        }
        gLObject.count = n10;
        gLObject.seal();
        return gLObject;
    }

    GLObject createGroundPlane() {
        GLObject gLObject = new GLObject(5400, 2, false);
        if (gLObject == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        for (int i = -15; i < 15; ++i) {
            for (int j = -15; j < 15; ++j) {
                byte by = (byte)((this.randomUInt() & 0x5F) + 81);
                for (int k = n2 * 4; k < (n2 + 6) * 4; k += 4) {
                    gLObject.colorArray.put(k, by);
                    gLObject.colorArray.put(k + 1, by);
                    gLObject.colorArray.put(k + 2, by);
                    gLObject.colorArray.put(k + 3, (byte)0);
                }
                for (int k = 0; k < 6; ++k) {
                    int n3 = j + (28 >> k & 1);
                    int n4 = i + (49 >> k & 1);
                    float f = (float)(Math.cos(n3 * 2) * Math.sin(n4 * 4) * 0.75);
                    gLObject.vertexArray.put(n2 * 2, FixedPoint.toFixed((float)((float)(n3 * 4) + f)));
                    gLObject.vertexArray.put(n2 * 2 + 1, FixedPoint.toFixed((float)((float)(n4 * 4) + f)));
                    ++n2;
                }
                ++n;
            }
        }
        gLObject.seal();
        return gLObject;
    }

    void drawGroundPlane() {
        this.gl.glDisable(2896);
        this.gl.glDisable(2929);
        if (this.blendingEnabled) {
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(0, 768);
        }
        this.sGroundPlane.draw();
        if (this.blendingEnabled) {
            this.gl.glDisable(3042);
        }
        this.gl.glEnable(2929);
        this.gl.glEnable(2896);
    }

    void drawFadeQuad() {
        int n;
        int n2 = (int)(this.sTick - this.sCurrentCamTrackStartTick);
        int n3 = (int)(this.sNextCamTrackStartTick - this.sTick);
        int n4 = n = n2 < n3 ? n2 : n3;
        if (n < 1024) {
            int n5 = n << 7;
            this.gl.glColor4x(n5, n5, n5, 0);
            this.gl.glDisable(2929);
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(0, 768);
            this.gl.glDisable(2896);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glBindBuffer(34962, 0);
            this.gl.glDisableClientState(32886);
            this.gl.glDisableClientState(32885);
            this.gl.glVertexPointer(2, 5132, 0, (Buffer)this.quadVertices);
            this.gl.glDrawArrays(4, 0, 6);
            this.gl.glEnableClientState(32886);
            this.gl.glMatrixMode(5888);
            this.gl.glEnable(2896);
            this.gl.glDisable(3042);
            this.gl.glEnable(2929);
        }
    }

    void configureLightAndMaterial() {
        this.gl.glLightxv(16384, 4611, this.light0Position);
        this.gl.glLightxv(16384, 4609, this.light0Diffuse);
        this.gl.glLightxv(16385, 4611, this.light1Position);
        this.gl.glLightxv(16385, 4609, this.light1Diffuse);
        this.gl.glLightxv(16386, 4611, this.light2Position);
        this.gl.glLightxv(16386, 4609, this.light2Diffuse);
        this.gl.glMaterialxv(1032, 4610, this.materialSpecular);
        this.gl.glMaterialx(1032, 5633, 0x3C0000);
        this.gl.glEnable(2903);
    }

    void drawModels(float f) {
        int n;
        float f2;
        int n2;
        int n3;
        this.seedRandom(9L);
        this.gl.glScalex(65536, 65536, FixedPoint.toFixed((float)f));
        for (int i = -5; i <= 5; ++i) {
            for (n3 = -5; n3 <= 5; ++n3) {
                n2 = this.randomUInt() % 21;
                f2 = SuperShape.sParams[n2][14];
                n = FixedPoint.toFixed((float)f2);
                this.gl.glPushMatrix();
                this.gl.glTranslatex(FixedPoint.toFixed((int)(n3 * 9)), FixedPoint.toFixed((int)(i * 9)), 0);
                this.gl.glRotatex(FixedPoint.toFixed((int)(this.randomUInt() % 360 << 16)), 0, 0, 65536);
                this.gl.glScalex(n, n, n);
                this.sSuperShapeObjects[n2].draw();
                this.gl.glPopMatrix();
            }
        }
        for (n3 = -2; n3 <= 2; ++n3) {
            n2 = n3 * 4500 + (int)(this.sTick % 4500L);
            f2 = (float)n2 * 0.01f;
            n = FixedPoint.toFixed((float)f2);
            this.gl.glPushMatrix();
            this.gl.glTranslatex(n, -262144, 131072);
            this.sSuperShapeObjects[20].draw();
            this.gl.glPopMatrix();
            this.gl.glPushMatrix();
            this.gl.glTranslatex(-262144, n, 262144);
            this.gl.glRotatex(0x5A0000, 0, 0, 65536);
            this.sSuperShapeObjects[20].draw();
            this.gl.glPopMatrix();
        }
    }

    void camTrack() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float[] fArray = new float[5];
        if (this.sNextCamTrackStartTick <= this.sTick) {
            ++this.sCurrentCamTrack;
            this.sCurrentCamTrackStartTick = this.sNextCamTrackStartTick;
        }
        this.sNextCamTrackStartTick = this.sCurrentCamTrackStartTick + (long)(CamTrack.sCamTracks[this.sCurrentCamTrack].len * 5442);
        CamTrack camTrack = CamTrack.sCamTracks[this.sCurrentCamTrack];
        long l = this.sTick - this.sCurrentCamTrackStartTick;
        float f7 = (float)l / (float)(5442 * camTrack.len);
        for (int i = 0; i < 5; ++i) {
            fArray[i] = ((float)camTrack.src[i] + (float)camTrack.dest[i] * f7) * 0.01f;
        }
        if (camTrack.dist > 0) {
            float f8 = (float)camTrack.dist * 0.1f;
            f6 = fArray[0];
            f5 = fArray[1];
            f4 = fArray[2];
            f3 = f6 - (float)Math.cos(fArray[3]) * f8;
            f2 = f5 - (float)Math.sin(fArray[3]) * f8;
            f = f4 - fArray[4];
        } else {
            f3 = fArray[0];
            f2 = fArray[1];
            f = fArray[2];
            f6 = f3 + (float)Math.cos(fArray[3]);
            f5 = f2 + (float)Math.sin(fArray[3]);
            f4 = f + fArray[4];
        }
        this.glu.gluLookAt(f3, f2, f, f6, f5, f4, 0.0f, 0.0f, 1.0f);
    }

    public class GLObject {
        IntBuffer vertexArray;
        ByteBuffer colorArray;
        IntBuffer normalArray;
        int vertexComponents;
        int count;
        int[] vbo;

        public GLObject(int n, int n2, boolean bl) {
            this.count = n;
            this.vertexComponents = n2;
            this.vertexArray = Buffers.newDirectIntBuffer((int)(n * n2));
            this.colorArray = Buffers.newDirectByteBuffer((int)(n * 4));
            this.normalArray = bl ? Buffers.newDirectIntBuffer((int)(n * 3)) : null;
        }

        void seal() {
            this.flip();
            this.vbo = new int[3];
            AngelesES1.this.gl.glGenBuffers(3, this.vbo, 0);
            AngelesES1.this.gl.glBindBuffer(34962, this.vbo[0]);
            AngelesES1.this.gl.glBufferData(34962, (long)(this.vertexArray.capacity() * 4), (Buffer)this.vertexArray, 35044);
            AngelesES1.this.gl.glVertexPointer(this.vertexComponents, 5132, 0, 0L);
            AngelesES1.this.gl.glBindBuffer(34962, this.vbo[1]);
            AngelesES1.this.gl.glBufferData(34962, (long)(this.colorArray.capacity() * 1), (Buffer)this.colorArray, 35044);
            AngelesES1.this.gl.glColorPointer(4, 5121, 0, 0L);
            if (null != this.normalArray) {
                AngelesES1.this.gl.glEnableClientState(32885);
                AngelesES1.this.gl.glBindBuffer(34962, this.vbo[2]);
                AngelesES1.this.gl.glBufferData(34962, (long)(this.normalArray.capacity() * 4), (Buffer)this.normalArray, 35044);
                AngelesES1.this.gl.glNormalPointer(5132, 0, 0L);
            } else {
                AngelesES1.this.gl.glDisableClientState(32885);
            }
        }

        void draw() {
            AngelesES1.this.gl.glBindBuffer(34962, this.vbo[0]);
            AngelesES1.this.gl.glVertexPointer(this.vertexComponents, 5132, 0, 0L);
            AngelesES1.this.gl.glBindBuffer(34962, this.vbo[1]);
            AngelesES1.this.gl.glColorPointer(4, 5121, 0, 0L);
            if (null != this.normalArray) {
                AngelesES1.this.gl.glEnableClientState(32885);
                AngelesES1.this.gl.glBindBuffer(34962, this.vbo[2]);
                AngelesES1.this.gl.glNormalPointer(5132, 0, 0L);
            } else {
                AngelesES1.this.gl.glDisableClientState(32885);
            }
            AngelesES1.this.gl.glDrawArrays(4, 0, this.count);
        }

        void rewind() {
            this.vertexArray.rewind();
            this.colorArray.rewind();
            if (this.normalArray != null) {
                this.normalArray.rewind();
            }
        }

        void flip() {
            this.vertexArray.flip();
            this.colorArray.flip();
            if (this.normalArray != null) {
                this.normalArray.flip();
            }
        }
    }

    public class VECTOR3 {
        float x;
        float y;
        float z;

        public VECTOR3() {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        }

        public VECTOR3(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }
}

