/*
 * Decompiled with CFR 0.152.
 */
package demos.es1.angeles;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.FixedPoint;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import demos.es1.angeles.CamTrack;
import demos.es1.angeles.SuperShape;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class AngelesGL
implements GLEventListener {
    private boolean blendingEnabled = true;
    private GL2ES1 gl;
    private GLU glu;
    private final int RUN_LENGTH = 108840;
    private final int RANDOM_UINT_MAX = 65535;
    private long sRandomSeed = 0L;
    private int cComps;
    long sStartTick = 0L;
    long sTick = 0L;
    int sCurrentCamTrack = 0;
    long sCurrentCamTrackStartTick = 0L;
    long sNextCamTrackStartTick = Integer.MAX_VALUE;
    GLSpatial[] sSuperShapeObjects = new GLSpatial[21];
    GLSpatial sGroundPlane;
    FloatBuffer quadVertices;
    FloatBuffer light0Position;
    FloatBuffer light0Diffuse;
    FloatBuffer light1Position;
    FloatBuffer light1Diffuse;
    FloatBuffer light2Position;
    FloatBuffer light2Diffuse;
    FloatBuffer materialSpecular;
    private int gAppAlive = 0;
    private int width;
    private int height;
    private int x;
    private int y;
    private int frames;

    public AngelesGL() {
        this(true);
    }

    public AngelesGL(boolean bl) {
        this.blendingEnabled = bl;
        this.quadVertices = Buffers.newDirectFloatBuffer((int)12);
        this.quadVertices.put(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f});
        this.quadVertices.flip();
        this.light0Position = Buffers.newDirectFloatBuffer((int)4);
        this.light0Diffuse = Buffers.newDirectFloatBuffer((int)4);
        this.light1Position = Buffers.newDirectFloatBuffer((int)4);
        this.light1Diffuse = Buffers.newDirectFloatBuffer((int)4);
        this.light2Position = Buffers.newDirectFloatBuffer((int)4);
        this.light2Diffuse = Buffers.newDirectFloatBuffer((int)4);
        this.materialSpecular = Buffers.newDirectFloatBuffer((int)4);
        this.light0Position.put(new float[]{FixedPoint.toFloat((int)-262144), 1.0f, 1.0f, 0.0f});
        this.light0Diffuse.put(new float[]{1.0f, FixedPoint.toFloat((int)26214), 0.0f, 1.0f});
        this.light1Position.put(new float[]{1.0f, FixedPoint.toFloat((int)-131072), -1.0f, 0.0f});
        this.light1Diffuse.put(new float[]{FixedPoint.toFloat((int)4587), FixedPoint.toFloat((int)9175), FixedPoint.toFloat((int)22937), 1.0f});
        this.light2Position.put(new float[]{-1.0f, 0.0f, FixedPoint.toFloat((int)-262144), 0.0f});
        this.light2Diffuse.put(new float[]{FixedPoint.toFloat((int)4587), FixedPoint.toFloat((int)11141), FixedPoint.toFloat((int)9175), 1.0f});
        this.materialSpecular.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.light0Position.flip();
        this.light0Diffuse.flip();
        this.light1Position.flip();
        this.light1Diffuse.flip();
        this.light2Position.flip();
        this.light2Diffuse.flip();
        this.materialSpecular.flip();
        this.seedRandom(15L);
        this.width = 0;
        this.height = 0;
        this.x = 0;
        this.y = 0;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.cComps = gLAutoDrawable.getGL().isGLES1() ? 4 : 3;
        this.gl = FixedFuncUtil.wrapFixedFuncEmul((GL)gLAutoDrawable.getGL(), (ShaderSelectionMode)ShaderSelectionMode.AUTO, null);
        System.err.println("AngelesGL: " + this.gl);
        this.glu = GLU.createGLU();
        this.gl.glEnable(2977);
        this.gl.glEnable(2929);
        this.gl.glDisable(2884);
        this.gl.glCullFace(1029);
        this.gl.glShadeModel(7424);
        this.gl.glEnable(2896);
        this.gl.glEnable(16384);
        this.gl.glEnable(16385);
        this.gl.glEnable(16386);
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32886);
        for (int i = 0; i < 21; ++i) {
            this.sSuperShapeObjects[i] = this.createSuperShape(SuperShape.sParams[i]);
        }
        this.sGroundPlane = this.createGroundPlane();
        this.gAppAlive = 1;
        this.sStartTick = System.currentTimeMillis();
        this.frames = 0;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        this.gl = gLAutoDrawable.getGL().getGL2ES1();
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glClearColor(0.1f, 0.2f, 0.3f, 1.0f);
        this.gl.glShadeModel(7424);
        this.gl.glDisable(3024);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        long l = System.currentTimeMillis();
        if (this.gAppAlive == 0) {
            return;
        }
        this.gl = gLAutoDrawable.getGL().getGL2ES1();
        this.sTick = this.sTick + l - this.sStartTick >> 1;
        if (this.sTick >= 108840L) {
            this.gAppAlive = 0;
            return;
        }
        this.gl.glClear(16640);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(45.0f, (float)this.width / (float)this.height, 0.5f, 150.0f);
        this.camTrack();
        this.configureLightAndMaterial();
        if (this.blendingEnabled) {
            this.gl.glEnable(2884);
            this.gl.glPushMatrix();
            this.drawModels(-1.0f);
            this.gl.glPopMatrix();
        }
        this.drawGroundPlane();
        if (this.blendingEnabled) {
            this.gl.glDisable(2884);
        }
        this.drawModels(1.0f);
        if (this.blendingEnabled) {
            this.drawFadeQuad();
        }
        ++this.frames;
        l = System.currentTimeMillis();
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    void seedRandom(long l) {
        this.sRandomSeed = l;
    }

    int randomUInt() {
        this.sRandomSeed = this.sRandomSeed * 214013L + 2531011L;
        return Math.abs((int)(this.sRandomSeed >> 16));
    }

    static void vector3Sub(VECTOR3 vECTOR3, VECTOR3 vECTOR32, VECTOR3 vECTOR33) {
        vECTOR3.x = vECTOR32.x - vECTOR33.x;
        vECTOR3.y = vECTOR32.y - vECTOR33.y;
        vECTOR3.z = vECTOR32.z - vECTOR33.z;
    }

    static void superShapeMap(VECTOR3 vECTOR3, float f, float f2, float f3, float f4) {
        vECTOR3.x = (float)(Math.cos(f3) * Math.cos(f4) / (double)f / (double)f2);
        vECTOR3.y = (float)(Math.sin(f3) * Math.cos(f4) / (double)f / (double)f2);
        vECTOR3.z = (float)(Math.sin(f4) / (double)f2);
    }

    float ssFunc(float f, float[] fArray) {
        return this.ssFunc(f, fArray, 0);
    }

    float ssFunc(float f, float[] fArray, int n) {
        return (float)Math.pow(Math.pow(Math.abs(Math.cos(fArray[0 + n] * f / 4.0f)) / (double)fArray[1 + n], fArray[4 + n]) + Math.pow(Math.abs(Math.sin(fArray[0 + n] * f / 4.0f)) / (double)fArray[2 + n], fArray[5 + n]), 1.0f / fArray[3 + n]);
    }

    GLSpatial createSuperShape(float[] fArray) {
        int n = (int)fArray[12];
        int n2 = (int)fArray[13];
        int n3 = n2 / 4;
        int n4 = n2 / 2;
        int n5 = n;
        int n6 = n4 - n3;
        int n7 = n5 * n6 * 2;
        int n8 = n7 * 3;
        float[] fArray2 = new float[3];
        GLSpatial gLSpatial = new GLSpatial(n8, 3, true);
        if (gLSpatial == null) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = (float)(this.randomUInt() % 155 + 100) / 255.0f;
        }
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = n3; j < n4; ++j) {
                float f = (float)(-Math.PI + (double)(i * 2) * Math.PI / (double)n);
                float f2 = (float)(-Math.PI + (double)((i + 1) * 2) * Math.PI / (double)n);
                float f3 = (float)(-1.5707963267948966 + (double)(j * 2) * Math.PI / (double)n2);
                float f4 = (float)(-1.5707963267948966 + (double)((j + 1) * 2) * Math.PI / (double)n2);
                float f5 = this.ssFunc(f, fArray);
                float f6 = this.ssFunc(f3, fArray, 6);
                float f7 = this.ssFunc(f2, fArray);
                float f8 = this.ssFunc(f4, fArray, 6);
                if (f5 != 0.0f && f6 != 0.0f && f7 != 0.0f && f8 != 0.0f) {
                    int n11;
                    VECTOR3 vECTOR3 = new VECTOR3();
                    VECTOR3 vECTOR32 = new VECTOR3();
                    VECTOR3 vECTOR33 = new VECTOR3();
                    VECTOR3 vECTOR34 = new VECTOR3();
                    VECTOR3 vECTOR35 = new VECTOR3();
                    VECTOR3 vECTOR36 = new VECTOR3();
                    VECTOR3 vECTOR37 = new VECTOR3();
                    AngelesGL.superShapeMap(vECTOR3, f5, f6, f, f3);
                    AngelesGL.superShapeMap(vECTOR32, f7, f6, f2, f3);
                    AngelesGL.superShapeMap(vECTOR33, f7, f8, f2, f4);
                    AngelesGL.superShapeMap(vECTOR34, f5, f8, f, f4);
                    if (j == n3 + 1) {
                        vECTOR32.z = 0.0f;
                        vECTOR3.z = 0.0f;
                    }
                    AngelesGL.vector3Sub(vECTOR35, vECTOR32, vECTOR3);
                    AngelesGL.vector3Sub(vECTOR36, vECTOR34, vECTOR3);
                    vECTOR37.x = vECTOR35.y * vECTOR36.z - vECTOR35.z * vECTOR36.y;
                    vECTOR37.y = vECTOR35.z * vECTOR36.x - vECTOR35.x * vECTOR36.z;
                    vECTOR37.z = vECTOR35.x * vECTOR36.y - vECTOR35.y * vECTOR36.x;
                    float f9 = vECTOR3.z + 0.5f;
                    if (gLSpatial.normalArray != null) {
                        for (n11 = n10 * 3; n11 < (n10 + 6) * 3; n11 += 3) {
                            gLSpatial.normalArray.put(n11, vECTOR37.x);
                            gLSpatial.normalArray.put(n11 + 1, vECTOR37.y);
                            gLSpatial.normalArray.put(n11 + 2, vECTOR37.z);
                        }
                    }
                    for (n11 = n10 * this.cComps; n11 < (n10 + 6) * this.cComps; n11 += this.cComps) {
                        float[] fArray3 = new float[3];
                        for (int k = 0; k < 3; ++k) {
                            fArray3[k] = f9 * fArray2[k];
                            if (!(fArray3[k] > 1.0f)) continue;
                            fArray3[k] = 1.0f;
                        }
                        gLSpatial.colorArray.put(n11, fArray3[0]);
                        gLSpatial.colorArray.put(n11 + 1, fArray3[1]);
                        gLSpatial.colorArray.put(n11 + 2, fArray3[2]);
                        if (3 >= this.cComps) continue;
                        gLSpatial.colorArray.put(n11 + 3, 0.0f);
                    }
                    gLSpatial.vertexArray.put(n10 * 3, vECTOR3.x);
                    gLSpatial.vertexArray.put(n10 * 3 + 1, vECTOR3.y);
                    gLSpatial.vertexArray.put(n10 * 3 + 2, vECTOR3.z);
                    gLSpatial.vertexArray.put(++n10 * 3, vECTOR32.x);
                    gLSpatial.vertexArray.put(n10 * 3 + 1, vECTOR32.y);
                    gLSpatial.vertexArray.put(n10 * 3 + 2, vECTOR32.z);
                    gLSpatial.vertexArray.put(++n10 * 3, vECTOR34.x);
                    gLSpatial.vertexArray.put(n10 * 3 + 1, vECTOR34.y);
                    gLSpatial.vertexArray.put(n10 * 3 + 2, vECTOR34.z);
                    gLSpatial.vertexArray.put(++n10 * 3, vECTOR32.x);
                    gLSpatial.vertexArray.put(n10 * 3 + 1, vECTOR32.y);
                    gLSpatial.vertexArray.put(n10 * 3 + 2, vECTOR32.z);
                    gLSpatial.vertexArray.put(++n10 * 3, vECTOR33.x);
                    gLSpatial.vertexArray.put(n10 * 3 + 1, vECTOR33.y);
                    gLSpatial.vertexArray.put(n10 * 3 + 2, vECTOR33.z);
                    gLSpatial.vertexArray.put(++n10 * 3, vECTOR34.x);
                    gLSpatial.vertexArray.put(n10 * 3 + 1, vECTOR34.y);
                    gLSpatial.vertexArray.put(n10 * 3 + 2, vECTOR34.z);
                    ++n10;
                }
                ++n9;
            }
        }
        gLSpatial.setCount(n10);
        gLSpatial.seal();
        return gLSpatial;
    }

    GLSpatial createGroundPlane() {
        GLSpatial gLSpatial = new GLSpatial(5400, 2, false);
        if (gLSpatial == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        for (int i = -15; i < 15; ++i) {
            for (int j = -15; j < 15; ++j) {
                float f = (float)(this.randomUInt() % 255) / 255.0f;
                for (int k = n2 * this.cComps; k < (n2 + 6) * this.cComps; k += this.cComps) {
                    gLSpatial.colorArray.put(k, f);
                    gLSpatial.colorArray.put(k + 1, f);
                    gLSpatial.colorArray.put(k + 2, f);
                    if (3 >= this.cComps) continue;
                    gLSpatial.colorArray.put(k + 3, 0.0f);
                }
                for (int k = 0; k < 6; ++k) {
                    int n3 = j + (28 >> k & 1);
                    int n4 = i + (49 >> k & 1);
                    float f2 = (float)(Math.cos(n3 * 2) * Math.sin(n4 * 4) * 0.75);
                    gLSpatial.vertexArray.put(n2 * 2, (float)(n3 * 4) + f2);
                    gLSpatial.vertexArray.put(n2 * 2 + 1, (float)(n4 * 4) + f2);
                    ++n2;
                }
                ++n;
            }
        }
        gLSpatial.seal();
        return gLSpatial;
    }

    void drawGroundPlane() {
        this.gl.glDisable(2896);
        this.gl.glDisable(2929);
        if (this.blendingEnabled) {
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(0, 768);
        }
        this.sGroundPlane.draw();
        if (this.blendingEnabled) {
            this.gl.glDisable(3042);
        }
        this.gl.glEnable(2929);
        this.gl.glEnable(2896);
    }

    void drawFadeQuad() {
        int n;
        int n2 = (int)(this.sTick - this.sCurrentCamTrackStartTick);
        int n3 = (int)(this.sNextCamTrackStartTick - this.sTick);
        int n4 = n = n2 < n3 ? n2 : n3;
        if (n < 1024) {
            float f = FixedPoint.toFloat((int)(n << 7));
            this.gl.glColor4f(f, f, f, 0.0f);
            this.gl.glDisable(2929);
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(0, 768);
            this.gl.glDisable(2896);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glBindBuffer(34962, 0);
            this.gl.glDisableClientState(32886);
            this.gl.glDisableClientState(32885);
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(2, 5126, 0, (Buffer)this.quadVertices);
            this.gl.glDrawArrays(4, 0, 6);
            this.gl.glEnableClientState(32886);
            this.gl.glMatrixMode(5888);
            this.gl.glEnable(2896);
            this.gl.glDisable(3042);
            this.gl.glEnable(2929);
        }
    }

    void configureLightAndMaterial() {
        this.gl.glLightfv(16384, 4611, this.light0Position);
        this.gl.glLightfv(16384, 4609, this.light0Diffuse);
        this.gl.glLightfv(16385, 4611, this.light1Position);
        this.gl.glLightfv(16385, 4609, this.light1Diffuse);
        this.gl.glLightfv(16386, 4611, this.light2Position);
        this.gl.glLightfv(16386, 4609, this.light2Diffuse);
        this.gl.glMaterialfv(1032, 4610, this.materialSpecular);
        this.gl.glMaterialf(1032, 5633, 60.0f);
        this.gl.glEnable(2903);
    }

    void drawModels(float f) {
        float f2;
        int n;
        int n2;
        this.seedRandom(9L);
        this.gl.glScalef(1.0f, 1.0f, f);
        for (int i = -5; i <= 5; ++i) {
            for (n2 = -5; n2 <= 5; ++n2) {
                n = this.randomUInt() % 21;
                f2 = SuperShape.sParams[n][14];
                this.gl.glPushMatrix();
                this.gl.glTranslatef((float)(n2 * 9), (float)(i * 9), 0.0f);
                this.gl.glRotatef((float)(this.randomUInt() % 360), 0.0f, 0.0f, 1.0f);
                this.gl.glScalef(f2, f2, f2);
                this.sSuperShapeObjects[n].draw();
                this.gl.glPopMatrix();
            }
        }
        for (n2 = -2; n2 <= 2; ++n2) {
            n = n2 * 4500 + (int)(this.sTick % 4500L);
            f2 = (float)n * 0.01f;
            this.gl.glPushMatrix();
            this.gl.glTranslatef(f2, -4.0f, 2.0f);
            this.sSuperShapeObjects[20].draw();
            this.gl.glPopMatrix();
            this.gl.glPushMatrix();
            this.gl.glTranslatef(-4.0f, f2, 4.0f);
            this.gl.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            this.sSuperShapeObjects[20].draw();
            this.gl.glPopMatrix();
        }
    }

    void camTrack() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float[] fArray = new float[5];
        if (this.sNextCamTrackStartTick <= this.sTick) {
            ++this.sCurrentCamTrack;
            this.sCurrentCamTrackStartTick = this.sNextCamTrackStartTick;
        }
        this.sNextCamTrackStartTick = this.sCurrentCamTrackStartTick + (long)(CamTrack.sCamTracks[this.sCurrentCamTrack].len * 5442);
        CamTrack camTrack = CamTrack.sCamTracks[this.sCurrentCamTrack];
        long l = this.sTick - this.sCurrentCamTrackStartTick;
        float f7 = (float)l / (float)(5442 * camTrack.len);
        for (int i = 0; i < 5; ++i) {
            fArray[i] = ((float)camTrack.src[i] + (float)camTrack.dest[i] * f7) * 0.01f;
        }
        if (camTrack.dist > 0) {
            float f8 = (float)camTrack.dist * 0.1f;
            f6 = fArray[0];
            f5 = fArray[1];
            f4 = fArray[2];
            f3 = f6 - (float)Math.cos(fArray[3]) * f8;
            f2 = f5 - (float)Math.sin(fArray[3]) * f8;
            f = f4 - fArray[4];
        } else {
            f3 = fArray[0];
            f2 = fArray[1];
            f = fArray[2];
            f6 = f3 + (float)Math.cos(fArray[3]);
            f5 = f2 + (float)Math.sin(fArray[3]);
            f4 = f + fArray[4];
        }
        this.glu.gluLookAt(f3, f2, f, f6, f5, f4, 0.0f, 0.0f, 1.0f);
    }

    public class GLSpatial {
        private final int vboName;
        private int count;
        private final int vComps;
        private final int nComps;
        private ByteBuffer pBuffer = null;
        private FloatBuffer vertexArray = null;
        private FloatBuffer colorArray = null;
        private FloatBuffer normalArray = null;
        protected GLArrayDataWrapper vArrayData;
        protected GLArrayDataWrapper cArrayData;
        protected GLArrayDataWrapper nArrayData = null;
        private boolean sealed = false;

        public GLSpatial(int n, int n2, boolean bl) {
            this.count = n;
            this.vComps = n2;
            this.nComps = bl ? 3 : 0;
            int n3 = GLBuffers.sizeOfGLType((int)5126) * this.count * (this.vComps + AngelesGL.this.cComps + this.nComps);
            this.pBuffer = Buffers.newDirectByteBuffer((int)n3);
            int n4 = 0;
            int n5 = GLBuffers.sizeOfGLType((int)5126) * this.count * this.vComps;
            this.vertexArray = (FloatBuffer)GLBuffers.sliceGLBuffer((ByteBuffer)this.pBuffer, (int)n4, (int)n5, (int)5126);
            n4 += n5;
            n5 = GLBuffers.sizeOfGLType((int)5126) * this.count * AngelesGL.this.cComps;
            this.colorArray = (FloatBuffer)GLBuffers.sliceGLBuffer((ByteBuffer)this.pBuffer, (int)n4, (int)n5, (int)5126);
            int n6 = n4;
            n4 += n5;
            int n7 = 0;
            if (bl) {
                n5 = GLBuffers.sizeOfGLType((int)5126) * this.count * this.nComps;
                this.normalArray = (FloatBuffer)GLBuffers.sliceGLBuffer((ByteBuffer)this.pBuffer, (int)n4, (int)n5, (int)5126);
                n7 = n4;
                n4 += n5;
            }
            this.pBuffer.position(n4);
            this.pBuffer.flip();
            int[] nArray = new int[1];
            AngelesGL.this.gl.glGenBuffers(1, nArray, 0);
            this.vboName = nArray[0];
            this.vArrayData = GLArrayDataWrapper.createFixed((int)32884, (int)this.vComps, (int)5126, (boolean)false, (int)0, (Buffer)this.pBuffer, (int)this.vboName, (long)0L, (int)35044, (int)34962);
            this.cArrayData = GLArrayDataWrapper.createFixed((int)32886, (int)AngelesGL.this.cComps, (int)5126, (boolean)false, (int)0, (Buffer)this.pBuffer, (int)this.vboName, (long)n6, (int)35044, (int)34962);
            if (bl) {
                this.nArrayData = GLArrayDataWrapper.createFixed((int)32885, (int)this.nComps, (int)5126, (boolean)false, (int)0, (Buffer)this.pBuffer, (int)this.vboName, (long)n7, (int)35044, (int)34962);
            }
        }

        void setCount(int n) {
            if (this.count != n) {
                throw new RuntimeException("diff count: " + this.count + " -> " + n);
            }
            this.count = n;
        }

        void seal() {
            if (this.sealed) {
                return;
            }
            this.sealed = true;
            this.vertexArray.position(this.count);
            this.vertexArray.flip();
            this.colorArray.position(this.count);
            this.colorArray.flip();
            if (this.nComps > 0) {
                this.normalArray.position(this.count);
                this.normalArray.flip();
            }
            if (this.nComps > 0) {
                AngelesGL.this.gl.glEnableClientState(32885);
            }
            AngelesGL.this.gl.glBindBuffer(34962, this.vboName);
            AngelesGL.this.gl.glBufferData(34962, (long)this.pBuffer.limit(), (Buffer)this.pBuffer, 35044);
            AngelesGL.this.gl.glBindBuffer(34962, 0);
            if (this.nComps > 0) {
                AngelesGL.this.gl.glDisableClientState(32885);
            }
        }

        void draw() {
            this.seal();
            if (this.nComps > 0) {
                AngelesGL.this.gl.glEnableClientState(32885);
            }
            AngelesGL.this.gl.glBindBuffer(34962, this.vboName);
            AngelesGL.this.gl.glVertexPointer((GLArrayData)this.vArrayData);
            AngelesGL.this.gl.glColorPointer((GLArrayData)this.cArrayData);
            if (this.nComps > 0) {
                AngelesGL.this.gl.glNormalPointer((GLArrayData)this.nArrayData);
            }
            AngelesGL.this.gl.glDrawArrays(4, 0, this.count);
            AngelesGL.this.gl.glBindBuffer(34962, 0);
            if (this.nComps > 0) {
                AngelesGL.this.gl.glDisableClientState(32885);
            }
        }
    }

    public class VECTOR3 {
        float x;
        float y;
        float z;

        public VECTOR3() {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        }

        public VECTOR3(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }
}

