/*
 * Decompiled with CFR 0.152.
 */
package demos.es1.cube;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class Cube
implements GLEventListener {
    public boolean glDebug = false;
    public boolean glTrace = false;
    boolean quit = false;
    static final float[] light_position = new float[]{-50.0f, 50.0f, 50.0f, 0.0f};
    static final float[] light_ambient = new float[]{0.125f, 0.125f, 0.125f, 1.0f};
    static final float[] light_diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] material_spec = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    static final float[] zero_vec4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    int[] vboNames = new int[4];
    boolean innerCube;
    boolean initialized = false;
    float time = 0.0f;
    ShortBuffer cubeVertices;
    ShortBuffer cubeTexCoords;
    FloatBuffer cubeColors;
    ByteBuffer cubeNormals;
    ByteBuffer cubeIndices;
    private GLU glu;
    private static final short[] s_cubeVertices = new short[]{-10, 10, 10, 10, -10, 10, 10, 10, 10, -10, -10, 10, -10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10, -10, -10, -10, 10, 10, -10, -10, 10, -10, 10, -10, -10, -10, -10, 10, 10, 10, 10, -10, 10, 10, 10, -10, 10, -10, 10, -10, 10, 10, 10, -10, 10, 10, 10, 10, -10, -10, -10, -10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10};
    private static final short[] s_cubeTexCoords = new short[]{0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0};
    private static final float[] s_cubeColors = new float[]{0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 255.0f};
    private static final byte[] s_cubeIndices = new byte[]{0, 3, 1, 2, 0, 1, 6, 5, 4, 5, 7, 4, 8, 11, 9, 10, 8, 9, 15, 12, 13, 12, 14, 13, 16, 19, 17, 18, 16, 17, 23, 20, 21, 20, 22, 21};
    private static final byte[] s_cubeNormals = new byte[]{0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0};
    public static int USE_NEWT = 0;
    public static int USE_AWT = 1;

    public Cube() {
        this(false, false);
    }

    public Cube(boolean bl, boolean bl2) {
        this.innerCube = bl2;
        this.cubeVertices = Buffers.newDirectShortBuffer((int)s_cubeVertices.length);
        this.cubeVertices.put(s_cubeVertices);
        this.cubeVertices.flip();
        this.cubeColors = Buffers.newDirectFloatBuffer((int)s_cubeColors.length);
        this.cubeColors.put(s_cubeColors);
        this.cubeColors.flip();
        this.cubeNormals = Buffers.newDirectByteBuffer((int)s_cubeNormals.length);
        this.cubeNormals.put(s_cubeNormals);
        this.cubeNormals.flip();
        this.cubeIndices = Buffers.newDirectByteBuffer((int)s_cubeIndices.length);
        this.cubeIndices.put(s_cubeIndices);
        this.cubeIndices.flip();
        if (bl) {
            this.cubeTexCoords = Buffers.newDirectShortBuffer((int)s_cubeTexCoords.length);
            this.cubeTexCoords.put(s_cubeTexCoords);
            this.cubeTexCoords.flip();
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glGetError();
        if (this.glDebug) {
            try {
                gL = gL.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)gL, null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.glTrace) {
            try {
                gL = gL.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)gL, (Object[])new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        GL2ES1 gL2ES1 = FixedFuncUtil.wrapFixedFuncEmul((GL)gL, (ShaderSelectionMode)ShaderSelectionMode.AUTO, null);
        this.glu = GLU.createGLU();
        gL2ES1.glGenBuffers(4, this.vboNames, 0);
        if (!this.innerCube) {
            System.err.println("Entering initialization");
            System.err.println("GL Profile: " + gL2ES1.getGLProfile());
            System.err.println("GL:" + gL2ES1);
            System.err.println("GL_VERSION=" + gL2ES1.glGetString(7938));
            System.err.println("GL_EXTENSIONS:");
            System.err.println("  " + gL2ES1.glGetString(7939));
            System.err.println("GLF:" + gL2ES1);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        float f = n4 != 0 ? (float)n3 / (float)n4 : 1.0f;
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glViewport(0, 0, n3, n4);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        if (this.innerCube) {
            gL2ES1.glClearColor(1.0f, 1.0f, 1.0f, 0.4f);
        } else {
            gL2ES1.glClearColor(0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (!this.innerCube) {
            gL2ES1.glLightfv(16384, 4611, light_position, 0);
            gL2ES1.glLightfv(16384, 4608, light_ambient, 0);
            gL2ES1.glLightfv(16384, 4609, light_diffuse, 0);
            gL2ES1.glLightfv(16384, 4610, zero_vec4, 0);
            gL2ES1.glMaterialfv(1032, 4610, material_spec, 0);
            gL2ES1.glEnable(2896);
            gL2ES1.glEnable(16384);
            gL2ES1.glEnable(2903);
        } else {
            gL2ES1.glDisable(2896);
            gL2ES1.glDisable(16384);
        }
        gL2ES1.glEnable(2884);
        gL2ES1.glEnable(2977);
        gL2ES1.glShadeModel(7425);
        gL2ES1.glDisable(3024);
        gL2ES1.glEnableClientState(32884);
        gL2ES1.glBindBuffer(34962, this.vboNames[0]);
        gL2ES1.glBufferData(34962, (long)(this.cubeVertices.limit() * 2), (Buffer)this.cubeVertices, 35044);
        gL2ES1.glVertexPointer(3, 5122, 0, 0L);
        gL2ES1.glEnableClientState(32885);
        gL2ES1.glBindBuffer(34962, this.vboNames[1]);
        gL2ES1.glBufferData(34962, (long)(this.cubeNormals.limit() * 1), (Buffer)this.cubeNormals, 35044);
        gL2ES1.glNormalPointer(5120, 0, 0L);
        gL2ES1.glEnableClientState(32886);
        gL2ES1.glBindBuffer(34962, this.vboNames[2]);
        gL2ES1.glBufferData(34962, (long)(this.cubeColors.limit() * 4), (Buffer)this.cubeColors, 35044);
        gL2ES1.glColorPointer(4, 5126, 0, 0L);
        if (this.cubeTexCoords != null) {
            gL2ES1.glEnableClientState(32888);
            gL2ES1.glBindBuffer(34962, this.vboNames[3]);
            gL2ES1.glBufferData(34962, (long)(this.cubeTexCoords.limit() * 2), (Buffer)this.cubeTexCoords, 35044);
            gL2ES1.glTexCoordPointer(2, 5122, 0, 0L);
        } else {
            gL2ES1.glDisableClientState(32888);
        }
        gL2ES1.glBindBuffer(34962, 0);
        gL2ES1.glHint(3152, 4353);
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        if (!this.innerCube) {
            this.glu.gluPerspective(90.0f, f, 1.0f, 100.0f);
        } else {
            gL2ES1.glOrthof(-20.0f, 20.0f, -20.0f, 20.0f, 1.0f, 40.0f);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.quit = true;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.display(gLAutoDrawable, true);
    }

    public void display(GLAutoDrawable gLAutoDrawable, boolean bl) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        if (bl) {
            gL2ES1.glClear(0x4000 | 0x100);
        }
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(0.0f, 0.0f, -30.0f);
        gL2ES1.glRotatef(this.time * 29.77f, 1.0f, 2.0f, 0.0f);
        gL2ES1.glRotatef(this.time * 22.311f, -0.1f, 0.0f, -5.0f);
        gL2ES1.glDrawElements(4, 36, 5121, (Buffer)this.cubeIndices);
        this.time += 0.01f;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void run(int n) {
        int n2 = 800;
        int n3 = 480;
        System.err.println("Cube.run()");
        try {
            GLWindow gLWindow;
            GLCapabilities gLCapabilities = new GLCapabilities(null);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            Window window = null;
            if (0 != (n & USE_AWT)) {
                Display display = NewtFactory.createDisplay((String)".awt", null);
                Screen screen = NewtFactory.createScreen((Display)display, (int)0);
                window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
                window.setUndecorated(false);
                gLWindow = GLWindow.create((Window)window);
            } else {
                gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            }
            gLWindow.addGLEventListener((GLEventListener)this);
            gLWindow.setUpdateFPSFrames(300, System.err);
            gLWindow.setSize(n2, n3);
            gLWindow.setFullscreen(true);
            gLWindow.setVisible(true);
            while (!this.quit && gLWindow.getTotalFPSDuration() < 31000L) {
                gLWindow.display();
            }
            gLWindow.destroy();
            System.out.println("Cube shut down cleanly.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        int n = USE_NEWT;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!stringArray[i].equals("-awt")) continue;
            n |= USE_AWT;
        }
        new Cube().run(n);
        System.exit(0);
    }
}

