/*
 * Decompiled with CFR 0.152.
 */
package demos.es1.cube;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.util.ImmModeSink;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class CubeImmModeSink
implements GLEventListener {
    boolean quit = false;
    private static boolean VBO_CACHE = true;
    ByteBuffer cubeIndices = null;
    ImmModeSink vboCubeF = null;
    private GLUquadric sphere = null;
    private ImmModeSink vboSphere = null;
    private GLUquadric cylinder = null;
    private ImmModeSink vboCylinder = null;
    int frameNum = 0;
    static final float[] light_position = new float[]{-50.0f, 50.0f, 50.0f, 0.0f};
    static final float[] light_ambient = new float[]{0.125f, 0.125f, 0.125f, 1.0f};
    static final float[] light_diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] material_spec = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    static final float[] zero_vec4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    static final float[] identity4x4f = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final short[] s_cubeVertices = new short[]{-10, 10, 10, 10, -10, 10, 10, 10, 10, -10, -10, 10, -10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10, -10, -10, -10, 10, 10, -10, -10, 10, -10, 10, -10, -10, -10, -10, 10, 10, 10, 10, -10, 10, 10, 10, -10, 10, -10, 10, -10, 10, 10, 10, -10, 10, 10, 10, 10, -10, -10, -10, -10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10};
    private static final short[] s_cubeTexCoords = new short[]{0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0};
    private static final float[] s_cubeColors = new float[]{0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.15686275f, 0.3137255f, 0.627451f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 0.5019608f, 0.5019608f, 0.5019608f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.43137255f, 0.039215688f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 1.0f, 1.0f, 0.27450982f, 0.23529412f, 255.0f};
    private static final byte[] s_cubeIndices = new byte[]{0, 3, 1, 2, 0, 1, 6, 5, 4, 5, 7, 4, 8, 11, 9, 10, 8, 9, 15, 12, 13, 12, 14, 13, 16, 19, 17, 18, 16, 17, 23, 20, 21, 20, 22, 21};
    private static final byte[] s_cubeNormals = new byte[]{0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0, -128, 0, 0};
    boolean innerCube;
    boolean useTexCoords;
    boolean initialized = false;
    float time = 0.0f;
    private GLU glu;
    public static int USE_NEWT = 0;
    public static int USE_AWT = 1;

    public CubeImmModeSink() {
        this(false, false);
    }

    public void drawCube(GL2ES1 gL2ES1, float f) {
        if (this.cubeIndices == null) {
            this.cubeIndices = Buffers.newDirectByteBuffer((byte[])s_cubeIndices);
        }
        if (this.vboCubeF == null) {
            ImmModeSink immModeSink = ImmModeSink.createFixed((int)36, (int)3, (int)5122, (int)4, (int)5126, (int)3, (int)5120, (int)0, (int)5126, (int)35044);
            immModeSink.glBegin(4);
            immModeSink.glVertexv((Buffer)Buffers.newDirectShortBuffer((short[])s_cubeVertices));
            immModeSink.glColorv((Buffer)Buffers.newDirectFloatBuffer((float[])s_cubeColors));
            immModeSink.glNormalv((Buffer)Buffers.newDirectByteBuffer((byte[])s_cubeNormals));
            if (VBO_CACHE) {
                immModeSink.glEnd((GL)gL2ES1, false);
            } else {
                immModeSink.glEnd((GL)gL2ES1, (Buffer)this.cubeIndices);
            }
            System.err.println("VBO Cube");
            System.err.println(immModeSink);
            if (VBO_CACHE) {
                this.vboCubeF = immModeSink;
            }
        }
        if (null != this.vboCubeF) {
            this.vboCubeF.draw((GL)gL2ES1, (Buffer)this.cubeIndices, true);
        }
    }

    public void drawSphere(GL2ES1 gL2ES1, float f, int n, int n2) {
        ImmModeSink immModeSink;
        if (this.sphere == null) {
            this.sphere = this.glu.gluNewQuadric();
            this.sphere.enableImmModeSink(true);
            this.sphere.setImmMode(!VBO_CACHE);
        }
        if ((immModeSink = this.vboSphere) == null) {
            this.glu.gluSphere(this.sphere, (double)f, 8, 8);
            if (VBO_CACHE) {
                immModeSink = this.vboSphere = this.sphere.replaceImmModeSink();
            }
            System.err.println("VBO Sphere");
            System.err.println(immModeSink);
        }
        if (VBO_CACHE && null != immModeSink) {
            immModeSink.draw((GL)gL2ES1, true);
        }
    }

    public void drawCylinder(GL2ES1 gL2ES1, float f, float f2, int n) {
        if (this.cylinder == null) {
            this.cylinder = this.glu.gluNewQuadric();
            this.cylinder.enableImmModeSink(true);
            this.cylinder.setImmMode(!VBO_CACHE);
        }
        gL2ES1.glPushMatrix();
        switch (n) {
            case 0: {
                gL2ES1.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
                gL2ES1.glTranslatef(0.0f, 0.0f, -f2);
                break;
            }
            case 1: {
                gL2ES1.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
                gL2ES1.glTranslatef(0.0f, 0.0f, -f2);
                break;
            }
            case 2: {
                gL2ES1.glTranslatef(0.0f, 0.0f, -f2);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        ImmModeSink immModeSink = this.vboCylinder;
        if (immModeSink == null) {
            this.glu.gluQuadricDrawStyle(this.cylinder, 100012);
            this.glu.gluQuadricNormals(this.cylinder, 100000);
            this.glu.gluCylinder(this.cylinder, (double)f, (double)f, (double)(2.0f * f2), 15, 10);
            if (VBO_CACHE) {
                immModeSink = this.vboCylinder = this.cylinder.replaceImmModeSink();
            }
            System.err.println("VBO Cylinder");
            System.err.println(immModeSink);
        }
        if (VBO_CACHE && null != immModeSink) {
            immModeSink.draw((GL)gL2ES1, true);
        }
        gL2ES1.glPopMatrix();
    }

    public CubeImmModeSink(boolean bl, boolean bl2) {
        this.innerCube = bl2;
        this.useTexCoords = bl;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = FixedFuncUtil.wrapFixedFuncEmul((GL)gLAutoDrawable.getGL(), (ShaderSelectionMode)ShaderSelectionMode.AUTO, null);
        this.glu = GLU.createGLU();
        if (!this.innerCube) {
            System.err.println("Entering initialization");
            System.err.println("GL Profile: " + gL2ES1.getGLProfile());
            System.err.println("GL:" + gL2ES1);
            System.err.println("GL_VERSION=" + gL2ES1.glGetString(7938));
            System.err.println("GL_EXTENSIONS:");
            System.err.println("  " + gL2ES1.glGetString(7939));
            System.err.println("GLF:" + gL2ES1);
        }
        gL2ES1.glGetError();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        float f = n4 != 0 ? (float)n3 / (float)n4 : 1.0f;
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glViewport(0, 0, n3, n4);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glScissor(0, 0, n3, n4);
        if (this.innerCube) {
            gL2ES1.glClearColor(1.0f, 1.0f, 1.0f, 0.6f);
        } else {
            gL2ES1.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        gL2ES1.glLightfv(16384, 4611, light_position, 0);
        gL2ES1.glLightfv(16384, 4608, light_ambient, 0);
        gL2ES1.glLightfv(16384, 4609, light_diffuse, 0);
        gL2ES1.glLightfv(16384, 4610, zero_vec4, 0);
        gL2ES1.glMaterialfv(1032, 4610, material_spec, 0);
        gL2ES1.glEnable(2977);
        gL2ES1.glEnable(2896);
        gL2ES1.glEnable(16384);
        gL2ES1.glEnable(2903);
        gL2ES1.glEnable(2884);
        gL2ES1.glShadeModel(7425);
        gL2ES1.glDisable(3024);
        gL2ES1.glHint(3152, 4353);
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        if (!this.innerCube) {
            this.glu.gluPerspective(90.0f, f, 1.0f, 100.0f);
        } else {
            gL2ES1.glOrthof(-20.0f, 20.0f, -20.0f, 20.0f, 1.0f, 40.0f);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.quit = true;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.glClear(0x4000 | 0x100);
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(0.0f, 0.0f, -30.0f);
        gL2ES1.glRotatef(this.time * 29.77f, 1.0f, 2.0f, 0.0f);
        gL2ES1.glRotatef(this.time * 22.311f, -0.1f, 0.0f, -5.0f);
        gL2ES1.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.drawCube(gL2ES1, 10.0f);
        gL2ES1.glDisable(2896);
        gL2ES1.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        gL2ES1.glPushMatrix();
        gL2ES1.glTranslatef(15.0f, 0.0f, 0.0f);
        this.drawSphere(gL2ES1, 5.0f, 10, 10);
        gL2ES1.glPopMatrix();
        gL2ES1.glEnable(2896);
        gL2ES1.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        gL2ES1.glPushMatrix();
        gL2ES1.glMultMatrixf(identity4x4f, 0);
        this.drawCylinder(gL2ES1, 4.0f, 10.0f, 1);
        gL2ES1.glPopMatrix();
        ++this.frameNum;
        this.time += 0.01f;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void run(int n) {
        int n2 = 800;
        int n3 = 480;
        System.err.println("CubeImmModeSink.run()");
        try {
            long l;
            GLWindow gLWindow;
            GLCapabilities gLCapabilities = new GLCapabilities(null);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            Window window = null;
            if (0 != (n & USE_AWT)) {
                Display display = NewtFactory.createDisplay((String)".awt", null);
                Screen screen = NewtFactory.createScreen((Display)display, (int)0);
                window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
                window.setUndecorated(false);
                gLWindow = GLWindow.create((Window)window);
            } else {
                gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            }
            gLWindow.addGLEventListener((GLEventListener)this);
            gLWindow.setUpdateFPSFrames(300, System.err);
            gLWindow.setSize(n2, n3);
            gLWindow.setVisible(true);
            long l2 = System.currentTimeMillis();
            while (!this.quit && (l = System.currentTimeMillis()) - l2 < 31000L) {
                gLWindow.display();
            }
            gLWindow.destroy();
            System.out.println("CubeImmModeSink shut down cleanly.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        int n = USE_NEWT;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!stringArray[i].equals("-awt")) continue;
            n |= USE_AWT;
        }
        new CubeImmModeSink().run(n);
        System.exit(0);
    }
}

