/*
 * Decompiled with CFR 0.152.
 */
package demos.es2;

import com.jogamp.common.nio.Buffers;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.Animator;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class RawGL2ES2demo
implements GLEventListener {
    private String vertexShaderString = "#if __VERSION__ >= 130\n  #define attribute in\n  #define varying out\n#endif\n#ifdef GL_ES \nprecision mediump float; \nprecision mediump int; \n#endif \nuniform mat4    uniform_Projection; \nattribute vec4  attribute_Position; \nattribute vec4  attribute_Color; \nvarying vec4    varying_Color; \nvoid main(void) \n{ \n  varying_Color = attribute_Color; \n  gl_Position = uniform_Projection * attribute_Position; \n} ";
    private String fragmentShaderString = "#if __VERSION__ >= 130\n  #define varying in\n  out vec4 mgl_FragColor;\n  #define texture2D texture\n  #define gl_FragColor mgl_FragColor\n#endif\n#ifdef GL_ES \nprecision mediump float; \nprecision mediump int; \n#endif \nvarying   vec4    varying_Color; \nvoid main (void) \n{ \n  gl_FragColor = varying_Color; \n} ";
    private double t0 = System.currentTimeMillis();
    private double theta;
    private double s;
    private static int width = 1920;
    private static int height = 1080;
    private int shaderProgram;
    private int vertShader;
    private int fragShader;
    private int ModelViewProjectionMatrix_location;
    static final int COLOR_IDX = 0;
    static final int VERTICES_IDX = 1;
    int[] vboHandles;

    private void glMultMatrixf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        int n3 = floatBuffer3.position();
        for (int i = 0; i < 4; ++i) {
            float f = floatBuffer.get(n + i + 0);
            float f2 = floatBuffer.get(n + i + 4);
            float f3 = floatBuffer.get(n + i + 8);
            float f4 = floatBuffer.get(n + i + 12);
            floatBuffer3.put(n3 + i + 0, f * floatBuffer2.get(n2 + 0 + 0) + f2 * floatBuffer2.get(n2 + 1 + 0) + f3 * floatBuffer2.get(n2 + 2 + 0) + f4 * floatBuffer2.get(n2 + 3 + 0));
            floatBuffer3.put(n3 + i + 4, f * floatBuffer2.get(n2 + 0 + 4) + f2 * floatBuffer2.get(n2 + 1 + 4) + f3 * floatBuffer2.get(n2 + 2 + 4) + f4 * floatBuffer2.get(n2 + 3 + 4));
            floatBuffer3.put(n3 + i + 8, f * floatBuffer2.get(n2 + 0 + 8) + f2 * floatBuffer2.get(n2 + 1 + 8) + f3 * floatBuffer2.get(n2 + 2 + 8) + f4 * floatBuffer2.get(n2 + 3 + 8));
            floatBuffer3.put(n3 + i + 12, f * floatBuffer2.get(n2 + 0 + 12) + f2 * floatBuffer2.get(n2 + 1 + 12) + f3 * floatBuffer2.get(n2 + 2 + 12) + f4 * floatBuffer2.get(n2 + 3 + 12));
        }
    }

    private float[] multiply(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[16];
        this.glMultMatrixf(FloatBuffer.wrap(fArray), FloatBuffer.wrap(fArray2), FloatBuffer.wrap(fArray3));
        return fArray3;
    }

    private float[] translate(float[] fArray, float f, float f2, float f3) {
        float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, f, f2, f3, 1.0f};
        return this.multiply(fArray, fArray2);
    }

    private float[] rotate(float[] fArray, float f, float f2, float f3, float f4) {
        float f5 = (float)Math.sin(Math.toRadians(f));
        float f6 = (float)Math.cos(Math.toRadians(f));
        float[] fArray2 = new float[]{f2 * f2 * (1.0f - f6) + f6, f3 * f2 * (1.0f - f6) + f4 * f5, f2 * f4 * (1.0f - f6) - f3 * f5, 0.0f, f2 * f3 * (1.0f - f6) - f4 * f5, f3 * f3 * (1.0f - f6) + f6, f3 * f4 * (1.0f - f6) + f2 * f5, 0.0f, f2 * f4 * (1.0f - f6) + f3 * f5, f3 * f4 * (1.0f - f6) - f2 * f5, f4 * f4 * (1.0f - f6) + f6, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return this.multiply(fArray, fArray2);
    }

    public static void main(String[] stringArray) {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2ES2"));
        gLCapabilities.setBackgroundOpaque(false);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle("Raw GL2ES2 Demo");
        gLWindow.setSize(width, height);
        gLWindow.setUndecorated(false);
        gLWindow.setPointerVisible(true);
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)new RawGL2ES2demo());
        Animator animator = new Animator();
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        Object[] objectArray;
        Object[] objectArray2;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL2ES2.getClass().getName());
        System.err.println("GL_VENDOR: " + gL2ES2.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL2ES2.glGetString(7937));
        System.err.println("GL_VERSION: " + gL2ES2.glGetString(7938));
        if (gL2ES2.isGL3core()) {
            System.out.println("GL3 core detected: explicit add #version 130 to shaders");
            this.vertexShaderString = "#version 130\n" + this.vertexShaderString;
            this.fragmentShaderString = "#version 130\n" + this.fragmentShaderString;
        }
        this.vertShader = gL2ES2.glCreateShader(35633);
        this.fragShader = gL2ES2.glCreateShader(35632);
        String[] stringArray = new String[]{this.vertexShaderString};
        int[] nArray = new int[]{stringArray[0].length()};
        gL2ES2.glShaderSource(this.vertShader, stringArray.length, stringArray, nArray, 0);
        gL2ES2.glCompileShader(this.vertShader);
        int[] nArray2 = new int[1];
        gL2ES2.glGetShaderiv(this.vertShader, 35713, nArray2, 0);
        if (nArray2[0] != 0) {
            System.out.println("Horray! vertex shader compiled");
        } else {
            objectArray2 = new int[1];
            gL2ES2.glGetShaderiv(this.vertShader, 35716, objectArray2, 0);
            objectArray = new byte[objectArray2[0]];
            gL2ES2.glGetShaderInfoLog(this.vertShader, objectArray2[0], (int[])null, 0, objectArray, 0);
            System.err.println("Error compiling the vertex shader: " + new String((byte[])objectArray));
            System.exit(1);
        }
        objectArray2 = new String[]{this.fragmentShaderString};
        objectArray = new int[]{objectArray2[0].length()};
        gL2ES2.glShaderSource(this.fragShader, objectArray2.length, (String[])objectArray2, (int[])objectArray, 0);
        gL2ES2.glCompileShader(this.fragShader);
        gL2ES2.glGetShaderiv(this.fragShader, 35713, nArray2, 0);
        if (nArray2[0] != 0) {
            System.out.println("Horray! fragment shader compiled");
        } else {
            int[] nArray3 = new int[1];
            gL2ES2.glGetShaderiv(this.fragShader, 35716, nArray3, 0);
            byte[] byArray = new byte[nArray3[0]];
            gL2ES2.glGetShaderInfoLog(this.fragShader, nArray3[0], (int[])null, 0, byArray, 0);
            System.err.println("Error compiling the fragment shader: " + new String(byArray));
            System.exit(1);
        }
        this.shaderProgram = gL2ES2.glCreateProgram();
        gL2ES2.glAttachShader(this.shaderProgram, this.vertShader);
        gL2ES2.glAttachShader(this.shaderProgram, this.fragShader);
        gL2ES2.glBindAttribLocation(this.shaderProgram, 0, "attribute_Position");
        gL2ES2.glBindAttribLocation(this.shaderProgram, 1, "attribute_Color");
        gL2ES2.glLinkProgram(this.shaderProgram);
        this.ModelViewProjectionMatrix_location = gL2ES2.glGetUniformLocation(this.shaderProgram, "uniform_Projection");
        this.vboHandles = new int[2];
        gL2ES2.glGenBuffers(2, this.vboHandles, 0);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.out.println("Window resized to width=" + n3 + " height=" + n4);
        width = n3;
        height = n4;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport((width - height) / 2, 0, height, height);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        double d = System.currentTimeMillis();
        this.theta += (d - this.t0) * (double)0.005f;
        this.t0 = d;
        this.s = Math.sin(this.theta);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 0.0f, 1.0f, 0.5f);
        gL2ES2.glClear(17664);
        gL2ES2.glUseProgram(this.shaderProgram);
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] fArray2 = this.translate(fArray, 0.0f, 0.0f, -0.1f);
        fArray2 = this.rotate(fArray2, 30.0f * (float)this.s, 1.0f, 0.0f, 1.0f);
        gL2ES2.glUniformMatrix4fv(this.ModelViewProjectionMatrix_location, 1, false, fArray2, 0);
        float[] fArray3 = new float[]{0.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f};
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((float[])fArray3);
        gL2ES2.glBindBuffer(34962, this.vboHandles[1]);
        int n = fArray3.length * 4;
        gL2ES2.glBufferData(34962, (long)n, (Buffer)floatBuffer, 35044);
        floatBuffer = null;
        gL2ES2.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        gL2ES2.glEnableVertexAttribArray(0);
        float[] fArray4 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.9f};
        FloatBuffer floatBuffer2 = Buffers.newDirectFloatBuffer((float[])fArray4);
        gL2ES2.glBindBuffer(34962, this.vboHandles[0]);
        n = fArray4.length * 4;
        gL2ES2.glBufferData(34962, (long)n, (Buffer)floatBuffer2, 35044);
        floatBuffer2 = null;
        gL2ES2.glVertexAttribPointer(1, 4, 5126, false, 0, 0L);
        gL2ES2.glEnableVertexAttribArray(1);
        gL2ES2.glDrawArrays(4, 0, 3);
        gL2ES2.glDisableVertexAttribArray(0);
        gL2ES2.glDisableVertexAttribArray(1);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.out.println("cleanup, remember to release shaders");
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glUseProgram(0);
        gL2ES2.glDeleteBuffers(2, this.vboHandles, 0);
        this.vboHandles = null;
        gL2ES2.glDetachShader(this.shaderProgram, this.vertShader);
        gL2ES2.glDeleteShader(this.vertShader);
        gL2ES2.glDetachShader(this.shaderProgram, this.fragShader);
        gL2ES2.glDeleteShader(this.fragShader);
        gL2ES2.glDeleteProgram(this.shaderProgram);
        System.exit(0);
    }
}

