/*
 * Decompiled with CFR 0.152.
 */
package demos.es2;

import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.util.ArrayList;
import java.util.Iterator;

public class RedSquare
extends Thread
implements WindowListener,
KeyListener,
MouseListener,
GLEventListener {
    public Window nWindow = null;
    public GLWindow window;
    private GLProfile glp;
    private boolean quit = false;
    private final String glprofile;
    private final int type;
    ShaderState st;
    PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private GLArrayDataServer vertices;
    private GLArrayDataServer colors;
    public static int USE_NEWT = 0;
    public static int USE_AWT = 1;
    public static boolean oneThread = false;
    public static int swapInterval = -1;
    public static boolean debuggl = false;

    public RedSquare() {
        this(null, USE_NEWT);
    }

    public RedSquare(String string, int n) {
        this.glprofile = string;
        this.type = n;
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    public void windowResized(WindowEvent windowEvent) {
    }

    public void windowMoved(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
        System.out.println("WINDOW-DESTROY NOTIFY " + Thread.currentThread() + " QUIT " + windowEvent);
        this.quit = true;
    }

    public void windowDestroyed(WindowEvent windowEvent) {
        System.out.println("WINDOW-DESTROYED " + Thread.currentThread());
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.out.println("KEY-PRESSED " + Thread.currentThread() + " UNHANDLED " + keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.out.println("KEY-RELEASED " + Thread.currentThread() + " UNHANDLED " + keyEvent);
        if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
            return;
        }
        if (keyEvent.getKeyChar() == 'f') {
            System.out.println("KEY-TYPED " + Thread.currentThread() + " FULLSCREEN " + keyEvent);
            this.window.setFullscreen(!this.window.isFullscreen());
        } else if (keyEvent.getKeyChar() == 'q') {
            System.out.println("KEY-TYPED " + Thread.currentThread() + " QUIT " + keyEvent);
            this.quit = true;
        } else {
            System.out.println("KEY-TYPED " + Thread.currentThread() + " UNHANDLED " + keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("MOUSE-CLICKED " + Thread.currentThread() + " UNHANDLED " + mouseEvent);
        switch (mouseEvent.getClickCount()) {
            case 1: {
                if (mouseEvent.getButton() <= 1) break;
                this.window.setFullscreen(!this.window.isFullscreen());
                break;
            }
            default: {
                this.quit = true;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
    }

    public boolean shouldQuit() {
        return this.quit;
    }

    @Override
    public void run() {
        this.glp = GLProfile.get((String)this.glprofile);
        System.out.println("RUN " + Thread.currentThread() + " " + this.glp);
        try {
            GLCapabilities gLCapabilities = new GLCapabilities(this.glp);
            if (0 != (this.type & USE_AWT)) {
                Display display = NewtFactory.createDisplay((String)".awt", null);
                Screen screen = NewtFactory.createScreen((Display)display, (int)0);
                this.nWindow = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
                this.window = GLWindow.create((Window)this.nWindow);
            } else {
                this.window = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            }
            this.window.addWindowListener((WindowListener)this);
            this.window.addMouseListener((MouseListener)this);
            this.window.addKeyListener((KeyListener)this);
            this.window.addGLEventListener((GLEventListener)this);
            this.window.setSize(800, 480);
            this.window.setVisible(true);
            this.window.setUpdateFPSFrames(300, System.err);
            if (!oneThread) {
                do {
                    this.display();
                } while (!this.quit && this.window.getTotalFPSDuration() < 20000L);
                this.shutdown();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void display() {
        try {
            this.window.display();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            this.window.destroy();
            this.window = null;
            if (null != this.nWindow) {
                this.nWindow.destroy();
                this.nWindow = null;
            }
            System.out.println("SHUTDOWN " + Thread.currentThread() + " cleanly");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void initShader(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, RedSquare.class, (String)"shader", (String)"shader/bin", (String)"redsquare", (boolean)false);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, RedSquare.class, (String)"shader", (String)"shader/bin", (String)"redsquare", (boolean)false);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, false);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (swapInterval >= 0) {
            gL2ES2.setSwapInterval(swapInterval);
        }
        System.err.println(Thread.currentThread() + " Entering initialization");
        System.err.println(Thread.currentThread() + " GL Profile: " + gL2ES2.getGLProfile());
        System.err.println(Thread.currentThread() + " GL:" + gL2ES2);
        System.err.println(Thread.currentThread() + " GL_VERSION=" + gL2ES2.glGetString(7938));
        System.err.println(Thread.currentThread() + " GL_EXTENSIONS:");
        System.err.println(Thread.currentThread() + "   " + gL2ES2.glGetString(7939));
        System.err.println(Thread.currentThread() + " swapInterval: " + swapInterval + " (GL: " + gL2ES2.getSwapInterval() + ")");
        System.err.println(Thread.currentThread() + " isShaderCompilerAvailable: " + ShaderUtil.isShaderCompilerAvailable((GL)gL2ES2));
        if (debuggl) {
            try {
                gL2ES2 = (GL2ES2)gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", GL2ES2.class, (GL)gL2ES2, null));
                gL2ES2 = (GL2ES2)gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", GL2ES2.class, (GL)gL2ES2, (Object[])new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.pmvMatrix = new PMVMatrix();
        this.initShader(gL2ES2);
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        this.st.ownUniform(this.pmvMatrixUniform);
        if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        this.vertices = GLArrayDataServer.createGLSL((String)"mgl_Vertex", (int)3, (int)5126, (boolean)false, (int)4, (int)35044);
        this.vertices.putf(-2.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(0.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(0.0f);
        this.vertices.putf(-2.0f);
        this.vertices.putf(-2.0f);
        this.vertices.putf(0.0f);
        this.vertices.putf(2.0f);
        this.vertices.putf(-2.0f);
        this.vertices.putf(0.0f);
        this.vertices.seal((GL)gL2ES2, true);
        this.st.ownAttribute((GLArrayData)this.vertices, true);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        this.colors = GLArrayDataServer.createGLSL((String)"mgl_Color", (int)4, (int)5126, (boolean)false, (int)4, (int)35044);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.putf(1.0f);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.putf(1.0f);
        this.colors.putf(0.0f);
        this.colors.putf(0.0f);
        this.colors.putf(1.0f);
        this.colors.seal((GL)gL2ES2, true);
        this.st.ownAttribute((GLArrayData)this.colors, true);
        this.colors.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        System.out.println(Thread.currentThread() + " " + this.st);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (null == this.st) {
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.gluPerspective(45.0f, (float)n3 / (float)n4, 1.0f, 100.0f);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.st.useProgram(gL2ES2, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (null == this.st) {
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.out.println(Thread.currentThread() + " RedSquare.dispose: " + gL2ES2.getContext());
        this.st.destroy(gL2ES2);
        this.st = null;
        this.pmvMatrix = null;
        System.out.println(Thread.currentThread() + " RedSquare.dispose: FIN");
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (null == this.st) {
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.st.useProgram(gL2ES2, true);
        gL2ES2.glClear(16640);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        float f = (float)this.window.getTotalFPSDuration() * 360.0f / 4000.0f;
        this.pmvMatrix.glRotatef(f, 0.0f, 0.0f, 1.0f);
        this.pmvMatrix.glRotatef(f, 0.0f, 1.0f, 0.0f);
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.vertices.enableBuffer((GL)gL2ES2, true);
        this.colors.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        this.colors.enableBuffer((GL)gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public static void main(String[] stringArray) {
        NewtFactory.setUseEDT((boolean)true);
        int n = USE_NEWT;
        ArrayList<RedSquare> arrayList = new ArrayList<RedSquare>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-swapi")) {
                ++i;
                try {
                    swapInterval = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                debuggl = true;
                continue;
            }
            if (stringArray[i].equals("-1thread")) {
                oneThread = true;
                continue;
            }
            if (stringArray[i].equals("-awt")) {
                n |= USE_AWT;
                continue;
            }
            if (!stringArray[i].startsWith("-GL")) continue;
            arrayList.add(new RedSquare(stringArray[i].substring(1), n));
        }
        if (arrayList.size() == 0) {
            arrayList.add(new RedSquare("GL2ES2", n));
        }
        if (!oneThread) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).start();
            }
            boolean bl = false;
            while (!bl) {
                int n2 = 0;
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    if (!((Thread)iterator2.next()).isAlive()) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n2;
                }
                bl = 0 == n2;
            }
        } else {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).run();
            }
            while (arrayList.size() > 0) {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    RedSquare redSquare = (RedSquare)iterator.next();
                    if (redSquare.shouldQuit()) {
                        redSquare.shutdown();
                        iterator.remove();
                        continue;
                    }
                    redSquare.display();
                }
            }
        }
    }
}

