/*
 * Decompiled with CFR 0.152.
 */
package demos.es2.perftst;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import demos.es2.perftst.PerfModule;
import demos.es2.perftst.Perftst;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.FloatBuffer;

public class PerfTextLoad
extends PerfModule {
    static final int MAX_TEXTURE_ENGINES = 8;
    Texture[] textures = null;
    TextureData[] textDatas = null;

    @Override
    public ShaderState initShaderState(GL2ES2 gL2ES2) {
        return this.initShaderState(gL2ES2, "vbo-vert-text", "ftext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOneSet(GLAutoDrawable gLAutoDrawable, String string, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        Object object;
        Object object2;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (n2 > 8) {
            throw new GLException("numTextures must be within 1..8");
        }
        String string2 = null;
        this.textDatas = new TextureData[n];
        this.textures = new Texture[n2];
        try {
            int n7;
            for (n7 = 0; n7 < n; ++n7) {
                string2 = "data/" + string + "." + (n7 + 1) + ".tga";
                object2 = IOUtil.getResource((String)string2, (ClassLoader)Perftst.class.getClassLoader(), Perftst.class);
                if (object2 == null) {
                    throw new RuntimeException("couldn't fetch " + string2);
                }
                object = ((URLConnection)object2).getInputStream();
                try {
                    this.textDatas[n7] = TextureIO.newTextureData((GLProfile)gL2ES2.getGLProfile(), (InputStream)object, (boolean)false, (String)"tga");
                    System.out.println(string + ": " + this.textDatas[n7]);
                    continue;
                }
                finally {
                    IOUtil.close((Closeable)object, (boolean)false);
                }
            }
            for (n7 = 0; n7 < n2; ++n7) {
                gL2ES2.glActiveTexture(n7);
                this.textures[n7] = new Texture(3553);
            }
        }
        catch (IOException iOException) {
            System.err.println("couldn't fetch " + string2);
            throw new RuntimeException(iOException);
        }
        this.st.useProgram(gL2ES2, true);
        GLArrayDataServer gLArrayDataServer = GLArrayDataServer.createGLSL((String)"mgl_Vertex", (int)2, (int)5126, (boolean)true, (int)4, (int)35044);
        object2 = (FloatBuffer)gLArrayDataServer.getBuffer();
        ((FloatBuffer)object2).put(0.0f);
        ((FloatBuffer)object2).put(0.0f);
        ((FloatBuffer)object2).put(1.0f);
        ((FloatBuffer)object2).put(0.0f);
        ((FloatBuffer)object2).put(0.0f);
        ((FloatBuffer)object2).put(1.0f);
        ((FloatBuffer)object2).put(1.0f);
        ((FloatBuffer)object2).put(1.0f);
        gLArrayDataServer.seal((GL)gL2ES2, true);
        object2 = GLArrayDataServer.createGLSL((String)"mgl_MultiTexCoord0", (int)2, (int)5126, (boolean)true, (int)4, (int)35044);
        object = (FloatBuffer)object2.getBuffer();
        ((FloatBuffer)object).put(0.0f);
        ((FloatBuffer)object).put(0.0f);
        ((FloatBuffer)object).put(1.0f);
        ((FloatBuffer)object).put(0.0f);
        ((FloatBuffer)object).put(0.0f);
        ((FloatBuffer)object).put(1.0f);
        ((FloatBuffer)object).put(1.0f);
        ((FloatBuffer)object).put(1.0f);
        object2.seal((GL)gL2ES2, true);
        object = new long[n + 1];
        object[0] = System.currentTimeMillis();
        for (int i = 0; i < n2; ++i) {
            gL2ES2.glActiveTexture(i);
            this.textures[i].updateImage((GL)gL2ES2, this.textDatas[0]);
            object[i + 1] = System.currentTimeMillis();
        }
        GLUniformData gLUniformData = new GLUniformData("mgl_ActiveTexture", 0);
        this.st.uniform(gL2ES2, gLUniformData);
        long[][] lArray = new long[n3][n];
        long[][] lArray2 = new long[n3][n];
        long[][][] lArray3 = new long[n3][n][n2];
        long[][][] lArray4 = new long[n3][n][n2];
        long[][][] lArray5 = new long[n3][n][n2];
        long[][] lArray6 = new long[n3][n];
        long[][] lArray7 = new long[n3][n];
        for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = 0; n5 < n; ++n5) {
                lArray[n6][n5] = System.currentTimeMillis();
                gL2ES2.glClear(16640);
                lArray2[n6][n5] = System.currentTimeMillis();
                for (n4 = 0; n4 < n2; ++n4) {
                    gL2ES2.glActiveTexture(33984 + n4);
                    this.textures[n4].enable((GL)gL2ES2);
                    this.textures[n4].bind((GL)gL2ES2);
                    gLUniformData.setData(n4);
                    this.st.uniform(gL2ES2, gLUniformData);
                    lArray3[n6][n5][n4] = System.currentTimeMillis();
                    this.textures[n4].updateSubImage((GL)gL2ES2, this.textDatas[n5], 0, 0, 0);
                    lArray4[n6][n5][n4] = System.currentTimeMillis();
                    gL2ES2.glDrawArrays(5, 0, gLArrayDataServer.getElemCount());
                    lArray5[n6][n5][n4] = System.currentTimeMillis();
                }
                gL2ES2.glFinish();
                lArray6[n6][n5] = System.currentTimeMillis();
                gLAutoDrawable.swapBuffers();
                lArray7[n6][n5] = System.currentTimeMillis();
            }
        }
        n6 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            n6 += this.textDatas[n5].getEstimatedMemorySize();
        }
        n6 *= n2;
        long l = 0L;
        for (n5 = 1; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                l += lArray7[n5][n4] - lArray[n5][n4];
            }
        }
        System.out.println("");
        System.out.println("Texture " + string + ", loops " + n3 + ", textures " + n2 + ", objects " + n + ", total bytes " + n6 + ", total time: " + l + "ms, fps(-1): " + (long)((n3 - 1) * n * 1000) / l + ",\n text kB/s: " + (double)(n3 * n6) / 1024.0 / ((double)l / 1000.0));
        for (n5 = 0; n5 < n3; ++n5) {
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            for (n4 = 0; n4 < n; ++n4) {
                l2 += lArray2[n5][n4] - lArray[n5][n4];
                l3 += lArray6[n5][n4] - lArray5[n5][n4][n2 - 1];
                l4 += lArray7[n5][n4] - lArray6[n5][n4];
                l5 += lArray7[n5][n4] - lArray[n5][n4];
            }
            if (l5 <= 0L) {
                l5 = 1L;
            }
            System.out.println("\tloop " + n5 + ": clear " + l2 + "ms, finish " + l3 + ", swap " + l4 + "ms, total: " + l5 + "ms, fps " + (long)(n * 1000) / l5);
        }
        System.out.println("*****************************************************************");
        this.st.useProgram(gL2ES2, false);
        for (n5 = 0; n5 < n2; ++n5) {
            this.textures[n5].disable((GL)gL2ES2);
            this.textures[n5].destroy((GL)gL2ES2);
            this.textures[n5] = null;
        }
        for (n5 = 0; n5 < n; ++n5) {
            this.textDatas[n5] = null;
        }
        this.textures = null;
        this.textDatas = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    @Override
    public void run(GLAutoDrawable gLAutoDrawable, int n) {
        this.runOneSet(gLAutoDrawable, "bob2.64x64", 33, 1, n);
        this.runOneSet(gLAutoDrawable, "bob2.128x128", 33, 1, n);
        this.runOneSet(gLAutoDrawable, "bob2.128x128", 4, 1, n);
        this.runOneSet(gLAutoDrawable, "bob2.256x256", 4, 1, n);
        this.runOneSet(gLAutoDrawable, "bob2.512x512", 4, 1, n);
    }
}

