/*
 * Decompiled with CFR 0.152.
 */
package demos.es2.perftst;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderState;
import demos.es2.perftst.PerfModule;
import java.nio.FloatBuffer;

public class PerfUniLoad
extends PerfModule {
    static final int MAX_ARRAYS = 12;
    static final int MAX_ARRAY_ELEM = 16;
    GLUniformData[] dummyA;
    GLUniformData[] dummyB;
    GLUniformData[] dummyC;
    final int dataType = 5126;

    @Override
    public ShaderState initShaderState(GL2ES2 gL2ES2) {
        return this.initShaderState(gL2ES2, "uni-vert-col", "fcolor");
    }

    protected void runOneSet(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (n > 12) {
            throw new GLException("numObjs must be within 0..12");
        }
        if (n2 > 16) {
            throw new GLException("numArrayElem must be within 0..16");
        }
        this.st.useProgram(gL2ES2, true);
        GLArrayDataServer gLArrayDataServer = GLArrayDataServer.createGLSL((String)"mgl_Vertex", (int)3, (int)5126, (boolean)true, (int)4, (int)35044);
        FloatBuffer floatBuffer = (FloatBuffer)gLArrayDataServer.getBuffer();
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(0.0f);
        gLArrayDataServer.seal((GL)gL2ES2, true);
        floatBuffer = GLArrayDataServer.createGLSL((String)"mgl_Color", (int)4, (int)5126, (boolean)true, (int)4, (int)35044);
        GLUniformData[] gLUniformDataArray = (GLUniformData[])floatBuffer.getBuffer();
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(1.0f);
        gLUniformDataArray.put(1.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(1.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(1.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(1.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(0.0f);
        gLUniformDataArray.put(1.0f);
        gLUniformDataArray.put(1.0f);
        floatBuffer.seal((GL)gL2ES2, true);
        gLUniformDataArray = new GLUniformData[n];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < n; ++i) {
            FloatBuffer floatBuffer2 = Buffers.newDirectFloatBuffer((int)(4 * n2));
            for (int j = 0; j < n2; ++j) {
                floatBuffer2.put(f);
                floatBuffer2.put(f2);
                floatBuffer2.put(f3);
                floatBuffer2.put(0.0f);
                if (f == 0.0f) {
                    f = 1.0f;
                } else if (f == 1.0f) {
                    f = 0.0f;
                    f2 += 0.01f;
                }
                if (!(f2 > 1.0f)) continue;
                f = 0.0f;
                f2 = 0.0f;
                f3 += 0.01f;
            }
            floatBuffer2.flip();
            gLUniformDataArray[i] = new GLUniformData("mgl_Dummy" + i, 4, floatBuffer2);
        }
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        long[][] lArray3 = new long[n3][n];
        long[][] lArray4 = new long[n3][n];
        long[] lArray5 = new long[n3];
        long[] lArray6 = new long[n3];
        for (n6 = 0; n6 < n3; ++n6) {
            lArray[n6] = System.currentTimeMillis();
            gL2ES2.glClear(16640);
            lArray2[n6] = System.currentTimeMillis();
            for (n5 = 0; n5 < n; ++n5) {
                this.st.uniform(gL2ES2, gLUniformDataArray[n5]);
                lArray3[n6][n5] = System.currentTimeMillis();
                gL2ES2.glDrawArrays(3, 0, gLArrayDataServer.getElemCount());
                lArray4[n6][n5] = System.currentTimeMillis();
            }
            gL2ES2.glFinish();
            lArray5[n6] = System.currentTimeMillis();
            gLAutoDrawable.swapBuffers();
            lArray6[n6] = System.currentTimeMillis();
        }
        n6 = n * n2;
        n5 = n6 * 4;
        long l = 0L;
        for (n4 = 1; n4 < n3; ++n4) {
            l += lArray6[n4] - lArray[n4];
        }
        System.out.println("");
        System.out.println("Loops " + n3 + ", uniform arrays " + gLUniformDataArray.length + ", type FLOAT, uniforms array size " + n2 + ",\n total elements " + n6 + ", total bytes " + n5 + ", total time: " + l + "ms, fps(-1): " + (long)((n3 - 1) * 1000) / l + ",\n uni elem/s: " + (double)(n3 * n6) / ((double)l / 1000.0));
        for (n4 = 0; n4 < n3; ++n4) {
            long l2 = lArray2[n4] - lArray[n4];
            long l3 = lArray5[n4] - lArray4[n4][gLUniformDataArray.length - 1];
            long l4 = lArray6[n4] - lArray5[n4];
            long l5 = lArray6[n4] - lArray[n4];
            if (l5 <= 0L) {
                l5 = 1L;
            }
            System.out.println("\tloop " + n4 + ": clear " + l2 + "ms, finish " + l3 + ", swap " + l4 + "ms, total: " + l5 + "ms, fps " + 1000L / l5);
        }
        System.out.println("*****************************************************************");
        this.st.useProgram(gL2ES2, false);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run(GLAutoDrawable gLAutoDrawable, int n) {
        this.runOneSet(gLAutoDrawable, 1, 1, n);
        this.runOneSet(gLAutoDrawable, 4, 1, n);
        this.runOneSet(gLAutoDrawable, 1, 4, n);
        this.runOneSet(gLAutoDrawable, 8, 1, n);
        this.runOneSet(gLAutoDrawable, 1, 8, n);
        this.runOneSet(gLAutoDrawable, 12, 1, n);
        this.runOneSet(gLAutoDrawable, 1, 12, n);
        this.runOneSet(gLAutoDrawable, 1, 16, n);
        this.runOneSet(gLAutoDrawable, 2, 16, n);
        this.runOneSet(gLAutoDrawable, 4, 16, n);
        this.runOneSet(gLAutoDrawable, 8, 16, n);
        this.runOneSet(gLAutoDrawable, 12, 16, n);
    }
}

